achievements_window = achievements_window or {}
achievements_window.actions = achievements_window.actions or {}

achievements_window.params = 
{
	--    
	back_image = "screens_achievements_achievements",
	--    
	back_image_completed = "screens_achievements_achievements_completed",
    
    --    
    achievements_offset_y = -13,
		
	-- ,     
	chain_image = "achievements_chain",
	
	--   
	image_pos_center = sf.misc.FloatVector(40, 80),
		
	--   -  
	label_title_params = 
	{
		--   
		{
			font = "white_font_20",
			color = sf.graphics.Color(255, 84,71,67),
		},
		--   
		{
			font = "font_20",
			color = sf.graphics.Color(255,255,255,255),
		}
	},
	label_title_pos = sf.misc.FloatVector(700, 17),
    label_title_horizontal_alignment = 1, --   :  -1,  0,  1
	
	--   -  
	label_description_params = 
	{
		--   
		{
			font = "white_font",
			color = sf.graphics.Color(255, 84,71,67),
		},
		--   
		{
			font = "basefont",
			color = sf.graphics.Color(255,255,255,255),
		}
	},
	label_description_pos = sf.misc.FloatVector(163, 53),
	--      .      ,      
	label_description_width = 350,
	
	--   -  
	label_progress_params = 
	{
		--   
		{
			font = "font_12",
			color = sf.graphics.Color(255, 84,71,67),
		},
		--   
		{
			font = "font_12_black",
			color = sf.graphics.Color(255,255,255,255),
		}
	},
	label_progress_pos = sf.misc.FloatVector(630, 96),
	
	--   -  
	label_score_params = 
	{
		--   
		{
			font = "font_40",
			color = sf.graphics.Color(255,255,255,255),
		},
		--   
		{
			font = "font_40",
			color = sf.graphics.Color(255,255,255,255),
		}
	},
	label_score_pos = sf.misc.FloatVector(705,57),
    
    --   -    
    label_score_title = 
    {
        {
            font = "font_12_black",
            text = "$2268",
            color = sf.graphics.Color(255,255,255,255),
            pos = sf.misc.FloatVector(705, 50)
        },
        
        {
            font = "font_12_black",
            text = "$2269",
            color = sf.graphics.Color(255,255,255,255),
            pos = sf.misc.FloatVector(705, 100)
        },
    },
	
	--  -
	progress_image = "screens_achievements_progressbar",
	progress_frame_image = "screens_achievements_progressbar_back",
	progress_pos = sf.misc.FloatVector(425, 96)
}

--       ,       achievements.xml.
--        .
if not achievements_window.params.achievements then
	local achs_info = sf.core.CSettings()

	local loaded = achs_info.LoadXml("properties\\achievements.xml")
	__assert(loaded, "    achievements.xml")
	
	local root = achs_info.GetFirstChild()
	__assert(root.GetId().c_str() == "Achievements", "   achievements.xml")

	achievements_window.params.achievements = {}
	
    local ach_settings = root.GetFirstChildRef()
	while ach_settings do
		__assert(ach_settings.GetId().c_str() == "ach", "   achievements.xml")
        __assert(ach_settings.IsValue("id"), "   achievements.xml")

		table.insert(achievements_window.params.achievements, ach_settings.GetValue("id").c_str())
		
		ach_settings = ach_settings.GetNextSiblingRef()
    end
end

function achievements_window.DoDraw(_this, _renderer)
	if game_background then
		game_background.Draw(_renderer)
	end
end

function achievements_window.DoUpdate(_this)
	if game_background then
		game_background.Update()
	end
end

function achievements_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
    return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function achievements_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast)
end

function achievements_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function achievements_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove( _pos, _state, _broadcast) 
end

function achievements_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function achievements_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function achievements_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function achievements_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function achievements_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = achievements_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end
	
function achievements_window.Show(_window)
    achievements_window._parent_window = _window
    --   
    achievements_window._parent_window.AddFlags(achievements_window._parent_window.FlagHidden)

	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "achievements_staticstics_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	
	achievements_window._InitWindow(dialog)
	
	dialog.UpdateLayout()

	--      ,     (0, 0)
	local offset = sf.misc.FloatVector(0, 0)
	local parent = _window
	while parent do
		offset.X = offset.X - parent.GetOffset().X
		offset.Y = offset.Y - parent.GetOffset().Y
		parent = parent.GetParentWindow()
	end
	dialog.SetOffset(offset.X, offset.Y)

    _window.AddChildWindow(dialog)
end

--    ,      /   
-- _panel -   - scrollable_panel
-- _i -       .     .
-- _ach_id -  
function achievements_window._AddAchievementWidgets(_panel, _i, _ach_id)
	
	--       ,      
	local ach_settings = game.g_Achievements.Instance().GetAchievementSettings(_ach_id)
	local ach_completed = achievements_window.achs.IsCompleted(_ach_id) ~= 0
	
	local label_param = 1
	if ach_completed then label_param = 2 end
	
	--  ,    
	local ach_chain = sf.gui.CImageWidget(achievements_window.params.chain_image, "", 0,0)	
				
	--       ,    
	local back_image = achievements_window.params.back_image
	if ach_completed then
		back_image = achievements_window.params.back_image_completed
	end
	
	--   
	local ach_back = sf.gui.CImageWidget(back_image, "", 0, 0)	
		
	--   (y)  -    ,      
	--   (x)   0
	local top = (ach_back.GetSize().Y + ach_chain.GetSize().Y + achievements_window.params.achievements_offset_y) * _i
	
	if _i > 0 then	
		--  ,    ,     
		ach_chain.SetOffset(0, top - ach_chain.GetSize().Y)
		local ach_chain_ptr = sf.gui.CImageWidgetPtrT(ach_chain)
		scrollable_panel.AddContentWidget(_panel, ach_chain_ptr)
	end
	
	--       
	ach_back.SetOffset(0, top)
	local ach_back_ptr = sf.gui.CImageWidgetPtrT(ach_back)
	scrollable_panel.AddContentWidget(_panel, ach_back_ptr)
	
	-- ,       
	local ach_image = sf.gui.CImageWidget(ach_settings.Image, "", 0, 0)
	ach_image.SetOffset(
		achievements_window.params.image_pos_center.X - ach_image.GetSize().X / 2, 
		achievements_window.params.image_pos_center.Y - ach_image.GetSize().Y / 2 + top)
	local ach_image_ptr = sf.gui.CImageWidgetPtrT(ach_image)
	scrollable_panel.AddContentWidget(_panel, ach_image_ptr)
	
	-- ,       
	local ach_title = sf.gui.CLabelWidget(achievements_window.fonts_title[label_param], ach_settings.Title, "", 0, 0)
    ach_title.ResizeToFitText(true)
	ach_title.SetOffset(
		achievements_window.params.label_title_pos.X, 
		achievements_window.params.label_title_pos.Y + top)
    local alignment = achievements_window.params.label_title_horizontal_alignment
    if alignment > -1 then
        --     
        ach_title.SetOffset(ach_title.GetOffset().X - ach_title.GetSize().X/2*(alignment + 1), ach_title.GetOffset().Y)
    end
	ach_title.SetColor(achievements_window.params.label_title_params[label_param].color)
	local ach_title_ptr = sf.gui.CLabelWidgetPtrT(ach_title)
	scrollable_panel.AddContentWidget(_panel, ach_title_ptr)
	
	-- ,       
	local ach_description = sf.gui.CLabelWidget(achievements_window.fonts_description[label_param], ach_settings.Description, "", 0, 0)
	ach_description.SetOffset(
		achievements_window.params.label_description_pos.X, 
		achievements_window.params.label_description_pos.Y + top)
	ach_description.SetColor(achievements_window.params.label_description_params[label_param].color)
	ach_description.SetWordBreak(true)
	ach_description.SetSize(achievements_window.params.label_description_width, 0)
	local ach_description_ptr = sf.gui.CLabelWidgetPtrT(ach_description)
	scrollable_panel.AddContentWidget(_panel, ach_description_ptr)
	
	-- ,         
	local ach_score = sf.gui.CLabelWidget(achievements_window.fonts_score[label_param], string.format("%i", ach_settings.Score), "", 0, 0)
	ach_score.SetOffset(
		achievements_window.params.label_score_pos.X, 
		achievements_window.params.label_score_pos.Y + top)
	ach_score.SetColor(achievements_window.params.label_score_params[label_param].color)
	local ach_score_ptr = sf.gui.CLabelWidgetPtrT(ach_score)
	scrollable_panel.AddContentWidget(_panel, ach_score_ptr)
    
    --      
    for i, label_info in ipairs(achievements_window.params.label_score_title) do
        local label = sf.gui.CLabelWidget(achievements_window.fonts_score_title[i], label_info.text, "", 0, 0)
        label.SetOffset(
            label_info.pos.X, 
            label_info.pos.Y + top)
        label.SetColor(label_info.color)
        local label_ptr = sf.gui.CLabelWidgetPtrT(label)
        scrollable_panel.AddContentWidget(_panel, label_ptr)
    end
	
	--      ?
	if ach_settings.MaxProgress ~= 1 then
		
		--   
		local progress = achievements_window.achs.GetProgress(_ach_id)
		
		--  -
		local ach_progress_bar = sf.gui.CProgressBarWidget("", 0, 0)
		--   -
		local image_progress_frame = sf.graphics.CImage(achievements_window.params.progress_frame_image)
		--    -
		local image_progress = sf.graphics.CImage(achievements_window.params.progress_image)
		--    -
		ach_progress_bar.SetImages(image_progress_frame, image_progress)
		--    -       (    )
		ach_progress_bar.SetSize(image_progress.GetTextureSize().X, image_progress.GetTextureSize().Y)
		--  -:   /  
		ach_progress_bar.SetValue(progress / ach_settings.MaxProgress)
		--  -     
		ach_progress_bar.SetOffset(
			achievements_window.params.progress_pos.X, 
			achievements_window.params.progress_pos.Y + top)
		local ach_progress_bar_ptr = sf.gui.CProgressBarWidgetPtrT(ach_progress_bar)
		scrollable_panel.AddContentWidget(_panel, ach_progress_bar_ptr)
		
		-- ,         
		local ach_progress = sf.gui.CLabelWidget(achievements_window.fonts_progress[label_param], 
			string.format("%i/%i", progress, ach_settings.MaxProgress), "", 0, 0)
		ach_progress.SetOffset(
			achievements_window.params.label_progress_pos.X, 
			achievements_window.params.label_progress_pos.Y + top)
		ach_progress.SetColor(achievements_window.params.label_progress_params[label_param].color)
		local ach_progress_ptr = sf.gui.CLabelWidgetPtrT(ach_progress)
		scrollable_panel.AddContentWidget(_panel, ach_progress_ptr)		
	end	
end

--   
function achievements_window._InitWindow(_window)

	--  -  
	local current_score_label = get_child_widget(_window, "current_score", sf.gui.CLabelWidget)
	__assert(current_score_label, "   current_score")

	local tab_widget = get_child_widget(_window, "achievements_tab_list", sf.gui.CTabWidget)
	__assert(tab_widget, "   achievements_tab_list")

	--    -   3: ,   
	local panels_num = tab_widget.EnumPanels()
	__assert(panels_num == 3, "   achievements_tab_list   3")
	
	--    .
	--    -,    scrollable_panel
	local panels = 
	{
		tab_widget.GetPanelContent(0).GetWidget("panel", true).get(),
		tab_widget.GetPanelContent(1).GetWidget("panel", true).get(),
		tab_widget.GetPanelContent(2).GetWidget("panel", true).get()
	}
	
	local i = 0
	
	--      
	achievements_window.fonts_title = 
    {
        g_App.GetResourceManager().GetFont(achievements_window.params.label_title_params[1].font),
        g_App.GetResourceManager().GetFont(achievements_window.params.label_title_params[2].font)
    }
	achievements_window.fonts_description = 
    {
        g_App.GetResourceManager().GetFont(achievements_window.params.label_description_params[1].font),
        g_App.GetResourceManager().GetFont(achievements_window.params.label_description_params[2].font)
    }
	achievements_window.fonts_progress = 
    {
        g_App.GetResourceManager().GetFont(achievements_window.params.label_progress_params[1].font),
        g_App.GetResourceManager().GetFont(achievements_window.params.label_progress_params[2].font)
    }
	achievements_window.fonts_score = 
    {
        g_App.GetResourceManager().GetFont(achievements_window.params.label_score_params[1].font),
        g_App.GetResourceManager().GetFont(achievements_window.params.label_score_params[2].font)
    }
    achievements_window.fonts_score_title = {}
    for _, label_info in ipairs(achievements_window.params.label_score_title) do
        table.insert(achievements_window.fonts_score_title, g_App.GetResourceManager().GetFont(label_info.font))
    end
	
	--  
	local profile = game.g_ProfileManager.Instance().GetCurrentProfile()
	__assert(profile)
		
	--     .
	--     2 :   ( 1,       )    
	--  , ..      ( 0,     )
	achievements_window.achs = game.g_Achievements.Instance().GetProfileAchievements(profile)
	
	--         
	local current_score_text = 
		string.format(current_score_label.GetText().c_str(), achievements_window.achs.GetScore())
	current_score_label.SetText(current_score_text)
	
	--    .  3 : ,   .
	-- "":     ,   ,        ,    
	--    achievements.xml
	-- "" -      ,     ()
	-- "" -      ,        achievements.xml
	
	-- achievements_window.params.achievements       ,        achievements.xml
	
	--     ,     ,          
	-- ,    ,       ,        achievements.xml.
	
	local sort_achs = {}
	
	--       achievements_window.params.achievements
	for _,a in ipairs(achievements_window.params.achievements) do
		table.insert(sort_achs, a)
	end
	
	--  .
	--   . 
	--  true,       .
	--     ,  ,      achievements.xml  ,
	--   true,      .
	--      false
	-- _ach1 -   
	-- _ach2 -   
	local sort_func = 	
		function (_ach1, _ach2)
			--     (0,   )
			local completed1 = achievements_window.achs.IsCompleted(_ach1)
			--     (0,   )
			local completed2 = achievements_window.achs.IsCompleted(_ach2)
			
			--                   .
			if completed1 ~= completed2 then
				return completed1 > completed2
			end
			
			--    ,     .
			--  ,        achievements.xml.
			for _,a in ipairs(achievements_window.params.achievements) do
				if a == _ach1 then					
					return true
				end
				--    ,     .
				if a == _ach2 then
					break
				end
			end
			
			return false
		end 
		
	--  
	table.sort(sort_achs, sort_func)

	local i=0
	
	-- ,      
	local has_completed = achievements_window.achs.IsCompleted(sort_achs[1]) ~= 0
	
	--    ,         ""
	if has_completed then
		achievements_window._AddAchievementWidgets(panels[1], i, sort_achs[1])
		i = i + 1
	end
	
	--   "".
	--      ,       achievements.xml.
	--  ,    ( )
	for _,a in ipairs(achievements_window.params.achievements) do
		if not has_completed or a ~= sort_achs[1] then
			achievements_window._AddAchievementWidgets(panels[1], i, a)
			i = i + 1
		end
	end
	
	--   ""  ""
	--   sort_achs    ,  .       ,    
	--  ,      "".
	--     ,     ""        .
	local i = 0
	local p = 2 --   
	for _,a in ipairs(sort_achs) do
		if p == 2 then
			if achievements_window.achs.IsCompleted(a) == 0 then
				i = 0
				p = 3
			end
		end
		achievements_window._AddAchievementWidgets(panels[p], i, a)
		i = i + 1
	end
	
	if game_background then
		--game_background.Init()
	end
end

achievements_window.actions.close = 
{
	pressed = function(_window) 
		_window.AddFlags(_window.FlagDead)
        achievements_window._parent_window.RemFlags(achievements_window._parent_window.FlagHidden)
	end
}

achievements = achievements or {}
achievements.statistics_window = achievements_window or {}