comics_window = {}
comics_window.actions = {}
comics_window.object = nil

comics_window._start_comics_time = 200
comics_window._end_comics_time = 200

comics_window._allow_buttons_resize = true

comics_window._end_effect_flag = nil

comics_widget = comics_widget or {}
comics_widget.dark_color = nil


comics_widget.def_start_time = 1500
comics_widget.def_end_time = 1400

local end_level_constants = g_App.GetSettings().GetChild("Constants", false).GetChildRef("change_step_effects", false)
if end_level_constants then
    local res = tonumber(end_level_constants.GetValue("start_comics_time").c_str())
    if res ~= nil then comics_window._start_comics_time = res end

    res = tonumber(end_level_constants.GetValue("end_comisc_time").c_str())
    if res ~= nil then comics_window._end_comics_time = res end

    local res = tonumber(end_level_constants.GetValue("def_start_comics_clip_time").c_str())
    if res ~= nil then comics_widget.def_start_time = res end

    res = tonumber(end_level_constants.GetValue("def_end_comics_clip_time").c_str())
    if res ~= nil then comics_widget.def_end_time = res end
	
end

local comics_window_info = g_App.GetSettings().GetChild("Constants", false).GetChildRef("comics_window", false)

if comics_window_info then
    local res = comics_window_info.GetValue("allow_button_width_resize").c_str()
    if res ~= "" then
        if res == "false" then
            comics_window._allow_buttons_resize = false
        end
    end    
end

comics_window._comics_timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer(_T("main")).AttachTimer(_T("")))

comics_window._change_timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer(_T("main")).AttachTimer(_T("")))


comics_window.end_comics = nil

comics_window._finish_time = nil

comics_window._current_change_effect = nil -- 1 start   2 end
comics_window._change_volume = false
comics_window._start_alpha = 0

function comics_window.SetCurrentChangeEffect(_type, _time)
    if comics_window._end_effect_flag == true then return end

    comics_window.max_music_volume =  game.g_GameOptions.Instance().GetMusicVolume()
    comics_window.max_sound_volume =  game.g_GameOptions.Instance().GetSoundVolume()

    comics_window._current_change_effect = _type
    comics_window._change_timer.Get().SetTime(0)
    if _type == 1 then
        comics_widget.dark_color = sf.graphics.Color(255, 0, 0, 0)
        comics_window._finish_time = _time or comics_window._start_comics_time
    elseif _type == 2 then
        comics_window._start_alpha = comics_widget.dark_color.Alpha
        comics_window._finish_time = _time or comics_window._end_comics_time
    end
 end


function comics_widget.DoDraw(_this, _renderer) 
    if comics_window.comics_table[comics_window.step_index] then
        comics_window.comics_table[comics_window.step_index].object.Draw(_renderer)
    end
    if comics_widget.dark_color then
        _renderer.RenderFilledPoly4(sf.misc.Poly4FromRect(sf.misc.FloatRect(0, 0, 1024, 768)), comics_widget.dark_color)
    end
    
    return false 
end

comics_widget.ch_clip_effect = nil


function need_effects(_element)
    if _element.time >= _element.start_time + _element.end_time then
        return true
    end
    return false
end

--   FPS 
function comics_window.SetHighFPS()
    if comics_window._low_fps then
        comics_window._low_fps = false
        sf.core.g_Application.LimitFPS(60)
    end
end

--  FPS   Flash
function comics_window.SetLowFPS()
    if not comics_window._low_fps then
        comics_window._low_fps = true
        sf.core.g_Application.LimitFPS(25)
    end
end

--   
function comics_window.PlayFlash(_path)
	if not _path or _path == "" then
		comics_window._flash.LoadMovie("empty_flash", 1024, 768, "")
		comics_window.SetHighFPS()	
        comics_window._has_flash = false
		return
	end
    --  FPS     
	comics_window.SetLowFPS()
	--    
	comics_window._flash.LoadMovie("flash\\clip_ldr.swf", 1024, 768, "")
	--  
	comics_window._total_flash_time = nil 
    local flash = comics_window._flash.GetFlash()
    flash.SetVariable("mov", _path)
    flash.SetVariable("vol", tostring(math.floor(game.g_GameOptions.Instance().GetVoiceVolume())))
	flash.Stop()
	flash.Play()
    comics_window._has_flash = true
    comics_window._flash_reached_middle = false
end

function comics_widget.DoUpdate(_this)     
    if not comics_window.step_index then
        comics_window.step_index = 1
        local comics_part = comics_window.comics_table[comics_window.step_index]
        comics_window.finished_sequence = nil
		comics_window.PlayFlash(comics_part.flash_path)  --   
        comics_window._comics_timer.Get().SetTime(0)
        comics_part.object.Stop()
        if not comics_window._has_flash then 
            --      
            --   ,       
            comics_part.object.Play()
        end
        comics_window._ShowReplay(false)
        
    elseif comics_window.comics_table[comics_window.step_index] and not comics_window.finished_sequence then
    
        local current_part = comics_window.comics_table[comics_window.step_index]
		local next_part = comics_window.comics_table[comics_window.step_index + 1]
        local play_time = current_part.time
        
        --   ,     
        if comics_window._has_flash then
            local flash = comics_window._flash.GetFlash()
            --     ,  
			local flash_time = tonumber(tostring(flash.GetVariable("mc_frame"))) * 1000/25
            comics_window._comics_timer.Get().SetTime(flash_time)
            current_part.object.MoveTime(flash_time)
            
			local total_flash_time = tonumber(tostring(flash.GetVariable("mc_total_frames"))) * 1000/25
			if total_flash_time < 8000 then total_flash_time = 8000 end -- , ..      
			
            
            if not comics_window._flash_reached_middle and flash_time > total_flash_time/2 then 
                --        
                comics_window._flash_reached_middle = true
            elseif comics_window._flash_reached_middle 
                and (flash_time < total_flash_time/3 or flash_time >= total_flash_time or play_time < flash_time) 
            then
                --    ,  
                comics_window._flash.GetFlash().SetVariable("mc_stop", "true")
                comics_window._has_flash = false
                current_part.object.Play()
            end
        end
    
        local time = comics_window._comics_timer.Get().GetTime()
		if play_time < time then
            if next_part then
                comics_window.step_index = comics_window.step_index + 1
				
				comics_window.PlayFlash(next_part.flash_path) --   
                
                next_part.object.Stop()
                if not comics_window._has_flash then 
                    --      
                    --   ,       
                    next_part.object.Play()
                end
                
				comics_window._comics_timer.Get().SetTime(0)
                if need_effects(next_part) and comics_window.end_effect_flag then
                    comics_window.SetCurrentChangeEffect(1, next_part.start_time )
                end
                comics_window.end_effect_flag = nil
            else
                comics_window.finished_sequence = true
                comics_window._flash.GetFlash().SetVariable("mc_stop", "true")
                if not comics_window.end_comics then
                    comics_window._ShowReplay(true)
                end
            end
        elseif current_part.time - time <= current_part.end_time and not comics_window._current_change_effect and next_part then
            if need_effects(current_part) and need_effects(next_part) then
                comics_window.SetCurrentChangeEffect(2, current_part.end_time)
                comics_window.end_effect_flag = true
            end
        end
    else

    end

    if comics_window.comics_table[comics_window.step_index] then
        comics_window.comics_table[comics_window.step_index].object.Update()
    end

    return false 
end

function comics_widget.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return false
end

function comics_widget.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	if _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast) then
      return true
    end
    return false
end

function comics_widget.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function comics_widget.OnMouseMove(_this, _pos, _state, _broadcast)
	return false
end

function comics_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return false
end

function comics_widget.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return false
end

function comics_widget.OnDoubleClick(_this, _pos, _state, _broadcast)
	return false
end

function comics_widget.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return false
end

function comics_widget.__CreateInstance()
    return "comics_widget"
end

function comics_widget.Load(_info, _templates)
    return true
end

function comics_widget.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = comics_widget.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end

comics_window.comics_table = {}

function comics_window._ShowReplay(_value, _total)
    if comics_window._replay_button then
        set_widget_flag_value(comics_window._replay_button, sf.gui.CBaseWidget.FlagHidden, not _value)  
        set_widget_flag_value(comics_window._replay_button, sf.gui.CBaseWidget.FlagDisabled, not _value)  
    end

    if _value or _total then
        if comics_window._continue_button then
           set_widget_flag_value(comics_window._continue_button, sf.gui.CBaseWidget.FlagHidden, not _value)  
            set_widget_flag_value(comics_window._continue_button, sf.gui.CBaseWidget.FlagDisabled, not _value)  
        end
        if comics_window._buttons_panel then
            set_widget_flag_value(comics_window._buttons_panel, sf.gui.CBaseWidget.FlagHidden, not _value)  
            set_widget_flag_value(comics_window._buttons_panel, sf.gui.CBaseWidget.FlagDisabled, not _value)  
        end
    end
end

function comics_window.Show(_window, _comcs_id, _track, _go_silence, _show_replay)

    --   
    comics_window._parent_window = _window
    comics_window._parent_window.AddFlags(comics_window._parent_window.FlagHidden)

    comics_window.comics_table = {}
    comics_window.step_index = nil
    comics_window.go_silence = _go_silence
    comics_widget.dark_color = nil
    comics_window.end_comics = nil

	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "comics_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	dialog.UpdateLayout()
    comics_window._self =     sf.gui.CBaseWindowPtrT(dialog)
    comics_window._replay_button = get_child_widget(dialog, "replay", sf.gui.CButtonWidget)
    comics_window._continue_button = get_child_widget(dialog, "skip_button", sf.gui.CButtonWidget)
    comics_window._buttons_panel = get_child_widget(dialog, "buttons_panel", sf.gui.CBaseWidget)
    comics_window._flash = get_child_widget(dialog, "flash", sf.gui.CFlashWidget)
    comics_window._has_flash = false

    if comics_window._allow_buttons_resize then
        local replay_button_size = sf.misc.FloatVector(comics_window._replay_button .GetSize())
        local continue_button_size = sf.misc.FloatVector(comics_window._continue_button .GetSize())

        local offset_r = 0
        local offset_c = 0
        local max_size = replay_button_size.X
        if max_size < continue_button_size.X then
            max_size = continue_button_size.X
            offset_r = max_size - replay_button_size.X
        else
            offset_r = max_size - continue_button_size.X
            offset_c = offset_r
        end

        comics_window._replay_button.SetSize(max_size, replay_button_size.Y)
        comics_window._continue_button.SetSize(max_size, continue_button_size.Y)

        local replay_button_offset = sf.misc.FloatVector(comics_window._replay_button .GetOffset())
        local continue_button_offset = sf.misc.FloatVector(comics_window._continue_button .GetOffset())
        
        comics_window._replay_button .SetOffset(replay_button_offset.X - offset_r, replay_button_offset.Y)
        comics_window._continue_button .SetOffset(continue_button_offset.X - offset_c, continue_button_offset.Y)
    end

	comics_window._ShowReplay(_show_replay, true)
	
	dialog.SetOffset((1024 - dialog.GetSize().X)/2, (768 - dialog.GetSize().Y)/2)

    for i,o in pairs(_comcs_id) do
        local new_elemet = {}        
        new_elemet.id = o.id
        new_elemet.start_time = o.start_time or comics_widget.def_start_time
        new_elemet.end_time = o.end_time or comics_widget.def_end_time
		
        new_elemet.object = sf.misc.anim.CClip()
        new_elemet.object.Load(_comcs_id[i].id, true)
        
        if new_elemet.object then
            local clip_size = dialog.GetSize()
            new_elemet.object.SetPos(clip_size/2)
            new_elemet.object.SetTime(0)
            new_elemet.time = qe.GetClipTime(new_elemet.object)
			new_elemet.flash_path = _comcs_id[i].flash_path
		end

        table.insert(comics_window.comics_table, new_elemet)
    end
    comics_window.SetCurrentChangeEffect(1)
    if _track ~= "" then
        sf.core.g_Application.GetAudioManager().StopGroup("music", 0)
        sf.core.g_Application.GetAudioManager().SetGroupVolume("music", 0)
        sf.core.g_Application.GetAudioManager().Play(_track, -2, -2, -2, -2, -2)
        comics_window._change_volume = true
    end
    
    local result = __cast(_window, sf.gui.CBaseWindow).DoModal(sf.gui.CBaseWindowPtrT(dialog))

    comics_window.SetHighFPS()
    collectgarbage()
    return result
end

function comics_window.DoDraw(_this, _renderer) 
    return false 
end

function comics_window.DoUpdate(_this) 
    local change_time = comics_window._change_timer.Get().GetTime()
    local koef = change_time/comics_window._finish_time
    local finish_efect = false
    if change_time > comics_window._finish_time then
        finish_efect = true
        koef = 1 
    end
    if comics_window._current_change_effect == 2 then
        --koef = 1 - koef
        comics_widget.dark_color = sf.graphics.Color( comics_window._start_alpha - (comics_window._start_alpha - 255)* koef, 0, 0, 0)
    elseif comics_window._current_change_effect == 1 then
        comics_widget.dark_color = sf.graphics.Color(((1-koef)) * 255, 0, 0, 0)
    end

	local sound_koef = koef
	if comics_window._current_change_effect == 2 then
		sound_koef = 1 - sound_koef
	end
    
    sf.core.g_Application.GetAudioManager().SetGroupVolume("sound", sound_koef * comics_window.max_sound_volume)
    if comics_window._change_volume then
        sf.core.g_Application.GetAudioManager().SetGroupVolume("music", sound_koef * comics_window.max_music_volume)
    end

    if finish_efect then
        if comics_window._current_change_effect == 2 and comics_window._end_effect_flag then
            comics_window._self = nil
			comics_window._end_effect_flag = nil
            comics_window._parent_window.RemFlags(comics_window._parent_window.FlagHidden)
		    _this.EndModal(0)
		end
		comics_window._current_change_effect = nil
		comics_window._change_volume = nil
    end

    return false 
end

function comics_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function comics_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	if _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast) then
        return true
    end
    if sf.core.g_Application.GetDebugLevel() >= sf.core.g_Application.DebugCheats then
        if _key == 114 then
            comics_window._self = nil
            comics_window._parent_window.RemFlags(comics_window._parent_window.FlagHidden)
            _this.EndModal(0)
            return true
        end
    end

    --[[
    if _key == 27 then
        local res = game_menu.Show(_this)
        if res == 1 then
            _this.EndModal(1)
        end
        
        return true
    end
]]
    return false
end

function comics_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function comics_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove( _pos, _state, _broadcast) 
end

function comics_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function comics_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function comics_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function comics_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function comics_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = comics_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end
	
comics_window.actions.skip_button = 
{
	pressed = function(_window) 
	
        comics_window._ShowReplay(false, true)
        comics_window.end_comics = true

	    if comics_window.go_silence then
	        comics_window._change_volume = true
	    end
	    comics_window.SetCurrentChangeEffect(2)
        comics_window._end_effect_flag = true
	end
}

comics_window.actions.replay = 
{
	pressed = function(_window) 
        comics_window.step_index = nil
	end
}
