dificulty_window = dificulty_window or {}
dificulty_window.actions = dificulty_window.actions or {}
dificulty_window.object = nil

function dificulty_window.Show(_window)
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "difficulty", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
    dificulty_window.Init(dialog)	
    dialog.UpdateLayout()
	dialog.SetOffset((_window.GetSize().X - dialog.GetSize().X)/2, (_window.GetSize().Y - dialog.GetSize().Y)/2)
    
    local dialog_ptr = sf.gui.CBaseWindowPtrT(dialog)
    modal_res = _window.DoModal(dialog_ptr)
	
    dialog_ptr = 0

	collectgarbage()
    return modal_res

end

function dificulty_window.Init(_window)
    local setter = nil
    local getter = nil  
    local hard_level_value = nil  
    local easy_level_value = nil  
    if game.g_GameOptions then
        setter = game.g_GameOptions.Instance().SetDificultyLevel
        getter = game.g_GameOptions.Instance().GetDificultyLevel
        hard_level_value = game.g_GameOptions.Instance().DificultyLevelHard  
        easy_level_value = game.g_GameOptions.Instance().DificultyLevelNoirmal  
    elseif game.GetDificultyLevel and game.SetDificultyLevel then
        setter = game.SetDificultyLevel
        getter = game.GetDificultyLevel
        hard_level_value = game.CGameOptions.DificultyLevelHard  
        easy_level_value = game.CGameOptions.DificultyLevelNoirmal  
    end
    
    dificulty_window.current_dif_level = getter()
    local normal_button_widget = __cast(_window.GetWidget("easy").get(), sf.gui.CButtonWidget)
    local hard_button_widget = __cast(_window.GetWidget("hard").get(), sf.gui.CButtonWidget)
    if dificulty_window.current_dif_level == easy_level_value then
        normal_button_widget.SetText(_T("$291"))--DisableButton(false)
        hard_button_widget.SetText(_T("$295"))
    elseif dificulty_window.current_dif_level == hard_level_value then
        normal_button_widget.SetText(_T("$296"))
        hard_button_widget.SetText(_T("$290"))
    end
    
end

function dificulty_window.DoDraw(_this, _renderer) 
    return false 
end

function dificulty_window.DoUpdate(_this) 
    return false 
end


function dificulty_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function dificulty_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	if _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast) then
        return true
    end
    
    if _key == 27 then
        _this.EndModal(0)
        return true
    end
    return false

end

function dificulty_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function dificulty_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove( _pos, _state, _broadcast) 
end

function dificulty_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function dificulty_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function dificulty_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function dificulty_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function dificulty_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = dificulty_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end
	
dificulty_window.actions.easy = 
{
	pressed = function(_window) 
        local new_dificulty_level = game.g_GameOptions.Instance().DificultyLevelNoirmal
        game.g_GameOptions.Instance().SetDificultyLevel(new_dificulty_level)
        game.g_GameOptions.Instance().UpdateLocalSettings()
        local res = game.g_GameOptions.Instance().ApplyOptionsChanges();
        game.g_GameOptions.Instance().Save()
        if dificulty_window.current_dif_level == new_dificulty_level then
		    _window.EndModal(0)
        else
            _window.EndModal(1)
        end
	end
}

dificulty_window.actions.hard = 
{
	pressed = function(_window) 
        local new_dificulty_level = game.g_GameOptions.Instance().DificultyLevelHard
        game.g_GameOptions.Instance().SetDificultyLevel(new_dificulty_level)
        game.g_GameOptions.Instance().UpdateLocalSettings()
        local res = game.g_GameOptions.Instance().ApplyOptionsChanges();
        game.g_GameOptions.Instance().Save()
        if dificulty_window.current_dif_level == new_dificulty_level then
		    _window.EndModal(0)
        else
            _window.EndModal(1)
        end
	end
}
