achievements = achievements or {}

achievements.params = 
{
	back_image = "screens_achievements_achievements_scenes", --  
	back_rect  = { x = 200, y = 505, x2 = 739, y2 = 648 }, --  
	icon_pos = { x = 210, y = 525 }, --      
    
    effects = --     
    {
        on_popup_get = --     ,     
        {
            bottom = --  
            {
                clip = "", 
                pos = { x = 500, y = 553 }
            },
            
            top = --  
            {
                clip = "achievements_completed_effect03",
                pos = { x = 490, y = 503 }
            }
        },
        on_popup_complete = --       
        {
            bottom = --  
            {
                clip = "achievements_completed_effect01", 
                pos = { x = 430, y = 503 }
            },
            
            top = --  
            {
                clip = "achievements_completed_effect02",
                pos = { x = 490, y = 503 }
            }
        },
        
        clip_on_take = "achievements_effect02" --    achievements.CreateTakeEffect
    },
    
	texts = --   
    {
        title =  --  
        {
            font = "font_20", -- 
            color = sf.graphics.Color(255, 255, 255, 255), -- 
            pos = { x = 310, y = 542 } -- 
        },
        score = -- 
        {
            font = "font_40",
            color = sf.graphics.Color(255, 255, 255, 255),
            pos = { x = 644, y = 554 }
        },
        progress = --   
        {
            font = "font_12_black",
            color = sf.graphics.Color(255, 255, 255, 255),
            pos = { x = 570, y = 595 }
        },
        description = --  
        {
            font = "font_12_black",
            color = sf.graphics.Color(255, 255, 255, 255),
            pos = { x = 300, y = 562 },
            width = 300 --   ;    . 
        },
        info = 
        {
            font = "font_12_black",
            color = sf.graphics.Color(255, 255, 255, 255),
            pos = { x = 640, y = 547 },
            text = 2268
        },
        info2 = 
        {
            font = "font_12_black",
            color = sf.graphics.Color(255, 255, 255, 255),
            pos = { x = 640, y = 594 },
            text = 2269
        }
    },
    
    progress = --  -
    {
        image = "screens_achievements_progressbar", --   
        frame_image = "screens_achievements_progressbar_back", --  
        pos = { x = 365, y = 594 } -- 
    },

	view_time = 4000, --   ,      
    sound_show_popup = "mini_scene_open_01", --     
    sound_achievement_complete = "mini_game_completed", --    ;     
}

function achievements.GetAchievement(_achievement)
	--  game  ,     QEditor
	--  QE    =>  
	if not game then return end
	
	local profile = game.g_ProfileManager.Instance().GetCurrentProfile()
	__assert(profile)
		
	local achs = game.g_Achievements.Instance().GetProfileAchievements(profile)

	if achs.IsCompleted(_achievement) ~= 0 then return end
	
	achs.AddProgress(_achievement, 1)
    
	local cur_progress = achs.GetProgress(_achievement)
	local ach_settings = game.g_Achievements.Instance().GetAchievementSettings(_achievement)
	local completed = cur_progress == ach_settings.MaxProgress 
	local show_progress = cur_progress == 1 or (ach_settings.MaxProgress > 1 and cur_progress % ach_settings.ShowProgressStep == 0)
	if completed or show_progress then
        --   
		achievements._ShowPopup(_achievement, achs.GetProgress(_achievement)) 
        --   
        if completed then
            if achievements.params.sound_achievement_complete ~= "" then
                sound(achievements.params.sound_achievement_complete)
            end
        elseif show_progress then
            if achievements.params.sound_show_popup ~= "" then
                sound(achievements.params.sound_show_popup)
            end
        end
	end
end

function achievements.IsAchievementComplete(_achievement)
	--  game  ,     QEditor
	--  QE    =>  
	if not game then return false end
    
    local profile = game.g_ProfileManager.Instance().GetCurrentProfile()
	__assert(profile)
    local achs = game.g_Achievements.Instance().GetProfileAchievements(profile)

	return achs.IsCompleted(_achievement) ~= 0
end

--  -   _object   (_offset_x, _offset_y)
-- id    achievements.params
function achievements.CreateTakeEffect(_object, _offset_x, _offset_y)
    if not _offset_x then _offset_x = 0 end
    if not _offset_y then _offset_y = 0 end
    
    local obj_pos = quest.get_object_pos(_object)
    __assert(obj_pos, " '".._object.."'  !")
    
    --  -    ,      
    --   
    local clip = over_scene_effect_widget.AddClipEffect(achievements.params.effects.clip_on_take)
    clip.SetPos(obj_pos + sf.misc.FloatVector(_offset_x, -clip.GetSize().Y/2 + _offset_y))
end

function achievements._ShowPopup(_achievement, _progress)
	local settings = game.g_Achievements.Instance().GetAchievementSettings(_achievement)

	achievements.icon = sf.core.g_Application.GetResourceManager().GetTexture(settings.Image)
	__assert(achievements.icon, "ACHIEVEMENTS:     '"..tostring(settings.Image).."'!")
	
	--  .   1,     
	achievements.progress = nil
	if settings.MaxProgress > 1 then
		achievements.progress = _progress
		achievements.max_progress = settings.MaxProgress
        
        achievements.progress_bar.SetValue(achievements.progress / achievements.max_progress)
	end
	
    achievements.score = settings.Score
	achievements.title = settings.Title
    achievements.description = settings.Description
    
    --   
    achievements.effects = {}
    local effect = nil
    if _progress == settings.MaxProgress then
        --     
        effect = achievements.params.effects.on_popup_complete
    else
        --     
        effect = achievements.params.effects.on_popup_get
    end
    if effect.top and effect.top.clip and effect.top.clip ~= "" then
        achievements.effects.top = sf.misc.anim.CClip()
        achievements.effects.top.Load(effect.top.clip, true)
        achievements.effects.top.SetPos(sf.misc.FloatVector(effect.top.pos.x, effect.top.pos.y))
    end
    if effect.bottom and effect.bottom.clip and effect.bottom.clip ~= "" then
        achievements.effects.bottom = sf.misc.anim.CClip()
        achievements.effects.bottom.Load(effect.bottom.clip, true)
        achievements.effects.bottom.SetPos(sf.misc.FloatVector(effect.bottom.pos.x, effect.bottom.pos.y))
    end
    
	achievements.timer.Get().SetTime(0)
	
	achievements.visible = true
end

function achievements.DoDraw(_this, _renderer)
	if not achievements.visible then return false end
	
    --    
    if achievements.effects.bottom then
        achievements.effects.bottom.Draw(_renderer)
    end
    
	--  
	local dest = sf.misc.FloatRect(achievements.params.back_rect.x, achievements.params.back_rect.y, 0, 0)
	dest.Width = achievements.params.back_rect.x2 - dest.X
	dest.Height = achievements.params.back_rect.y2 - dest.Y
	_renderer.RenderTextureBox(achievements.back_image.GetTexture(0), dest, 
		sf.misc.IntRect(0, 0, achievements.back_image.GetWidth(), achievements.back_image.GetHeight()), sf.graphics.Color(255, 255, 255, 255)) 
	
	--   
	_renderer.RenderTexture(achievements.icon.GetTexture(0), 
		achievements.params.icon_pos.x, achievements.params.icon_pos.y, sf.graphics.Color(255, 255, 255, 255))
        
    --   ,  
    if achievements.progress then
        achievements.progress_bar.Draw(_renderer)
    end
        
    --  
    local text_content = {}
    text_content.title = achievements.title
    text_content.score = tostring(achievements.score)
    --    
    if achievements.progress then
        text_content.progress = string.format("%i/%i", achievements.progress, achievements.max_progress)
    else
        text_content.progress = false
    end
    text_content.description = achievements.description
    
    --  
    for id, text_info in pairs(achievements.params.texts) do
        local text = text_info.text or text_content[id]
        __assert(text ~= nil)
        if text ~= false then
            if type(text) == "number" then
                text = sf.misc.g_StringTable.Instance().GetString(text)
            end
            
            local back_color = sf.graphics.Color(0, 255, 255, 255)
            if text_info.width then --   
                _renderer.RenderText(achievements._fonts[id], text,
                    sf.misc.IntRect(text_info.pos.x, text_info.pos.y, text_info.width, 0), 
                    sf.graphics.CRenderer.TextWordBreak, 0, text_info.color, back_color)
            else --    
                _renderer.RenderString(achievements._fonts[id], text, text_info.pos.x, text_info.pos.y, -1, -1, 1, 
                    text_info.color, sf.graphics.Color(0, 255, 255, 255))
            end
        end
    end
    
    --    
    if achievements.effects.top then
        achievements.effects.top.Draw(_renderer)
    end
    
	if achievements.timer.Get().GetTime() >= achievements.params.view_time then
		achievements.visible = false
        achievements.effects = {}
	end
	
	return false
end

function achievements.OnEndLevel()
    local profile = game.g_ProfileManager.Instance().GetCurrentProfile()
    local stats = profile.GetAchievementsStats()
    
    local level_id = quest.global_played_level.GetId()
    
    if not quest.g_LuaVariables.difficulty_changed then
        if difficulty.IsEasyDifficulty() then
            stats.AddEasyLevel(level_id)
            if stats.EnumEasyLevels() == 9 then
                achievements.GetAchievement("play_by_novice")
            end
        else
            stats.AddHardLevel(level_id)
            if stats.EnumHardLevels() == 9 then
                achievements.GetAchievement("play_by_expert")
            end
        end
    end
end

function achievements.DoUpdate(_this)
	if achievements.effects then
        for _,clip in pairs(achievements.effects) do
            clip.Update()
        end
    end
	return false
end

function achievements.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	if not _broadcast then
		local rect = achievements.params.back_rect
		if _pos.X >= rect.x and _pos.X <= rect.x2 and _pos.Y >= rect.y and _pos.Y <= rect.y2 then
			achievements.visible = false
		end
	end
	return false
end

function achievements.Load(_this)
	achievements.this = _this
    
    --    
    achievements._fonts = {}
    for id, content in pairs(achievements.params.texts) do
        local font = g_App.GetResourceManager().GetFont(content.font)
        __assert(font, "ACHIEVEMENTS:  '"..content.font.."'  !")
        achievements._fonts[id] = font
    end
	
	achievements.back_image = sf.core.g_Application.GetResourceManager().GetTexture(achievements.params.back_image)
	__assert(achievements.back_image, "ACHIEVEMENTS:  '"..achievements.params.back_image.."'  !")
    
    --  -
    ach_progress_bar = sf.gui.CProgressBarWidget("", 0, 0)
    --   -
    local image_progress_frame = sf.graphics.CImage(achievements.params.progress.frame_image)
    --    -
    local image_progress = sf.graphics.CImage(achievements.params.progress.image)
    --    -
    ach_progress_bar.SetImages(image_progress_frame, image_progress)
    --    -       
    -- (    )
    ach_progress_bar.SetSize(image_progress.GetTextureSize().X, image_progress.GetTextureSize().Y)
    --  
    ach_progress_bar.SetOffset(achievements.params.progress.pos.x, achievements.params.progress.pos.y)
    achievements.progress_bar = ach_progress_bar
	
	achievements.visible = false
	achievements.timer = __create_timer()
end

function achievements.__CreateInstance()
	return "achievements"
end

__inherite( achievements, null_lua_widget_handler() )