change_scene_widget = {}

__inherite(change_scene_widget, null_lua_widget_handler())

change_scene_widget.go_dark_time = 500
change_scene_widget.go_light_time = 500

change_scene_widget.darker_offset = sf.misc.FloatVector(0, 0)
change_scene_widget.darker_size = sf.misc.FloatVector(1024, 685)

change_scene_widget._timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")).AttachTimer(_T("")))

function change_scene_widget.__CreateInstance()
    return "change_scene_widget"
end

function change_scene_with_effect(_scene)

    if not change_scene_widget.main_menu_button and quest.global_quest_window then
         change_scene_widget.main_menu_button = __cast(quest.global_quest_window.GetWidget("menu_button").get(), "sf.gui.CButtonWidget")
    end
    
    change_scene_widget._max_sound_volume =  sf.core.g_Application.GetAudioManager().GetGroupVolume("sound")

    

    if change_scene_widget.main_menu_button then
        set_widget_flag_value(change_scene_widget.main_menu_button, sf.gui.CBaseWidget.FlagDisabled, true)  
    end
    
    change_scene_widget.new_scene = _scene

    change_scene_widget._StartEffect()    

	sleep(change_scene_widget.go_dark_time + change_scene_widget.go_light_time)
end

function change_scene_widget._StartEffect()
    quest.global_modify_level_flag = true     
    change_scene_widget.total_time = change_scene_widget.go_dark_time
    change_scene_widget.start_time = change_scene_widget._timer.Get().GetTime()
    change_scene_widget.effect_state = 1 -- 
    quest.global_cursor.SetDisableHints(true)
end

function change_scene_widget.DoUpdate(_this)
    local current_time = change_scene_widget._timer.Get().GetTime()
    if change_scene_widget.effect_state ~= nil then
        k = (current_time - change_scene_widget.start_time)/change_scene_widget.total_time
        if k > 1 then
            k = 1
        end
        if change_scene_widget.effect_state == 1 then
            change_scene_widget.dark_color = sf.graphics.Color(255*k, 0, 0, 0)
            sf.core.g_Application.GetAudioManager().SetGroupVolume("sound", change_scene_widget._max_sound_volume*(1 - k))
            if k == 1 then
                change_scene_widget.effect_state = 2
                change_scene_widget.total_time = change_scene_widget.go_light_time
                show_scene(change_scene_widget.new_scene)
                change_scene_widget.start_time = current_time
            end
        elseif change_scene_widget.effect_state == 2 then
            change_scene_widget.dark_color = sf.graphics.Color(255*(1 - k), 0, 0, 0)
            sf.core.g_Application.GetAudioManager().SetGroupVolume("sound", change_scene_widget._max_sound_volume*k)
            if k == 1 then
                change_scene_widget.effect_state = nil
                quest.global_cursor.SetDisableHints(false)
                if change_scene_widget.main_menu_button then
                    set_widget_flag_value(change_scene_widget.main_menu_button, sf.gui.CBaseWidget.FlagDisabled, false)  
                end

            end
        end
    end
	return false
end

function change_scene_widget.DoDraw(_this, _renderer)
    if change_scene_widget.effect_state then
        _renderer.RenderFilledPoly4(sf.misc.Poly4FromRect(sf.misc.FloatRect(change_scene_widget.darker_offset.X, change_scene_widget.darker_offset.Y, change_scene_widget.darker_size.X, change_scene_widget.darker_size.Y)), change_scene_widget.dark_color)
    end
    return true
end

function change_scene_widget.Load(_this, _info, _templates)

    local effect_info = quest.game_resources.GetChild("Constants", false).GetChildRef("change_scene_effect", false)
    if effect_info then
        
        local res = tonumber(effect_info.GetValue("go_dark_time").c_str())
        if res ~= nil then change_scene_widget.go_dark_time = res end

        res = tonumber(effect_info.GetValue("go_light_time").c_str())
        if res ~= nil then change_scene_widget.go_light_time = res end

        res = tonumber(effect_info.GetValue("dark_offset_x").c_str())
        if res ~= nil then change_scene_widget.darker_offset.X = res end

        res = tonumber(effect_info.GetValue("dark_offset_y").c_str())
        if res ~= nil then change_scene_widget.darker_offset.Y = res end

        res = tonumber(effect_info.GetValue("dark_size_x").c_str())
        if res ~= nil then change_scene_widget.darker_size.X = res end

        res = tonumber(effect_info.GetValue("dark_size_y").c_str())
        if res ~= nil then change_scene_widget.darker_size.Y = res end

    end
    return true
end
