difficulty = difficulty or {}

function difficulty.GetDifLevel()
    return game.GetDificultyLevel()
end

function difficulty.InitDifLevelOwerload(_window, _game_resources)

    local widget = _window.GetWidget("upper_panel", true).get()
    difficulty.easy_panel = __cast(widget, sf.gui.CImageWidget)            

    local widget = _window.GetWidget("upper_panel_hard", true).get()
    difficulty.hard_panel = __cast(widget, sf.gui.CImageWidget)            

    local widget = _window.GetWidget("take_objects_list", true).get()
    difficulty.take_objects_list = __cast(widget, sf.gui.CLuaWidget)            
end

function difficulty.ApplyDifLevelOwerload(_table_id)
    local show_widgets = difficulty.dif_table["show_take_obj_list"][_table_id]
    
    set_widget_flag_value(difficulty.easy_panel, sf.gui.CBaseWidget.FlagHidden, not show_widgets)  
    set_widget_flag_value(difficulty.hard_panel, sf.gui.CBaseWidget.FlagHidden, show_widgets)  

    --        
    set_widget_flag_value(difficulty.easy_panel, sf.gui.CBaseWidget.FlagDisabled, not show_widgets)  
    set_widget_flag_value(difficulty.hard_panel, sf.gui.CBaseWidget.FlagDisabled, show_widgets)  

    set_widget_flag_value(difficulty.take_objects_list, sf.gui.CBaseWidget.FlagHidden, not show_widgets)  
    set_widget_flag_value(difficulty.take_objects_list, sf.gui.CBaseWidget.FlagDisabled, not show_widgets)  
end


