end_level_lua_widget = end_level_lua_widget or {}

end_level_lua_widget._effect_timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")).AttachTimer(_T("")))

__inherite(end_level_lua_widget, null_lua_widget_handler())

function end_level_lua_widget.__CreateInstance()
    return "end_level_lua_widget"
end

end_level_lua_widget.go_dark = nil  --- 1 start_level 2 end_level
end_level_lua_widget.go_dark_time = 2000
end_level_lua_widget.go_light_time = 2000
end_level_lua_widget.pre_change_dif_level_delay = 1000
end_level_lua_widget.effect_time = nil
end_level_lua_widget.effect_start = nil
end_level_lua_widget.change_music_volume = nil

end_level_lua_widget.dark_color = sf.graphics.Color(0, 0, 0, 0)

function end_level_lua_widget.StartEffect(_sleep)
    end_level_lua_widget.max_music_volume =  game.GetMusicVolume()
    end_level_lua_widget.max_sound_volume =  game.GetSoundVolume()

    end_level_lua_widget.effect_start = true
    quest.global_quest_window.SetChildFocused(end_level_lua_widget.self)
    set_widget_flag_value(end_level_lua_widget.self, sf.gui.CBaseWidget.FlagDisabled, false)  
    set_widget_flag_value(end_level_lua_widget.self, sf.gui.CBaseWidget.FlagHidden, false)     
    quest.do_not_change_curosor = true
    if _sleep then
        sleep(end_level_lua_widget.go_dark_time)    
    end
    quest.do_not_change_curosor = false
end

function end_level_lua_widget.StartLight(_incres_volume, _show_change_dif_level_window)
    end_level_lua_widget.change_music_volume = _incres_volume
    end_level_lua_widget.go_dark = 1
    end_level_lua_widget.dark_color = sf.graphics.Color(255, 0, 0, 0)
    end_level_lua_widget.effect_time = end_level_lua_widget.go_light_time
    if _show_change_dif_level_window then
        end_level_lua_widget.widow_delay = end_level_lua_widget.pre_change_dif_level_delay
    else
        end_level_lua_widget.widow_delay = nil
    end
    end_level_lua_widget.StartEffect(false)
end

function end_level_lua_widget.StartDark(_decres_volume)
    end_level_lua_widget.change_music_volume = _decres_volume
    end_level_lua_widget.go_dark = 2
    end_level_lua_widget.dark_color = sf.graphics.Color(0, 0, 0, 0)
    end_level_lua_widget.effect_time = end_level_lua_widget.go_dark_time
    end_level_lua_widget.StartEffect(true)
end

function end_level_lua_widget.DoUpdate(_this)
    if end_level_lua_widget.go_dark then
        if end_level_lua_widget.effect_start then
            end_level_lua_widget.effect_start = nil
            end_level_lua_widget._effect_timer.Get().SetTime(0)    
        end
    
        local time = end_level_lua_widget._effect_timer.Get().GetTime()
        local koef = time / end_level_lua_widget.effect_time
        local finish_effect = false
        if time > end_level_lua_widget.effect_time then
            koef = 1
            finish_effect = true
        end

        if end_level_lua_widget.go_dark == 1 then
            if end_level_lua_widget.widow_delay and time > end_level_lua_widget.widow_delay then
                --dificulty_window.Show(quest.global_quest_window)
                end_level_lua_widget.widow_delay = nil
                sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")).SetK(0)
				
                local res = dificulty_window.Show(quest.global_quest_window)
                if res == 1 then
                    difficulty.ApplyDifLevel()
                end
                
                quest.g_LuaVariables.difficulty = nil
                quest.g_LuaVariables.difficulty_changed = nil
                
                sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")).SetK(1)
            end
            koef = 1 - koef
        end
        
        end_level_lua_widget.dark_color = sf.graphics.Color((koef) * 255, 0, 0, 0)
        
        sf.core.g_Application.GetAudioManager().SetGroupVolume("sound", (1 - koef) * end_level_lua_widget.max_sound_volume)
        if end_level_lua_widget.change_music_volume then
            sf.core.g_Application.GetAudioManager().SetGroupVolume("music", (1 - koef) * end_level_lua_widget.max_music_volume)
        end

        if finish_effect then
            if end_level_lua_widget.go_dark == 1 then
                set_widget_flag_value(end_level_lua_widget.self, sf.gui.CBaseWidget.FlagDisabled, true)  
                set_widget_flag_value(end_level_lua_widget.self, sf.gui.CBaseWidget.FlagHidden, true)     
            end
            end_level_lua_widget.go_dark = nil
            end_level_lua_widget.change_music_volume = nil
        end

    end
    return true
end

function end_level_lua_widget.DoDraw(_this, _renderer)
    _renderer.RenderFilledPoly4(sf.misc.Poly4FromRect(sf.misc.FloatRect(0, 0, 1024, 768)), end_level_lua_widget.dark_color)
    return true
end

function end_level_lua_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)
    return true
end

function end_level_lua_widget.OnMouseMove(_this, _pos, _state, _broadcast)
    return true
end

function end_level_lua_widget.OnDoubleClick(_this, _pos, _state, _broadcast)
    return true
end

function end_level_lua_widget.OnMouseUp(_this, _pos, _button, _state, _broadcast)
    return true
end

function end_level_lua_widget.Load(_this, _info, _templates)
    end_level_lua_widget.self = _this
    set_widget_flag_value(end_level_lua_widget.self, sf.gui.CBaseWidget.FlagDisabled, true)  
    set_widget_flag_value(end_level_lua_widget.self, sf.gui.CBaseWidget.FlagHidden, true)  
    
    local end_level_constants = quest.game_resources.GetChild("Constants", false).GetChildRef("change_step_effects", false)
    if end_level_constants then
        local res = tonumber(end_level_constants.GetValue("end_level_time").c_str())
        if res ~= nil then end_level_lua_widget.go_dark_time = res end

        res = tonumber(end_level_constants.GetValue("start_level_time").c_str())
        if res ~= nil then end_level_lua_widget.go_light_time = res end
    end
    return true
end

function end_level_lua_widget.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	return true
end
