quest_window = quest_window or {}

function quest.UpdateHintGui()
    local hints_count = quest.GetHints()
    if g_HintButtonWidget ~= nil then
        --local new_hint_button_text = "?" --string.format (quest_window.hint_button_text, quest.GetHints())
        if hints_count < hints_lua_widget.working_hints_count then
          --  new_hint_button_text =""
            --set_widget_flag_value(g_HintButtonWidget, sf.gui.CBaseWidget.FlagDisabled, true)  
            g_HintButtonWidget.DisableButton(true)
        else
            --set_widget_flag_value(g_HintButtonWidget, sf.gui.CBaseWidget.FlagDisabled, false)  
            g_HintButtonWidget.DisableButton(false)
            g_HintButtonWidget.OnMouseMove(sf.misc.FloatVector(-1000, -1000), 0, true)
        end
        --g_HintButtonWidget.SetText(new_hint_button_text)
    end
end

function quest.InitQuestWindow(_window)
    quest_window.hint_button_text = sf.misc.g_StringTable.Instance().FormatByStringsID(
		quest.game_resources.GetChild("Constants", false).GetChild("game_hints", false).GetValue("hint_button_string").c_str()).c_str()

    if quest_window.hint_button_text == "" then
        quest_window.hint_button_text = "Hint x %i"
        __message("      ", "")
    end

    local widget = _window.GetWidget("hint_button", true).get()
    local hint_button = __cast(widget, sf.gui.CButtonWidget)
    g_HintButtonWidget = hint_button
    quest.UpdateHintGui()

    if g_HintButtonWidget then
        widget = _window.GetWidget("hints_widget", true).get()
        local hint_widget = __cast(widget, sf.gui.CLuaWidget)
        local new_widget_offset = g_HintButtonWidget.GetOffset() + g_HintButtonWidget.GetSize()/2
        g_HintButtonWidget.UpdateLayout()
        hint_widget.SetOffset(new_widget_offset.X, new_widget_offset.Y)
    end
end
quest_window = quest_window or {}
quest_window.actions = quest_window.actions or {}


quest_window.actions.main_panel =
{
    mouse_move = function(_window, _widget) 
       if quest.global_played_level then 
           quest.global_played_level.UpdateFocusedObject(nil) 
       end 
    end
}

quest_window.actions.upper_panel =
{
    mouse_move = function(_window, _widget) 
       if quest.global_played_level then 
           quest.global_played_level.UpdateFocusedObject(nil) 
       end
    end
}

quest_window.actions.upper_panel_hard =
{
    mouse_move = function(_window, _widget) 
       if quest.global_played_level then 
           quest.global_played_level.UpdateFocusedObject(nil) 
       end 
    end
}

---        
quest_window.actions.full_screen_minigame_exit_button = 
{
	pressed = function(_window) 
		minigame_window.CloseGame()
	end
}

quest_window.actions.full_screen_minigame_solve_button = 
{
	pressed = function(_window) 
		minigame_window.SolveGame()
	end
}

quest_window.actions.main_object_box_widget =
{
	object_selected = function(_window, _widget)
        local invent_widget = __cast(_widget, qe.CObjectsBoxWidget)
        local selected_object = invent_widget.GetSelectedObject()
        if selected_object ~= nil then
            quest.global_cursor.SetCursorObject(selected_object)
        else
            quest.global_cursor.ClearCursor(false)
        end
	end,
	mouse_over = function(_window, _widget)
        local invent_widget = __cast(_widget, qe.CObjectsBoxWidget)
        quest.global_played_level.UpdateFocusedObject(invent_widget.GetOverObject())
        quest.global_played_level.UpdateHint(invent_widget.GetOverObject())
	end
}

