--[[
      .
 : http://wiki/HomePage/QuestEngine/HOG
]]

--[[
    hidden_category.categories -    .     ,   . 
      left_to_find  found -      , .
    
    hidden_category.object_to_take -   ,       .
    
         ,         .   
    hidden_category.categories.
    
       (  ),    ,  userdata  "f",    
    hidden_category.categories.
    
      hidden_category    hidden_object.    hidden_object   
    . 
]]
hidden_category = {}

hidden_category.params = {}

--    
--     QE  " "  -
-- 	_current_scene - ,    
--	_return_scene - id ,       
--  _categories_settings -      
--  _script_on_complete - ,     
function hidden_category.Start(_current_scene, _return_scene, _categories_settings, _script_on_complete)
    --     hidden_object
    --   
    hidden_category.hidden_object = hidden_object
    hidden_category.lua_widget._this = hidden_object.lua_widget._this
    hidden_category.OnStart = hidden_object.OnStart
    hidden_category.OnEnd = hidden_object.OnEnd
    hidden_object = hidden_category
    
    -- callback   
    local callback, err = loadstring("return function() "..(_script_on_complete or "").." end")
	if not callback then __message("Error: "..err) end
	hidden_category.on_complete = callback()

	hidden_category.font = sf.core.g_Application.GetResourceManager().GetFont(hidden_category.params.label_font)
	__assert(hidden_category.font, "HOG:  '"..hidden_category.params.label_font.."'  !")
	
	hidden_category.scene = _current_scene
	__assert(hidden_category.scene)
    
    hidden_category.categories_settings = _categories_settings
	
	-- ,    
    hidden_category.object_shape_category = nil
	
	-- id ,     
	hidden_category.return_scene = _return_scene
	
	--     
	hidden_category.label_selected_back = sf.core.g_Application.GetResourceManager().GetTexture(
        hidden_category.params.label_selected_back)
	__assert(hidden_category.label_selected_back, "HOG:  '"..hidden_category.params.label_selected_back..
        "',        ,  !")
	
	hidden_category.timer = __create_timer()
	
	--    ?
	hidden_category.active = true
	
	--   
	hidden_category.prev_disable_hints_value = quest.global_cursor.GetDisableHints()
	quest.global_cursor.SetDisableHints(true)
	
	--   
	tasks_lua_widget.Show(false)
	--     
	take_objects_list.Hide()
    
    
    --      
    -- ,      
    --      
    --       ,   
    hidden_category.object_to_take = nil
    
    --  ,   
    hidden_category.all_categories = {}
    
    -- :  -> ,    + -  
    hidden_category.categories = {} 
    
    local obj_iter = hidden_category.scene.GetObjects()
    while not obj_iter.IsEnd() do
        local obj = obj_iter.Get()
        
        if hidden_category._IsObjectToTake(obj) then
            __assert(not hidden_category.object_to_take)
            hidden_category.object_to_take = obj
        end
        
        local category_id = hidden_category._GetObjectCategory(obj)
        if category_id then
            --    
            __assert(_categories_settings[category_id], "  "..tostring(category_id)..
                "    hidden_category.Start\n "..tostring(hidden_category.scene.GetId())) 
            
            --      
            if not hidden_category.all_categories[category_id] then
                hidden_category.all_categories[category_id] = {}
            end
            table.insert(hidden_category.all_categories[category_id], obj)
            
            --     -     
            --     -    
            if not hidden_category.categories[category_id] then
                --  
                hidden_category.categories[category_id] = 
                    { 
                        id = category_id,
                        left_to_find = 0, --   
                        found = 0 --  
                    }
            end            
            local category = hidden_category.categories[category_id]
            if not obj.ReadObjectFlag(obj.ObjectFlagDisable) then
                --  ,    
                obj.SetLuaScript("hidden_category.object_click()", obj.ScriptMouseClick)
                category.left_to_find = category.left_to_find + 1
                table.insert(category, obj)
            elseif  hidden_category._IsMarkedAsFound(obj) then
                --     
                category.found = category.found + 1
            end
        end
        obj_iter.Next()
    end
    
    --      
    --     
    local categories = {}
    for id, category in pairs(hidden_category.categories) do
        if #category ~= 0 or category.found > 0 then
            --       
            -- ,    
            __assert(#category == category.left_to_find)
            __assert(#category + category.found == #(hidden_category.all_categories[id]))
            table.insert(categories, category)
        end
    end 
    hidden_category.categories = categories
	
	hidden_category.lua_widget.Show(true)
	
	hidden_category.OnStart()
end

--   ,        
--     ,   _categories_to_find
--         _object_for_take
function hidden_category.InitHogScene(_scene_id, _object_for_take, _categories_to_find)
    --     : .  =>    
    local categories_to_find_map = {}
    for _, id in ipairs(_categories_to_find) do
        categories_to_find_map[id] = true
    end

    --       
    --      
    local scene = quest.global_played_level.GetSceneById(_scene_id)
    __assert(scene)
    local obj_iter = scene.GetObjects()
    while not obj_iter.IsEnd() do
        local obj = obj_iter.Get()
        local category = hidden_category._GetObjectCategory(obj)
        if category then
            __assert(not hidden_category._IsMarkedAsFound(obj))
            if categories_to_find_map[category] then
                obj.ClearObjectFlag(obj.ObjectFlagDisable)
            else
                obj.RaiseObjectFlag(obj.ObjectFlagDisable)
                obj.SetLuaScript("", obj.ScriptMouseClick)
            end
        end
        
        if obj.GetIdRef().compare(_object_for_take) == 0 then
            --       
            --  
            __assert(not category)
            __assert(obj.GetUserData().empty())
            obj.SetUserData("t")
            obj.RaiseObjectFlag(obj.ObjectFlagHidden)
        end
        
        obj_iter.Next()
    end
end

function hidden_category.GetActiveScene()
    return hidden_category.active and hidden_category.scene.GetId().c_str()
end

--       
function hidden_category._ResetObjects()
    for _, objects in pairs(hidden_category.all_categories) do
        for _, obj in ipairs(objects) do
            obj.RaiseObjectFlag(obj.ObjectFlagDisable)
            obj.ClearObjectFlag(obj.ObjectFlagHidden)
            obj.SetUserData("")
        end
    end
    
    if hidden_category.object_to_take then
        hidden_category.object_to_take.SetUserData("")
    end
end

--      nil,    
--  
function hidden_category._GetObjectCategory(_obj)
    return tonumber(string.match(tostring(_obj.GetId()), "^__hog(%d+)"))
end

--    
function hidden_category._MarkAsFound(_obj)
    __assert(hidden_category._GetObjectCategory(_obj))
    __assert(_obj.GetUserData().empty())
    _obj.SetUserData("f")
end

--     ?
function hidden_category._IsMarkedAsFound(_obj)
    local is_found = _obj.GetUserData().compare("f") == 0
    --   ,      
    __assert(not is_found or hidden_category._GetObjectCategory(_obj))
    return is_found
end

--       ?
function hidden_category._IsObjectToTake(_obj)
    local is_to_take = _obj.GetUserData().compare("t") == 0
    --      ,       
    __assert(not is_to_take or not hidden_category._GetObjectCategory(_obj))
    return is_to_take
end

--    
function hidden_category._Complete()
	hidden_category.OnEnd()

	--      , 
	if hidden_category.object_to_take then
		--       ,   
		hidden_category.lua_widget.Show(false)
		take(tostring(hidden_category.object_to_take.GetIdRef()))
	end
    
    hidden_category.on_complete()
    
	--      
	hidden_category.Close()
	hidden_category._ResetObjects()
end

--  
function hidden_category.Close()
	-- FIXME:      ,      (  ),   
	-- c ,    
	hidden_category.lua_widget.Show(false)
	show_scene(hidden_category.return_scene)
	
	hidden_category.active = false
	
	--       
	quest.global_cursor.SetDisableHints(hidden_category.prev_disable_hints_value)
	--   
	tasks_lua_widget.Show(true)
	--     
	take_objects_list.Show()
    

    hidden_object = hidden_category.hidden_object
end

--    
function hidden_category.CompleteUsingCheat()
	--    
	if not hidden_category.active then return end

	--       
	--    -        
	--    -    
    
    local cycles = 0
    while true do
        local found = false
        for _, category in ipairs(hidden_category.categories) do
            if #category > 0 then
                local obj = category[1]
                quest.global_scene_widget.RunMouseCickScript(obj, obj.GetPos())
                threads_managment.InterruptClickScript()
                found = true
                break
            end
        end
        
        if not found then 
            break 
        end
        
        cycles = cycles + 1
        if cycles > 10000 then 
            __message("   !")
            break 
        end
    end
	
	return true
end

function hidden_category.click() end

--       ,   
function hidden_category.object_click()
    local object = quest.global_current_script_object
    
    --   ,  
    local category_id = hidden_category._GetObjectCategory(object)
    __assert(category_id)
    __assert(not hidden_category._IsMarkedAsFound(object))
    local object_category = nil
    for _, category in ipairs(hidden_category.categories) do
        if category_id == category.id then
            object_category = category
            break
        end
    end
    __assert(object_category)
    
    
    hidden_category._MarkAsFound(object)
    object.RaiseObjectFlag(object.ObjectFlagDisable)
    object.RaiseObjectFlag(object.ObjectFlagHidden)
    object_category.left_to_find = object_category.left_to_find - 1
    __assert(object_category.left_to_find >= 0)
    object_category.found = object_category.found + 1
    
    --      
    local removed = false
    for i, o in ipairs(object_category) do
        if o.GetIdRef() == object.GetIdRef() then
            table.remove(object_category, i)
            removed = true
            break
        end
    end
    __assert(removed)
    
	neutral_click() --    -  
	
	--      ,   
	-- if hidden_category.object_shape and hidden_category.object_shape.GetIdRef() == object.GetIdRef() then
		-- hidden_category.object_shape = nil
	-- end
	
	--      - 
    for _, category in ipairs(hidden_category.categories) do
        if category.left_to_find > 0 then 
            return true 
        end
	end
    --  ,  
    hidden_category._Complete()
	
	return true
end

--       
hidden_category.lua_widget = 
{
	_this = nil,
	last_object_shape_category = nil,
	
	-- /     
	Show = function(_show)
		local this = hidden_category.lua_widget._this
		local inventory = objects_box_lua_widget.self
		__assert(this, "lua_widget  id = 'hidden_category'     gui.xml")
		if not _show then
			if difficulty.GetDifLevel() == 0 then
				set_widget_flag_value(difficulty.easy_panel, sf.gui.CBaseWidget.FlagHidden, false)
				set_widget_flag_value(difficulty.easy_panel, sf.gui.CBaseWidget.FlagDisabled, false)
				set_widget_flag_value(difficulty.hard_panel, sf.gui.CBaseWidget.FlagHidden, true)
				set_widget_flag_value(difficulty.hard_panel, sf.gui.CBaseWidget.FlagDisabled, true)
			end
			inventory.RemFlags(__or(inventory.FlagHidden, inventory.FlagDisabled))
			this.AddFlags(sf.misc.BitwiseOr(this.FlagDisabled, this.FlagHidden))
		else
			set_widget_flag_value(difficulty.easy_panel, sf.gui.CBaseWidget.FlagHidden, true)
			set_widget_flag_value(difficulty.easy_panel, sf.gui.CBaseWidget.FlagDisabled, true)
			set_widget_flag_value(difficulty.hard_panel, sf.gui.CBaseWidget.FlagHidden, false)
			set_widget_flag_value(difficulty.hard_panel, sf.gui.CBaseWidget.FlagDisabled, false)
			inventory.AddFlags(__or(inventory.FlagHidden, inventory.FlagDisabled))
			this.RemFlags(sf.misc.BitwiseOr(this.FlagDisabled, this.FlagHidden))
		end
	end,

	Load = function(_this)
		local self = hidden_category.lua_widget
		
		self._this = _this
		_this.AddFlags(sf.misc.BitwiseOr(_this.FlagDisabled, _this.FlagHidden))
		
		self.effects = {}
	end,
	
	DoUpdate = function(_this)
		local self = hidden_category.lua_widget
		
		--   :-(  
		
		if self.effects.select_effect and self.effects.select_effect:Update() then
			self.effects.select_effect = nil
		end
		
		if self.effects.label_back_appear and self.effects.label_back_appear:Update() then
			self.effects.label_back_appear = nil
		end
		
		return false
	end,
	
	DoDraw = function(_this, _renderer)
	
		local self = hidden_category.lua_widget
	
		--     
		local label_area = hidden_category.params.label_area
		if hidden_category.params.debug_render then
			sf.graphics.RenderRect(_renderer, sf.misc.FloatRect(label_area.x, label_area.y, label_area.x2 - label_area.x, label_area.y2 - label_area.y), 
				sf.graphics.Color(255, 255, 255, 255))
		end
		
		--   
		local shape_area = hidden_category.params.shape_area
		if hidden_category.params.debug_render then
			sf.graphics.RenderRect(_renderer, sf.misc.FloatRect(shape_area.x, shape_area.y, shape_area.x2 - shape_area.x, shape_area.y2 - shape_area.y), 
				sf.graphics.Color(255, 255, 255, 0))
		end
		
		if not hidden_category.font then return false end
		
		--   
        local categories_count = #hidden_category.categories
		local x, y = (label_area.x2 + label_area.x)/2, label_area.y
        local offy = ((label_area.y2 - label_area.y) - categories_count * hidden_category.font.PixHeight)/(categories_count + 1)
        y = y + offy
		local categories = hidden_category.categories
        for _, category in ipairs(categories) do
            local settings = hidden_category.categories_settings[category.id]
            local text = settings.text
            text = sf.misc.g_StringTable.Instance().FormatByStringsID(text)
            text = qe.StringFormat(text, category.found, category.left_to_find + category.found)
            local width = hidden_category.font.GetStringWidth(text)
            
            --    
            if category.id == hidden_category.object_shape_category or category.id == self.last_object_shape_category then
                _renderer.RenderTexture(hidden_category.label_selected_back.GetTexture(0), 
                    sf.misc.FloatRect(x - width/2, y, width, hidden_category.font.PixHeight), 
                    sf.misc.IntRect(0, 0, 0, 0), 
                    category.id == hidden_category.object_shape_category and self.label_back_color or self.last_label_back_color)
            end
            
            --  
            if category.id == hidden_category.object_shape_category then
                if #category == 0 then
                    hidden_category.object_shape_category = nil
                else
                    local x, y = shape_area.x, shape_area.y -- (x,y) -   
                    local width, height = shape_area.x2 - shape_area.x + 1, shape_area.y2 - shape_area.y + 1
                    if shape_area.x2 and shape_area.y2 then
                        x = (shape_area.x2 + x)/2
                        y = (shape_area.y2 + y)/2
                    end
                    
                    _renderer.PushState()
                    
                    local obj = category[1]
                    local objsize = obj.GetSize()
                    if objsize.X > width or objsize.Y > height then
                        local k, ky = width/objsize.X, height/objsize.Y
                        if ky < k then k = ky end
                        _renderer.ApplyMatrix(sf.misc.MatrixScale(k, k)*sf.misc.MatrixTranslation( x,  y ))
                    else
                        _renderer.ApplyMatrix(sf.misc.MatrixTranslation( x,  y ))
                    end
                
                    _renderer.SetColor(self.object_shape_color)
                    obj.Draw(_renderer)
                    
                    _renderer.PopState()
                end
            end
            
            local color = hidden_category.params.label_color
            _renderer.RenderString(hidden_category.font, text, x, y, 0, -1, 1, color, 0)
            
            y = y + offy + hidden_category.font.PixHeight
        end
		
		return false
	end,
	
	OnMouseMove = function(_this, _pos, _state, _broadcast)
		if not hidden_category.font or _broadcast then return false end
		
		local font = hidden_category.font
		local label_area = hidden_category.params.label_area
	
		-- ,     
        local categories_count = #hidden_category.categories
		local x, y = (label_area.x2 + label_area.x)/2, label_area.y
        local offy = ((label_area.y2 - label_area.y) - categories_count * hidden_category.font.PixHeight)/(categories_count + 1)
        y = y + offy
		local categories = hidden_category.categories
        for _, category in ipairs(categories) do
            local settings = hidden_category.categories_settings[category.id]
            local text = settings.text
            text = sf.misc.g_StringTable.Instance().FormatByStringsID(text)
            text = qe.StringFormat(text, category.found, category.left_to_find + category.found)
            
            local width = hidden_category.font.GetStringWidth(text)
            local height = hidden_category.font.PixHeight
                        
            if _pos.X >= x - width/2 and _pos.X <= x + width/2 and _pos.Y >= y and _pos.Y <= y + height then
                -- 
                hidden_category.lua_widget._InitSelectEffect(category.id)
                return false
            end
            
            y = y + offy + hidden_category.font.PixHeight
        end
		
		hidden_category.lua_widget.select_effect = nil
		return false
	end,
	
	--      
	_InitSelectEffect = function(_category) 
		local self = hidden_category.lua_widget
		
		if hidden_category.object_shape_category == _category or self.effects.select_effect and self.effects.select_effect.category == _category then return end
		
		--    
		self.effects.select_effect = 
		{
			category = _category,
			time = hidden_category.timer.Get().GetTime() + hidden_category.params.label_select_delay,
			
			Update = function(_self)
				if _self.time > hidden_category.timer.Get().GetTime() then return end
				
				local widget = hidden_category.lua_widget
				
				--       
				hidden_category.object_shape_category = _self.category
				widget.label_back_color = sf.graphics.Color(0, 255, 255, 255)
				widget.object_shape_color = sf.graphics.Color(0, 0, 0, 0)
				
				--            
				hidden_category.lua_widget.effects.label_back_appear = 
				{
					time = hidden_category.timer.Get().GetTime() + hidden_category.params.select_appear_time,
					
					Update = function(_self)
						if _self.time > hidden_category.timer.Get().GetTime() then 
							--   
							local k = (_self.time - hidden_category.timer.Get().GetTime())/hidden_category.params.select_appear_time
							widget.label_back_color.Alpha = (1 - k)*255
							
							widget.object_shape_color.Alpha = (1 - k)*255
							return
						end
							
						--  
						widget.label_back_color.Alpha = 255
						widget.object_shape_color.Alpha = 255
						widget.last_object_shape_category = nil
						return true
					end
				}
				
				return true
			end
		}
	end,
	
	effects = {},
	
	_actions = 
	{
		hog_close_button = 
		{
			pressed = function()
				hidden_category.Close()
				return true
			end
		}
	},
}

__inherite(hidden_category.lua_widget, null_lua_widget_handler(hidden_category.lua_widget._actions))
