over_scene_effect_widget = {}

over_scene_effect_widget._clips = {}
over_scene_effect_widget._timer = __create_timer()

__inherite(over_scene_effect_widget, null_lua_widget_handler())

function over_scene_effect_widget.__CreateInstance()
    return "over_scene_effect_widget"
end

function over_scene_effect_widget.DoDraw(_this, _renderer)
	local self = over_scene_effect_widget
	
	self._effect_list:PreDraw(_renderer)
	self._effect_list:PostDraw(_renderer)
    
    --   - 
    for _, clip_info in ipairs(over_scene_effect_widget._clips) do
        clip_info.clip.Draw(_renderer)
	end
    
	if self._scene then self._scene.Draw(_renderer) end
	if self._amulet_apply_clip then self._amulet_apply_clip.Draw(_renderer) end
	return false
end

function over_scene_effect_widget.DoUpdate(_this)
	over_scene_effect_widget._effect_list:Update()
	if over_scene_effect_widget._scene then over_scene_effect_widget._scene.Update() end
    
    local cur_time = over_scene_effect_widget._timer.Get().GetTime()
    
    --   - 
    local i, size = 1, #over_scene_effect_widget._clips
    while i <= size do
        local clip_info = over_scene_effect_widget._clips[i]
        clip_info.clip.Update()
        if cur_time - clip_info.start_time >= clip_info.time then
            --  ,  
            table.remove(over_scene_effect_widget._clips, i)
            i = i - 1
            size = size - 1
        end
        i = i + 1
    end
    
	return true
end

function over_scene_effect_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	if not _broadcast and _pos.Y < 676 and not quest.global_minigame_opened then
		--
	end
	return false
end

function over_scene_effect_widget.SetAmuletApplyEffectClip(_clip)
	over_scene_effect_widget._amulet_apply_clip = _clip
end

function over_scene_effect_widget.Load(_this, _info, _templates)
	over_scene_effect_widget._effect_list = visual_effects.CreateEffectsList()
	return true
end

function over_scene_effect_widget.AddEffect(_id, _pos)
	return over_scene_effect_widget._effect_list:CreateInstantEffect(_id, _pos)
end

--         
--          once 
--   
function over_scene_effect_widget.AddClipEffect(_id)
    local clip_info = 
    {
        clip = sf.misc.anim.CClip(),
        start_time = over_scene_effect_widget._timer.Get().GetTime()
    }
    clip_info.clip.Load(_id, true)
    clip_info.time = qe.GetClipTime(clip_info.clip)
    table.insert(over_scene_effect_widget._clips, clip_info)
    return clip_info.clip
end

function over_scene_effect_widget.SetScene(_scene)
	over_scene_effect_widget._scene = _scene
end

function quest.OnWrongClick(_pos)
    over_scene_effect_widget.AddEffect("EffectOnClick", _pos)
end