scene_effects = {}

scene_effects.flashlight = 
{
	Init = function(_back_id, _mask_id, _spot_id)
		if game==nil then return end
		
		local scene_widget = __cast(quest.global_scene_widget, qe.CSceneWidget)
		assert(scene_widget)
		assert(not scene_widget.GetWidget("__flashlight", false).get())
		
		scene_effects.flashlight.back = sf.core.g_Application.GetResourceManager().GetTexture(_back_id)
		assert(scene_effects.flashlight.back)
		scene_effects.flashlight.mask = sf.core.g_Application.GetResourceManager().GetTexture(_mask_id)
		assert(scene_effects.flashlight.mask)
		
		if _spot_id then
			scene_effects.flashlight.spot = sf.core.g_Application.GetResourceManager().GetTexture(_spot_id)
			assert(scene_effects.flashlight.spot)
			scene_effects.flashlight.spot = scene_effects.flashlight.spot.GetTexture(0)
			assert(scene_effects.flashlight.spot)
		else
			scene_effects.flashlight.spot = nil
		end
	
		local flashlight = sf.gui.CLuaWidget("__flashlight", 0, sf.gui.CWidget.BroadcastOnMouseMove)
		flashlight.SetLua(quest.g_Lua.GetId())
		flashlight.SetOverloadTable("scene_effects.flashlight")
		scene_widget.AddWidget(flashlight)
		
		scene_effects.flashlight.abs_pos = flashlight.GetAbsPos(true)
	end,
	
	DoDraw = function(_this, _renderer)
		_renderer.PushState()
		
		local cursor_pos = sf.gui.g_Cursor.Instance().GetPosition() - scene_effects.flashlight.abs_pos
		game.misc.RenderFlashlightEffect(_renderer, scene_effects.flashlight.back, scene_effects.flashlight.mask, cursor_pos.X, cursor_pos.Y)
		if scene_effects.flashlight.spot then
			_renderer.SetBlendMode(_renderer.BlendAdditive)
			local rect = scene_effects.flashlight.spot.GetRect()
			_renderer.RenderTexture(scene_effects.flashlight.spot, cursor_pos.X - rect.Width/2, cursor_pos.Y - rect.Height/2, sf.graphics.Color(255, 255, 255, 255))
		end
		_renderer.PopState()
		return true
	end,
	
	__CreateInstance = function() return "scene_effects.flashlight" end
}
__inherite(scene_effects.flashlight, null_lua_widget_handler(scene_effects.flashlight.actions))
