child_scenes = child_scenes or {}
child_scenes.close_scene_time = 300
child_scenes.open_scene_time = 300

child_scenes.open_minigame_time = 700
child_scenes.close_minigame_time = 700
child_scenes.close_minigame_pause = 500

function quest.OnCloseScene(_scene_widget)
    game.AddEffectToWidget(_scene_widget, child_scenes.close_scene_time, _scene_widget.GetInitPos(), sf.misc.FloatVector(1, 1), sf.misc.FloatVector(0, 0))
    game.AddRemoveEffectToWidget(_scene_widget, child_scenes.close_scene_time)
end

function quest.OnOpenScene(_scene_widget, _init_offset_x, _init_ffset_y)
        local click_pos = quest.g_ClickPos
        if not click_pos then
            click_pos = sf.misc.FloatVector(-1000, -1000)
        end
		if _init_offset_x and _init_ffset_y then
			click_pos = sf.misc.FloatVector(_init_offset_x, _init_ffset_y)
		end
				
        _scene_widget.SetInitPos(click_pos)
        game.AddEffectToWidget(_scene_widget, child_scenes.open_scene_time, click_pos, sf.misc.FloatVector(0, 0), sf.misc.FloatVector(1, 1))
end

function quest.OnOpenMinigame(_minigame_widget)
        game.AddEffectToWidget(_minigame_widget, child_scenes.open_minigame_time, child_scenes.init_minigame_pos, sf.misc.FloatVector(0, 0), sf.misc.FloatVector(1, 1))
		shadow_widget.StartDark(child_scenes.open_minigame_time)
end

function quest.OnCloseMinigame(_minigame_widget, _win)
	local show_effect = _win and _minigame_widget.GetWidget("solve_game", true).get()
	
	_minigame_widget.AddFlags(_minigame_widget.FlagDisabled)
	
	if show_effect then
		local pos = _minigame_widget.GetAbsPos(true) + _minigame_widget.GetSize()/2
		local effect = over_gui_effect_widget.AddEffect("MinigameCompletedStart", pos)
        local particle_effect = effect:GetChildEffect("rect_effect")
		assert(particle_effect)
		particle_effect:SetEmiterSize(_minigame_widget.GetSize())
        sound("mini_game_completed")
		sleep(child_scenes.close_minigame_pause)
	end
	
    --       ,       
    if not quest.global_skip_windows_flag then
        game.AddEffectToWidget(_minigame_widget, child_scenes.close_minigame_time, child_scenes.init_minigame_pos, sf.misc.FloatVector(1, 1), sf.misc.FloatVector(0, 0))
        game.AddRemoveEffectToWidget(_minigame_widget, child_scenes.close_minigame_time)
        shadow_widget.StartLight(child_scenes.close_minigame_time)
    end
	if show_effect then
		sleep(child_scenes.close_minigame_time)
		--over_gui_effect_widget.AddEffect("MinigameCompletedEnd", child_scenes.init_minigame_pos)
	end
end

    


    
