local type_bars_table = 
{
    take_type = { 2,  1 },
    minigame_type = { 2,  2},
    take_hint_type = { 2,  1},
    remove_type = { 2,  1}
}

local type_points_table = 
{
    take_type = { 100,  100 },
    minigame_type = { 100,  100},
    take_hint_type = { 100,  100},
    remove_type = { 100,  100}
}
local function load_table(_type_points_table, _first_row)
    local bar_row = _first_row
    while bar_row do
        local type_value = bar_row.GetValue(_T("type")).c_str()
        if type_value then
            local easy_bars_count = tonumber(bar_row.GetValue(_T("easy")).c_str()) or 1
            local hard_bars_count = tonumber(bar_row.GetValue(_T("hard")).c_str()) or 1
            if not _type_points_table[type_value] then
                _type_points_table[type_value] = {}
            end
            if easy_bars_count then
                _type_points_table[type_value][1] = easy_bars_count
            end
            if hard_bars_count then
                _type_points_table[type_value][2] = hard_bars_count
            end
        end
        bar_row = bar_row.GetNextSiblingRef()
    end
end

function score.InitScore(_game_resources)
    local score_info = _game_resources.GetChild(_T("Constants"), false).GetChild(_T("score"), false)
    load_table(type_bars_table, score_info.GetChild(_T("bars_table"), false).GetFirstChildRef())
    load_table(type_points_table, score_info.GetChild(_T("points_table"), false).GetFirstChildRef())
end

function score.get_new_bars_count(_score_table) -- 
    local res = 0
    local points_count = 0
    local dif_level =  difficulty.GetDifLevel()--game.GetDificultyLevel()
    if dif_level == 0 then --game.CGameOptions.DificultyLevelNoirmal then
        dif_level = 1
    elseif dif_level == 1 then --game.CGameOptions.DificultyLevelHard then
        dif_level = 2
    else
        __assert(false, "  ")
    end
    for i,o in pairs(_score_table) do
      local koef = 1
      local points_koef = 1
      __assert(type_bars_table[i], "  ")
      koef = type_bars_table[i][dif_level]
      points_koef = type_points_table[i][dif_level]
        
      if o.enabled == true then
          res = res + o.count*koef
          points_count = points_count + o.count*points_koef
      end
    end
    return res, points_count
end

function score.GetBars()
    local current_profile = game.g_ProfileManager.Instance().GetCurrentProfile()
    assert(current_profile)
    if current_profile ~= nil then
        return current_profile.GetThermometerPoints()
    end
    return 0
end

function score.SetBars(_value)
    if _value and type(_value) =="number" then
        local current_profile = game.g_ProfileManager.Instance().GetCurrentProfile()
        assert(current_profile)
        if current_profile ~= nil then
            current_profile.SetThermometerPoints(_value)
            --game.g_ProfileManager.Instance().Save()
        end
    end
end

function score.GetScore()
    local current_profile = game.g_ProfileManager.Instance().GetCurrentProfile()
    assert(current_profile)
    if current_profile ~= nil then
        return current_profile.GetPointsCount()
    end
    return 0
end

function score.SetScore(_value)
    if _value and type(_value) =="number" then
        local current_profile = game.g_ProfileManager.Instance().GetCurrentProfile()
        assert(current_profile)
        if current_profile ~= nil then
            current_profile.SetPointsCount(_value)
            --game.g_ProfileManager.Instance().Save()
        end
    end
end

function score.GetAlphaBars()
    local current_profile = game.g_ProfileManager.Instance().GetCurrentProfile()
    assert(current_profile)
    if current_profile ~= nil then
        return current_profile.GetAlphaThermometerPoints()
    end
    return 0
end

function score.SetAlphaBars(_value)
    if _value and type(_value) =="number" then
        local current_profile = game.g_ProfileManager.Instance().GetCurrentProfile()
        assert(current_profile)
        if current_profile ~= nil then
            current_profile.SetAlphaThermometerPoints(_value)
            --game.g_ProfileManager.Instance().Save()
        end
    end
end
