avatar_widget = avatar_widget or {}

avatar_widget.avatar_timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")).AttachTimer(_T("")))

__inherite(avatar_widget, null_lua_widget_handler())

function avatar_widget.__CreateInstance()
    return "avatar_widget"
end

avatar_widget.change_koef = 0

avatar_widget.current_state = nil

avatar_widget.def_state = "normal"

avatar_widget.change_time = 1000

avatar_widget.def_state_time = 5000

avatar_widget.avatar_say = false

avatar_widget.allow_say = true

function avatar_widget.SetAvatarSay(_value)
    if _value and not avatar_widget.allow_say then return end
    avatar_widget.avatar_say = _value
end

function avatar_widget.DoDraw(_this, _renderer)

    if avatar_widget.avatar_say and avatar_widget.states_table[avatar_widget.current_state].say_obj then
        avatar_widget.states_table[avatar_widget.current_state].say_obj.Draw(_renderer)
    else
        avatar_widget.states_table[avatar_widget.current_state].obj.Draw(_renderer)
    end
   
    if avatar_widget.new_state ~= nil then

        local color = sf.graphics.Color(_renderer.GetColor())
        color.Alpha = color.Alpha * avatar_widget.change_koef
        
        _renderer.SetColor(color)
        if avatar_widget.avatar_say and avatar_widget.states_table[avatar_widget.new_state].say_obj then
            avatar_widget.states_table[avatar_widget.new_state].say_obj.Draw(_renderer)
        else
            avatar_widget.states_table[avatar_widget.new_state].obj.Draw(_renderer)
        end
    end
    
	
    return true
end

function avatar_widget.ChangeState(_new_state, _state_time)
    if avatar_widget.states_table[_new_state] then
        if avatar_widget.new_state == nil and avatar_widget.current_state ~= _new_state then
            avatar_widget.avatar_timer.Get().SetTime(0)
        end
        avatar_widget.new_state = _new_state
        avatar_widget.state_time = _state_time
    else
        __message("     ".._new_state, "")
    end
end

function avatar_widget.GetCurrentState()
    if avatar_widget.new_state ~= nil then
        return avatar_widget.new_state
    end
    return avatar_widget.current_state
end

function avatar_widget.DoUpdate(_this)
    
    if avatar_widget.new_state == nil and avatar_widget.current_state ~= "normal" then
        local time = avatar_widget.avatar_timer.Get().GetTime()
        if time > avatar_widget.state_time and avatar_widget.state_time ~= 0 then
            avatar_widget.ChangeState("normal")
        end
        
    end

    if avatar_widget.new_state ~= nil then
        local time = avatar_widget.avatar_timer.Get().GetTime()
        if time < avatar_widget.change_time then
           avatar_widget.change_koef = time / avatar_widget.change_time
        else
            avatar_widget.current_state = avatar_widget.new_state
            avatar_widget.new_state = nil
            avatar_widget.avatar_timer.Get().SetTime(0)
            if avatar_widget.state_time == nil then
                avatar_widget.state_time = avatar_widget.states_table[avatar_widget.current_state].def_time
            end
        end
    end
    
    if avatar_widget.new_state ~= nil then
        local object = avatar_widget.states_table[avatar_widget.new_state].obj
        if object then
            object.Update()
        end
        if avatar_widget.avatar_say and avatar_widget.states_table[avatar_widget.new_state].say_obj then
            avatar_widget.states_table[avatar_widget.new_state].say_obj.Update()
        end
    end
    if avatar_widget.current_state ~= nil then
        local object = avatar_widget.states_table[avatar_widget.current_state].obj
        if object then
            object.Update()
        end
        if avatar_widget.avatar_say and avatar_widget.states_table[avatar_widget.current_state].say_obj then
            avatar_widget.states_table[avatar_widget.current_state].say_obj.Update()
        end
    end
    

    
    return true
end

function avatar_widget.FormStates(_avatar_table)
    for i,o in pairs(_avatar_table) do
        if o.type == "image" then
            o.obj = sf.misc.anim.CImageObject(o.src)
        elseif  o.type == "clip" then
            o.obj = sf.misc.anim.CClipViewObject(o.src)
        end
        if o.say_type ~= nil then
            if o.say_type == "image" then
                o.say_obj = sf.misc.anim.CImageObject(o.say_src)
            elseif  o.say_type == "clip" then
                o.say_obj = sf.misc.anim.CClipViewObject(o.say_src)
            end
        end
    end
end



function avatar_widget.change_avatar(_id)
    if avatar_widget.avatars_table[_id] then
        quest.global_modify_level_flag = true 
        avatar_widget.states_table = avatar_widget.avatars_table[_id]
    end
end

function avatar_widget.Load(_this, _info, _templates)
    avatar_widget.avatars_table = {}

    local avatars_info = quest.game_resources.GetChild(_T("Constants"), false).GetChild(_T("avatars"), false)
    local current_avatar = avatars_info.GetFirstChildRef()
    local def_avatar = avatars_info.GetValue("def_avatar").c_str()
    local allow_say = avatars_info.GetValue("allow_say").c_str()
    if allow_say =="false" then
        avatar_widget.allow_say = false
    end
    local first_avatar_id = nil

	while current_avatar do
       local avatars_info = current_avatar
       local avatar_id = avatars_info.GetValue("id").c_str()
       if not first_avatar_id then
           first_avatar_id = avatar_id
       end
       avatar_widget.avatars_table[avatar_id] = {}
       local def_say_type = avatars_info.GetValue("def_say_type").c_str()
       local def_say_src = avatars_info.GetValue("def_say_src").c_str()

       local avatars_item = avatars_info.GetFirstChildRef()

        while avatars_item do
            local id = avatars_item.GetValue("id").c_str()
            local type = avatars_item.GetValue("type").c_str()
            local src = avatars_item.GetValue("src").c_str()
            if id ~= "" and  type ~= "" and src ~= "" then
                local def_time = tonumber(avatars_item.GetValue("def_time").c_str())
                if not def_time then
                    def_time = avatar_widget.def_state_time
                end
                avatar_widget.avatars_table[avatar_id][id]={type=type, src=src, def_time=def_time}

            
                type = avatars_item.GetValue("say_type").c_str()
                src = avatars_item.GetValue("say_src").c_str()
                if type ~= "" and src ~= "" then
                    avatar_widget.avatars_table[avatar_id][id]["say_type"]=type
                    avatar_widget.avatars_table[avatar_id][id]["say_src"]=src
                elseif def_say_type ~= "" and def_say_src ~= "" then
                    avatar_widget.avatars_table[avatar_id][id]["say_type"]=def_say_type
                    avatar_widget.avatars_table[avatar_id][id]["say_src"]=def_say_src
                end
            end
            
            avatars_item = avatars_item.GetNextSiblingRef()
        end
        avatar_widget.FormStates(avatar_widget.avatars_table[avatar_id])



        current_avatar = current_avatar.GetNextSiblingRef()
    end


    if def_avatar ~= "" then
        avatar_widget.states_table = avatar_widget.avatars_table[def_avatar]
    elseif first_avatar_id ~= nil and first_avatar_id ~= "" then
        avatar_widget.states_table = avatar_widget.avatars_table[first_avatar_id]
    end

    avatar_widget.current_state = avatar_widget.def_state

    return true
end
