--  
--    /  , 
--        
background_sounds = 
{
    --     _sound_id
    -- _scene_volume_table -   ' =>     '
    Play = function(_sound_id, _scene_volume_table)
        local audio = sf.core.g_Application.GetAudioManager()
        
        --      
        local sound = 
        { 
            play_id = nil, --   
            sound_id = _sound_id, --   
            max_volume = audio.GetVolume(_sound_id),  --   
            scene_volume = _scene_volume_table --     
        }
        
        background_sounds._PlaySound(sound)
    end,
    
    --       _sound_id
    Stop = function(_sound_id)
        local audio = sf.core.g_Application.GetAudioManager()
        
        --      sound_id == _sound_id
        --   
        local sound_id = tostring(_sound_id)
        local i, size = 1, #background_sounds._sounds
        while i <= size do
            local sound = background_sounds._sounds[i]
            if sound.sound_id == sound_id then
                audio.Stop(sound.play_id, 0)
                table.remove(background_sounds._sounds, i)
                i = i - 1
                size = size - 1
            end
            i = i + 1
        end
    end,
    
    --    ,       
    UpdateSoundsVolume = function()        
        local audio = sf.core.g_Application.GetAudioManager()
        
        local i, size = 1, #background_sounds._sounds
        while i <= size do
            local sound = background_sounds._sounds[i]
            
            --    ,  
            if not audio.IsSound(sound.play_id) then    
                table.remove(background_sounds._sounds, i)
                i = i - 1
                size = size - 1
            end
            
            --           
            audio.SetVolume(sound.play_id, background_sounds._CalcSoundVolume(sound), 0, 0)
            
            i = i + 1
        end        
    end,
    
    --     quest.g_LuaVariables
    SaveToLuaVariables = function()
        local audio = sf.core.g_Application.GetAudioManager()
    
        quest.g_LuaVariables.background_sounds = {}
        
        --    
        for _, sound in ipairs(background_sounds._sounds) do
            if audio.IsSound(sound.play_id) then
                table.insert(quest.g_LuaVariables.background_sounds, sound)
            end
        end
    end,
    
    --     quest.g_LuaVariables
    LoadFromLuaVariables = function()
        form_event([[
        if not quest.g_LuaVariables.background_sounds then 
            background_sounds._sounds = {}
            return
        end
        
        for _, sound in ipairs(quest.g_LuaVariables.background_sounds) do
            background_sounds._PlaySound(sound)
        end
        quest.g_LuaVariables.background_sounds = nil
        ]])
    end,
    
    --       
    _PlaySound = function(_sound)
        local audio = sf.core.g_Application.GetAudioManager()
    
        local start_volume = background_sounds._CalcSoundVolume(_sound)
        _sound.play_id = audio.Play(_sound.sound_id, -2, start_volume, -2, -2, -2)
        --[[__assert(_sound.play_id ~= 0, 
            "background_sounds.Play:     "..tostring(_sound.sound_id))]]
        if _sound.play_id ~= 0 then
            --    -        
            table.insert(background_sounds._sounds, _sound)
        end
    end,
    
    -- ,         
    _CalcSoundVolume = function(_sound)
        local current_scene = tostring(quest.global_current_main_scene.GetId())
        local volume_k = _sound.scene_volume[current_scene]
        if not volume_k then volume_k = 0 end
        return volume_k * _sound.max_volume
    end,
    
    --   
    _sounds = {}
}
