child_scenes = child_scenes or {}

child_scenes.close_button_text = ""

--  ,           
child_scenes._minigame_full_screen = false

---      
function child_scenes.IsMinigameFullScreen()
	return child_scenes._minigame_full_screen
end



---          
function child_scenes.SetHideFullScreenMinigameDescription(_value)
	if child_scenes._full_screen_minigame_description then
		set_widget_flag_value(child_scenes._full_screen_minigame_description, sf.gui.CBaseWidget.FlagHidden, _value)  
		set_widget_flag_value(child_scenes._full_screen_minigame_description, sf.gui.CBaseWidget.FlagDisabled, _value)  
	end
end
--- ,        (     )
-- _hide_solve_value -    
function child_scenes.SetHideSolveMinigame(_hide_solve_value)
	local end_button = child_scenes._close_minigame_button
	local solve_button = child_scenes._solve_minigame_button
	
	--      (  )
    if not child_scenes._minigame_full_screen then
		--   
	    if end_button and solve_button and _hide_solve_value == false then --           
			--   
			set_widget_flag_value(solve_button, sf.gui.CBaseWidget.FlagHidden, false)  
			--      
			local minigame_size = child_scenes._current_minigame.GetSize()
	        local end_button_size = end_button.GetSize()
	        local solve_button_size = solve_button.GetSize()
	        local max_width = end_button_size.X
	        if max_width < solve_button_size.X then
	            max_width = solve_button_size.X
	        end
	        end_button.SetSize(max_width, end_button_size.Y)
	        solve_button.SetSize(max_width, solve_button_size.Y)
	        end_button_size = end_button.GetSize()
	        solve_button_size = solve_button.GetSize()
	        end_button.SetOffset(minigame_size.X/2 + minigame_window.buttons_space, minigame_size.Y - end_button_size.Y - minigame_window.buttons_bottom_space)
	        solve_button.SetOffset(minigame_size.X/2 - minigame_window.buttons_space - solve_button_size.X, minigame_size.Y - solve_button_size.Y - minigame_window.buttons_bottom_space)

	    else --            
			if solve_button then 
				--       
				set_widget_flag_value(solve_button, sf.gui.CBaseWidget.FlagHidden, true)  
			end
			
			if end_button then 
				--         
		        local minigame_size = child_scenes._current_minigame.GetSize()
		        local button_size = end_button.GetSize()
		        end_button.SetOffset(minigame_size.X/2 - button_size.X/2, minigame_size.Y - button_size.Y - minigame_window.buttons_bottom_space)
			end
	    end
	else
	    --   
		local hide = true --         
		if solve_button then
			--            
			hide = _hide_solve_value
		end
		set_widget_flag_value(child_scenes._full_screen_solve_button, sf.gui.CBaseWidget.FlagHidden, hide)
	end
end

--      
function child_scenes.full_screen_minigame(_id, _x, _y, _text, _close_pos_x, _close_pos_y)
	return child_scenes.minigame_ex(_id, _x, _y, _text, _close_pos_x, _close_pos_y, true)
end

function child_scenes.minigame(_id, _x, _y, _text, _close_pos_x, _close_pos_y)
	return child_scenes.minigame_ex(_id, _x, _y, _text, _close_pos_x, _close_pos_y, nil)
end

function child_scenes.minigame_ex(_id, _x, _y, _text, _close_pos_x, _close_pos_y, _full_screen)
	child_scenes._minigame_full_screen = _full_screen

    commit_score()
    if quest.global_skip_windows_flag == true then
        return false
    end
    quest.global_modify_level_flag = true 
    quest.global_minigame_window_result = nil

    objects_box_lua_widget.ShowObjectsWithAlpha(true)
    local minigame_res = nil
    minigame_res = quest.game_resources.GetChild("GUI", false).GetChildByAttribute("window", "id", _id, true)
    if minigame_res.GetId().c_str() == "" then
        minigame_res = quest.game_resources.GetChild("GUI", false).GetChildByAttribute("window", "id", "assemble_image_circle", true)
    end
    quest.global_cursor.SetHintText(_T(""), false)
    
    --      
	if not quest.g_LuaVariables.minigames then
		quest.g_LuaVariables.minigames = {}
	end
    local save_id = "__" .. tostring(_id)
    sminigames.save = quest.g_LuaVariables.minigames[save_id]
    
    ---              
	local minigame_layer = 15
	if _full_screen then
		--             
		minigame_layer = 1
	end
	local minigame_widget = sf.gui.CLuaWidget("minigame_widget", minigame_layer, __or(sf.gui.CWidget.BroadcastOnKeyDown, sf.gui.CWidget.BroadcastOnMouseMove))

    minigame_window.self = minigame_widget

    minigame_widget.Load(minigame_res, quest.game_resources.GetChild("GUITemplates", false))
    
    minigame_widget.UpdateLayout()
    
    local minigames_info = quest.game_resources.GetChild("Constants", false).GetChildRef("minigame", false)
    if minigames_info then
        local res = tonumber(minigames_info.GetValue("buttons_from_center_space").c_str())
        if res ~= nil then minigame_window.buttons_space = res end

        res = tonumber(minigames_info.GetValue("buttons_bottom_space").c_str())
        if res ~= nil then minigame_window.buttons_bottom_space = res end

    end

	child_scenes._current_minigame = minigame_widget
	
	--   (  ) 
	--     ,      
	child_scenes._solve_minigame_button = get_child_widget(minigame_widget, "solve_game", sf.gui.CButtonWidget)
	child_scenes._close_minigame_button = get_child_widget(minigame_widget, "end_game", sf.gui.CButtonWidget)
    
    __assert(child_scenes._close_minigame_button, ":    '"..tostring(_id).."'   'end_game'")
	
	if _full_screen then
		--        
		child_scenes._full_screen_solve_button = get_child_widget(quest.global_quest_window, "full_screen_minigame_solve_button", sf.gui.CButtonWidget)
		child_scenes._full_screen_end_button = get_child_widget(quest.global_quest_window, "full_screen_minigame_exit_button", sf.gui.CButtonWidget)
		--      ,    
		if not child_scenes._full_screen_end_button or not child_scenes._full_screen_end_button then
			__message("Minigame buttons for full screen not found!!!(full_screen_minigame_solve_button or full_screen_minigame_exit_button) ")
			return false
		end
		--      
		child_scenes.show_fullscreen_minigame_buttons() 
        
		--  ,      
		child_scenes._object_box = get_child_widget(quest.global_quest_window, "main_object_box_widget", sf.gui.CLuaWidget)
		--      
		if child_scenes._object_box then
			set_widget_flag_value(child_scenes._object_box, sf.gui.CBaseWidget.FlagHidden, true)  
			set_widget_flag_value(child_scenes._object_box, sf.gui.CBaseWidget.FlagDisabled, true)  
		end
	
		---      
		child_scenes._full_screen_minigame_description = get_child_widget(quest.global_quest_window, "full_screen_minigame_description", sf.gui.CLabelWidget)
		--      ,      
		if not child_scenes._full_screen_minigame_description then
			__message("Label(full_screen_minigame_description) for minigame description not found!!!")
		end
		--     
		if child_scenes._full_screen_minigame_description then
			--  
			set_widget_flag_value(child_scenes._full_screen_minigame_description, sf.gui.CBaseWidget.FlagHidden, false)  
			set_widget_flag_value(child_scenes._full_screen_minigame_description, sf.gui.CBaseWidget.FlagDisabled, false)  
			--       
			local label_widget = get_child_widget(minigame_widget, "minigame_description_label", sf.gui.CLabelWidget)
			if label_widget then
				--             
				child_scenes._full_screen_minigame_description.SetText(label_widget.GetText())
				set_widget_flag_value(label_widget, sf.gui.CBaseWidget.FlagHidden, true)  
			else
				--        
				child_scenes._full_screen_minigame_description.SetText(_T(""))
			end
		
		end
		
		--      
		set_widget_flag_value(child_scenes._close_minigame_button, sf.gui.CBaseWidget.FlagHidden, true)  
		set_widget_flag_value(child_scenes._close_minigame_button, sf.gui.CBaseWidget.FlagDisabled, true)  
		--        
		child_scenes._close_minigame_button = get_child_widget(quest.global_quest_window, "full_screen_minigame_exit_button", sf.gui.CButtonWidget)
		
		---    ,      
		if child_scenes._solve_minigame_button then
			set_widget_flag_value(child_scenes._solve_minigame_button, sf.gui.CBaseWidget.FlagHidden, true)  
			set_widget_flag_value(child_scenes._solve_minigame_button, sf.gui.CBaseWidget.FlagDisabled, true)  

			child_scenes._solve_minigame_button = child_scenes._full_screen_solve_button
		else
			set_widget_flag_value(child_scenes._full_screen_solve_button, sf.gui.CBaseWidget.FlagHidden, true)  
			set_widget_flag_value(child_scenes._full_screen_solve_button, sf.gui.CBaseWidget.FlagDisabled, true)  
		
		end
	end
	
	--        (     )
    if child_scenes._solve_minigame_button then
        minigame_window.InitSolveButton(child_scenes._solve_minigame_button)
    end

    local window_template = minigame_res.GetValue("window_template").c_str()

    if window_template and window_template ~= "" then
        local templates = quest.game_resources.GetChild("GUITemplates", false).GetChildByAttribute("window_template", "id", window_template, false)
        if templates.GetId().c_str() ~= "" then
            local back_ground_id = templates.GetValue("background").c_str()
            minigame_window.background_image = sf.graphics.CImage(back_ground_id);

            minigame_window.background_image.SetFlags(__or(__or(minigame_window.background_image.GetFlags(), sf.graphics.CImage.FlagBoxImage), sf.graphics.CImage.FlagIntDest))
            local minigame_size = minigame_widget.GetSize()

            minigame_window.background_image.SetRect( sf.misc.FloatRect(0, 0, minigame_size.X, minigame_size.Y))
        end
    end
    local parent_size = quest.global_quest_window.GetSize()
    if _x == nil then
        _x = (parent_size.X - minigame_widget.GetSize().X) /2
    end

    if _y == nil then
        _y = (parent_size.Y - minigame_widget.GetSize().Y) /2
    end

    minigame_widget.SetOffset(_x, _y)

    --shadow_widget.Show(true)
    hints_lua_widget.HideHint()
    scene_click_widget.Enable(false)

    local click_pos = quest.g_ClickPos
    if not click_pos then
        click_pos = sf.misc.FloatVector(-1000, -1000)
    end
    child_scenes.init_minigame_pos = click_pos

    if child_scenes.init_minigame_pos then
        if _close_pos_x then
            child_scenes.init_minigame_pos.X = _close_pos_x
        end
        if _close_pos_y then
            child_scenes.init_minigame_pos.Y = _close_pos_y
        end
    end
    
    

    quest.OnOpenMinigame(minigame_widget)
    

    quest.global_quest_window.AddWidget(minigame_widget)
    difficulty.ApplyDifLevelForMinigames()
    --child_scenes.replase_minigame_buttons() -- minigame_widget

    quest.global_cursor.SetDisableHints(true)
    --set_widget_flag_value(objects_box_lua_widget.self, sf.gui.CBaseWidget.FlagDisabled, true)  

	quest.global_minigame_opened = minigame_widget
	
    if _text ~= nil then
        say(_text)
    end

    local hint_tutorial_value = hints_lua_widget.get_disable_hint_tutorial()
    hints_lua_widget.disable_hint_tutorial(true)

    hints_lua_widget.set_show_hint_tutorial(false)

    quest.do_not_change_curosor = true
	cursor_lua_widget.DropCursor()
    sound("mini_open_close")

    while true do
        if quest.global_minigame_window_result ~= nil then
            break
        end
        sleep(100)
    end
    hints_lua_widget.disable_hint_tutorial(hint_tutorial_value)
	if _full_screen then

		--     
        child_scenes.hide_fullscreen_minigame_buttons()

		---  
		if child_scenes._object_box then
			set_widget_flag_value(child_scenes._object_box, sf.gui.CBaseWidget.FlagHidden, false)  
			set_widget_flag_value(child_scenes._object_box, sf.gui.CBaseWidget.FlagDisabled, false)  
		end
		---    
		if child_scenes._full_screen_minigame_description then
			set_widget_flag_value(child_scenes._full_screen_minigame_description, sf.gui.CBaseWidget.FlagHidden, true)  
			set_widget_flag_value(child_scenes._full_screen_minigame_description, sf.gui.CBaseWidget.FlagDisabled, true)  
		end
	end
	
	---     ,                  
	child_scenes._solve_minigame_button = nil
	child_scenes._close_minigame_button = nil
	
	---  
	child_scenes._minigame_full_screen = false
    
	difficulty.ApplyDifLevelForMinigames()
	
	hints_lua_widget.disable_hint_tutorial(hint_tutorial_value)
	
	quest.global_minigame_opened = false
	
	quest.OnCloseMinigame(minigame_window.self, quest.global_minigame_window_result~=0 and quest.global_minigame_window_result)
	
    --set_widget_flag_value(objects_box_lua_widget.self, sf.gui.CBaseWidget.FlagDisabled, false)  
    quest.global_cursor.SetDisableHints(false)
    objects_box_lua_widget.ShowObjectsWithAlpha(false)
    scene_click_widget.Enable(true)
    --shadow_widget.Show(false)
    quest.do_not_change_curosor = false
    
    if quest.global_minigame_window_result == 1 then
        add_score("minigame_type", 1)
    end
    

    if quest.global_minigame_window_result == 1 or quest.global_minigame_window_result == 2 then
        quest.g_LuaVariables.minigames[save_id] = nil --   -   
        return true
    end
    
    --    
    quest.g_LuaVariables.minigames[save_id] = sminigames.save
    return false
end

--     
function child_scenes.show_fullscreen_minigame_buttons()
    if child_scenes._solve_minigame_button then
        set_widget_flag_value(child_scenes._full_screen_solve_button, sf.gui.CBaseWidget.FlagHidden, false)  
        set_widget_flag_value(child_scenes._full_screen_solve_button, sf.gui.CBaseWidget.FlagDisabled, false)  
    end

    set_widget_flag_value(child_scenes._full_screen_end_button, sf.gui.CBaseWidget.FlagHidden, false)  
    set_widget_flag_value(child_scenes._full_screen_end_button, sf.gui.CBaseWidget.FlagDisabled, false) 
end

--     
function child_scenes.hide_fullscreen_minigame_buttons()
    set_widget_flag_value(child_scenes._full_screen_solve_button, sf.gui.CBaseWidget.FlagHidden, true)  
    set_widget_flag_value(child_scenes._full_screen_solve_button, sf.gui.CBaseWidget.FlagDisabled, true)  

    set_widget_flag_value(child_scenes._full_screen_end_button, sf.gui.CBaseWidget.FlagHidden, true)  
    set_widget_flag_value(child_scenes._full_screen_end_button, sf.gui.CBaseWidget.FlagDisabled, true)  
end

function child_scenes.is_fullscreen_minigame_opened()
    return quest.global_minigame_opened and child_scenes._minigame_full_screen
end

function child_scenes.close_scene(_scene_id)
    if _scene_id ~= nil then
        quest.global_scene_widget.CloseChildSceneById(_scene_id)
    end
end

function child_scenes.close_minigame(_value)
    local current_widget = quest.global_quest_window.GetWidgets()
    while not current_widget.IsEnd() do
        local widget_id = current_widget.Get().GetId().c_str()
        local lua_widget = __cast(current_widget.Get(), sf.gui.CLuaWidget )
        if lua_widget then
            local overload_table = lua_widget.GetOverloadTable()
            if string.find(overload_table, "minigame") then
                say_widget.close_say()
                minigame_window.CloseMinigame(_value)
                return true
            end
        end
        current_widget.Next()
    end
    return false
end

function child_scenes.disable_scene_sounds(_scene, _disable)
    if _disable == nil then _disable = true end
    
    local current_child = _scene.GetObjects()
    while not current_child.IsEnd() do
        local object = current_child.Get()
        local type = object.GetType()
        if  type == qe.CBaseSceneObject.GroupType then
            local group = __cast(object.get(), qe.CSceneGroup)
            if group then
                local current_group_child = group.GetChilds()
                while not current_group_child.IsEnd() do
                    local clip_object = __cast(current_group_child.Get(), qe.CClipObject)
                    if clip_object then
                        clip_object.DisableSounds(_disable)
                    end
                    current_group_child.Next()
                end 
            end
        else
            local clip_object = __cast(object, qe.CClipObject)
            if clip_object then
                clip_object.DisableSounds(_disable)
            end
        end
        current_child.Next()
    end
end

function child_scenes.show_scene(_scene_id, _x, _y, _init_offset_x, _init_ffset_y)
    if _scene_id == nil then return end
	
    local scene_widget = quest.get_scene_widget(_scene_id)
    if scene_widget ~= nil then return end
	target_scene = quest.global_played_level.GetSceneById(_scene_id)    
	if target_scene == nil then
		__message(" "..tostring(_scene_id).."  ", "")
		return 
	end
    quest.global_modify_level_flag = true 
	local in_a_window = target_scene.ReadFlag(qe.CScene.FlagSceneInNewWindow)
	local new_widget = qe.CSceneWidget(_T("standart"), true, quest.game_resources.GetChild("GUITemplates", true)) --in_a_window

    new_widget.SetCloseButtonText(child_scenes.close_button_text)
    
	if in_a_window then
        sound("mini_open_close")

		-- 
		new_widget.SetScene(target_scene)
		if _x ~= nil and _y ~= nil then
			new_widget.SetOffset(_x, _y)    
		end
        hints_lua_widget.HideHint(new_widget.GetOffset(), new_widget.GetSize())
        quest.OnOpenScene(new_widget, _init_offset_x, _init_ffset_y)
		quest.global_scene_widget.AddWidget(new_widget)
		quest.global_cursor.SetHintText(_T(""), false)
		target_scene.RunSceneScript()
	else
        child_scenes.disable_scene_sounds(quest.global_current_main_scene)
        
        --sf.core.g_Application.GetResourceManager().UnloadAllOnDemandSurfaces()
        
        hints_lua_widget.HideHintInstantly()
		--  
		quest.global_scene_widget.CloseChildScenes()
		quest.global_scene_widget.SetScene(target_scene)
		quest.global_current_main_scene = target_scene
		quest.global_cursor.SetWorkAreaSize(quest.global_scene_widget.GetSize())
		quest.global_cursor.SetHintText(_T(""), false)
		target_scene.RunSceneScript()
		quest.OnLevelChanged()
        
        child_scenes.disable_scene_sounds(target_scene, false)
        
        background_sounds.UpdateSoundsVolume()
	end
end

function child_scenes.LoadConstants(_constants)
	local miniscene_info = _constants.GetChild("miniscene", false)
    if miniscene_info then
        child_scenes.close_button_text = miniscene_info.GetValue("close_button_text").c_str()
    end

--[[
	local self = cursor_lua_widget
	
	local cursors = _constants.GetChild("cursors", false)
    self.object_offset.X = tonumber(cursors.GetValue("object_offset_x").c_str()) or self.object_offset.X
	self.object_offset.Y = tonumber(cursors.GetValue("object_offset_y").c_str()) or self.object_offset.Y
    quest.global_cursor.SetObjectOffset(self.object_offset)
	
	self.object_scale.X = tonumber(cursors.GetValue("object_scale_x").c_str()) or self.object_scale.X
	self.object_scale.X = tonumber(cursors.GetValue("object_scale_y").c_str()) or self.object_scale.Y
    quest.global_cursor.SetCursorObjectScale(self.object_scale)
	
	quest.go_to_hourglass_delay = tonumber(cursors.GetValue("go_to_hourglass_delay").c_str())
	
	
	local hints = _constants.GetChild("hints", false)
    self.hint_offset.X = tonumber(hints.GetValue("hint_offset_x").c_str()) or self.hint_offset.X
	self.hint_offset.Y = tonumber(hints.GetValue("hint_offset_y").c_str()) or self.hint_offset.Y
    quest.global_cursor.SetHintOffset(self.hint_offset)

    local res = hints.GetValue("hint_font").c_str()
    if res ~= "" then
        cursor_lua_widget.hint_font = res
    end

    quest.global_cursor.SetHintFont(cursor_lua_widget.hint_font)

    local ring_offset_X = tonumber(cursors.GetValue("ring_offset_x").c_str())
	local ring_offset_Y = tonumber(cursors.GetValue("ring_offset_y").c_str())
	cursor_lua_widget.ring_object_width = tonumber(cursors.GetValue("ring_object_width").c_str()) or cursor_lua_widget.ring_object_width

    quest.global_cursor.SetPreObjectOffset(sf.misc.FloatVector(ring_offset_X, ring_offset_Y))


	local ring_id = cursors.GetValue("ring_id").c_str()
	if ring_id ~= "" then
        quest.global_cursor.SetPreObject(ring_id)
    end
    quest.global_cursor.SetObjectWidth(cursor_lua_widget.ring_object_width)
    
]]
end
