dialog_widget = dialog_widget or {}

dialog_widget._dialog_timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")).AttachTimer(_T("")))

__inherite(dialog_widget, null_lua_widget_handler())

dialog_widget._text_font = sf.core.g_Application.GetResourceManager().GetFont("basefont")

dialog_widget._back_ground_id =  "gui_game_gui_miniframe"

dialog_widget._current_steep = 1
--[[
dialog_widget.text_skip = sf.misc.g_StringTable.Instance().FormatByStringsID("$617")
dialog_widget.text_next = sf.misc.g_StringTable.Instance().FormatByStringsID("$619")
dialog_widget.text_replay = sf.misc.g_StringTable.Instance().FormatByStringsID("$619")
]]

dialog_widget._start_dialog_time = 600
dialog_widget._back_alpha_max_alpha = 150
dialog_widget._top_stripe_width = 120
dialog_widget._bottom_stripe_width = 120
dialog_widget._stripe_border = 120

dialog_widget._start_dialog_effect = nil

dialog_widget._stripe_alpha = 0
dialog_widget._back_alpha = 0

dialog_widget._dialog_is_stoped = nil

dialog_widget._text_delay_time = nil
dialog_widget._current_avatar = nil

dialog_widget._text_color = sf.graphics.Color(255, 255, 0, 0)

dialog_widget._min_avatar_alpha = 100

dialog_widget._change_avatar_time = 700
dialog_widget._def_dialog_say_time = 1000
dialog_widget._after_sound_delay = 1000


dialog_widget._text_offset = sf.misc.FloatVector(100, 200)
dialog_widget._text_size = sf.misc.FloatVector(300, 50)

dialog_widget._buttons_area_height = 50
dialog_widget._replay_offset = sf.misc.FloatVector(0, 0)
dialog_widget._buttons_space = 10
--dialog_widget._continue_offset = sf.misc.FloatVector(150, 0)



dialog_widget._avatar_def_pos_table = 
{
    sf.misc.FloatVector(100, 100),
    sf.misc.FloatVector(300, 100),
    sf.misc.FloatVector(500, 100)
}

dialog_widget._avatars_table = { }
dialog_widget._dialog_struct = { }

local function local_create_color(_alpha, _shadow_coef)
    local color_item = dialog_widget._min_avatar_alpha + (255 - dialog_widget._min_avatar_alpha) * (1 - _shadow_coef)
    return sf.graphics.Color(_alpha, color_item, color_item, color_item)
end

function dialog_widget._CreateChangeAvatarEffect()
    local new_child_effect = 
    {
        Init = function(_self, _old_avatar, _new_avatar, _start_time, _total_time, _new_image, _text, _old_image) --     _src_cell, _dst_cell, _start_time, _total_time )
            _self.old = _old_avatar
            _self.new = _new_avatar

            if _old_avatar == _new_avatar then --and _new_avatar.id == _old_avatar.id then
                _self._do_not_shadow = true
            else

                if _old_image and _old_image~="" then
                    _self.old.new_image = _self.old.base_image
                    _self.old.base_image = sf.misc.anim.CImageObject(_old_image)
                    _self.change_all = true
                end


            end
            
            
            if _new_image and _new_image~="" then
                _self.new.new_image = _self.new.base_image
                _self.new.base_image = sf.misc.anim.CImageObject(_new_image)
            end

            dialog_widget.new_text.SetText(_text)
            _self.new_text_color = dialog_widget._text_color
            
            if not _self.old then
                dialog_widget.old_text.SetText("")
            end
            _self.old_text_color = dialog_widget._text_color

            _self.start_time = _start_time
            _self.total_time = _total_time
            _self.end_time = _self.start_time + _self.total_time
        end,

        Update = function(_self, _time)
            local koef = (_time - _self.start_time)/_self.total_time
            if not _self._do_not_shadow then
                if _self.old then
                    _self.old.alpha_koef = koef
                    
                end
                _self.new.alpha_koef = 1 - koef
            end
            
            _self.new.image_koef = 1 - koef
            

            local shadow_color = local_create_color(255, _self.new.alpha_koef)
            
            if not _self.new.new_image then
                _self.new.base_image.SetColor(shadow_color)
            else
                _self.new.base_image.SetColor(shadow_color)

                local color = sf.graphics.Color(shadow_color)
                color.Alpha = color.Alpha * _self.new.image_koef
                _self.new.new_image.SetColor(color)

            end        


            
            if _self.old then
                local color = local_create_color(255, _self.old.alpha_koef)
                if not _self.change_all then
                    _self.old.base_image.SetColor(color)
                else
                    if not _self.old.new_image then
                        _self.old.base_image.SetColor(color)
                    else
                        local color_base = sf.graphics.Color(color)
                        color_base.Alpha = color_base.Alpha * (1 - _self.new.image_koef)

                        _self.old.base_image.SetColor(color_base)

                        local color_new = sf.graphics.Color(color)
                        color_new.Alpha = color_new.Alpha * _self.new.image_koef
                        _self.old.new_image.SetColor(color_new)

                    end        
                end



            end
            
            _self.old_text_color.Alpha = 255*(1 - koef)
            dialog_widget.old_text.SetColor(_self.old_text_color)
            
             _self.new_text_color.Alpha = 255*koef
            dialog_widget.new_text.SetColor(_self.new_text_color)
            
            if _time > _self.end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)

            if not _self._do_not_shadow then
                if _self.old then
                    _self.old.alpha_koef = 1
                end
                _self.new.alpha_koef = 0
            end

            _self.new.image_koef = 0
            _self.old_text_color.Alpha = 0
            dialog_widget.old_text.SetColor(_self.old_text_color)

            _self.new_text_color.Alpha = 255
            dialog_widget.new_text.SetColor(_self.new_text_color)
            local temp = dialog_widget.old_text
            dialog_widget.old_text = dialog_widget.new_text
            dialog_widget.new_text = temp

            _self.new.new_image = nil
            _self.old.new_image = nil
            dialog_widget._current_avatar = _self.new
            _self.is_dead = true
        end,
    }
    return new_child_effect
end

function dialog_widget._CreateLabelWidget(_parent_widget)
    if dialog_widget._text_font then
        local label = sf.gui.CLabelWidget(dialog_widget._text_font, "", "", 0, 0)
        label.SetWordBreak(true)
        label.SetSize(dialog_widget._text_size.X, dialog_widget._text_size.Y)
        label.SetOffset(dialog_widget._text_offset.X, dialog_widget._text_offset.Y)
        label.ResizeToFitText(false)
        local color =  sf.graphics.Color(dialog_widget._text_color)
        color.Alpha = 0
        label.SetColor(color)
        _parent_widget.AddWidget(label)
        return label
    end
    return nil
end

function dialog_widget._CreateAvatar(_pos, _image_id, _avatar_id)
    local new_avatar = {pos = _pos,
    base_image= sf.misc.anim.CImageObject(_image_id),
    image_id = _image_id,
    new_image= nil,
    replay_init= nil,
    image_size=sf.misc.FloatVector(0, 0), image_koef=0, alpha_koef=1, id = _avatar_id }    
     
    new_avatar.image_size = new_avatar.base_image.GetPoly().Point(2) - new_avatar.base_image.GetPoly().Point(0)
    local shadow_color = local_create_color(255, 1)
    --local shadow_color = sf.graphics.Color(255, dialog_widget._min_avatar_alpha, dialog_widget._min_avatar_alpha, dialog_widget._min_avatar_alpha)
    new_avatar.base_image.SetColor(shadow_color)
    return new_avatar
end

function dialog_widget.add_dialog_say(_avatar_id, _text, _time, _image_id)
    if not _time then
        _time = dialog_widget._def_dialog_say_time
    end
    if not _image_id then
        _image_id = ""
    end
    local say_count = #dialog_widget._dialog_struct + 1
    if not dialog_widget._avatars_table[_avatar_id].replay_init then
        if not _image_id or _image_id =="" then
            _image_id = dialog_widget._avatars_table[_avatar_id].image_id
        end
        dialog_widget._avatars_table[_avatar_id].replay_init = true
    end

    dialog_widget._dialog_struct[say_count] = { avatar_id=_avatar_id, image_id=_image_id, text=_text, time=_time}
end

function dialog_widget.init_dialog( ...)
    dialog_widget._avatars_table = { }
    dialog_widget._dialog_struct = { }
    local current_def_avatar_offset = 1
    for _,v in ipairs({...}) do
        if v and type(v) =="table" then
            local pos = nil
            if v[3] and v[4] and type(v[3]) =="number" and type(v[4]) =="number" then
                pos = sf.misc.FloatVector(v[3], v[4])
            end
            if not pos then
                if dialog_widget._avatar_def_pos_table[current_def_avatar_offset] then
                    pos = dialog_widget._avatar_def_pos_table[current_def_avatar_offset]
                end
            end
            if not pos then
                __message("     "..v[1], "")
            end
            dialog_widget._avatars_table[v[1]] = dialog_widget._CreateAvatar(pos, v[2], v[1])
        end
        current_def_avatar_offset = current_def_avatar_offset + 1
    end
end

function dialog_widget.UpdateDialogSize()
    local current_size = dialog_widget.self.GetSize()
    
    if current_size.Y < dialog_widget._text_offset.Y + dialog_widget._text_size.Y + dialog_widget._buttons_area_height then
        dialog_widget.SetSize(current_size.X, dialog_widget._text_offset.Y + dialog_widget._text_size.Y + dialog_widget._buttons_area_height)
    end

    local new_size = dialog_widget.self.GetSize()        
    local button_area_start = sf.misc.FloatVector(0, new_size.Y - dialog_widget._buttons_area_height)

    local replay_offset = button_area_start + dialog_widget._replay_offset
    dialog_widget.replay_button.SetOffset(replay_offset.X, replay_offset.Y)
    local repla_button_size = dialog_widget.replay_button.GetSize()
    local continue_offset = button_area_start + dialog_widget._replay_offset
    continue_offset.X = continue_offset.X + repla_button_size.X  + dialog_widget._buttons_space
    dialog_widget.continue_button.SetOffset(continue_offset.X, continue_offset.Y)

end

function dialog_widget.SetSize(_width, _height)
    dialog_widget.self.SetSize(_width, _height)
    dialog_widget.background_image.SetRect( sf.misc.FloatRect(0, 0, _width, _height))
end

function dialog_widget.Init(_widget, _back_widget)
    dialog_widget.self = _widget
    dialog_widget.self_back = _back_widget

    dialog_widget.background_image = sf.graphics.CImage(dialog_widget._back_ground_id)

    dialog_widget.background_image.SetFlags(__or(__or(dialog_widget.background_image.GetFlags(), sf.graphics.CImage.FlagBoxImage), sf.graphics.CImage.FlagIntDest))
    local dialog_size = dialog_widget.self.GetSize()
    local a = dialog_size.X
    dialog_widget.background_image.SetRect( sf.misc.FloatRect(0, 0, dialog_size.X, dialog_size.Y))
    dialog_widget.replay_button = get_child_widget(_widget, "replay", sf.gui.CButtonWidget)
    dialog_widget.continue_button = get_child_widget(_widget, "continue", sf.gui.CButtonWidget)
    local continue_button_size = dialog_widget.continue_button.GetSize()


    local replay_button_size = sf.misc.FloatVector(dialog_widget.replay_button.GetSize())
    if replay_button_size.X < dialog_widget.continue_button.GetSize().X then
        replay_button_size.X = dialog_widget.continue_button.GetSize().X
    end
    dialog_widget.replay_button.SetSize(replay_button_size.X, replay_button_size.Y)
    dialog_widget.continue_button.SetSize(replay_button_size.X, replay_button_size.Y)
    
    dialog_widget._ShowReplay(false)
    
    dialog_widget.old_text = dialog_widget._CreateLabelWidget(dialog_widget.self)     
    dialog_widget.new_text = dialog_widget._CreateLabelWidget(dialog_widget.self)     
    
end

function dialog_widget._ShowReplay(_value)
    if dialog_widget.replay_button then
        set_widget_flag_value(dialog_widget.replay_button, sf.gui.CBaseWidget.FlagHidden, not _value)  
        set_widget_flag_value(dialog_widget.replay_button, sf.gui.CBaseWidget.FlagDisabled, not _value)  
    end
    if dialog_widget.continue_button and _value then
        set_widget_flag_value(dialog_widget.continue_button, sf.gui.CBaseWidget.FlagHidden, not _value)  
        set_widget_flag_value(dialog_widget.continue_button, sf.gui.CBaseWidget.FlagDisabled, not _value)  
    end
end

function dialog_widget.Show(_value)
    if dialog_widget.self then
        set_widget_flag_value(dialog_widget.self, sf.gui.CBaseWidget.FlagHidden, not _value)  
        set_widget_flag_value(dialog_widget.self, sf.gui.CBaseWidget.FlagDisabled, not _value)  
    end
end

function dialog_widget._StopSound()
    if dialog_widget.global_say_sound ~= nil then
        sf.core.g_Application.GetAudioManager().Stop(dialog_widget.global_say_sound, 0)
        dialog_widget.global_say_sound = nil
    end
end

function dialog_widget._PlaySound(_sound_string)
    if sf.core.g_Application.GetAudioManager().IsSound(_sound_string) then
        dialog_widget.global_say_sound = sf.core.g_Application.GetAudioManager().Play(_sound_string, -2, -2, -2, -2, -2);
    end
end

function dialog_widget.DoUpdate(_this)
    local current_time = dialog_widget._dialog_timer.Get().GetTime()
    if dialog_widget._start_dialog_effect then
        local koef = current_time/dialog_widget._start_dialog_time
        if current_time > dialog_widget._start_dialog_time then
            dialog_widget._start_dialog_effect = nil
            koef = 1
        end
        dialog_widget._stripe_alpha = 255 * koef
        for i,o in pairs(dialog_widget._avatars_table) do
            if dialog_widget._current_avatar == o then
                o.base_image.SetColor(local_create_color(255 * koef, 0))
            else
                o.base_image.SetColor(local_create_color(255 * koef, 1))
            end
        end
        dialog_widget._back_alpha = dialog_widget._back_alpha_max_alpha * koef
    elseif not dialog_widget._dialog_is_stoped then
        if dialog_widget.current_effect ~= nil then
            dialog_widget.current_effect:Update(current_time)
            if dialog_widget.current_effect.is_dead == true then
                dialog_widget.current_effect = nil
            end
        elseif dialog_widget.current_effect_add ~= nil then
            dialog_widget.current_effect_add:Update(current_time)
            if dialog_widget.current_effect_add.is_dead == true then
                dialog_widget.current_effect_add = nil
            end
        else
            if dialog_widget._text_delay_time ~= nil then
                if dialog_widget.sound_string ~= nil then
                    dialog_widget._PlaySound(dialog_widget.sound_string)
                    dialog_widget.sound_string = nil
                end
                if current_time > dialog_widget._text_delay_time then
                    dialog_widget._text_delay_time = nil
                end
            else
                if dialog_widget._current_steep ~= nil then
                    local step = dialog_widget._dialog_struct[dialog_widget._current_steep]
                    if step then
                        dialog_widget.sound_string = nil
                        local text = step.text
                        if type(text) == "number" then
                            dialog_widget.sound_string = "say_"..tostring(text)
                            text = sf.misc.g_StringTable.Instance().FormatByStringsID("$"..tostring(text))
                        end
                        dialog_widget._StopSound()

                        local sound_time = nil
                        if dialog_widget.sound_string then
                            if sf.core.g_Application.GetAudioManager().IsSound(dialog_widget.sound_string) then
                                sound_time = sf.core.g_Application.GetAudioManager().GetLength(dialog_widget.sound_string)
                            end
                        end
                        local add_image = nil
                        if dialog_widget._current_steep == 1 then
                             
                            for i,o in pairs(dialog_widget._avatars_table) do
                                if step.avatar_id ~= i then
                                    add_image = o.image_id
                                    break
                                end
                            end
                        end
                        dialog_widget._current_steep = dialog_widget._current_steep + 1 
                        dialog_widget.current_effect = dialog_widget._CreateChangeAvatarEffect()
                        dialog_widget.current_effect:Init(dialog_widget._current_avatar, dialog_widget._avatars_table[step.avatar_id ], current_time, dialog_widget._change_avatar_time, step.image_id, text, add_image)
                        if sound_time then
                            dialog_widget._text_delay_time = current_time + sound_time + dialog_widget._after_sound_delay
                        else
                            dialog_widget._text_delay_time = current_time + step.time
                        end
                    else
                        dialog_widget._current_steep = nil
                    end
                else
                    dialog_widget._ShowReplay(true)
                end
            end
        end
    end
    
    return true
end

function dialog_widget.DoDraw(_this, _renderer)
    local dialog_pos = dialog_widget._self.GetOffset()

    _renderer.PushState()
    _renderer.ApplyMatrix(sf.misc.MatrixTranslation(-dialog_pos.X, -dialog_pos.Y))
    _renderer.RenderFilledPoly4(sf.misc.Poly4FromRect(sf.misc.FloatRect(0, 0, 1024, 768)), sf.graphics.Color(dialog_widget._back_alpha, 0, 0, 0))
    _renderer.PopState()


    if dialog_widget.background_image then
        dialog_widget.background_image.Draw(_renderer)
    end
    
    for i,o in pairs(dialog_widget._avatars_table) do
    
        local current_avatar = o
        _renderer.PushState()
        _renderer.ApplyMatrix(sf.misc.MatrixTranslation(current_avatar.pos.X + current_avatar.image_size.X/2, current_avatar.pos.Y + current_avatar.image_size.Y/2))
        current_avatar.base_image.Draw(_renderer)
        
        if current_avatar.new_image then
            current_avatar.new_image.Draw(_renderer)
        end
        _renderer.PopState()
    end
    _renderer.PushState()
    _renderer.ApplyMatrix(sf.misc.MatrixTranslation(-dialog_pos.X, -dialog_pos.Y))
    _renderer.RenderFilledPoly4(sf.misc.Poly4FromRect(sf.misc.FloatRect(0- dialog_widget._stripe_border, 0- dialog_widget._stripe_border, 1024 + dialog_widget._stripe_border, dialog_widget._top_stripe_width + dialog_widget._stripe_border)), sf.graphics.Color(dialog_widget._stripe_alpha, 0, 0, 0))
    _renderer.RenderFilledPoly4(sf.misc.Poly4FromRect(sf.misc.FloatRect(0 - dialog_widget._stripe_border , 768 - dialog_widget._bottom_stripe_width, 1024 + dialog_widget._stripe_border, 768 + dialog_widget._stripe_border)), sf.graphics.Color(dialog_widget._stripe_alpha, 0, 0, 0))
    _renderer.PopState()
    
    return false
end

function dialog_widget.Load(_this, _info, _templates)
    dialog_widget._self = _this
    local dialogs = quest.game_resources.GetChild("Constants", false).GetChildRef("dialogs", false)
    if dialogs then
        
        local background_id = dialogs.GetValue("background_image").c_str()
        if background_id ~= "" then dialog_widget._back_ground_id = background_id end

        local res = tonumber(dialogs.GetValue("min_avatar_alpha").c_str())
        if res ~= nil then dialog_widget._min_avatar_alpha = res end

        res = tonumber(dialogs.GetValue("start_dialog_time").c_str())
        if res ~= nil then dialog_widget._start_dialog_time = res end

        res = tonumber(dialogs.GetValue("back_alpha_max_alpha").c_str())
        if res ~= nil then dialog_widget._back_alpha_max_alpha = res end

        res = tonumber(dialogs.GetValue("top_stripe_width").c_str())
        if res ~= nil then dialog_widget._top_stripe_width = res end

        res = tonumber(dialogs.GetValue("bottom_stripe_width").c_str())
        if res ~= nil then dialog_widget._bottom_stripe_width = res end

        
        local text_group = dialogs.GetChildRef("text", false)
        if text_group then
            local res = tonumber(text_group.GetValue("text_width").c_str())
            if res ~= nil then dialog_widget._text_size.X = res end
            res = tonumber(text_group.GetValue("text_height").c_str())
            if res ~= nil then dialog_widget._text_size.Y = res end
            res = tonumber(text_group.GetValue("text_x").c_str())
            if res ~= nil then dialog_widget._text_offset.X = res end
            res = tonumber(text_group.GetValue("text_y").c_str())
            if res ~= nil then dialog_widget._text_offset.Y = res end
            res = text_group.GetValue("color").c_str()
            if res ~= "" then dialog_widget._text_color = string_to_color(res) end
            res = text_group.GetValue("font").c_str()
            if res~='' then 
                dialog_widget._text_font = sf.core.g_Application.GetResourceManager().GetFont(res)
            end
        end

        local buttons_group = dialogs.GetChildRef("buttons", false)
        if buttons_group then
            local res = tonumber(buttons_group.GetValue("replay_x").c_str())
            if res ~= nil then dialog_widget._replay_offset.X = res end
            res = tonumber(buttons_group.GetValue("replay_y").c_str())
            if res ~= nil then dialog_widget._replay_offset.Y = res end
            res = tonumber(buttons_group.GetValue("buttons_space").c_str())
            if res ~= nil then dialog_widget._buttons_space = res end
            res = tonumber(buttons_group.GetValue("button_area_height").c_str())
            if res ~= nil then dialog_widget._buttons_area_height = res end
        end

        local delays_group = dialogs.GetChildRef("delays", false)
        if delays_group then
            local res = tonumber(delays_group.GetValue("change_avatart_delay").c_str())
            if res ~= nil then dialog_widget._change_avatar_time = res end
            res = tonumber(delays_group.GetValue("def_say_delay").c_str())
            if res ~= nil then dialog_widget._def_dialog_say_time = res end
            res = tonumber(delays_group.GetValue("after_sound_delay").c_str())
            if res ~= nil then dialog_widget._after_sound_delay = res end
        end

        local avatrs_pos_group = dialogs.GetChildRef("def_avatars_pos", false)
        if avatrs_pos_group then
            dialog_widget._avatar_def_pos_table = {}
            local avatars_item = avatrs_pos_group.GetFirstChildRef()
            while avatars_item do
                local x = nil
                local y = nil
                local res = tonumber(avatars_item.GetValue("x").c_str())
                if res ~= nil then x = res end
                res = tonumber(avatars_item.GetValue("y").c_str())
                if res ~= nil then y = res end
                if x and y then
                    table.insert(dialog_widget._avatar_def_pos_table, sf.misc.FloatVector(x, y))
                end
                avatars_item = avatars_item.GetNextSiblingRef()
            end        
        end
    end
end

function dialog_widget.close_dialog()
    quest.global_dialog_window_result = true 
end

function dialog_widget._init_dialog_begin()
    dialog_widget._current_steep = 1
    dialog_widget.current_effect = nil 
    dialog_widget._text_delay_time = nil
    dialog_widget._ShowReplay(false)
--    dialog_widget.continue_button.SetText(dialog_widget.text_skip)
end

function dialog_widget.start_dialog(_hide_dialog)
    quest.global_modify_level_flag = true 
    dialog_widget._init_dialog_begin()

    dialog_widget._current_avatar = dialog_widget._avatars_table[dialog_widget._dialog_struct[1].avatar_id]

    dialog_widget._dialog_is_stoped = nil    

    local shadow_color = local_create_color(255, 0)
    dialog_widget._current_avatar.base_image.SetColor(shadow_color)
    dialog_widget._current_avatar.alpha_koef = 0

    dialog_widget._start_dialog_effect = true

    dialog_widget._dialog_timer.Get().SetTime(0)

    if dialog_widget.continue_button then
        set_widget_flag_value(dialog_widget.continue_button, sf.gui.CBaseWidget.FlagHidden, true)  
        set_widget_flag_value(dialog_widget.continue_button, sf.gui.CBaseWidget.FlagDisabled, true)  
    end

    
    local max_text_size_y = 0
    for i,o in pairs(dialog_widget._dialog_struct) do
        local text = o.text
        if type(text) == "number" then
            text = sf.misc.g_StringTable.Instance().FormatByStringsID("$"..tostring(text))
        end
    
        
        dialog_widget.old_text.SetText(text)
        local text_size = dialog_widget.old_text.GetPreferredSize()
        if max_text_size_y < text_size.Y then
            max_text_size_y = text_size.Y
        end
    end
    dialog_widget.old_text.SetText("")

    if dialog_widget._text_size.Y < max_text_size_y then
        dialog_widget._text_size.Y = max_text_size_y
    end

    dialog_widget.UpdateDialogSize()
    


    if quest.global_skip_windows_flag == true then
        return false
    end
    objects_box_lua_widget.ShowObjectsWithAlpha(true)
    quest.global_dialog_window_result = nil
    quest.global_cursor.SetHintText(_T(""), false)

    --shadow_widget.Show(true, sf.graphics.Color(0, 0, 0, 0))
    scene_click_widget.Enable(false)
    dialog_widget.Show(true)

    quest.do_not_change_curosor = true
    quest.global_cursor.SetDisableHints(true)
    cursor_lua_widget.DropCursor()

    

    if dialog_widget.self_back then
        set_widget_flag_value(dialog_widget.self_back, sf.gui.CBaseWidget.FlagHidden, false)
        set_widget_flag_value(dialog_widget.self_back, sf.gui.CBaseWidget.FlagDisabled, false)
    end



    while true do
        if quest.global_dialog_window_result ~= nil then
            break
        end
        sleep(100)
    end

    if dialog_widget.self_back then
        set_widget_flag_value(dialog_widget.self_back, sf.gui.CBaseWidget.FlagHidden, true)
        set_widget_flag_value(dialog_widget.self_back, sf.gui.CBaseWidget.FlagDisabled, true)
    end

    --quest.global_cursor.SetDisableHints(false)
    if _hide_dialog then
        objects_box_lua_widget.ShowObjectsWithAlpha(false)
        scene_click_widget.Enable(true)
      --  shadow_widget.Show(false)
		quest.global_cursor.SetDisableHints(false)
        dialog_widget.Show(false)    
        quest.do_not_change_curosor = false
    end
    
    if quest.global_dialog_window_result == 1 then
       return true
    end
    return false
end

function dialog_widget.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = dialog_widget.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
	return false
end

function dialog_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)

    if dialog_widget.current_effect ~= nil then
        dialog_widget.current_effect:InstantApply()
        dialog_widget.current_effect = nil
        dialog_widget._text_delay_time = nil
    elseif dialog_widget._text_delay_time ~= nil then
        dialog_widget._text_delay_time = nil
    end

	return false
end

function dialog_widget.OnMouseMove(_this, _pos, _state, _broadcast)
	return true
end

dialog_widget.actions = dialog_widget.actions or {}
dialog_widget.actions.continue = 
{
	pressed = function(_window) 
	    dialog_widget.close_dialog()
	    dialog_widget._dialog_is_stoped = true
	end
}

dialog_widget.actions.replay = 
{
	pressed = function(_window) 
	    dialog_widget._init_dialog_begin()
	end
}

function dialog_widget.__CreateInstance()
    return "dialog_widget"
end





dialogs_back_widget = dialogs_back_widget or {}

__inherite(dialogs_back_widget, null_lua_widget_handler())

function dialogs_back_widget.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = dialogs_back_widget.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
	return false
end

function dialogs_back_widget.OnMouseMove(_this, _pos, _state, _broadcast)
	return true
end

function dialogs_back_widget.__CreateInstance()
    return "dialogs_back_widget"
end

