difficulty = difficulty or {}

difficulty.DifLevelTypes = {easy = 1, hard = 2}

difficulty.dif_table = {}

function difficulty.GetDifLevel()
    return difficulty.DifLevelTypes[easy]
end

function difficulty.SetDifLevel()

end

--     
function difficulty.IsEasyDifficulty()
	return difficulty.GetDifLevel() == 0
end

--       
function difficulty.InitDifLevelOwerload(_window, _game_resources)
end

function difficulty.InitDifLevel(_window, _game_resources)
end

function difficulty.InitDifLevel(_window, _game_resources)
    difficulty.dif_table = {}

    local dif_options_group = _game_resources.GetChild(_T("Constants"), false).GetChild(_T("dif_level_options"), false)
        
    local current_option = dif_options_group.GetFirstChildRef()
    while current_option do
        local option_id = current_option.GetId().c_str()
        local easy_value = string_to_bool_or_numeral(current_option.GetValue(_T("easy")).c_str())
        local hard_value = string_to_bool_or_numeral(current_option.GetValue(_T("hard")).c_str())

        difficulty.dif_table[option_id] = {easy = easy_value, hard = hard_value}
        current_option = current_option.GetNextSiblingRef()
    end
    
    difficulty.InitDifLevelOwerload(_window, _game_resources)
end

--      
function difficulty.ApplyDifLevelOwerload(_dif_level)
end

function difficulty.GetTableId()
    local dif_level =  difficulty.GetDifLevel()
    if dif_level == 0 then
        return  "easy"
    elseif dif_level == 1 then
        return  "hard"
    else
        __assert(false, "  ")
        return nil
    end
end

function difficulty.ApplyDifLevel()

    local table_id = difficulty.GetTableId()

    quest.global_cursor.SetShowHints(difficulty.dif_table["show_hints"][table_id])
    
    difficulty.HideHints(not difficulty.dif_table["show_questions"][table_id])

    hints_lua_widget.update_time = difficulty.dif_table["hint_resume_time"][table_id]
    hints_lua_widget.koef_hint_refreshtime = difficulty.dif_table["hint_koef_time"][table_id]
    
    difficulty.ApplyDifLevelOwerload(table_id)
    
    difficulty.ApplyDifLevelForMinigames()  
    
    quest.click_limit_time = difficulty.dif_table["limit_time"][table_id]
    quest.click_limit_count = difficulty.dif_table["limit_click_count"][table_id]
    score.const_gloabl_max_incorrect_click_count = difficulty.dif_table["incorect_click_limit"][table_id]
			
	score.alpha_bar_fill_time = difficulty.dif_table["bar_decrese_time"][table_id]
	score.alpha_bar_decrease_part = difficulty.dif_table["bar_decrese_part"][table_id]
	score.one_bar_fill_time_in_full_temp = difficulty.dif_table["bar_resume_time"][table_id]
    
end

function difficulty.ApplyDifLevelForMinigames()
    local dif_level_id = difficulty.GetTableId()
    local hide_solve = not difficulty.dif_table["show_slove_game_button"][dif_level_id]
	child_scenes.SetHideSolveMinigame(hide_solve)
	
    
	if child_scenes.IsMinigameFullScreen() == true then
		--           
		difficulty.ApplyDifLevelOwerload("hard")
        
        --    
        local hide_desc = difficulty.dif_table["hide_minigame_description"][dif_level_id]
        if hide_desc == nil then
            -- -   ,   
            hide_desc = dif_level_id == "hard"
        end
		child_scenes.SetHideFullScreenMinigameDescription(hide_desc)
	else
		difficulty.ApplyDifLevelOwerload(dif_level_id)
		child_scenes.SetHideFullScreenMinigameDescription(true)
	end
end

function difficulty.HideHints(_value)
    local current_scene = quest.global_played_level.GetScenes()
    while not current_scene.IsEnd() do
        local current_child = current_scene.Get().GetObjects()
        while not current_child.IsEnd() do
            local object = current_child.Get()
            if not object.ReadFlag(qe.CBaseSceneObject.ObjectFlagRemoved) then
                local object_id = object.GetId().c_str()
                if string.find(object_id, "#question") then
                    if _value then
                        object.RaiseObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden)
                        object.RaiseObjectFlag(qe.CBaseSceneObject.ObjectFlagDisable)
                    else
                        object.ClearObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden)
                        object.ClearObjectFlag(qe.CBaseSceneObject.ObjectFlagDisable)
                    end
                else
                    if _find_group_childs and object.GetType() == qe.CBaseSceneObject.GroupType then
                        local group = __cast(object.get(), qe.CSceneGroup)
                        if group then
                            local current_group_child = group.GetChilds()
                            while not current_group_child.IsEnd() do
                                local object_id = current_group_child.Get().GetId().c_str()
                                if string.find(object_id, "#question") then
                                    if _value then
                                        object.RaiseFlag(qe.CBaseSceneObject.ObjectFlagHidden)
                                        object.RaiseFlag(qe.CBaseSceneObject.ObjectFlagDisable)
                                    else
                                        object.ClearFlag(qe.CBaseSceneObject.ObjectFlagHidden)
                                        object.ClearFlag(qe.CBaseSceneObject.ObjectFlagDisable)
                                    end
                                end
                                current_group_child.Next()
                            end 
                        end
                    end
                end
            end
            current_child.Next()
        end
        current_scene.Next()
    end
end
