minigame_window = minigame_window or {}
minigame_window.actions = minigame_window.actions or {}

minigame_window.solve_timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")).AttachTimer(_T("")))
minigame_window.solve_disable_time = 2000
minigame_window.buttons_space = 14
minigame_window.buttons_bottom_space = 0

minigame_window.skip_text_offset = sf.misc.FloatVector(10, 10)
minigame_window.skip_text = "skip"
minigame_window.skip_text_font = "font_12"
minigame_window.skip_text_font_ptr = nil

minigame_window.solve_button_progress_image_id = "gui_game_gui_button_small_progress"

minigame_window.skip_text_color = sf.graphics.Color(255, 255, 255, 255)

__inherite(minigame_window, null_lua_widget_handler())

function minigame_window.__CreateInstance()
    return "minigame_window"
end

function quest.OnCloseMinigame(_minigame_widget)
    _minigame_widget.AddFlags(sf.gui.CBaseWidget.FlagDead) 
end

function minigame_window.CloseMinigame(_value)
    quest.global_minigame_window_result = _value
end

minigame_window.actions.minigame = 
{
    end_game = function(_owner)
        minigame_window._ClearSolveButton()
		minigame_window.CloseMinigame(1)
    end
}
minigame_window.actions.end_game = 
{
    pressed = function(_owner)
        minigame_window.CloseGame()
    end
}
minigame_window.actions.solve_game = 
{
    pressed = function(_owner)
        minigame_window.SolveGame()
    end
}

--    
function minigame_window.CloseGame()
	minigame_window._ClearSolveButton()
    minigame_window.CloseMinigame(0)
end

--    
function minigame_window.SolveGame()
	minigame_window._ClearSolveButton()
	minigame_window.CloseMinigame(2)
end

-- ,              (              )
function minigame_window._ClearSolveButton()
	if minigame_window.solve_button_widget then
		minigame_window.solve_button_widget.SetText(minigame_window.button_text)
		minigame_window.solve_button_widget.RemoveWidget(minigame_window._new_solve_widget)
	end
end

function minigame_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = minigame_window.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
    return false
end

function minigame_window.OnMouseMove(_this, _pos, _state, _broadcast)
	if _broadcast == false then
		quest.global_played_level.UpdateFocusedObject(nil) 
		--return true
	end
	return false
end


function minigame_window.UpdateSolveButton()
    minigame_window.solve_image.SetRect(sf.misc.FloatRect(0, 0, minigame_window.solve_button_size.X*minigame_window.solve_koef, minigame_window.solve_button_size.Y) )
    minigame_window.solve_image.SetSourceRect(sf.misc.FloatRect(0, 0, minigame_window.solve_image_size.X*minigame_window.solve_koef, minigame_window.solve_image_size.Y) )
end

function minigame_window.DoUpdate(_this)
    if not minigame_window.finish_solve_enabling then
        local current_time = minigame_window.solve_timer.Get().GetTime()
        minigame_window.solve_koef = current_time/minigame_window.solve_disable_time
        if minigame_window.solve_koef > 1 then
            minigame_window.solve_koef = 1
        end

        minigame_window.UpdateSolveButton()

        if minigame_window.solve_button_widget and minigame_window.solve_koef == 1 then
            minigame_window.solve_button_widget.DisableButton(false)
            minigame_window.solve_button_widget.OnMouseMove(sf.misc.FloatVector(-1000, -1000), 0, true)
            minigame_window.solve_button_widget.SetText(minigame_window.button_text)

            minigame_window.effects_list:CreateInstantEffect("SolveButtonEffect", sf.misc.FloatVector(minigame_window.solve_button_size.X/2, minigame_window.solve_button_size.Y/2))
            minigame_window.finish_solve_enabling = true
        end
    end
    minigame_window.effects_list:Update()
    return false    
end

function minigame_window.InitSolveButton(_widget)
	local solve_button_widget = _widget
    if solve_button_widget then

        minigame_window.finish_solve_enabling = nil

        local minigames_info = quest.game_resources.GetChild("Constants", false).GetChildRef("minigame", false)
        if minigames_info then
            local res = tonumber(minigames_info.GetValue("solve_disable_time").c_str())
            if res ~= nil then minigame_window.solve_disable_time = res end

            res = tonumber(minigames_info.GetValue("text_offset_x").c_str())
            if res ~= nil then minigame_window.skip_text_offset.X = res end
            res = tonumber(minigames_info.GetValue("text_offset_y").c_str())
            if res ~= nil then minigame_window.skip_text_offset.Y = res end
            res = minigames_info.GetValue("text_id").c_str()
            if res ~= "" then minigame_window.skip_text = sf.misc.g_StringTable.Instance().FormatByStringsID(res) end
            res = minigames_info.GetValue("text_font").c_str()
            if res ~= "" then minigame_window.skip_text_font = res end

            res = minigames_info.GetValue("disabled_skip_text_color").c_str()
            if res ~= "" then minigame_window.skip_text_color = string_to_color(res) end

            res = minigames_info.GetValue("solve_progres_image_id").c_str()
            if res ~= "" then minigame_window.solve_button_progress_image_id = res end

        end

        local new_solve_widget = sf.gui.CLuaWidget("solve_lua_widget", 50, __or(sf.gui.CWidget.BroadcastOnKeyDown, sf.gui.CWidget.BroadcastOnMouseMove))
        minigame_window._new_solve_widget = new_solve_widget
		new_solve_widget.SetOffset(0, 0)
        new_solve_widget.SetLua(quest.g_Lua.GetId())
        new_solve_widget.SetOverloadTable("solve_widget")


        minigame_window.solve_button_widget = solve_button_widget
        solve_button_widget.AddWidget(new_solve_widget)
        solve_button_widget.DisableButton(true)

        minigame_window.button_text = solve_button_widget.GetText()
        solve_button_widget.SetText("")

        minigame_window.solve_button_size = solve_button_widget.GetSize()

        minigame_window.solve_koef = 0.001
        minigame_window.solve_timer.Get().SetTime(0)

        minigame_window.solve_image = sf.graphics.CImage(minigame_window.solve_button_progress_image_id)


        local rect = minigame_window.solve_image.GetRect()

        minigame_window.solve_image_size = sf.misc.FloatVector(rect.Width, rect.Height )

        minigame_window.UpdateSolveButton()

        minigame_window.skip_text_font_ptr = sf.core.g_Application.GetResourceManager().GetFont(minigame_window.skip_text_font)
        minigame_window.skip_text_offset = minigame_window.skip_text_offset + minigame_window.solve_button_size/2
    end
end

function minigame_window.Load(_this, _info, _templates)
    
    minigame_window.finish_solve_enabling = true
    minigame_window.effects_list = visual_effects.CreateEffectsList()
    return false    
end


function minigame_window.DoDraw(_this, _renderer)
    if minigame_window.background_image then
        minigame_window.background_image.Draw(_renderer)
    end
    return false
end
----------------------------------------------------------------------------------------
solve_widget = solve_widget or {}

__inherite(solve_widget, null_lua_widget_handler()) 

function solve_widget.__CreateInstance()
    return "solve_widget"
end

function solve_widget.DoDraw(_this, _renderer)
    if not minigame_window.finish_solve_enabling and minigame_window.solve_image then
        minigame_window.solve_image.Draw(_renderer) 
        if minigame_window.skip_text_font_ptr then
            _renderer.RenderString(minigame_window.skip_text_font_ptr, minigame_window.skip_text, minigame_window.skip_text_offset.X, minigame_window.skip_text_offset.Y, 0, 0, 1, minigame_window.skip_text_color, 0)
        end
    end
    minigame_window.effects_list:PreDraw(_renderer)
    minigame_window.effects_list:PostDraw(_renderer)
    return false
end
