sminigames = sminigames or {}
function sminigames.SetStandartScriptName(_widget, _table)
	if _widget then
		local i = 1
		local v = ""
		for i,v in ipairs{"OnChar", "OnKeyDown", "OnKeyUp", "OnMouseMove", "OnMouseDown", "OnMouseUp", "OnDoubleClick", "OnMouseWheel", "OnUpdate", "OnPreferredSize", "OnChildAction"} do
			assert(loadstring("\
			function sminigames.SetScriptName(_widget, _table, _name) \
				if	_table."..v.." then \
					_widget.Set"..v.."ScriptName(\""..v.."\") \
				else \
					_widget.Set"..v.."ScriptName(\"\") \
				end\
			end"))()
			sminigames.SetScriptName(_widget, _table, name)
		end
	end
end

function sminigames.OnChildAction(_owner, _action, _child)
	if	_action == _T("end_game") then
        _owner.EndModal(1) -- AddFlags(sf.gui.CBaseWidget.FlagDead)
    elseif _child and _child.GetId() == _T("end_game") and _action == _T("pressed") then
        _owner.EndModal(0) -- AddFlags(sf.gui.CBaseWidget.FlagDead)
	end
end

function sminigames.OnPreferredSize(_owner)
    local size = sf.misc.FloatVector(0, 0)
    local iterator = _owner.GetWidgets()
    while iterator.IsEnd() == false do
        size.X = math.max(size.X, iterator.Get().GetSize().X + iterator.Get().GetOffset().X)
        size.Y = math.max(size.Y, iterator.Get().GetSize().Y + iterator.Get().GetOffset().Y)
        iterator.Next()
    end
    return size
end

function sminigames.ImageDropBuffer(_image)
	local frames = _image.GetTexture().EnumFrames()
	for i=0, frames-1 do
		local t = _image.GetTexture().GetFrameTime(i)
		local texture = _image.GetTexture().GetTexture(t)
		if texture.RectSurfaceIsBuffer(0) then
			texture.DropBuffer()
		end
	end
end

function sminigames.IsVisiblePoint(_image, _x, _y)
    local texture = _image.GetTexture().GetTexture(_image.GetTime())
	if not texture.RectSurfaceIsBuffer(0) then
		texture.CreateBuffer()
		texture.LoadBuffer()
	end
	assert(texture.RectSurfaceIsBuffer(0))
	local pixel = texture.Pixel(_x, _y)
	local color = sf.graphics.Color(pixel)
	local alpha = color.Alpha
	return alpha ~= 0
end

