enter_password_on_mouse = {}

enter_password_on_mouse.params =
{
	image_number_prefix = "scene02_mini_number",
	password = {4, 0, 1, 4},
	answer_pos = sf.misc.FloatVector(154.0, 72.0),
	answer_insets = 3,
	
	sound_on_click = "",
	
	sleep = 500.0 --        /       
}

function enter_password_on_mouse.IsPressed(_pos, _table)
	if	_table and _table.widget and misc.GetRect(_table.widget).IsContains(_pos.X, _pos.Y) then
		return true
	end
	return false
end

function enter_password_on_mouse.Enter(_owner)
	enter_password_on_mouse.CheckEnd(_owner)
	enter_password_on_mouse.RemAllAnswerImage(_owner)
end

function enter_password_on_mouse.OnUpdate(_owner) 	
	if not enter_password_on_mouse.need_check_end then return end
	local t = enter_password_on_mouse.timer.Get().GetTime()
	if t >= enter_password_on_mouse.need_check_end then
		enter_password_on_mouse.need_check_end = nil
		enter_password_on_mouse.CheckEnd(_owner)
	end
end

--[[
function enter_password_on_mouse.OnKeyDown(_owner, _key, _keyboard_state, _state, _broadcast)
	if	_key == 13  then  -- (VK_RETURN)
		enter_password_on_mouse.Enter(_owner)
		return true
	end
	return false
end
]]
function enter_password_on_mouse.OnChildAction(_owner, _action, _child)
	if	_child and _action == _T("pressed") then
		
		sound(enter_password_on_mouse.params.sound_on_click)
	
		if	_child.GetId() == _T("clear") then
			enter_password_on_mouse.RemAnswerImage(_owner)
		elseif	_child.GetId() == _T("clear_all") then
			enter_password_on_mouse.RemAllAnswerImage(_owner)
		elseif	_child.GetId() == _T("enter") then
			enter_password_on_mouse.Enter(_owner)
		else
			enter_password_on_mouse.AddAnswerImage(_owner, tonumber((T_(_child.GetId()).c_str())))
		end
	end
end

function enter_password_on_mouse.OnPreferredSize(_owner)
	local result = sf.misc.FloatVector(0, 0)
	if	enter_password_on_mouse.size then
		result.X = enter_password_on_mouse.size.x
		result.Y = enter_password_on_mouse.size.y
	end
	return result
end

function enter_password_on_mouse.CheckEnd(_owner)
	i = 1 
	result = true
	while i <= math.min(#enter_password_on_mouse.data.password.array, #enter_password_on_mouse.answer.array) do
		if	enter_password_on_mouse.data.password.array[i] ~= enter_password_on_mouse.answer.array[i].index then
			result = false
			break
		end
		i = i + 1
	end
	if #enter_password_on_mouse.answer.array ~= #enter_password_on_mouse.data.password.array then
		result = false
	end
	if	result then
		_owner.SetGameResult(1)
		_owner.OnEndGame()
	end
	if	enter_password_on_mouse.data.max_answer_size and enter_password_on_mouse.data.max_answer_size_clear and #enter_password_on_mouse.answer.array >= enter_password_on_mouse.data.max_answer_size then
		enter_password_on_mouse.RemAllAnswerImage(_owner)
	end
end

function enter_password_on_mouse.AddImage(_owner, _name, _x, _y, _id)
	widget_ptr = sf.gui.CImageWidgetPtrT(sf.gui.CImageWidget(_name, _id, 0, 0))
	if	_owner then
		_owner.AddWidget(widget_ptr)
	end
	widget_ptr.SetOffset(_x, _y)
	return widget_ptr
end

function enter_password_on_mouse.AddAnswerImage(_owner, _index)
	if	enter_password_on_mouse.data.max_answer_size and enter_password_on_mouse.data.max_answer_size <= #enter_password_on_mouse.answer.array then
		return
	end
	if	enter_password_on_mouse.data.button.array[_index] then
		index = #enter_password_on_mouse.answer.array + 1
		enter_password_on_mouse.answer.array[index] = {}
		enter_password_on_mouse.answer.array[index].image_name = enter_password_on_mouse.data.button.array[_index].image_for_add
		enter_password_on_mouse.answer.array[index].x = enter_password_on_mouse.answer.position.x
		enter_password_on_mouse.answer.array[index].y = enter_password_on_mouse.answer.position.y
		misc.AddImageWidget(_owner, enter_password_on_mouse.answer.array[index])
		enter_password_on_mouse.answer.array[index].index = _index
		enter_password_on_mouse.answer.position.x = enter_password_on_mouse.answer.position.x + enter_password_on_mouse.answer.array[index].widget.GetSize().X + enter_password_on_mouse.data.insets
		if enter_password_on_mouse.data.on_enter == false or enter_password_on_mouse.data.max_answer_size and enter_password_on_mouse.data.max_answer_size_clear and #enter_password_on_mouse.answer.array >= enter_password_on_mouse.data.max_answer_size then
			enter_password_on_mouse.need_check_end = enter_password_on_mouse.timer.Get().GetTime() + enter_password_on_mouse.params.sleep
		end
	end
end

function enter_password_on_mouse.RemAnswerImage(_owner)
	index = #enter_password_on_mouse.answer.array
	if	index > 0 then
		enter_password_on_mouse.answer.position.x = enter_password_on_mouse.answer.position.x - enter_password_on_mouse.answer.array[index].widget.GetSize().X - enter_password_on_mouse.data.insets
		_owner.RemoveWidget(enter_password_on_mouse.answer.array[index].widget)
		table.remove(enter_password_on_mouse.answer.array, index)	
	end
end

function enter_password_on_mouse.RemAllAnswerImage(_owner)
	while #enter_password_on_mouse.answer.array > 0 do
		enter_password_on_mouse.RemAnswerImage(_owner)
	end
end

function enter_password_on_mouse.Load(_owner, _data)
	sminigames.SetStandartScriptName(_owner, enter_password_on_mouse)
	enter_password_on_mouse.data = _data
	enter_password_on_mouse.size = {}
	enter_password_on_mouse.size.x = 0
	enter_password_on_mouse.size.y = 0

	local size = _owner.GetPreferredSize()
	_owner.SetSize(size.X, size.Y)
	enter_password_on_mouse.answer = {}
	enter_password_on_mouse.answer.array = {}
	enter_password_on_mouse.answer.position = {}
	enter_password_on_mouse.answer.position.x = _data.answer.position.x
	enter_password_on_mouse.answer.position.y = _data.answer.position.y
	_data.max_answer_size = math.max(_data.max_answer_size, #_data.password.array)

end

function enter_password_on_mouse.Button(_table, _index, _image_for_add)
	_table[_index] = {}
	_table[_index].id = tostring(_index)
	_table[_index].image_for_add = _image_for_add
end

function enter_password_on_mouse.Init(_owner)
	local data = {}
	data.button = {}
	data.button.array = {}
	
	for i = 0, 9 do
		enter_password_on_mouse.Button(data.button.array, i, _T(enter_password_on_mouse.params.image_number_prefix..i))
	end	
	
	data.password = {}
	data.password.array = {}
	for i = 1, #enter_password_on_mouse.params.password do
		data.password.array[i] = enter_password_on_mouse.params.password[i]
	end
	
	data.insets = enter_password_on_mouse.params.answer_insets

	data.answer = {}
	data.answer.position = {}
	data.answer.position.x = enter_password_on_mouse.params.answer_pos.X
	data.answer.position.y = enter_password_on_mouse.params.answer_pos.Y

	data.max_answer_size = #enter_password_on_mouse.params.password
	data.max_answer_size_clear = true
	data.on_enter = true
	
	enter_password_on_mouse.need_check_end = nil
	enter_password_on_mouse.timer = __create_timer("", "qe_level")
		
	enter_password_on_mouse.Load(_owner, data)
end
