enter_password_scroll = {}

enter_password_scroll.params = 
{
	init_numbers = {3, 3, 3},
	password = {1, 2, 3},
	horizontal = true,
	states = 4,
	move_time = 500,
	
	--
	sound_on_click = ""
}

--     /    
local add_delta = function(_pos, _delta)
	if enter_password_scroll.params.horizontal then
		_pos.X = _pos.X - _delta
	else
		_pos.Y = _pos.Y - _delta
	end
end

function enter_password_scroll.Init(_owner)
	sminigames.SetStandartScriptName(_owner, enter_password_scroll)
	enter_password_scroll.moves = {}
	
	enter_password_scroll.timer = __create_timer("", "qe_level")

	
	enter_password_scroll.images = nil
	
	_owner.AddFlags(sf.gui.CBaseWidget.FlagClipDraw)
	
	--   
	enter_password_scroll.images = {}
	local i = #enter_password_scroll.params.init_numbers
	local w = _owner.GetWidgets()	
	while not w.IsEnd() do
		local widget = __cast(w.Get(), sf.gui.CImageWidget) 
		if widget then
			local id = tonumber(widget.GetId().c_str())
			if id then --    				
				local init_number = 1
				if i > 0 then init_number = enter_password_scroll.params.init_numbers[i] end
				local pos = sf.misc.FloatVector(widget.GetOffset())
				local size, rect = nil, sf.misc.FloatRect(pos.X, pos.Y, 0.0, 0.0)
				--    /    
				if enter_password_scroll.params.horizontal then
					size = widget.GetSize().X
					size = size / (enter_password_scroll.params.states + 2)
					rect.Width = size
					rect.Height = widget.GetSize().Y
				else
					size = widget.GetSize().Y
					size = size / (enter_password_scroll.params.states + 2)
					rect.Width = widget.GetSize().X
					rect.Height = size
				end				

				local init_pos = sf.misc.FloatVector(pos)
				local number = init_number
				if number == 0 then number = enter_password_scroll.params.states end
				add_delta(init_pos, size * number)
				widget.SetOffset(init_pos.X, init_pos.Y)

				enter_password_scroll.images[id] = { widget = widget, number = number, size = size, rect = rect}
				
				i = i-1
			else
				enter_password_scroll.back_image = widget
			end
		end
		w.Next()
	end
end

function enter_password_scroll.OnMouseMove(_owner, _pos, _state, _broadcast)
	for id, image in pairs(enter_password_scroll.images) do
		if not enter_password_scroll.moves[id] and image.rect.IsContains(_pos.X, _pos.Y) then
			sf.gui.g_Cursor.Instance().SetCursor(sf.gui.CCursor.CursorHand)
			return true
		end
	end
	return false
end

function enter_password_scroll.OnMouseDown(_owner, _pos, _button, _state, _broadcast)
	if enter_password_scroll.timer then
		for id, image in pairs(enter_password_scroll.images) do
			if not enter_password_scroll.moves[id] and image.rect.IsContains(_pos.X, _pos.Y) then		
				enter_password_scroll.moves[id] = { start_time = enter_password_scroll.timer.Get().GetTime(), direction = (_button==_owner.LeftButton and 1 or -1)}
				sf.core.g_Application.GetAudioManager().Play(enter_password_scroll.params.sound_on_click, -2, -2, -2, -2, -2)
				return true
			end
		end
	end
	return false
end

function enter_password_scroll.OnUpdate(_owner) 
	if not enter_password_scroll.timer then return end
	
	local time = enter_password_scroll.timer.Get().GetTime()
	
	--   
	for id,move in pairs(enter_password_scroll.moves) do
		local image = enter_password_scroll.images[id]
		local new_pos = sf.misc.FloatVector(image.rect.X, image.rect.Y)
		if time < move.start_time + enter_password_scroll.params.move_time then
			--   
			local delta = image.number*image.size + move.direction*(time - move.start_time)/enter_password_scroll.params.move_time*image.size
			add_delta(new_pos, delta)
			image.widget.SetOffset(new_pos.X, new_pos.Y)
		else
			--  
			--  
			enter_password_scroll.moves[id] = nil
			--    1 
			image.number = image.number + move.direction
			if image.number > enter_password_scroll.params.states then
				image.number = 1
			elseif image.number < 1 then 
				image.number = enter_password_scroll.params.states
			end
			local delta = image.number * image.size 
			add_delta(new_pos, delta)
			image.widget.SetOffset(new_pos.X, new_pos.Y)
			--  
			enter_password_scroll.CheckVictory(_owner)
		end
	end
end

function enter_password_scroll.CheckVictory(_owner)
	for id,image in ipairs(enter_password_scroll.images) do
		if enter_password_scroll.params.password[id]~=image.number then return end
	end
	_owner.SetGameResult(1)
	_owner.OnEndGame()
	enter_password_scroll.moves = {}
	enter_password_scroll.timer = nil
end
