find_pairs = {}

find_pairs.params = 
{
	--    ; angle  
	items = 
	{		
		-- 1
		{pos = sf.misc.FloatVector(100.0, 100.0), angle = 15.0},
		-- 2
		{pos = sf.misc.FloatVector(200.0, 100.0), angle = 30.0},
		-- 3
		{pos = sf.misc.FloatVector(300.0, 100.0), angle = 45.0},
		-- 4
		{pos = sf.misc.FloatVector(400.0, 100.0), angle = 60.0},
		-- 5
		{pos = sf.misc.FloatVector(100.0, 150.0), angle = 75.0},
		-- 6
		{pos = sf.misc.FloatVector(200.0, 150.0), angle = 90.0},
		-- 7
		{pos = sf.misc.FloatVector(300.0, 150.0), angle = 105.0},
		-- 8
		{pos = sf.misc.FloatVector(400.0, 150.0), angle = 120.0},
		-- 9		
		{pos = sf.misc.FloatVector(100.0, 200.0), angle = 135.0},
		-- 10
		{pos = sf.misc.FloatVector(200.0, 200.0), angle = 150.0},
		-- 11
		{pos = sf.misc.FloatVector(300.0, 200.0), angle = 165.0},
		-- 12
		{pos = sf.misc.FloatVector(400.0, 200.0), angle = 180.0},		
		-- 13
		{pos = sf.misc.FloatVector(250.0, 250.0), angle = 195.0}
	},
	
	--  
	selection_color = sf.graphics.Color(255, 100, 100, 100), -- ARGB
	
	--  
	fade_out_time = 1000.0,
	
	--     
	deselect_time = 500.0,
	
	sound_on_click = ""
}

function find_pairs.CheckEnd(_owner)
end
				
function find_pairs.EndGame(_owner)
	if find_pairs.widgets then
		for _, w in pairs(find_pairs.widgets) do
			sminigames.ImageDropBuffer(w.GetImage())
		end
		find_pairs.widgets = nil
	end
	_owner.SetGameResult(1)
	_owner.OnEndGame()
end

function find_pairs.ClickInWidget(_item, _pos)
	local is_enabled = (sf.misc.BitwiseAnd(_item.widget.GetFlags(), sf.gui.CBaseWidget.FlagDisabled) == 0)
	return (is_enabled and _item.widget.GetPoly().IsContains(_pos.X, _pos.Y))
end
	
function find_pairs.ClickInFilled(_item, _pos)
	local angle = math.pi * _item.info.angle / 180.0
	local size = _item.widget.GetSize()
    local offset = _item.info.pos - size / 2.0
	local p = _pos * sf.misc.MatrixRotation(-angle, _item.info.pos.X, _item.info.pos.Y) - offset

    return sminigames.IsVisiblePoint(_item.widget.GetImage(), p.X, p.Y)
end
				
function find_pairs.OnMouseDown(_owner, _pos, _button, _state, _broadcast)
	for _, item in pairs(find_pairs.items) do		
		if find_pairs.ClickInWidget(item, _pos) and find_pairs.ClickInFilled(item, _pos) then			
			find_pairs.SelectItem(item)
			return true
		end
	end
	return false
end

function find_pairs.OnMouseMove(_owner, _pos, _state, _broadcast)
	return false
end

function find_pairs.OnMouseUp(_owner, _pos, _button, _state, _broadcast)	
	return false
end


function find_pairs.OnUpdate(_owner)
	local i = 1
	while i <= #find_pairs.effects do
		local effect = find_pairs.effects[i]
		assert(effect)
		effect:Update(find_pairs.timer.Get().GetTime())
		if effect.is_dead then
			table.remove(find_pairs.effects, i)			
		else
			i = i+1
		end
	end
	if #find_pairs.effects == 0 and find_pairs.resolved == true then
		find_pairs.EndGame(_owner)
		find_pairs.resolved = false
	end
end

function find_pairs.OnPreferredSize(_owner)
	return sminigames.OnPreferredSize(_owner)
end

function find_pairs.Init(_owner)
	sminigames.SetStandartScriptName(_owner, find_pairs)
	
	find_pairs.widgets = {}
	find_pairs.items = {}

	--  
	local w = _owner.GetWidgets()
	while not w.IsEnd() do
		local widget = w.Get()		
		if not widget.GetId().empty() then
			local image_item = __cast(widget, sf.gui.CImageWidget)
			if image_item then 
				table.insert(find_pairs.widgets, image_item)
				table.insert(find_pairs.items, {widget = image_item})
			end
		end
		w.Next()
	end
	
	--         
	local count = math.min(#find_pairs.items, #find_pairs.params.items)
	for i = 1, count do
		local item = find_pairs.items[i]
		local item_info = find_pairs.params.items[count - i + 1]
		
		local size = item.widget.GetSize()
		local offset = item.widget.GetOffset()		
		
		local matrix = sf.misc.MatrixTranslation(-offset.X - size.X / 2.0, -offset.Y - size.Y / 2.0)
		matrix = matrix * sf.misc.MatrixRotation(math.pi * item_info.angle / 180.0, 0.0, 0.0)
		matrix = matrix * sf.misc.MatrixTranslation(item_info.pos.X, item_info.pos.Y)
		
		item.info = item_info
		
		item.widget.SetRotation(matrix)
		
		item.widget.RemFlags(sf.gui.CBaseWidget.FlagDisabled)
	end
	
	find_pairs.timer = __create_timer("", "qe_level")
	
	find_pairs.effects = {}
	
	find_pairs.resolved = false
end

function find_pairs.FadeOutEffect(_item, _start_time, _target_time)
	return 
	{
		_item = _item,
		_start_time = _start_time,
		_target_time = _target_time,
		
		is_dead = false, 
				
		Update = function(_self, _time)
			local alpha = 0
			if _self._start_time <= _time and _time <= _self._target_time then
				local k = (_time - _self._start_time) / (_self._target_time - _self._start_time)
				alpha = 255.0 * (1.0 - k)
			else
				_self.is_dead = true
			end
			local color = sf.graphics.Color(_self._item.widget.GetColor())
			color.Alpha = alpha
			_self._item.widget.SetColor(color)
		end
	}
end

function find_pairs.DeselectEffect(_item, _start_time, _target_time)
	return 
	{
		_item = _item,
		_start_time = _start_time,
		_target_time = _target_time,
		
		is_dead = false, 
				
		Update = function(_self, _time)
			if not (_self._start_time <= _time and _time <= _self._target_time) then								
				_self._item.widget.SetColor(sf.graphics.Color(255, 255, 255, 255))
				_self._item.widget.RemFlags(sf.gui.CBaseWidget.FlagDisabled)
				_self.is_dead = true
			else
				_self._item.widget.AddFlags(sf.gui.CBaseWidget.FlagDisabled)
			end
		end
	}
end

function find_pairs.SelectItem(_item)
	if find_pairs.selected_item == _item then return end
	
	sound(find_pairs.params.sound_on_click)
	_item.widget.SetColor(find_pairs.params.selection_color)
	if find_pairs.selected_item then		
		local id1 = find_pairs.selected_item.widget.GetId().c_str()
		local id2 = _item.widget.GetId().c_str()
		
		if id1 == id2 then			
			--  
			find_pairs.RemoveItem(find_pairs.selected_item)
			find_pairs.RemoveItem(_item)
			find_pairs.AddFadeOutEffect(find_pairs.selected_item)
			find_pairs.AddFadeOutEffect(_item)

			if #find_pairs.items == 0 then
				find_pairs.resolved = true
			end
		else
			--  
			find_pairs.AddDeselectEffect(find_pairs.selected_item)
			find_pairs.AddDeselectEffect(_item)			
		end
		find_pairs.selected_item = nil
	else
		if #find_pairs.items == 1 then
			find_pairs.resolved = true
		else
			find_pairs.selected_item = _item
		end
	end	

end

function find_pairs.RemoveItem(_item)
	for i = 1, #find_pairs.items do
		local item = find_pairs.items[i]
		assert(item)
		if item == _item then
			table.remove(find_pairs.items, i)
			break
		end
	end
end

function find_pairs.AddFadeOutEffect(_item)	
	local effect = find_pairs.FadeOutEffect(_item, find_pairs.timer.Get().GetTime(), find_pairs.timer.Get().GetTime() + find_pairs.params.fade_out_time)
	table.insert(find_pairs.effects, effect)
end

function find_pairs.AddDeselectEffect(_item)
	local effect = find_pairs.DeselectEffect(_item, find_pairs.timer.Get().GetTime(), find_pairs.timer.Get().GetTime() + find_pairs.params.deselect_time)
	table.insert(find_pairs.effects, effect)
end
