move_mouse_by_path = {}

move_mouse_by_path.params = 
{
	--  true,  
	--	-   ,     
	-- 
	-- 	       
	easy = true, 
	
	start_area = 
	{
		pos = sf.misc.FloatVector(0.0, 0.0), 
		radius = 5.0
	},
	
	finish_area = 
	{
		pos = sf.misc.FloatVector(0.0, 0.0), 
		radius = 5.0
	},
	
	colors = 
	{
		normal = sf.graphics.Color(255,255,255,255), 
		in_area = sf.graphics.Color(255,255,255,255), 
		out_area = sf.graphics.Color(255,255,255,255)
	},
	
	time_after_failed = 500,
	
	sound_start_move = "start_click",
	sound_failed = ""
}

function move_mouse_by_path.SetParams(_params)
	move_mouse_by_path.params = _params
end

function move_mouse_by_path.SetFuncCheckEnd(_func_check_end)
	move_mouse_by_path.CheckEnd = _func_check_end
end

function move_mouse_by_path.OnStartRound()
	move_mouse_by_path.path_image.SetColor(move_mouse_by_path.params.colors.in_area)
	move_mouse_by_path.dragging = true
	move_mouse_by_path.failed = false
end

function move_mouse_by_path.OnFailedRound()
	move_mouse_by_path.path_image.SetColor(move_mouse_by_path.params.colors.out_area)
	move_mouse_by_path.dragging = false
	move_mouse_by_path.failed = true
	move_mouse_by_path.time_failed_round = move_mouse_by_path.timer.Get().GetTime()
end

function move_mouse_by_path.OnEndRound()
	move_mouse_by_path.path_image.SetColor(move_mouse_by_path.params.colors.normal)
	move_mouse_by_path.dragging = false
	move_mouse_by_path.failed = false
end

function move_mouse_by_path.IsVisiblePoint(_pos)
    return sminigames.IsVisiblePoint(move_mouse_by_path.alpha_image.GetImage(), _pos.X, _pos.Y)
end

function move_mouse_by_path._CheckEnd(_owner)
	sminigames.ImageDropBuffer(move_mouse_by_path.alpha_image.GetImage())
	_owner.SetGameResult(1)
	_owner.OnEndGame()
end

move_mouse_by_path.CheckEnd = move_mouse_by_path._CheckEnd

function move_mouse_by_path.OnUpdate(_owner)
	if move_mouse_by_path.failed == true then
		if (move_mouse_by_path.timer.Get().GetTime() - move_mouse_by_path.time_failed_round) >= 
			move_mouse_by_path.params.time_after_failed then
				move_mouse_by_path.OnEndRound()
		end
	end
end

function move_mouse_by_path.OnChildAction(_owner, _action, _child)
end

function move_mouse_by_path.OnMouseDown(_owner, _pos, _button, _keyboard_state, _broadcast)
	if not move_mouse_by_path.dragging and _button == sf.gui.CBaseWidget.LeftButton then		
		local delta = move_mouse_by_path.params.start_area.pos - (sf.misc.FloatVector(_pos) - move_mouse_by_path.path_image.GetOffset())
		if sf.misc.CalculateFloatVectorModule(delta) <= move_mouse_by_path.params.start_area.radius then
			if move_mouse_by_path.params.sound_start_move then
				sf.core.g_Application.GetAudioManager().Play(move_mouse_by_path.params.sound_start_move, -2, -2, -2, -2, -2)
			end
		    move_mouse_by_path.OnStartRound()
            return true
        end
	end
    return false
end

function move_mouse_by_path.OnMouseUp(_owner, _pos, _button, _keyboard_state, _broadcast)
	if move_mouse_by_path.params.easy == false then
		if move_mouse_by_path.dragging == true then
			move_mouse_by_path.OnEndRound()
	        return true
		end
	end
    return false
end

function move_mouse_by_path.OnMouseMove(_owner, _pos, _button, _keyboard_state, _broadcast)	
	local ret = false
	
	if move_mouse_by_path.dragging then		
		if move_mouse_by_path.dragged_image then			
			sf.gui.g_Cursor.Instance().SetCustomCursor(move_mouse_by_path.dragged_image.GetImage().GetTexture())
		end
		local pos = sf.misc.FloatVector(_pos) - move_mouse_by_path.path_image.GetOffset()
		if	move_mouse_by_path.IsVisiblePoint(pos) == false then
			if move_mouse_by_path.params.sound_failed then
				sf.core.g_Application.GetAudioManager().Play(move_mouse_by_path.params.sound_failed, -2, -2, -2, -2, -2)
			end
			move_mouse_by_path.OnFailedRound()
		else
			local delta = move_mouse_by_path.params.finish_area.pos - (sf.misc.FloatVector(_pos) - move_mouse_by_path.path_image.GetOffset())
            if sf.misc.CalculateFloatVectorModule(delta) <= move_mouse_by_path.params.finish_area.radius then
		    	move_mouse_by_path.CheckEnd(_owner)
            end
		end
		
		ret =  true
	elseif move_mouse_by_path.failed then
		if move_mouse_by_path.failed_image then
			sf.gui.g_Cursor.Instance().SetCustomCursor(move_mouse_by_path.failed_image.GetImage().GetTexture())
		end
	else
		if move_mouse_by_path.normal_image then
			sf.gui.g_Cursor.Instance().SetCustomCursor(move_mouse_by_path.normal_image.GetImage().GetTexture())
		end
	end
	
    return ret
end

function move_mouse_by_path.OnPreferredSize(_owner)
    return sminigames.OnPreferredSize(_owner)
end

function move_mouse_by_path._Init(_owner)
	sminigames.SetStandartScriptName(_owner, move_mouse_by_path)
	
	move_mouse_by_path.alpha_image.AddFlags(sf.gui.CWidget.FlagHidden)
	
	move_mouse_by_path.dragging = false
	move_mouse_by_path.failed = false
	
	move_mouse_by_path.timer = __create_timer("", "qe_level")

	move_mouse_by_path.time_failed_round = 0.0
		
	move_mouse_by_path.dragged_image = __cast(_owner.GetWidget(_T("dragged"), true), sf.gui.CImageWidget)		
	move_mouse_by_path.failed_image = __cast(_owner.GetWidget(_T("failed"), true), sf.gui.CImageWidget)
	move_mouse_by_path.normal_image = __cast(_owner.GetWidget(_T("normal"), true), sf.gui.CImageWidget)
	
	if move_mouse_by_path.dragged_image then
		move_mouse_by_path.dragged_image.AddFlags(sf.gui.CBaseWidget.FlagHidden)
	end
	if move_mouse_by_path.failed_image then
		move_mouse_by_path.failed_image.AddFlags(sf.gui.CBaseWidget.FlagHidden)
	end
	if move_mouse_by_path.normal_image then
		move_mouse_by_path.normal_image.AddFlags(sf.gui.CBaseWidget.FlagHidden)
	end
	
	move_mouse_by_path.OnEndRound()
end

function move_mouse_by_path.Init(_owner)	
	move_mouse_by_path.alpha_image = __cast(_owner.GetWidget(_T("alpha"), true), sf.gui.CImageWidget)
	assert(move_mouse_by_path.alpha_image)
	
	move_mouse_by_path.path_image = __cast(_owner.GetWidget(_T("path"), true), sf.gui.CImageWidget)
	assert(move_mouse_by_path.path_image)	
		
	move_mouse_by_path._Init(_owner)
end
