push_all_buttons = {}
local self = push_all_buttons
self.params = 
{
	different_buttons = false, --     
	buttons = 
	{
		{	-- 1
			pos = sf.misc.FloatVector(100.0, 100.0),
			on = true,
			buttons = {3,4}
		},
		{	-- 2
			pos = sf.misc.FloatVector(200.0, 100.0),
			on = false,
			buttons = {1,3}
		},
		{	-- 3
			pos = sf.misc.FloatVector(300.0, 100.0),
			on = true,
			buttons = {1,2}
		},
		{	-- 4
			pos = sf.misc.FloatVector(400.0, 100.0),
			on = false
		}
	},
	
	sound_click = "take_put_item"
}

self.CButton = function (_owner, _info, _state1, _state2)
	
	local image1 = sf.gui.CImageWidget(_state1, _T(""), -1, 0)
	image1.SetOffset(_info.pos.X, _info.pos.Y)
	_owner.AddWidget(sf.gui.CImageWidgetPtrT(image1))
	
	local image2 = sf.gui.CImageWidget(_state2, _T(""), -1, 0)
	image2.SetOffset(_info.pos.X, _info.pos.Y)
	_owner.AddWidget(sf.gui.CImageWidgetPtrT(image2))
	
	return
	{
		states = {image1, image2},
		state = 1,
		on = _info.on,
		buttons = _info.buttons,
		
		SetState = function(_self, _state)
			_self.state = _state
			_self:_UpdateImage()
		end,
				
		IsContains = function(_self, _pos)
			local widget = _self.states[_self.state]
			local pos = _pos - widget.GetOffset()
			return sminigames.IsVisiblePoint(widget.GetImage(), pos.X, pos.Y)
		end,	
		
		_UpdateImage = function(_self)
			_self.states[_self.state].RemFlags(sf.gui.CWidget.FlagHidden)
			_self.states[3-_self.state].AddFlags(sf.gui.CWidget.FlagHidden)
		end
	}
end

function self.CheckEnd(_owner)
	for _, b in pairs(self.buttons) do	
		if b.state == 1 then
			return false
		end
	end

	return true
end

function self.OnMouseDown(_owner, _pos, _button, _state, _broadcast)
	
	for _, b in pairs(self.buttons) do
		if b:IsContains(_pos) then
			if b.state == 1 then
				sf.core.g_Application.GetAudioManager().Play(self.params.sound_click, -2, -2, -2, -2, -2)
			end
			if not(b.on == false and b.state == 2) then
				local buttons = b.buttons
				if not buttons then
					buttons = {}
					for i = 1, #self.buttons do
						if self.buttons[i] ~= b then
							table.insert(buttons, i)
						end
					end
				end	
				local state = nil
				if b.on == true then 
					state = 3 - b.state
				else 
					state = 1 
				end
				for _, i in ipairs(buttons) do
					self.buttons[i]:SetState(state)
				end
			end
			b:SetState(3-b.state)
			self.pushed = true
			return true
		end
	end
	
	return false
end

function self.OnMouseMove(_owner, _pos, _state, _broadcast)

	for i, b in ipairs(self.buttons) do
		if b:IsContains(_pos) then
			if self.params.clip_id then --   ,   
				if not self.clip then
					local layer = 1
					if self.params.clip_layer then
						layer = self.params.clip_layer
					end
					self.clip = sf.gui.CClipWidget("", layer, 0)
					local id = self.params.clip_id
					if self.params.different_buttons then
						id = id .. i
					end
					self.clip.GetClip().Load(id, true)
					self.clip.SetOffset(self.params.buttons[i].pos.X, self.params.buttons[i].pos.Y)
					_owner.AddWidget(self.clip)
				end
			end 
			
			--  ,     
			sf.gui.g_Cursor.Instance().SetCursor(sf.gui.CCursor.CursorHand)
			return true
		end
	end

	if self.clip then --  ,   ,         
		_owner.RemoveWidget(self.clip)
		self.clip = nil
	end
	
	return false
end

function self.OnUpdate(_owner)
	if self.pushed == true and self.resolved == false then
		self.pushed = false
		self.resolved = self.CheckEnd(_owner)
		if self.resolved == true then
			if self.widgets then
				for _, w in pairs(self.widgets) do
			--		sminigames.ImageDropBuffer(w.GetImage())
					_owner.RemoveWidget(w)
				end
				self.widgets = nil
			end
			if self.clip then --  ,   ,         
				_owner.RemoveWidget(self.clip)
				self.clip = nil
			end
			_owner.SetGameResult(1)
			_owner.OnEndGame()
		end
	end
end

function self.OnPreferredSize(_owner)
	return sminigames.OnPreferredSize(_owner)
end

function self.Init(_owner)
	sminigames.SetStandartScriptName(_owner, push_all_buttons)
	
	--self.back = __cast(_owner.GetWidget("back", false).get(), sf.gui.CImageWidget)
	--__assert(self.back)
	
	local button_state1, button_state2
	if not self.params.different_buttons then --    
	
		button_state1 = __cast(_owner.GetWidget("button_state1", false).get(), sf.gui.CImageWidget)
		__assert(button_state1, "   id=button_state1")	
		button_state1.AddFlags(sf.gui.CWidget.FlagHidden)
	
		button_state2 = __cast(_owner.GetWidget("button_state2", false).get(), sf.gui.CImageWidget)
		__assert(button_state2, "   id=button_state2")	
		button_state2.AddFlags(sf.gui.CWidget.FlagHidden)
	end
	
	self.buttons = {}
	self.widgets = {}
	
	for i, b in ipairs(self.params.buttons) do
		if self.params.different_buttons then
			--   
			button_state1 = __cast(_owner.GetWidget("button_state1_"..i, false).get(), sf.gui.CImageWidget)
			__assert(button_state1, "   id=button_state1_"..i)	
			button_state1.AddFlags(sf.gui.CWidget.FlagHidden)
	
			button_state2 = __cast(_owner.GetWidget("button_state2_"..i, false).get(), sf.gui.CImageWidget)
			__assert(button_state2, "   id=button_state2_"..i)	
			button_state2.AddFlags(sf.gui.CWidget.FlagHidden)
		end
		table.insert(self.widgets, button_state1)
		table.insert(self.widgets, button_state2)
		local button = self.CButton(_owner, b, button_state1.GetImage(), button_state2.GetImage())
		button:SetState(1)
		table.insert(self.buttons, button)
	end	
	
	self.pushed = false
	self.resolved = false
end
