misc = {}

function misc.Clamp(_value, _min, _max)
	return math.min(_max, math.max(_min, _value))
end

function misc.MoveOn(_object, _x, _y)
	_object.SetOffset(_object.GetOffset().X + _x, _object.GetOffset().Y + _y)
end

function misc.GetCenter(_object)
	return _object.GetOffset() + _object.GetSize() / 2
end

function misc.MoveCenterTo(_object, _x, _y)
	_object.SetOffset(_x - _object.GetSize().X / 2, _y - _object.GetSize().Y / 2)
end

function misc.GetRect(_object)
	return sf.misc.FloatRect(_object.GetOffset().X, _object.GetOffset().Y, _object.GetSize().X, _object.GetSize().Y)
end

function misc.Intersection(_rect1, _rect2)
	if	_rect1.X ~= misc.Clamp(_rect1.X, _rect2.X, _rect2.X + _rect2.Width)	and  
		_rect2.X ~= misc.Clamp(_rect2.X, _rect1.X, _rect1.X + _rect1.Width)	then
		return 0
	end
	if	_rect1.Y ~= misc.Clamp(_rect1.Y, _rect2.Y, _rect2.Y + _rect2.Height)	and  
		_rect2.Y ~= misc.Clamp(_rect2.Y, _rect1.Y, _rect1.Y + _rect1.Height)	then
		return 0
	end
	
	return	(math.min(_rect1.X + _rect1.Width, _rect2.X + _rect2.Width) - math.max(_rect1.X, _rect2.X)) * 
			(math.min(_rect1.Y + _rect1.Height, _rect2.Y + _rect2.Height) - math.max(_rect1.Y, _rect2.Y))
end

function misc.Swap(_first, _second)
	local temp = _first
	_first = _second
	_second = temp
end

function table.Copy(_from, _to)
	local result = _to or {}
	trace("_from", _from)
	if	(type(_from) == "table") then
		for	index in pairs(_from) do
			if	(type(_from[index]) == "table") then
				result[index] = _from[index]
			else
				result[index] = table.Copy(_from[index], result[index])
			end
		end
	else
		result = _from
	end
	return result
end
