function misc.IncreaseSize(_vector, _object)
	if	_object then
		_vector.X = math.max(_vector.X,_object.GetOffset().X + _object.GetSize().X)
		_vector.Y = math.max(_vector.Y, _object.GetOffset().Y + _object.GetSize().Y)
	end
end

function misc.IncreaseSize2(_vector, _table, _index)
	if	_table and _table[_index] then
		misc.IncreaseSize(_vector, _table[_index])
	end
end

function misc.IncreaseSize3(_vector, _table, _index1, _index2)
	if	_table and _table[_index1] then
		misc.IncreaseSize2(_vector, _table[_index1], _index2)
	end
end

function misc.AddDefaultParametr(_table, _parameter_name, _parametr)
	if	_table[_parameter_name] == nil then
		if	_table.temp == nil then
			_table.temp = {}
		end
		_table.temp[_parameter_name] = _parametr
	end
end

function misc.GetParametr(_table, _parameter_name)
	if	_table[_parameter_name] ~= nil then
		return _table[_parameter_name]
	end
	if	_table.temp ~=  nil then
		return _table.temp[_parameter_name]
	end
	return nil
end

function misc.GetParametr2(_table, _first_parameter_name, _second_parameter_name)
	return misc.GetParametr(misc.GetParametr(_table, _first_parameter_name), _second_parameter_name)
end

function misc.ClearTemporaryParametr(_table)
	if	_table.temp ~= nil then
		_table.temp = nil
	end
	collectgarbage()
end

function misc.CreateWidgetTable(_table)
	local temp = _table or {}
	misc.AddDefaultParametr(temp, "id", _T(""))
	misc.AddDefaultParametr(temp, "layer", 0)
	misc.AddDefaultParametr(temp, "broadcast_mask", 0)
	misc.AddDefaultParametr(temp, "x", 0)
	misc.AddDefaultParametr(temp, "y", 0)
	return temp
end

function misc.SetParametrs(_table, _setter, _getter, _param1, _param2)
    if  _table and _table[_setter] then
        if	_param1 ~= nil then
            if	_param2 ~= nil then
                _table[_setter](_param1, _param2)
            else
                if  _table[_getter] then
                    _table[_setter](_param1, _table[_getter]().Y)
                end
            end
        else
            if  _param2 ~= nil and _table[_getter] then
                _table[_setter](_table[_getter]().X, _param2)
            end
        end
    end
end

function misc.ApplyWidgetParametrs(_table)
    misc.SetParametrs(_table.widget, "SetSize", "GetSize", _table.size_x, _table.size_y)
    local x = misc.GetParametr(_table, "x")
    local y = misc.GetParametr(_table, "y")
    if  _table.center then
        x = x - _table.widget.GetSize().X / 2
        y = y - _table.widget.GetSize().Y / 2
    end
    misc.SetParametrs(_table.widget, "SetOffset", "GetOffset", x, y)
end

function misc.CreateImageTable(_table)
	local temp = _table or {}
	misc.AddDefaultParametr(temp, "image_name", _T(""))
	return temp
end

function misc.AddImage(_table)
	local temp  = misc.CreateImageTable(_table)
	temp.image = sf.graphics.CImage(
		misc.GetParametr(temp, "image_name"))
	misc.ClearTemporaryParametr(temp)
	return temp 
end

function misc.CreateImageWidgetTable(_table)
	local temp = misc.CreateWidgetTable(_table)
	misc.AddDefaultParametr(temp, "image_name", _T(""))
	return temp
end

function misc.AddImageWidget(_owner, _table)
	local temp = misc.CreateImageWidgetTable(_table)

	--trace("widget", temp.widget)
	temp.widget = sf.gui.CImageWidget(
		misc.GetParametr(temp, "image_name"), 
		misc.GetParametr(temp, "id"), 
		misc.GetParametr(temp, "layer"), 
		misc.GetParametr(temp, "broadcast_mask"))
	--trace("widget", temp.widget)
	if _owner ~= nil then
		_owner.AddWidget(temp.widget)
	end
	misc.ApplyWidgetParametrs(temp)	
	misc.ClearTemporaryParametr(temp)
	return temp
end

function misc.CreateLabelWidgetTable(_table)
	local temp = misc.CreateWidgetTable(_table)
	misc.AddDefaultParametr(temp, "font_name", _T(""))
	misc.AddDefaultParametr(temp, "text", _T(""))
	misc.AddDefaultParametr(temp, "font", sf.core.g_Application.GetResourceManager().GetFont(misc.GetParametr(temp, "font_name")))
	return temp
end

function misc.AddLabelWidget(_owner, _table)
	local temp = misc.CreateLabelWidgetTable(_table)
	temp.widget = sf.gui.CLabelWidgetPtrT(sf.gui.CLabelWidget(
		misc.GetParametr(temp, "font"), 
		misc.GetParametr(temp, "text"), 
		misc.GetParametr(temp, "id"), 
		misc.GetParametr(temp, "layer"), 
		misc.GetParametr(temp, "broadcast_mask")))
	if _owner ~= nil then
		_owner.AddWidget(temp.widget)
	end
	misc.ApplyWidgetParametrs(temp)	
	misc.ClearTemporaryParametr(temp)	
	return temp
end

function misc.CreateButtonWidgetTable(_table)
	local temp = misc.CreateWidgetTable(_table)
	misc.AddDefaultParametr(temp, "image", {})
	misc.AddImage(misc.GetParametr(temp, "image"))
	misc.AddDefaultParametr(temp, "label", {})
	misc.AddLabelWidget(nil, misc.GetParametr(temp, "label"))
	return temp
end

function misc.AddButtonWidget(_owner, _table)
	local temp = misc.CreateButtonWidgetTable(_table)
	temp.widget = sf.gui.CButtonWidgetPtrT(sf.gui.CButtonWidget(
		misc.GetParametr2(temp, "image", "image"), 
		misc.GetParametr2(temp, "label", "widget"), 
		misc.GetParametr(temp, "id"), 
		misc.GetParametr(temp, "layer"), 
		misc.GetParametr(temp, "broadcast_mask")))
	if _owner ~= nil then
		_owner.AddWidget(temp.widget)
	end
	misc.ApplyWidgetParametrs(temp)	
	misc.ClearTemporaryParametr(temp)	
	return temp
end

function misc.ButtonWithImage(_table, _index, _id, _image, _x, _y)
	_table[_index] = {}
	_table[_index].image = {}
	_table[_index].image.image_name = _image
	_table[_index].x = _x
	_table[_index].y = _y
	_table[_index].id = _id
end


