modifers = modifers or {}
modifers.def_slep_on_hide_show = true
modifers.def_time_for_hide_show = 0


function modifers.set_user_data(_object, _data, _do_not_assert)
    local current_object = quest.global_current_script_object 

    if _data == nil then
       _data = _object 
       current_object = quest.global_current_script_object
	else
	
	    if _object ~= nil then
	        current_object = quest.FindObjectById(_object)
	        if not _do_not_assert then        
	            quest.show_object_find_error(_object, current_object)
	        end
		end
	end
    if current_object then
		if _data == nil then
			_data = ""
		end
		current_object.SetUserData(_data)
    end
end

function modifers.get_user_data(_object, _do_not_assert)
    local current_object = quest.global_current_script_object 
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
		return current_object.GetUserData()
    end
end



function modifers.hide(_object, _do_not_assert)
    modifers.hide_ex(nil, nil, _object, _do_not_assert)
end


function modifers.hide_ex(_momental, _sleep, _object, _do_not_assert)
    if _momental == nil then
        _momental = modifers.def_time_for_hide_show
    end
    if _sleep == nil then
        _sleep = modifers.def_slep_on_hide_show
    end
    local current_object = quest.global_current_script_object 
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        quest.global_modify_level_flag = true 
        if current_object.ReadObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden) == false then
            current_object.RaiseObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden)
            if _momental > 0 then
                qe.g_EffectsList.Instance().AddEffect(qe.CAlphaEffect(current_object, false, false, _momental, quest.level_timer.Get() )) --.Reset(AttachTimer(_T("")))
                if _sleep == true then
                    sleep(_momental)
                end            
            end
        end        
    end
end

function modifers.show(_object, _do_not_assert)
    modifers.show_ex(nil, nil, _object, _do_not_assert)
end

function modifers.show_ex(_momental, _sleep, _object, _do_not_assert)
    if _momental == nil then
        _momental = modifers.def_time_for_hide_show
    end
    if _sleep == nil then
        _sleep = modifers.def_slep_on_hide_show
    end
    
    local current_object = quest.global_current_script_object 
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        quest.global_modify_level_flag = true 
        if current_object.ReadObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden) == true then
            current_object.ClearObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden)
            if _momental > 0 then
                qe.g_EffectsList.Instance().AddEffect(qe.CAlphaEffect(current_object, true, false, _momental, quest.level_timer.Get()) ) --AttachTimer(_T(""))
                if _sleep == true then
                    sleep(_momental)
                end            
            end
        end
    end
end

function modifers.disable(_object, _do_not_assert)
    local current_object = quest.global_current_script_object 
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        quest.global_modify_level_flag = true 
        current_object.RaiseObjectFlag(qe.CBaseSceneObject.ObjectFlagDisable)
    end
end

function modifers.enable(_object, _do_not_assert)
    local current_object = quest.global_current_script_object 
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        quest.global_modify_level_flag = true 
        current_object.ClearObjectFlag(qe.CBaseSceneObject.ObjectFlagDisable)
    end
end

function modifers.change_color(_object, _a, _r, _g, _b, _find_removed)

    current_object = quest.FindObjectById(_object, _find_removed)
	
	if current_object then
		local group = __cast(current_object, qe.CSceneGroup)
		if group then
			__message("    ! id = ".._object)
			return 
		end
		local new_color = sf.graphics.Color(_a, _r, _g, _b)
		current_object.SetColor(new_color)
	else
		__message("     ! id = ".._object)
	end
end

function modifers.change_hint(_object, _hint_text, _find_removed)

    local current_object = nil
    if _hint_text == nil then
       _hint_text = _object 
       current_object = quest.global_current_script_object
    else
       current_object = quest.FindRootObjectById(_object, _find_removed)
    end
    local hint_type = type(_hint_text)

    local text = _hint_text
    if hint_type == "number" then
        text = "$"..tostring(_hint_text)
    end

    current_object.SetHint(text)
    quest.global_played_level.UpdateHint(current_object)
end

function modifers.play_clip(_object, _delay, _do_not_assert)
    local current_object = nil

    current_object = quest.global_current_script_object
    if _object ~= nil then
       current_object = quest.FindObjectById(_object)
       if not _do_not_assert then        
           quest.show_object_find_error(_object, current_object)
       end

    end
    if current_object then
        quest.global_modify_level_flag = true 
        local clip_object = __cast(current_object, qe.CClipObject )
        if clip_object ~= nil then
            local clip_time = clip_object.GetClipTime()
            if _delay ~= nil and type(_delay) == "number" then
                clip_time = _delay
            end
            if clip_time >= 0 or clip_time > 0 and _delay ~= nil then
                clip_object.Stop()
                clip_object.Play()
                Wait(clip_time)
            end
        else
            local image_object = __cast(current_object, qe.CImageObject )
            if image_object ~= nil then
                local image_time = image_object.GetTotalTime()
                if _delay ~= nil and type(_delay) == "number" and _delay > 0 then
                    image_time = _delay
                end
                if image_time > 0 then
                    image_object.PlayFromStart()
                    Wait(image_time)
                end
            end
        end
    end
end
