objects_box_lua_widget = objects_box_lua_widget or {}

objects_box_lua_widget.self = nil

objects_box_lua_widget.effects_list = {}

objects_box_lua_widget.show_objects_with_alpha = false

objects_box_lua_widget.show_objects_alpha = 128
objects_box_lua_widget.taked_objects_alpha = 128

objects_box_lua_widget.current_effect = nil

objects_box_lua_widget.taked_object = nil

objects_box_lua_widget.objects_list = nil

objects_box_lua_widget.FirstVisibleCell = 0
objects_box_lua_widget.VisibleCellsCount = 9

objects_box_lua_widget.drag_distance = 20

objects_box_lua_widget.CellSize = sf.misc.FloatVector(70, 70)

objects_box_lua_widget.cells_list = {}


invent_timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")).AttachTimer(_T("")))

--------------------------

function objects_box_lua_widget.SimpleFlyFunction( _start_pos, _end_pos, _t)
    return _start_pos + (_end_pos - _start_pos)*_t
end

function objects_box_lua_widget.LinkFlyFunction( _start_pos, _end_pos, _t)
    local current_pos =  _start_pos + (_end_pos - _start_pos)*_t
    current_pos.Y = current_pos.Y - math.sin( _t * 3.1415)*30
    return current_pos
end


function objects_box_lua_widget.CreateChildLinkEffect()
    local new_child_effect = 
    {
        Init = function(_self, _src_cell, _dst_cell, _start_time, _total_time )


            _self.start_time = _start_time
            _self.total_time = _total_time
            _self.end_time = _self.start_time + _self.total_time

            _self.src_cell = _src_cell
            

            _self.dst_cell = _dst_cell
            if not _src_cell.object_InventState then
                _self.object_InventState = nil
            else
                _self.object_InventState = qe.CSceneObjectPtrT(_src_cell.object_InventState.get())
            end
            
          

            _self.start_pos = sf.misc.FloatVector(_src_cell.cell_offset + _src_cell.width/2, objects_box_lua_widget.CellSize.Y/2)
            _self.fly_obj_pos = _start_pos
            _self.particle_effect = objects_box_lua_widget.effects_list:CreateEffect("LinkEffect", _self.fly_obj_pos)            
            _self.src_cell.formed = false
            _src_cell.object_InventState = nil
            _self.src_cell_start_width = _src_cell.width
            _self.src_cell.dead = true 

        end,

        Draw = function(_self, _renderer)
                if _self.fly_obj_pos ~= nil then
                    local object_pos = _self.object_InventState.get().GetPos()
                    _renderer.PushState()
                    _renderer.ApplyMatrix( sf.misc.MatrixTranslation(-object_pos.X + _self.fly_obj_pos.X , - object_pos.Y + _self.fly_obj_pos.Y))
                    _self.object_InventState.get().DrawGame(_renderer)
                    _renderer.PopState()
                end
        end,

        Update = function(_self, _time)
            local koef = (_time - _self.start_time)/_self.total_time
            _self.fly_obj_pos = objects_box_lua_widget.LinkFlyFunction( _self.start_pos, sf.misc.FloatVector(_self.dst_cell.cell_offset + _self.dst_cell.width/2,  objects_box_lua_widget.CellSize.Y/2), koef)
            _self.particle_effect:SetPos( _self.fly_obj_pos)
            if _time > _self.end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            if not _self.is_dead then
            end
            _self.particle_effect:Kill(false)

            _self.is_dead = true
        end,
        
        cell_link = nil,
        is_dead = false,
        object_InventState = nil,
        object_Item = nil,
        end_time = nil,
        total_time = nil,
        start_time = nil,
        start_pos = nil,
        fly_obj_pos = nil
    }
    return new_child_effect
end


--------------------------


--------------------------

function objects_box_lua_widget.CreateParentLinkEffect()
    local new_parent_link_effect = 
    {
        Init = function(_self, _final_object_id,  _link_objects_id_table, _target_cell,  _effect_cells_list, _total_time, _effects_time)

            inventory.shadow_take(_final_object_id) --     

            if objects_box_lua_widget.objects_list ~= nil then
                local current_object = objects_box_lua_widget.objects_list.GetObjects()
                while not current_object.IsEnd() do
                    if current_object.Get().Item.GetId().c_str() == _final_object_id then
                        _self.object_InventState = qe.CSceneObjectPtrT(current_object.Get().InventState.get())
                        _self.object_Item = qe.CBaseSceneObjectPtrT(current_object.Get().Item.get())
                        _self.object = current_object.Get()

                    end
                    current_object.Next()
                end
            end
            _self.effect_cells_list = _effect_cells_list

            _self.new_cell_width = math.ceil( _self.object_InventState.GetSize().X / objects_box_lua_widget.CellSize.X )*objects_box_lua_widget.CellSize.X
        

            for i,o in pairs(_link_objects_id_table) do
                objects_box_lua_widget.objects_list.RemoveObject(o)
            end
            _self.cell_link = _target_cell
            _self.start_cell_width = _self.cell_link.width
            _self.cell_link.formed = false
            _self.total_time = _total_time
            _self.effects_time = _total_time


            --if all_cells_formed == true then
                --_self.effect_is_init = true
            _self.start_time = invent_timer.Get().GetTime()
            _self.end_time = _self.start_time + _self.total_time + _self.effects_time

            for i,o in pairs(_self.effect_cells_list) do

                local new_child_effect = objects_box_lua_widget.CreateChildLinkEffect()
                new_child_effect:Init(o, _self.cell_link, _self.start_time, _self.total_time)
                table.insert(_self.child_effects_list, new_child_effect)
            end            
            --end


            return _total_time + _effects_time
        end,

        Draw = function(_self, _renderer)
            if _self.fly_obj_pos ~= nil and _self.effect_is_init == true then
                local object_pos = _self.object_InventState.get().GetPos()
                _renderer.PushState()
                _renderer.ApplyMatrix( sf.misc.MatrixTranslation(-object_pos.X + _self.cell_link.offset + _self.cell_link.width/2 , - object_pos.Y + objects_box_lua_widget.CellSize.Y/2))
                _self.object_InventState.get().DrawGame(_renderer)
                _renderer.PopState()
            end

            local size = #(_self.child_effects_list)
            if size ~= 0 then
                for i = 1, size do
                    _self.child_effects_list[i]:Draw(_renderer)
                end
            end

        end,

        Update = function(_self, _time)
            local koef = (_time - _self.start_time)/(_self.total_time + _self.effects_time)
            _self.cell_link.width = _self.start_cell_width + (_self.new_cell_width - _self.start_cell_width )*koef


            local size = #(_self.child_effects_list)
            if size ~= 0 then
                local current_time = invent_timer.Get().GetTime()
                local i = 1
                while i <= size do
                    _self.child_effects_list[i]:Update(_time)
                    if _self.child_effects_list[i].is_dead == true then
                        table.remove(_self.child_effects_list, i)
                        size = size - 1
                        i = i - 1
                    end
                    i = i + 1
                end
                
            end
            if  #_self.child_effects_list == 0 and _self.effect_create == nil then
                objects_box_lua_widget.effects_list:CreateInstantEffect("LinkEffectParent", sf.misc.FloatVector(_self.cell_link.cell_offset + _self.cell_link.width/2,  objects_box_lua_widget.CellSize.Y/2))            
                _self.effect_create = true
            end

            
            if _time > _self.end_time then

                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            if not _self.is_dead then

                _self.cell_link.object_InventState = _self.object_InventState
                _self.cell_link.object_Item = _self.object_Item
                _self.cell_link.formed = true
                _self.cell_link.width = _self.new_cell_width 

                objects_box_lua_widget.effects_list:CreateInstantEffect("LinkEffectParentFinal", sf.misc.FloatVector(_self.cell_link.cell_offset + _self.cell_link.width/2,  objects_box_lua_widget.CellSize.Y/2))            

                local size = #(_self.child_effects_list)
                if size ~= 0 then
                    local current_time = invent_timer.Get().GetTime()
                    local i = 1
                    while i <= size do
                        _self.child_effects_list[i]:InstantApply()
                        table.remove(_self.child_effects_list, i)
                        size = size - 1
                    end
                end
            end
            _self.is_dead = true
        end,
        
        child_effects_list = {},
        effect_cells_list = nil,
        cell_link = nil, --    
        is_dead = false,
        object_InventState = nil, --    
        object_Item = nil, --    
        object = nil, --   


        end_time = nil,
        total_time = nil,
        start_time = nil,
        effect_is_init = false,
        new_cell_width = nil
    }
    return new_parent_link_effect
end

--------------------------

function objects_box_lua_widget.CreateComboEffect()
    local new_take_effect = 
    {
        Init = function(_self, _invent_object, _start_time, _total_time, _start_pos, _res_object_id )
            


            _self.part_object_InventState = qe.CSceneObjectPtrT(_invent_object.InventState.get())
            _self.part_object_Item = qe.CBaseSceneObjectPtrT(_invent_object.Item.get())
            
            objects_box_lua_widget.objects_list.RemoveObject(_invent_object.Item.GetId())
            
            
            local res_cell = nil
            for i,o in pairs(objects_box_lua_widget.cells_list) do
                if o.object_Item ~= nil then
                    if o.object_Item.GetId().c_str() == _res_object_id then
                        res_cell = o
                        break         
                    end
                end
             end
            if res_cell == nil then
                res_cell = objects_box_lua_widget.InsertEmptyCell()
                inventory.shadow_take(_res_object_id)
                _self.new_cell = true
            end
            local res_object_is_find = false
            if objects_box_lua_widget.objects_list ~= nil then
                local current_object = objects_box_lua_widget.objects_list.GetObjects()
                while not current_object.IsEnd() do
                    if current_object.Get().Item.GetId().c_str() == _res_object_id then
                        _self.object_InventState = qe.CSceneObjectPtrT(current_object.Get().InventState.get())
                        _self.object_Item = qe.CBaseSceneObjectPtrT(current_object.Get().Item.get())
                        _self.object = current_object.Get()
                        res_object_is_find = true
                    end
                    current_object.Next()
                end
            end
            __assert(res_object_is_find, "  ".._res_object_id.."    ")

            _self.start_pos = _start_pos
            _self.fly_obj_pos = _start_pos

            _self.particle_effect = objects_box_lua_widget.effects_list:CreateEffect("TakeComboObject", _self.fly_obj_pos)            

            _self.cell_link = res_cell

            _self.cell_link.object_Item = qe.CBaseSceneObjectPtrT(_self.object_Item.get())

            _self.start_time = _start_time
            local target_pos = sf.misc.FloatVector(_self.cell_link.cell_offset + _self.cell_link.width/2,  objects_box_lua_widget.CellSize.Y/2)
            _self.total_time = ((sf.misc.CalculateFloatVectorModule(_start_pos - target_pos))/objects_box_lua_widget.combo_speed)*1000
            _self.end_time = _self.start_time + _self.total_time
            return _self.total_time
        end,

        Draw = function(_self, _renderer)
                if _self.fly_obj_pos ~= nil then
                    local object_pos = _self.part_object_InventState.get().GetPos()
                    _renderer.PushState()
                    _renderer.ApplyMatrix( sf.misc.MatrixTranslation(-object_pos.X + _self.fly_obj_pos.X , - object_pos.Y + _self.fly_obj_pos.Y))
                    _self.part_object_InventState.get().DrawGame(_renderer)
                    _renderer.PopState()
                end
        end,

        Update = function(_self, _time)
            local koef = (_time - _self.start_time)/_self.total_time
            _self.fly_obj_pos = objects_box_lua_widget.SimpleFlyFunction( _self.start_pos, sf.misc.FloatVector(_self.cell_link.cell_offset + _self.cell_link.width/2,  objects_box_lua_widget.CellSize.Y/2), koef)

            _self.particle_effect:SetPos( sf.misc.FloatVector(_self.fly_obj_pos.X, _self.fly_obj_pos.Y))
            if _time > _self.end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            if not _self.is_dead then
                if _self.new_cell == nil then --_self.cell_link.object_InventState ~= nil 
                    objects_box_lua_widget.objects_list.SetItemNextState(_self.cell_link.object_Item.GetId().c_str())
                    _self.cell_link.object_InventState = qe.CSceneObjectPtrT(_self.object.InventState.get())
                else
                    _self.cell_link.object_InventState =qe.CSceneObjectPtrT(_self.object_InventState.get())
                    _self.cell_link.formed = true
                end
                _self.particle_effect:Kill(false)
            end
            _self.is_dead = true
        end,
        
        cell_link = nil,
        is_dead = false,
        object_InventState = nil,
        object_Item = nil,
        object = nil,

        part_object_InventState = nil,
        part_object_Item = nil,

        end_time = nil,
        total_time = nil,
        start_time = nil,
        start_pos = nil,
        fly_obj_pos = nil
    }
    return new_take_effect
end

--------------------------

function objects_box_lua_widget.CreateTakeEffect()
    local new_take_effect = 
    {
        Init = function(_self, _invent_object, _start_time, _total_time, _start_pos )
            

            local new_cell = objects_box_lua_widget.InsertEmptyCell()
            _self.start_pos = _start_pos
            _self.fly_obj_pos = _start_pos
            _self.cell_link = new_cell
            _self.particle_effect = objects_box_lua_widget.effects_list:CreateEffect("TakeObject", _self.fly_obj_pos)            
            
             _self.object_InventState = qe.CSceneObjectPtrT(_invent_object.InventState.get())
            _self.cell_link.width = math.ceil(_self.object_InventState.GetSize().X / objects_box_lua_widget.CellSize.X )*objects_box_lua_widget.CellSize.X
            _self.object_Item = qe.CBaseSceneObjectPtrT(_invent_object.Item.get())
            _self.cell_link.object_Item = qe.CBaseSceneObjectPtrT(_self.object_Item.get())
            _self.start_time = _start_time
            local target_pos = sf.misc.FloatVector(_self.cell_link.cell_offset + _self.cell_link.width/2,  objects_box_lua_widget.CellSize.Y/2)
            _self.total_time = ((sf.misc.CalculateFloatVectorModule(_start_pos - target_pos))/objects_box_lua_widget.take_speed)*1000
            _self.end_time = _self.start_time + _self.total_time
            return _self.total_time
        end,

        Draw = function(_self, _renderer)
                if _self.fly_obj_pos ~= nil then
                    local object_pos = _self.object_InventState.get().GetPos()
                    _renderer.PushState()
                    _renderer.ApplyMatrix( sf.misc.MatrixTranslation(-object_pos.X + _self.fly_obj_pos.X , - object_pos.Y + _self.fly_obj_pos.Y))
                    _self.object_InventState.get().DrawGame(_renderer)
                    _renderer.PopState()
                end
        end,

        Update = function(_self, _time)
            local koef = (_time - _self.start_time)/_self.total_time

            _self.fly_obj_pos = objects_box_lua_widget.SimpleFlyFunction( _self.start_pos, sf.misc.FloatVector(_self.cell_link.cell_offset + _self.cell_link.width/2,  objects_box_lua_widget.CellSize.Y/2), koef)

            _self.particle_effect:SetPos( sf.misc.FloatVector(_self.fly_obj_pos.X, _self.fly_obj_pos.Y))
            if _time > _self.end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            if not _self.is_dead then
                _self.cell_link.object_InventState = qe.CSceneObjectPtrT(_self.object_InventState.get())
                _self.cell_link.formed = true
                _self.particle_effect:Kill(false)
            end
            _self.is_dead = true
        end,
        
        cell_link = nil,
        is_dead = false,
        object_InventState = nil,
        object_Item = nil,
        end_time = nil,
        total_time = nil,
        start_time = nil,
        start_pos = nil,
        fly_obj_pos = nil
    }
    return new_take_effect
end

--------------------------




function objects_box_lua_widget.InsertEffect(_effect)
    if objects_box_lua_widget.current_effect ~= nil then
        objects_box_lua_widget.current_effect:InstantApply()
    end
    objects_box_lua_widget.current_effect = _effect
end

function objects_box_lua_widget.remove(_id)
    if objects_box_lua_widget.objects_list ~= nil then
        local current_object = objects_box_lua_widget.objects_list.GetObjects()
        local removed_object = nil
        while not current_object.IsEnd() do
            local test = current_object.Get().Item.GetId().c_str()
            if current_object.Get().Item.GetId().c_str() == _id then 
                removed_object = current_object.Get()
                break
            end
            current_object.Next()
        end

        if removed_object ~= nil then

           local cells_count = #objects_box_lua_widget.cells_list
           local index = 1
           for i,o in pairs(objects_box_lua_widget.cells_list) do
                if o.object_Item ~= nil then
                    if o.object_Item.GetId().c_str() == removed_object.Item.GetId().c_str() then
                        o.dead = true
                        if index == cells_count then
                            o.width = 0
                        end
                        break         
                    end
                end
                index = index + 1 
            end


            objects_box_lua_widget.objects_list.RemoveObject(_id)
        end
    end
end

function objects_box_lua_widget.change_state(_id)
    local inven_object = nil
    local current_object = objects_box_lua_widget.objects_list.GetObjects()
    while not current_object.IsEnd() do
        if current_object.Get().Item.GetId().c_str() == _id then
            inven_object = current_object.Get()
            break
        end
        current_object.Next()
    end

    for i,o in pairs(objects_box_lua_widget.cells_list) do
        if o.object_Item ~= nil then
            local cell_object_id = o.object_Item.GetId().c_str()
            if cell_object_id == _id then
                objects_box_lua_widget.objects_list.SetItemNextState(cell_object_id)
                o.object_InventState = qe.CSceneObjectPtrT(inven_object.InventState.get())
                break         
            end
        end
     end
end            

function objects_box_lua_widget.change_state_by_id(_id, _state_id)
    local inven_object = nil
    local current_object = objects_box_lua_widget.objects_list.GetObjects()
    while not current_object.IsEnd() do
        if current_object.Get().Item.GetId().c_str() == _id then
            inven_object = current_object.Get()
            break
        end
        current_object.Next()
    end
    if inven_object then

        for i,o in pairs(objects_box_lua_widget.cells_list) do
            if o.object_Item ~= nil then
                local cell_object_id = o.object_Item.GetId().c_str()
                if cell_object_id == _id then
                    objects_box_lua_widget.objects_list.SetItemStateById(cell_object_id, _state_id)
                    o.object_InventState = qe.CSceneObjectPtrT(inven_object.InventState.get())
                    break         
                end
            end
         end
    end
end            




function objects_box_lua_widget.take(_id, _momental)

    local widget_pos = quest.get_object_pos(_id)
    if not widget_pos then
        widget_pos = sf.misc.FloatVector(0, 0)    
    end

    local object_list_abs_pos = sf.misc.FloatVector(0,0)
    object_list_abs_pos = objects_box_lua_widget.self.GetAbsPos(false)
    
    --quest.global_played_level.RemoveObject(_id)
    quest.RemoveObject(_id.c_str())
    local res_object_id = inventory.IsFormed(_id.c_str())
    local take_effect = nil
	local take_time = nil
    if res_object_id ~= nil then
        if objects_box_lua_widget.objects_list ~= nil then
            local current_object = objects_box_lua_widget.objects_list.GetObjects()
            while not current_object.IsEnd() do
                if current_object.Get().Item.GetId().c_str() == _id.c_str() then 

                    local new_combo_effect = objects_box_lua_widget.CreateComboEffect()
                    take_effect = new_combo_effect
					
                    take_time = new_combo_effect:Init(current_object.Get(), invent_timer.Get().GetTime(), "take_time", widget_pos - object_list_abs_pos, res_object_id)
                    if not _momental then
	    				objects_box_lua_widget.InsertEffect(new_combo_effect)
                    else
                        new_combo_effect:InstantApply()
                    end
                    break
                end
                current_object.Next()
            end
        end
    else
        if objects_box_lua_widget.objects_list ~= nil then
            local current_object = objects_box_lua_widget.objects_list.GetObjects()
            while not current_object.IsEnd() do
                if current_object.Get().Item.GetId().c_str() == _id.c_str() then 
                    local new_take_effect = objects_box_lua_widget.CreateTakeEffect()
                    take_effect = new_take_effect
					
                    take_time = new_take_effect:Init(current_object.Get(), invent_timer.Get().GetTime(), "take_time", widget_pos - object_list_abs_pos)
                    if not _momental then
	    				objects_box_lua_widget.InsertEffect(new_take_effect)
                    else
                        new_take_effect:InstantApply()
                    end

                    break
                end
                current_object.Next()
            end
        end
    end
  
    sleep(take_time)
    if objects_box_lua_widget.current_effect == take_effect then
        objects_box_lua_widget.InsertEffect(nil)
    elseif objects_box_lua_widget.current_effect ~= nil then 
		return
    end
    
    local link_table = inventory.NeedLink()
    while(link_table ~= nil) do
        objects_box_lua_widget.link(link_table)
        link_table = inventory.NeedLink()
    end
end

function objects_box_lua_widget.link(_link_table)
    local target_cell = nil
    local effect_cells_list = {}
    for i,o in pairs(objects_box_lua_widget.cells_list) do
        if o.object_Item ~= nil then
            local cell_object_id = o.object_Item.GetId().c_str()
            for j,obj in pairs(_link_table.link_objects) do
                if cell_object_id == obj then
                    if target_cell == nil then
                        target_cell = o
                    else 
                        table.insert(effect_cells_list, o)
                    end
                    break
                end
            end
        end
     end

    local new_parent_link_effect = objects_box_lua_widget.CreateParentLinkEffect()
    effect_time = new_parent_link_effect:Init(
		_link_table.final_object, _link_table.link_objects, target_cell, effect_cells_list, 
		objects_box_lua_widget.link_time, objects_box_lua_widget.link_effect_delay)
	objects_box_lua_widget.InsertEffect(new_parent_link_effect)

    sleep(effect_time)
    if objects_box_lua_widget.current_effect == new_parent_link_effect then
        objects_box_lua_widget.InsertEffect(nil)
    end


end

function objects_box_lua_widget.InsertEmptyCell()
        local new_cell = {}
        new_cell.width = objects_box_lua_widget.CellSize.X
        --new_cell.object = current_object.Get()
        new_cell.object_InventState = nil
        new_cell.object_Item = nil
        new_cell.dead = false
        new_cell.formed = false
        table.insert(objects_box_lua_widget.cells_list, new_cell)    
        objects_box_lua_widget.UpdateCellsPos()
        return new_cell
end

function objects_box_lua_widget.UpdateCells()
    objects_box_lua_widget.cells_list = {}
    if objects_box_lua_widget.objects_list ~= nil then
        local current_object = objects_box_lua_widget.objects_list.GetObjects()
        while not current_object.IsEnd() do
    
            local new_cell = {}
            
            --new_cell.object = current_object.Get()
            new_cell.object_InventState = qe.CSceneObjectPtrT(current_object.Get().InventState.get())
            new_cell.object_Item = qe.CBaseSceneObjectPtrT(current_object.Get().Item.get())
            new_cell.width = math.ceil( new_cell.object_InventState.GetSize().X / objects_box_lua_widget.CellSize.X )*objects_box_lua_widget.CellSize.X

            table.insert(objects_box_lua_widget.cells_list, new_cell)    
            current_object.Next()
        end
    end
	objects_box_lua_widget.UpdateCellsPos()
end



function objects_box_lua_widget.SetObjectsBox(_value)
    objects_box_lua_widget.objects_list = _value
    objects_box_lua_widget.UpdateCells()
end

objects_box_lua_widget.actions = objects_box_lua_widget.actions or {}
objects_box_lua_widget.actions.cancel = 
{
	pressed = function(_window) 
		_window.AddFlags(_window.FlagDead) 
	end
}

objects_box_lua_widget.mouse_pos = sf.misc.FloatVector(10, 10)
objects_box_lua_widget.mouse_in_window_flag = true

function objects_box_lua_widget.__CreateInstance()
    return "objects_box_lua_widget"
end

function objects_box_lua_widget.Show(_objects, _window)
end

function objects_box_lua_widget.ShowObjectsWithAlpha(_value)
    objects_box_lua_widget.show_objects_with_alpha = _value
end

function objects_box_lua_widget.DoDraw(_this, _renderer)

    objects_box_lua_widget.effects_list:PreDraw(_renderer)

    local size = _this.GetSize()
    local cell_index = 0 
    local first_visible_cell = objects_box_lua_widget.FirstVisibleCell
    local visible_cells_count = objects_box_lua_widget.VisibleCellsCount
    local cell_size = objects_box_lua_widget.CellSize
    for i,o in pairs(objects_box_lua_widget.cells_list) do
        if (first_visible_cell <= cell_index) and ((first_visible_cell + visible_cells_count) >cell_index) then
            if o.object_InventState ~= nil and  o.dead ~= true then
                local object_pos = o.object_InventState.get().GetPos()
                
                _renderer.PushState()
                _renderer.ApplyMatrix( sf.misc.MatrixTranslation(-object_pos.X + 1 + o.cell_offset + o.width/2, - object_pos.Y + cell_size.Y/2))
                if objects_box_lua_widget.show_objects_with_alpha then
                    local color = sf.graphics.Color(_renderer.GetColor())
                    color.Alpha = objects_box_lua_widget.show_objects_alpha
                    _renderer.SetColor(color)
                elseif objects_box_lua_widget.taked_object then
                    local a = o.object_Item.GetId().c_str()
                    if objects_box_lua_widget.taked_object == o.object_Item.GetId().c_str() then
                        local color = sf.graphics.Color(_renderer.GetColor())
                        color.Alpha = objects_box_lua_widget.taked_objects_alpha
                        _renderer.SetColor(color)
                    end
                end
                o.object_InventState.get().DrawGame(_renderer)
                _renderer.PopState()
            end
            --_renderer.RenderLine(sf.misc.FloatVector(o.cell_offset, 0 ), sf.misc.FloatVector(o.cell_offset + o.width, 70), 0xffffffff)

        end

        cell_index = cell_index + 1
    end

--[[
    if objects_box_lua_widget.effects_list ~= nil then
        local size = #(objects_box_lua_widget.effects_list)
        if size ~= 0 then
            for i = 1, size do
                objects_box_lua_widget.effects_list[i]:Draw(_renderer)
            end
        end
    end
]]
    if objects_box_lua_widget.current_effect ~= nil then
        objects_box_lua_widget.current_effect:Draw(_renderer)
    end

    objects_box_lua_widget.effects_list:PostDraw(_renderer)
	
    return true
end

function objects_box_lua_widget.UpdateCellsPos()
    offset = 0
    for i,o in pairs(objects_box_lua_widget.cells_list) do
        o.cell_offset = offset
        offset = offset + o.width
    end
end

function objects_box_lua_widget.DoUpdate(_this)
--[[
    if objects_box_lua_widget.effects_list ~= nil then
        local size = #(objects_box_lua_widget.effects_list)
        if size ~= 0 then
            local current_time = invent_timer.Get().GetTime()
            local i = 1
            while i <= size do
                objects_box_lua_widget.effects_list[i]:Update(current_time)
                if objects_box_lua_widget.effects_list[i].is_dead == true then
                    table.remove(objects_box_lua_widget.effects_list, i)
                    size = size - 1
                    i = i - 1
                end
                i = i + 1
            end
        end
    end
    ]]

    for i,o in pairs(objects_box_lua_widget.cells_list) do
        if o.object_InventState ~= nil then
            o.object_InventState.Update()
        end
    end

    if objects_box_lua_widget.current_effect ~= nil then
        local current_time = invent_timer.Get().GetTime()
        objects_box_lua_widget.current_effect:Update(current_time)

        if objects_box_lua_widget.current_effect.is_dead == true then
            objects_box_lua_widget.current_effect = nil
        end
    end

    objects_box_lua_widget.UpdateCellsPos()


    local frame_time = invent_timer.Get().GetFrameDelta()
    local size = #(objects_box_lua_widget.cells_list)
    if size ~= 0 then
        local i = 1
        while i <= size do
            if objects_box_lua_widget.cells_list[i].dead == true then
                local cell = objects_box_lua_widget.cells_list[i]
                if cell.width > 0 then
                    cell.width = cell.width - (objects_box_lua_widget.remove_speed * frame_time / 1000)
                else
                    table.remove(objects_box_lua_widget.cells_list, i)
                    size = size - 1
                    i = i - 1
                end
            end
            i = i + 1
        end
    end

    objects_box_lua_widget.effects_list:Update()

    return true
end

function objects_box_lua_widget.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return false --return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function objects_box_lua_widget.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast)
end

function objects_box_lua_widget.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end



function objects_box_lua_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)
    if not threads_managment.IsClikThread() then
        local widget_size = _this.GetSize()
        if (widget_size.X >= _pos.X) and (widget_size.Y >= _pos.Y) and _pos.Y > 0 and _pos.X > 0 then
            local is_object_click = nil
            local offset = 0
            for i,o in pairs(objects_box_lua_widget.cells_list) do

                if (_pos.X > offset) and (_pos.X < offset + o.width) then
                    if o.object_Item ~= nil then --and o.formed == false 
                        local object_id = o.object_Item.GetId().c_str()
                        if object_id ~= objects_box_lua_widget.taked_object then
                            quest.global_cursor.SetCursorObject(o.object_Item)
                            cursor_lua_widget.UpdateCursorsTable()
                            quest.global_scene_widget.RunIventoryClickScript(o.object_Item)     
                            is_object_click = o.object_Item
                            objects_box_lua_widget.taked_object = o.object_Item.GetId().c_str()
                        else
                            clear_cursor()
                        end
                        break
                    end
                end
                offset = offset + o.width
            end
            if is_object_click == nil then
                clear_cursor()
            else
                objects_box_lua_widget.mouse_down_info = {object = is_object_click, object_id = is_object_click.GetId().c_str(), pos = _pos}
                return true
            end

        end
    end
	return false
	

end

function objects_box_lua_widget.OnMouseMove(_this, _pos, _state, _broadcast)

    local widget_size = _this.GetSize()

	if (widget_size.X >= _pos.X) and (widget_size.Y >= _pos.Y) then
        local offset = 0
        
        for i,o in pairs(objects_box_lua_widget.cells_list) do

            if (_pos.X > offset) and (_pos.X < offset + o.width) then
                if o.object_Item ~= nil then
                    quest.global_played_level.UpdateFocusedObject(o.object_Item)
                    quest.global_played_level.UpdateHint(o.object_Item)
                    return true
                end
            end
            offset = offset + o.width
        end
    end

	return false
end

function objects_box_lua_widget.OnMouseUp(_this, _pos, _button, _state, _broadcast)
    if not threads_managment.IsClikThread() then
        local widget_size = _this.GetSize()
        if (widget_size.X >= _pos.X) and (widget_size.Y >= _pos.Y) and _pos.Y > 0 and _pos.X > 0 then
            if objects_box_lua_widget.mouse_down_info then
                objects_box_lua_widget.mouse_down_info = nil
                quest.global_cursor.SetIsDrag(false)
                return true
            end
        end
    end
	return true
end

function objects_box_lua_widget.OnDoubleClick(_this, _pos, _state, _broadcast)
	return false --return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function objects_box_lua_widget.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return false -- _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function objects_box_lua_widget.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = objects_box_lua_widget.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end

function objects_box_lua_widget.Load(_this, _info, _templates)
	local constants = quest.game_resources.GetChild("Constants", false)
	
	local invent_time = constants.GetChild("invent_time", false)
    objects_box_lua_widget.remove_time = tonumber(invent_time.GetChildByAttribute("time", "id", "remove_time", false).GetValue("value").c_str())
    objects_box_lua_widget.combo_time = tonumber(invent_time.GetChildByAttribute("time", "id", "combo_time", false).GetValue("value").c_str())
    objects_box_lua_widget.take_time = tonumber(invent_time.GetChildByAttribute("time", "id", "take_time", false).GetValue("value").c_str())

    objects_box_lua_widget.combo_speed = tonumber(invent_time.GetChildByAttribute("time", "id", "combo_speed", false).GetValue("value").c_str())
    objects_box_lua_widget.take_speed = tonumber(invent_time.GetChildByAttribute("time", "id", "take_speed", false).GetValue("value").c_str())
    objects_box_lua_widget.link_speed = tonumber(invent_time.GetChildByAttribute("time", "id", "link_speed", false).GetValue("value").c_str())

    objects_box_lua_widget.link_time = tonumber(invent_time.GetChildByAttribute("time", "id", "link_time", false).GetValue("value").c_str())
    objects_box_lua_widget.link_effect_delay = tonumber(invent_time.GetChildByAttribute("time", "id", "link_effect_delay", false).GetValue("value").c_str())
    objects_box_lua_widget.remove_speed = tonumber(invent_time.GetChildByAttribute("speed", "id", "remove_speed", false).GetValue("value").c_str())

	local inventory = constants.GetChild("inventory", false)
    local res = tonumber(inventory.GetValue("objects_alpha").c_str())
    if res then objects_box_lua_widget.show_objects_alpha = res end

    res = tonumber(inventory.GetValue("taked_objects_alpha").c_str())
    if res then objects_box_lua_widget.taked_objects_alpha = res end


    local cell_size_x = tonumber(inventory.GetValue("cell_size_x").c_str())

    local cell_size_y = tonumber(inventory.GetValue("cell_size_y").c_str())
    objects_box_lua_widget.CellSize = sf.misc.FloatVector(cell_size_x, cell_size_y)

    local drag_distance = tonumber(inventory.GetValue("drag_distance").c_str())
    if drag_distance then objects_box_lua_widget.drag_distance = drag_distance end
	
	objects_box_lua_widget.effects_list = visual_effects.CreateEffectsList()

    return true
end
