quest = quest or {}
quest = quest or {}

quest.const_say_arrow_offset = sf.misc.FloatVector(- 20, -7)

quest.const_say_arrow_face_offset = sf.misc.FloatVector( 100, 70 )

quest.global_level_box = qe.CObjectsBox()

quest.global_current_script_object = nil

quest.global_played_level = nil

quest.g_LuaVariables = {}

quest.global_current_main_scene = nil

quest.global_cursor = qe.g_Cursor.Instance()

quest.global_quest_window = nil

quest.global_scene_widget = nil

quest.global_show_areas_in_preview = false

quest.global_skip_windows_flag = false

quest.global_say_window_result = nil

quest.global_minigame_window_result = nil

quest.game_resources = nil

quest.global_say_momental_end_flag = nil

g_App = sf.core.g_Application

quest.level_timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")))

quest.script_time = nil

quest.g_SceneTrackMap = {}

quest.do_not_change_curosor = false

quest.global_modify_level_flag = nil

quest.enable_wrong_click = true

function quest.neutral_click()
    quest.global_modify_level_flag = true
end

function quest.GetModifyFlag()
    return quest.global_modify_level_flag
end

function quest.SetModifyFlag(_value)
    quest.global_modify_level_flag = _value
end

function quest.SetClickPos(_pos)
    quest.g_ClickPos = _pos
end

function quest.OnCloseScene(_scene_widget)
    _scene_widget.AddFlags(sf.gui.CBaseWidget.FlagDead)
end

function quest.OnOpenScene(_scene_widget)

end

function quest.OnOpenMinigame(minigame_widget)

end

function quest.LoadProjectConstants(_constants)

end

function LoadConstants()
	local constants = quest.game_resources.GetChild("Constants", false)
    quest.LoadProjectConstants(constants)


    local change_state = constants.GetChild("change_state", false)
    local res = string_to_bool_or_numeral(change_state.GetValue("def_change_type_bottom").c_str())
    if res ~= nil then states.use_bottom_change_state_default = res end
    res = string_to_bool_or_numeral(change_state.GetValue("def_change_state_time").c_str())
    if res ~= nil then states.change_effect_time = res end
    res = string_to_bool_or_numeral(change_state.GetValue("def_sleep_after_change_state").c_str())
    if res ~= nil then states.sleep_after_change_state = res end
    res = string_to_bool_or_numeral(change_state.GetValue("def_slep_on_hide_show").c_str())
    if res ~= nil then modifers.def_slep_on_hide_show = res end
    res = string_to_bool_or_numeral(change_state.GetValue("def_time_for_hide_show").c_str())
    if res ~= nil then modifers.def_time_for_hide_show = res end
    cursor_lua_widget.LoadConstants(constants)  
    child_scenes.LoadConstants(constants)  
	if tutorial then
	    tutorial.LoadConstants(constants)    
	end
    say_widget.LoadConstants(constants)
end

function quest.InitQuestWindow(_window)

end

function quest.UpdateHintGui()

end

 
--    
quest.g_Lua = sf.lua.CLua.GetLua("qe_level")
assert(quest.g_Lua)
quest.g_Lua.LoadScript("scripts/game_engine/misc.lua")
quest.g_Lua.LoadScript("scripts/game_engine/visual_effects.lua")
quest.g_Lua.LoadScript("scripts/game_engine/helpers.lua")
quest.g_Lua.LoadScript("scripts/game_engine/cursor_widget.lua")
quest.g_Lua.LoadScript("scripts/game_engine/objects_box_widget.lua")
quest.g_Lua.LoadScript("scripts/game_engine/hints_widget.lua")
quest.g_Lua.LoadScript("scripts/game_engine/say_dialog.lua")
quest.g_Lua.LoadScript("scripts/game_engine/tutorial_dialog.lua")
--quest.g_Lua.LoadScript("scripts/game_engine/shadow_widget.lua")
quest.g_Lua.LoadScript("scripts/game_engine/task.lua")
quest.g_Lua.LoadScript("scripts/game_engine/score.lua")
quest.g_Lua.LoadScript("scripts/game_engine/take_objects_list.lua")
quest.g_Lua.LoadScript("scripts/game_engine/level_hints.lua")
quest.g_Lua.LoadScript("scripts/game_engine/minigame/main.lua")


quest.g_Lua.LoadScript("scripts/game_engine/save_game.lua")
quest.g_Lua.LoadScript("scripts/game_engine/modifers.lua")
quest.g_Lua.LoadScript("scripts/game_engine/states.lua")
quest.g_Lua.LoadScript("scripts/game_engine/child_scenes.lua")
quest.g_Lua.LoadScript("scripts/game_engine/inventory.lua")
quest.g_Lua.LoadScript("scripts/game_engine/difficulty.lua")
quest.g_Lua.LoadScript("scripts/game_engine/avatar.lua")
quest.g_Lua.LoadScript("scripts/game_engine/dialogs.lua")
quest.g_Lua.LoadScript("scripts/game_engine/tutorial.lua")
quest.g_Lua.LoadScript("scripts/game_engine/background_sounds.lua")



function quest.show_object_find_error(_object, current_object)
    if not current_object then
        __message(" ".._object.."  ", "")
    end
end

function quest.RemoveObject(_id)
    local object = quest.find_object_by_id(_id, false, false)
    if object ~= nil then
        object.RaiseObjectFlag(qe.CBaseSceneObject.ObjectFlagRemoved)
    end
end

function quest.FindRootObjectById(_id, _find_reomved)
    return quest.find_object_by_id(_id, false, _find_reomved)
end

function quest.FindObjectById(_id, _find_reomved)
    return quest.find_object_by_id(_id, true, _find_reomved)
end

function quest.find_object_by_id(_id, _find_group_childs, _find_reomved)
    if not _find_group_childs then _find_group_childs = false end
    if not _find_reomved then _find_reomved = false end
	if not quest.global_played_level then 
		return nil 
	end
    return quest.global_played_level.FindObjectById(_id, _find_group_childs, _find_reomved) 
end

function quest.OnClose()
    return true
end

function quest.OnWrongClick(_pos)

end

function quest.SetDefaultWrongAction(_value)
    quest.enable_wrong_click = _value
end

function quest.WrongAction()
    score.wrong_action()
end

function wrong_click(_pos)
    if not _pos then
        _pos = quest.g_ClickPos
    end
    quest.OnWrongClick(_pos)
    if quest.enable_wrong_click then
        quest.WrongAction()
    end
end

function quest.GetHints()
    assert(false)
    return 0
end

function quest.SetHints(_value)
    assert(false)
end

function quest.GetHintsUseFlag()
    assert(false)
end

function quest.SetHintsUseFlag(_value)
    assert(false)
end

function quest.StartLevel(_window, _level, _start_scene_id, _game_resources, _load_file_name, _track, _go_silence)
        if not g_MusicTable then
            g_MusicTable = {}
        end
        
        quest.g_LuaVariables = {}
        
        quest.start_track = g_MusicTable[1]
        quest.go_silence = g_GoSilenceInEndLevel
        
		qe.CSceneWidget.ClearScriptCache()
		qe.g_EffectsList.Instance().Clear()
		
        local main_scene_id = _start_scene_id
        quest.game_resources = _game_resources
        LoadConstants()

        local current_scene = _level.GetScenes()
        local index = 1
        g_SceneTrackMap = {}
        while not current_scene.IsEnd() do 
            local in_window_flag = current_scene.Get().ReadFlag(qe.CScene.FlagSceneInNewWindow)
            if not in_window_flag then
                if g_MusicTable[index] then
                    g_SceneTrackMap[current_scene.Get().GetId().c_str()] = g_MusicTable[index]
                    index = index + 1 
                else
                    g_SceneTrackMap[current_scene.Get().GetId().c_str()] = ""
                end
            end
            current_scene.Next()
            
        end
         
        quest.global_played_level = _level

        
        quest.global_played_level.SetShowChildSceneAreas(quest.global_show_areas_in_preview)

        quest.global_level_box.Clear()
		
		assert(quest.game_resources.GetChild("GUI", false).GetChildByAttributeRef("window", "id", "quest_window", true))
		
        local dialog = sf.gui.CWindow()
        dialog.Load(quest.game_resources.GetChild("GUI", false).GetChildByAttribute("window", "id", "quest_window", true),
            quest.game_resources.GetChild("GUITemplates", false))

        quest.global_quest_window = sf.gui.CBaseWindowPtrT(dialog)

        quest.InitQuestWindow(quest.global_quest_window)
        score.InitScore(quest.game_resources)
        difficulty.InitDifLevel(quest.global_quest_window, quest.game_resources)
        
        objects_box_lua_widget.SetObjectsBox(quest.global_level_box)
        objects_box_lua_widget.self = get_child_widget(dialog, "main_object_box_widget", sf.gui.CLuaWidget)      
        objects_box_lua_widget.abs_pos = objects_box_lua_widget.self.GetAbsPos(true)

		--      
		local full_screen_solve_button = get_child_widget(quest.global_quest_window, "full_screen_minigame_solve_button", sf.gui.CButtonWidget)
		if full_screen_solve_button then
			set_widget_flag_value(full_screen_solve_button, sf.gui.CBaseWidget.FlagHidden, true)  
			set_widget_flag_value(full_screen_solve_button, sf.gui.CBaseWidget.FlagDisabled, true)  
		end
		local full_screen_end_button = get_child_widget(quest.global_quest_window, "full_screen_minigame_exit_button", sf.gui.CButtonWidget)
		if full_screen_end_button then
			set_widget_flag_value(full_screen_end_button, sf.gui.CBaseWidget.FlagHidden, true)  
			set_widget_flag_value(full_screen_end_button, sf.gui.CBaseWidget.FlagDisabled, true)  
		end
		--   
		local full_screen_minigame_description = get_child_widget(quest.global_quest_window, "full_screen_minigame_description", sf.gui.CLabelWidget)
		if full_screen_minigame_description then
			set_widget_flag_value(full_screen_minigame_description, sf.gui.CBaseWidget.FlagHidden, true)  
			set_widget_flag_value(full_screen_minigame_description, sf.gui.CBaseWidget.FlagDisabled, true)  
		end
		
        quest.global_scene_widget = get_child_widget(dialog, "main_scene_widget", qe.CSceneWidget)      
        hints_lua_widget.self = get_child_widget(dialog, "hints_widget", sf.gui.CLuaWidget)
        quest.say_lua_widget = get_child_widget(dialog, "say_lua_widget", sf.gui.CLuaWidget)
        quest.tutorial_lua_widget = get_child_widget(dialog, "tutorial_lua_widget", sf.gui.CLuaWidget)
        
        local local_dialogs_back_widget = get_child_widget(dialog, "dialogs_back_widget", sf.gui.CLuaWidget)
        if local_dialogs_back_widget then
            set_widget_flag_value(local_dialogs_back_widget, sf.gui.CBaseWidget.FlagHidden, true)
            set_widget_flag_value(local_dialogs_back_widget, sf.gui.CBaseWidget.FlagDisabled, true)
        end
        
        local local_dialog_widget = get_child_widget(dialog, "dialog_lua_widget", sf.gui.CLuaWidget)        
        if local_dialog_widget then
            dialog_widget.Init(local_dialog_widget, local_dialogs_back_widget)
            dialog_widget.Show(false)
        end

       
        say_widget.ShowSay(false)
        tutorial_widget.Show(false)
        
        score_lua_widget.score_label_widget = get_child_widget(dialog, "score_label", sf.gui.CLabelWidget)

        if not score_lua_widget.score_label_widget then
            __message("  score_label    ", "")
        end

        score_lua_widget.Init(score.GetBars(), score.GetScore(), score.GetAlphaBars())


        --  ,   ,    ,  
        quest.global_played_level.RunLevelScript()

        --      
        say_widget.init_common_table()

        --    ,   ,   
        if _load_file_name.c_str() ~= "" then
            local new_scene_id = save_game.Load(_load_file_name)
            if new_scene_id then
                main_scene_id = new_scene_id
                if g_SceneTrackMap[main_scene_id.c_str()] then
                    quest.start_track = g_SceneTrackMap[main_scene_id.c_str()]
                end
            end
        end

        task_list.begin_task_update = true
        tasks_lua_widget.UpdateTasksLabels()
        local cloned_scene = quest.global_played_level.GetSceneById(main_scene_id)
        quest.global_current_main_scene = cloned_scene

		if not quest.global_current_main_scene.ReadFlag(qe.CScene.FlagSceneInNewWindow) then
		    level_hints.Init()
        end


        -- 
        local scene_widget_offset = cloned_scene.GetOffset() 
        quest.global_scene_widget.SetOffset(scene_widget_offset.X, scene_widget_offset.Y)
        quest.global_scene_widget.SetScene(cloned_scene)
        local scene_widget_size = quest.global_scene_widget.GetSize()


        --shadow_widget.Create(quest.global_scene_widget) 
        
        quest.global_cursor.SetWorkAreaSize(quest.global_scene_widget.GetSize())
        quest.global_cursor.SetWorkAreaOffset(quest.global_scene_widget.GetOffset())
        quest.global_cursor.ClearCursor(true)

        dialog.UpdateLayout()

        local cursor_widget = get_child_widget(dialog, "cursor_lua_widget", sf.gui.CLuaWidget)
        cursor_widget.SetSize(1024, 768)
        cursor_widget.SetOffset(0, 0)


        scene_click_widget.self = get_child_widget(dialog, "scene_click_widget", sf.gui.CLuaWidget)
        if scene_click_widget.self then
            scene_click_widget.self.SetSize(scene_widget_size.X, scene_widget_size.Y)
            scene_click_widget.self.SetOffset(scene_widget_offset.X, scene_widget_offset.Y)
            scene_click_widget.Enable(true)
        else
            __message("  scene_click_widget", "")
        end
        objects_box_lua_widget.UpdateCells()

		quest.OnLevelChanged()

        --               
        if _load_file_name.c_str() == "" then
            quest.global_played_level.RunStartLevelScript()
        end
		if quest.global_current_main_scene.RunSceneScript then
			quest.global_current_main_scene.RunSceneScript()
		end

        difficulty.ApplyDifLevel()

        quest.OnStartLevel()
        
        local res = __cast(_window, sf.gui.CBaseWindow).DoModal(sf.gui.CBaseWindowPtrT(dialog))
        return res
end

function quest.ChangeAreaView(_value)
    local new_value = not quest.global_show_areas_in_preview
    if _value ~= nil then
        new_value = _value
    end
    quest.global_show_areas_in_preview = new_value
    if quest.global_played_level ~= nil then
        quest.global_played_level.SetShowChildSceneAreas(quest.global_show_areas_in_preview)
    end
end

function quest.SetScriptObject(_object)
    quest.global_current_script_object = _object
end

function quest.GetScriptObject()
    return quest.global_current_script_object
end

function take_hint(_object, _do_not_assert)
    local current_object = quest.global_current_script_object 
    if   _object ~= nil then
        current_object = quest.FindRootObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end

    end
    if current_object ~= nil    then
        hints_lua_widget.take_hint(current_object)
        add_score("take_hint_type", 1)
    end
end


function hint_to_object(_object, _restore_hint)
    if not threads_managment.IsClikThread() then
        local hints_count =  quest.GetHints()
        if hints_count >= hints_lua_widget.working_hints_count then
            if not _restore_hint then 
                quest.SetHints(0) 
            end
            quest.SetHintsUseCount( quest.GetHintsUseCount() + 1 )
            quest.SetHintsUseFlag(1)
            local current_object = quest.global_current_script_object 
            if _object ~= nil then
                --     
                local current_scene = quest.global_played_level.GetScenes()
                while not current_scene.IsEnd() do
                    if quest.get_scene_widget(current_scene.Get().GetId().c_str()) then
                        current_object = current_scene.Get().FindObjectById(_object, false, false)
                        if current_object then
                            break
                        end
                    end
                    current_scene.Next()
                end
            end
            if current_object ~= nil    then
				hints_lua_widget.hint_to_object(current_object)
            end
        end
    end
end


function cursor(_object, _state)
    local cursor_object = quest.global_cursor.GetCursorObject()
    if  _object == nil then
        if cursor_object == nil then
            return true
        end
        return false
    else
        if cursor_object ~= nil then
            local cursor_object_id = cursor_object.GetId().c_str()
            if cursor_object_id == _object then
                if _state == nil then
                    return true
                else
                    local cursor_group = __cast(cursor_object, qe.CSceneGroup)
                    if cursor_group.IsCurrent(_state) then
                        return true
                    end
                    return false
                end         
            end
        end
        return false
    end
end

function clear_cursor()
    if not quest.do_not_change_cursor_flag then
	   quest.global_cursor.ClearCursor(false) 
	   cursor_lua_widget.UpdateCursorsTable()
	   objects_box_lua_widget.taked_object = nil
	   --         
	   cursor_lua_widget.ApplyObjectToCursor()
    end
end


function sound(_id, _delay)
    if _id ~= nil then
        sf.core.g_Application.GetAudioManager().Play(_id, -2, -2, -2, -2, -2);
        if _delay ~= nil and _delay == true then
            local time = sf.core.g_Application.GetAudioManager().GetLength(_id)
            if time ~= nil then
                sleep(time)            
            end
        end
    end
end

function stop_sound(_id, _fade_time)
    __assert(_id)
    if not _fade_time then _fade_time = 0 end
    sf.core.g_Application.GetAudioManager().Stop(_id, _fade_time)
end

--    
function quest.OnStartLevel()

end

function quest.OnCompleteLevel()
    assert(false)
end

function complete_level()
    quest.global_modify_level_flag = true 
    quest.OnCompleteLevel()
end

function random(...)
    return math.random(...)
end

function pre_click_event()
	quest.do_not_change_cursor_flag = false --      
	cursor_lua_widget.SetCursorsTable({})
	threads_managment.global_curent_click_thread = GetCurrentCoroutine()
end

function post_click_event()
	threads_managment.global_curent_click_thread = nil 
	commit_score()
	quest.OnLevelChanged()
    if quest.global_say_momental_end_flag then
        quest.global_say_momental_end_flag = false
        if say_widget.click_result then
            if quest.global_scene_widget then
                if say_widget.click_result.type == "up" then
                    __cast(quest.global_scene_widget, sf.gui.CWidget).GetParentWidget().OnMouseUp(say_widget.click_result[1], say_widget.click_result[2], say_widget.click_result[3], say_widget.click_result[4])
                else
                    __cast(quest.global_scene_widget, sf.gui.CWidget).GetParentWidget().OnMouseDown(say_widget.click_result[1], say_widget.click_result[2], say_widget.click_result[3], say_widget.click_result[4])
                    if say_widget.click_result then
                        __cast(objects_box_lua_widget.self, sf.gui.CWidget).GetParentWidget().OnMouseDown(say_widget.click_result[1] - objects_box_lua_widget.abs_pos, say_widget.click_result[2], say_widget.click_result[3], say_widget.click_result[4])
                    end
                end
            end
            say_widget.click_result = nil
        end
    end
end

function quest.get_scene_widget(_id)
    local target_widget = nil
    if _id ~= nil then
        if quest.global_scene_widget.GetSceneId().c_str() == _id then
            target_widget = quest.global_scene_widget
        else
            local current_widget = quest.global_scene_widget.GetWidgets()
            while not current_widget.IsEnd() do
                local scene_widget = __cast(current_widget.Get(), qe.CSceneWidget)     
                if scene_widget ~= nil then
                    if scene_widget.GetSceneId().c_str() == _id then
                        target_widget = scene_widget
                        break
                    end
                end
                current_widget.Next()
            end            
        end
    end
    return target_widget
end

function quest.is_hide(_object, _do_not_assert)
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        return current_object.ReadObjectFlag(qe.CBaseSceneObject.ObjectFlagHidden)
    else
        return false
    end
end

function quest.is_disable(_object, _do_not_assert)
    if _object ~= nil then
        current_object = quest.FindObjectById(_object)
        if not _do_not_assert then        
            quest.show_object_find_error(_object, current_object)
        end
    end
    if current_object then
        return current_object.ReadObjectFlag(qe.CBaseSceneObject.ObjectFlagDisable)
    else
        return false
    end
end

function quest.get_object_pos(_id)
    local scene_widget = nil
    local object_pos = sf.misc.FloatVector(0, 0)
    local current_scene = quest.global_played_level.GetScenes()
    local scene_id =""
    while not current_scene.IsEnd() do 
        scene_widget = quest.get_scene_widget(current_scene.Get().GetId().c_str())
        --      
        if scene_widget then
            local taked_object = current_scene.Get().IsContentObject(_id)
            if taked_object ~= nil then
                object_pos = taked_object.GetPos()
                scene_id = current_scene.Get().GetId().c_str()
                break
            end
            local taked_area = current_scene.Get().IsContentArea(_id)
            if taked_area ~= nil then
                object_pos = taked_area.GetPos()
                scene_id = current_scene.Get().GetId().c_str()
                break
            end
        end
        current_scene.Next()
    end

    if scene_widget~= nil then
        local res_widget_pos = scene_widget.GetAbsPos(false) + object_pos
        return res_widget_pos, scene_id
    end
    return nil
end

function quest.OnLevelChanged()
	take_objects_list.UpdateObjects()
	cursor_lua_widget.UpdateCursorsTable()
end

function quest.change_dif_level()
end

say = say_widget.say
pre_say = say_widget.pre_say
show_tutorial = say_widget.show_tutorial
hide_tutorial = say_widget.hide_tutorial


unite_objects = inventory.unite_objects
form_object_form_parts = inventory.form_object_form_parts


hide = modifers.hide
show = modifers.show

show_ex = modifers.show_ex
hide_ex = modifers.hide_ex
disable = modifers.disable
enable = modifers.enable
change_hint = modifers.change_hint
play_clip = modifers.play_clip


is_light_on = states.is_light_on
turn_light = states.turn_light
change_state = states.change_state
state = states.state

change_invent_state = inventory.change_invent_state
change_invent_state_by_id = inventory.change_invent_state_by_id
is_object_in_inventory = inventory.is_object_in_inventory
move_to_scene = inventory.move_to_scene
take = inventory.take

show_scene = child_scenes.show_scene
close_scene = child_scenes.close_scene
minigame = child_scenes.minigame
full_screen_minigame = child_scenes.full_screen_minigame

sleep = threads_managment.sleep
form_event = threads_managment.form_event

is_object_on_level = inventory.is_object_on_level
remove = inventory.remove

add_say = say_widget.add_say
safety_say = say_widget.safety_say
form_start_dialog_event = threads_managment.form_start_dialog_event

change_state_ex = states.change_state_ex


init_dialog = dialog_widget.init_dialog
add_dialog_say = dialog_widget.add_dialog_say
start_dialog = dialog_widget.start_dialog

neutral_click = quest.neutral_click

add_score = score.add_score

is_hide = quest.is_hide

is_disable = quest.is_disable
change_avatar = avatar_widget.change_avatar
change_avatar_state = avatar_widget.ChangeState

disable_hint_tutorial = hints_lua_widget.disable_hint_tutorial

set_userdata = modifers.set_user_data
get_userdata = modifers.get_user_data

change_color = modifers.change_color

is_easy_difficulty = difficulty.IsEasyDifficulty

--         
do_not_change_cursor = cursor_lua_widget.DoNotChangeCursor

--    ,        
take_to_cursor = cursor_lua_widget.TakeToCursor


--AHTUNG !!       
IsClikThread = threads_managment.IsClikThread


load_lua_scripts('scripts/game/')
--  ,         

__g_InitScript()

