score = score or {}

---score.gloabl_incorrect_click_count = 0

---score.const_gloabl_max_incorrect_click_count = 3

score.const_global_max_bars_count = 15

score.grade_div_image_id = ""

score_lua_widget = score_lua_widget or {}

score_lua_widget.bar_width = 10

score_lua_widget.bars_offset = sf.misc.FloatVector(10, 10)
score_lua_widget.labels_offset = sf.misc.FloatVector(10, 10)
score_lua_widget.font_id = "font_12"
score_lua_widget.labels_color = sf.graphics.Color(255, 255, 255, 255)

score_lua_widget.last_dead_bar_width = 50

score_lua_widget.score_width = 50

score_lua_widget.ctrl_1_rand = 100
score_lua_widget.ctrl_2_rand = 100
score_lua_widget.ctrl_1 = sf.misc.FloatVector(300, 300)
score_lua_widget.ctrl_2 = sf.misc.FloatVector(900, 230)

score.alpha_bar_fill_time = 300
score.alpha_bar_decrease_time = 150
score.alpha_bar_decrease_part = 0.12
score.one_bar_fill_time_in_full_temp = 3 -- lol
score.alpha_bar_image_color = sf.graphics.Color(100, 255, 255, 255)

score.bar_fill_time = 150
score.bar_empty_time = 600
score.bar_empty_effect_time = 600
score.bar_color_effect_time = 600
score.bar_color_effect_max_alpha = 200

score.blink_time = 200
score.blink_max_alpha = 200

score.score_go_up_time = 3200
score.score_go_up_alt = 50
score.score_go_up_offset = sf.misc.FloatVector(0, -20)
score.score_go_up_font_id = "font_12"
score.score_go_up_font = g_App.GetResourceManager().GetFont(score_lua_widget.font_id)
score.score_text_border_offset = 5


score_lua_widget.go_on_size_down_time = 300
score_lua_widget.go_on_size_up_time = 300
score_lua_widget.go_off_time = 300
score_lua_widget.go_on_max_scale = 1.5


score_lua_widget.mul_on_def_image = "gui_game_gui_lable01_on"
score_lua_widget.mul_off_def_image = "gui_game_gui_lable01_off"


score_lua_widget.score_pos = sf.misc.FloatVector(500, 500)

score_lua_widget.grade_offset = sf.misc.FloatVector(0, 0)

score_lua_widget.grade_traget_size = sf.misc.FloatVector(785, 17)

function score_lua_widget.BezierFlyFunction( _start_pos, _end_pos, _ctrl_1, _ctrl_2, t)
	local t1 = (1-t)*(1-t)*(1-t)
    local t2 = 3*(1-t)*(1-t)*t 
    local t3 = 3*(1-t)*t*t 
    local t4 = t*t*t
	local x = t1*_start_pos.X + t2*_ctrl_1.X + t3*_ctrl_2.X + t4*_end_pos.X
	local y = t1*_start_pos.Y + t2*_ctrl_1.Y + t3*_ctrl_2.Y + t4*_end_pos.Y
    return sf.misc.FloatVector(x, y)
end

function score_lua_widget.LinkFlyFunction( _start_pos, _end_pos, _t)
    local current_pos =  _start_pos + (_end_pos - _start_pos)*_t
    current_pos.Y = current_pos.Y + math.sin( _t * 3.1415)*100
    return current_pos
end


score.score_table = 
{
    take_type = {enabled = true, count = 0 },
    minigame_type = {enabled = true, count = 0},
    take_hint_type = {enabled = true, count = 0},
    remove_type = {enabled = true, count = 0}
}
--[[
function drop_incorect_click()
    score.gloabl_incorrect_click_count = 0
end

function add_incorect_click()
    score.gloabl_incorrect_click_count = score.gloabl_incorrect_click_count + 1
    if score.gloabl_incorrect_click_count >= score.const_gloabl_max_incorrect_click_count then
        score.CalculateScore()
        score.gloabl_incorrect_click_count = 0
        avatar_widget.ChangeState("sad")
    end
end
]]


function score.wrong_action()
	--     
	if score_lua_widget._turn_off_score then return end
	if score_lua_widget.bars_count > 0 then
        local new_alpha_bars_count = score_lua_widget.alpha_bars_count + score_lua_widget.bars_count*score.alpha_bar_decrease_part
        if new_alpha_bars_count >= score_lua_widget.bars_count then
            new_alpha_bars_count = score_lua_widget.bars_count
            score_lua_widget.SetAlphaBars(new_alpha_bars_count)
            score.CalculateScore()
            score_lua_widget.alpha_bars_count = 0
            avatar_widget.ChangeState("sad")
        else
            score_lua_widget.SetAlphaBars(new_alpha_bars_count)
        end
    end
    score.SetAlphaBars(score_lua_widget.alpha_bars_count)
end

function score.add_score(_type, _value)
	--     
	if score_lua_widget._turn_off_score then return end
	tutorial.last_correct_action_time = tutorial.tutorial_timer.Get().GetTime()
    hints_lua_widget.show_hint_tutorial = nil

    if score.score_table[_type] then
        if score.score_table[_type].enabled == true then
            score.score_table[_type].count = score.score_table[_type].count + _value
            ---drop_incorect_click()
        end
    else
        sf.misc.MesageBox("    ".._type , "  ", 0)
    end
end

function disable_score_type(_type, _value)
    if score.score_table[_type] then
        score.score_table[_type].enabled = _value
    else
        sf.misc.MesageBox("    ".._type , "   ", 0)
    end
end

function score.drop_positiv_actions_count()
    score.drop_positiv_actions_count = 0
end

function score.default_get_new_bars_count(_score_table) -- 
    local res = 0
    local res_points = 0
    for i,o in pairs(_score_table) do
      if o.enabled == true then
          res = res + o.count
          if o.count > 0 then
            res_points = 100
          end
      end
    end
    return res, res_points
end

score.get_new_bars_count = score.default_get_new_bars_count


function commit_score()
	--     
	if score_lua_widget._turn_off_score then return end
	local total_new_bars, total_new_points = score.get_new_bars_count(score.score_table)

    for i,o in pairs(score.score_table) do
        o.count = 0
    end
    if total_new_bars > 0 or total_new_points > 0 then
        if score_lua_widget.alpha_bars_count > 0 then
            score_lua_widget.SetAlphaBars(0)
        end
        --score_lua_widget.alpha_bars_count = 0
        --score_lua_widget.set_grade_width(score_lua_widget.bars_count, score_lua_widget.alpha_bars_count)

        sound("add_points")
        ---scene_click_widget.DropClicks()
        ---drop_incorect_click()
        avatar_widget.ChangeState("happy")
        score.AddBars(total_new_bars, total_new_points)
        hints_lua_widget.HideHint()
    end
end

function score.AddBars(_value, _value_points)
    local current_bars = score.GetBars()
    if current_bars < score.const_global_max_bars_count then
        local new_bars_value = current_bars + _value
        if new_bars_value > score.const_global_max_bars_count then
            new_bars_value = score.const_global_max_bars_count
        end
        score.SetBars(new_bars_value)
        score_lua_widget.SetVisualBars(new_bars_value)
    end
    local new_current_bars = score.GetBars()
    local new_points = 0
    local mul_koef = 1
    if _value_points > 0 then
        mul_koef = score.GetMulKkoefByBars(new_current_bars)
        new_points = _value_points* mul_koef
        score.SetScore(score.GetScore() + new_points)
        score_lua_widget.VisualSetScore(score.GetScore(),_value_points, mul_koef )
    end
--[[

    local new_bars_value = current_bars + _value
    local score_increment = 0
    if new_bars_value >= score.const_global_max_bars_count then
        score_increment = score.CalculateBarsFormula(score.const_global_max_bars_count)
        new_bars_value = new_bars_value - score.const_global_max_bars_count
    end
    
    if score_increment > 0 then
        score_lua_widget.SetVisualBars(score.const_global_max_bars_count)
        score_lua_widget.VisualCalculateBars(score.GetScore() + score_increment)
    end
    score.SetBars(new_bars_value)
]]
    
end

function score.CalculateScore()
    local current_bars = score.GetBars()
    if current_bars > 0 then
        sound("converting_points")
        --score_increment = score.CalculateBarsFormula(current_bars)
        score_lua_widget.VisualCalculateBars(0)
        score.SetBars(0)
        --score.SetScore(score.GetScore() + score_increment)
    end
end

local bars_multiply_table = 
{
    {count = 2, koef = 2},
    {count = 5, koef = 3},
    {count = 9, koef = 5},
    {count = 15, koef = 10}
}

function score.GetMulKkoefByBars(_bars_count)
    local mul_type = nil
    local max_count = 0
    for i,o in ipairs(bars_multiply_table) do
        if max_count < o.count then
            if _bars_count >= o.count then  
                mul_type = o
                max_count = o.count
            end
        end
    end  
    if mul_type then
        return mul_type.koef
    else
        return 1
    end
end

--[[
function score.CalculateBarsFormula(_bars_count)
    local mul_type = nil
    local max_count = 0
    for i,o in ipairs(bars_multiply_table) do
        if max_count < o.count then
            if _bars_count >= o.count then  
                mul_type = o
                max_count = o.count
            end
        end
    end  
    if mul_type then
        return mul_type.count*mul_type.koef*500 + (_bars_count-mul_type.count) * 500
    else
        return _bars_count * 500
    end
end
]]

function score.InitScore(_game_resources)
end

function score.GetBars()
    __assert(_value, "score.GetBars()  ")
end

function score.SetBars(_value)
    __assert(_value, "score.SetBars()  ")
end

function score.GetAlphaBars()
    __assert(_value, "score.GetAlphaBars()  ")
end

function score.SetAlphaBars(_value)
    __assert(_value, "score.SetAlphaBars()  ")
end

function score.GetScore()
    __assert(_value, "score.GetScore()  ")
end

function score.SetScore(_value)
    __assert(_value, "score.SetScore()  ")
end


score_lua_widget.bars_count = 0
score_lua_widget.alpha_bars_count = 0
score_lua_widget.enable_alpha_decres = true

score_lua_widget.score_count = 0


__inherite(score_lua_widget, null_lua_widget_handler())

score_lua_widget.score_timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")).AttachTimer(_T("")))

function score_lua_widget.Calculate(_value)

end

function score_lua_widget.__CreateInstance()
    return "score_lua_widget"
end

function score_lua_widget.set_grade_width(visaul_bars_count, alpha_bars_count)
    if not alpha_bars_count then
        alpha_bars_count = 0
    end
    if alpha_bars_count > visaul_bars_count then
        alpha_bars_count = visaul_bars_count
    end
    local koef = visaul_bars_count/score.const_global_max_bars_count
    if koef == 0 then
        koef = 0.0001
    end

    local vbc_koef = (visaul_bars_count - alpha_bars_count)/score.const_global_max_bars_count
    if vbc_koef == 0 then
        vbc_koef = 0.0002
    end
	
	local target_size_x = (score_lua_widget.grade_traget_size.X-score_lua_widget.last_dead_bar_width)
	local image_size_x = (score_lua_widget.grade_image_size.X-score_lua_widget.last_dead_bar_width)
	
    score_lua_widget.grade_image.SetRect(sf.misc.FloatRect(0, 0, target_size_x*vbc_koef, score_lua_widget.grade_traget_size.Y) ) 
    score_lua_widget.grade_image.SetSourceRect(sf.misc.FloatRect(0, 0, image_size_x*vbc_koef, score_lua_widget.grade_image_size.Y) )       
    local rect_size = target_size_x*koef - target_size_x*vbc_koef
    if rect_size == 0 then
        rect_size = 0.0001
    end
    local source_rect_size = target_size_x*koef - target_size_x*vbc_koef
    if source_rect_size == 0 then
        source_rect_size = 0.0001
    end

    score_lua_widget.grade_image_alpha.SetRect(sf.misc.FloatRect( target_size_x*vbc_koef, 0, rect_size, score_lua_widget.grade_traget_size.Y) ) 
    score_lua_widget.grade_image_alpha.SetSourceRect(sf.misc.FloatRect(image_size_x*vbc_koef, 0, source_rect_size, score_lua_widget.grade_image_size.Y) )       



    score_lua_widget.grade_image_white.SetRect(sf.misc.FloatRect(0, 0, target_size_x*koef, score_lua_widget.grade_traget_size.Y) ) 
    score_lua_widget.grade_image_white.SetSourceRect(sf.misc.FloatRect(0, 0, image_size_x*koef, score_lua_widget.grade_image_size.Y) )       
    return target_size_x*koef
end

function score_lua_widget.set_white_grade_color(_color)
    if _color then
        score_lua_widget.grade_image_white.SetColor(_color) 
    end
end


function score_lua_widget.set_grade_color(_color)
    if _color then
        score_lua_widget.grade_image.SetColor(_color) 
    end
end

function score_lua_widget.set_alpha_grade_color(_color)
    if _color then
        score_lua_widget.grade_image_alpha.SetColor(_color) 
    end
end


function random_pos_in_radius(_pos, _radius)
    local c1_r = math.random(0, _radius)
    local c1_a = math.random(0, 360)
    return sf.misc.FloatVector(_pos.X + math.cos(c1_a)*c1_r, _pos.Y + math.sin(c1_a)*c1_r)
end

function score_lua_widget.CreateCalcBarsEffect()
    local new_child_effect = 
    {
        Init = function(_self, _start_bars_count, _score, _alpha_bars)

            --_self._alpha_bars_count = _alpha_bars
            --_self._start_bars_count = _start_bars_count
            --_self._end_bars_count = 0
            --_self._final_score = _score
        end,

        Start = function(_self, _start_time)
            _self.start_time = _start_time
            _self.total_time = score.bar_color_effect_time --+  --math.abs(_self._end_bars_count - _self._start_bars_count) * 100
            _self.state = 1 --   
            _self.alpha_color = sf.graphics.Color(score.alpha_bar_image_color)
            _self.start_alpha_value = score.alpha_bar_image_color.Alpha
            --_self.end_time = _self.start_time + _self.total_time
--[[
            _self._effects_table = {}
            for i = 1, _self._start_bars_count do
            

                local new_effect = {}
                new_effect["start_pos"] = sf.misc.FloatVector(score_lua_widget.bars_offset.X + i * score_lua_widget.bar_width - score_lua_widget.bar_width/2, score_lua_widget.bars_offset.Y)
                --score_lua_widget.visual_effects_list:CreateInstantEffect("NewHint", new_effect["start_pos"])        

                new_effect["visual"] = score_lua_widget.visual_effects_list:CreateEffect("CalcEffectFly", new_effect["start_pos"])             
--                new_effect["ctrl_1"] = sf.misc.FloatVector(score_lua_widget.ctrl_1.X - score_lua_widget.ctrl_1_rand/2 + math.random(0, score_lua_widget.ctrl_1_rand), score_lua_widget.ctrl_1.Y - score_lua_widget.ctrl_1_rand/2 + math.random(0, score_lua_widget.ctrl_1_rand))
--                new_effect["ctrl_2"] = sf.misc.FloatVector(score_lua_widget.ctrl_2.X - score_lua_widget.ctrl_2_rand/2 + math.random(0, score_lua_widget.ctrl_2_rand), score_lua_widget.ctrl_2.Y - score_lua_widget.ctrl_2_rand/2 + math.random(0, score_lua_widget.ctrl_2_rand))
                new_effect["ctrl_1"] = random_pos_in_radius(score_lua_widget.ctrl_1, score_lua_widget.ctrl_1_rand)
                new_effect["ctrl_2"] = random_pos_in_radius(score_lua_widget.ctrl_2, score_lua_widget.ctrl_2_rand)

                if _self._start_bars_count-1 <= 0 then
                    new_effect["end_pos"] = score_lua_widget.score_pos
                else
                    new_effect["ctrl_1"]. X = score_lua_widget.ctrl_1.X  - score_lua_widget.ctrl_1_rand/2 + score_lua_widget.ctrl_1_rand*((i-1)/(_self._start_bars_count-1))
                    new_effect["end_pos"] = sf.misc.FloatVector(score_lua_widget.score_pos.X - score_lua_widget.score_width/2 + score_lua_widget.score_width*((i-1)/(_self._start_bars_count-1)), score_lua_widget.score_pos.Y)
                end

                table.insert(_self._effects_table, new_effect)
            end
]]
                    for j,obj in pairs(bars_multiply_table) do
                        if  obj.state == 2 then
                            local new_effect = score_lua_widget.CreateMulEffectGoOff()
                            new_effect:Init(_start_time, obj)
                            obj._effect = new_effect
                        end
                    end


        end,

        GetType = function(_self)
            return  2 
        end,

        Draw = function(_self, _renderer)

        end,

        Update = function(_self, _time)
            local koef = (_time - _self.start_time)/_self.total_time
            if koef >= 1 then
                koef = 1
            end
            if _self.state == 1 then
                score_lua_widget.set_white_grade_color(sf.graphics.Color(score.bar_color_effect_max_alpha*koef, 255, 255, 255))
                _self.alpha_color.Alpha = _self.start_alpha_value * (1 - koef)

                score_lua_widget.set_alpha_grade_color(_self.alpha_color)
                score_lua_widget.set_grade_color(_self.alpha_color)



                if koef == 1 then

                    _self.state = 2
                    _self.start_time = _time
                    _self.total_time = score.bar_empty_effect_time
                end
            elseif _self.state == 2 then
                score_lua_widget.set_white_grade_color(sf.graphics.Color(score.bar_color_effect_max_alpha*(1 - koef), 255, 255, 255))
                if koef == 1 then
                    _self._effect_finished = true
                    score_lua_widget.set_alpha_grade_color(score.alpha_bar_image_color)
                    score_lua_widget.set_grade_color(sf.graphics.Color(255, 255, 255, 255))
                    score_lua_widget.set_grade_width(0, 0)
                end
            end
--[[
--            for i,o in pairs(_self._effects_table) do
  --              o["visual"]:SetPos(score_lua_widget.BezierFlyFunction( o["start_pos"], o["end_pos"], o["ctrl_1"], o["ctrl_2"], koef))
    --        end


            if not _self.empty_finished then
                local alpha_koef = (_time - _self.start_time)/score.bar_empty_time
                if alpha_koef > 1 then
                    alpha_koef = 1
                end
                local visaul_bars_count = _self._start_bars_count + (_self._end_bars_count - _self._start_bars_count)*alpha_koef
                local grade_width = score_lua_widget.set_grade_width(visaul_bars_count, _self._alpha_bars_count)

                score_lua_widget.set_grade_color(nil, 255*(1 - alpha_koef))
                if alpha_koef == 1 then
                    score_lua_widget.set_grade_width(0, score_lua_widget.alpha_bars_count)
                    score_lua_widget.set_grade_color(_color, 255)
                    _self.empty_finished = true
                end
            end
    
            if _time > _self.end_time then
                _self:InstantApply()
            end
]]
            if _self.state == 2 and _self._effect_finished then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            score_lua_widget.set_alpha_grade_color(score.alpha_bar_image_color)
            score_lua_widget.set_grade_color(sf.graphics.Color(255, 255, 255, 255))

--[[
            for i,o in pairs(_self._effects_table) do
                o["visual"]:Kill(false)
                --score_lua_widget.visual_effects_list:CreateInstantEffect("NewHint", o["end_pos"])        
            end
            score_lua_widget.visual_effects_list:CreateInstantEffect("CalcEffectFinal", score_lua_widget.score_pos)        
   ]]

            --if score_lua_widget.score_label_widget then
              --  score_lua_widget.score_label_widget.SetText(tostring(_self._final_score))
            --end

            _self.is_dead = true
        end,
        is_dead = false,
    }
    return new_child_effect
end


function score_lua_widget.CreateAddAlphaEffect()
    local new_child_effect = 
    {
        Init = function(_self, _start_alpha_count, _end_alpha_count, _curretn_bars_count)

            _self._start_alpha_count = _start_alpha_count
            _self._end_alpha_count = _end_alpha_count
            _self._current_bars_count = _curretn_bars_count
        end,

        _GetBarTime = function(_self)

            --local a = 

            local bar_time = ((math.abs(_self._end_alpha_count - _self._start_alpha_count)/_self._current_bars_count)*score.alpha_bar_fill_time)/score.alpha_bar_decrease_part--score.alpha_bar_fill_time* (score.const_global_max_bars_count - score_lua_widget.bars_count + 1)/2 
            if _self._end_alpha_count < _self._start_alpha_count then
                bar_time = math.abs(_self._end_alpha_count - _self._start_alpha_count) * score.alpha_bar_decrease_time
            end
            return bar_time
        end,
        
        Start = function(_self, _start_time)
            score_lua_widget.enable_alpha_decres = false

            _self.start_time = _start_time

             _self.total_time = _self:_GetBarTime()
            _self.end_time = _self.start_time + _self.total_time
--[[
            _self.particle_pos = sf.misc.FloatVector(score_lua_widget.grade_offset)
            _self.particle_pos.X = _self.particle_pos.X + (_self._start_bars_count/score.const_global_max_bars_count)*score_lua_widget.grade_traget_size.X
            _self.particle_pos.Y = _self.particle_pos.Y + score_lua_widget.grade_traget_size.Y/2

            _self.particle_effect = score_lua_widget.visual_effects_list:CreateEffect("AddEffectGrade", _self.particle_pos)
]]
        end,

        SetAlphaBars = function(_self, _alpha_bars)
           -- if _alpha_bars >= _self._end_alpha_count then
                _self._end_alpha_count = _alpha_bars

                local bar_time = score.alpha_bar_fill_time
                if _self._end_alpha_count < _self._start_alpha_count then
                    bar_time = score.alpha_bar_decrease_time
                end

                if _self.start_time then
                    _self.total_time = _self:_GetBarTime()
                    _self.end_time = _self.start_time + _self.total_time
                end
            --else
              --  __message("   ","")
            --end

        end,

        GetType = function(_self)
            return  3 -- add alpha bars
        end,

        Draw = function(_self, _renderer)

        end,

        Update = function(_self, _time)
            local koef = (_time - _self.start_time)/_self.total_time
            if _time > _self.end_time then
--[[
                if not _self._blink_time and not _self._do_not_show_blink then
                    _self._blink_time = _time
                    _self._blink_finished = false
                end
                if _self.particle_effect then
                    _self.particle_effect:Kill(false)
                    _self.particle_effect = nil
                end]]
                koef = 1
            end
            local visaul_alpha_count = _self._start_alpha_count + (_self._end_alpha_count - _self._start_alpha_count)*koef
            score_lua_widget.set_grade_width(_self._current_bars_count, visaul_alpha_count)
            --[[
            local grade_width = 
            if _self.particle_effect then
                _self.particle_pos.X = score_lua_widget.grade_offset.X + grade_width
                _self.particle_effect:SetPos(_self.particle_pos)
            end
]]
    
--[[
            if _self._blink_time then
                local koef = (_time - _self._blink_time) /(score.blink_time)
                if koef > 1 then
                    koef = 1
                end
                local color_koef = koef
                if koef > 0.5 then
                    color_koef = 1 - koef
                end
                color_koef = color_koef*((score.blink_max_alpha/255)/0.5)
      
                score_lua_widget.set_grade_color(sf.graphics.Color(255*color_koef, 255, 255, 255))
                if koef == 1 then
                    score_lua_widget.set_grade_color(sf.graphics.Color(0, 255, 255, 255))
                    _self._blink_finished = true
                end

            end
]]
            if _time > _self.end_time then -- and (_self._blink_finished == true or _self._do_not_show_blink ) then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            --score_lua_widget.set_grade_color(sf.graphics.Color(0, 255, 255, 255))
            score_lua_widget.enable_alpha_decres = true
            _self.is_dead = true
        end,
        is_dead = false,
    }
    return new_child_effect
end

function score_lua_widget.VisualSetScore(_score, _score_count, _score_koef)
    score_lua_widget.score_label_widget.SetText(tostring(_score))
    local new_score_effect = score_lua_widget.CreateAddScoreEffect()
    local current_time = score_lua_widget.score_timer.Get().GetTime()
    new_score_effect:Init(current_time, _score_count, _score_koef, quest.g_ClickPos - score_lua_widget._self_pos)
    table.insert(score_lua_widget.add_score_effects_list, new_score_effect)
    
end


function score_lua_widget.VisualCalculateBars(_score)
    local current_time = score_lua_widget.score_timer.Get().GetTime()
    local effects_count = #score_lua_widget.effects_list
    if effects_count == 0 then
        local new_effect = score_lua_widget.CreateCalcBarsEffect()
        new_effect:Init(score_lua_widget.bars_count, _score, score_lua_widget.alpha_bars_count)
        new_effect:Start(current_time)
        table.insert(score_lua_widget.effects_list, new_effect)
    else
        local new_effect = score_lua_widget.CreateCalcBarsEffect()
        new_effect:Init(score_lua_widget.bars_count, _score, score_lua_widget.alpha_bars_count)
        table.insert(score_lua_widget.effects_list, new_effect)
    end
    score_lua_widget.bars_count = 0
end

function score_lua_widget.SetVisualBars(_bars)
    local current_time = score_lua_widget.score_timer.Get().GetTime()
    local effects_count = #score_lua_widget.effects_list
    if effects_count == 0 then
        local new_effect = score_lua_widget.CreateAddBarsEffect()
        new_effect:Init(score_lua_widget.bars_count, _bars)
        new_effect:Start(current_time)
        table.insert(score_lua_widget.effects_list, new_effect)
    else
        if score_lua_widget.effects_list[effects_count]:GetType() == 1 then
            score_lua_widget.effects_list[effects_count]:SetBars(_bars)
        else
            local new_effect = score_lua_widget.CreateAddBarsEffect()
            new_effect:Init(score_lua_widget.bars_count, _bars)
            table.insert(score_lua_widget.effects_list, new_effect)
        end
    end

    score_lua_widget.bars_count = _bars
    --score_lua_widget.grade_image.SetRect(sf.misc.FloatRect(0, 0, score_lua_widget.bars_count*score_lua_widget.bar_width, hints_lua_widget.grade_image_size.Y) ) 
end

function score_lua_widget.SetAlphaBars(_bars_alpha)
    local current_time = score_lua_widget.score_timer.Get().GetTime()
    local effects_count = #score_lua_widget.effects_list
    if effects_count == 0 then
        local new_effect = score_lua_widget.CreateAddAlphaEffect()
        new_effect:Init(score_lua_widget.alpha_bars_count, _bars_alpha, score_lua_widget.bars_count)
        new_effect:Start(current_time)
        table.insert(score_lua_widget.effects_list, new_effect)
    else
        if score_lua_widget.effects_list[effects_count]:GetType() == 3 then
            score_lua_widget.effects_list[effects_count]:SetAlphaBars(_bars_alpha)
        else
            local new_effect = score_lua_widget.CreateAddAlphaEffect()
            new_effect:Init(score_lua_widget.alpha_bars_count, _bars_alpha, score_lua_widget.bars_count)
            table.insert(score_lua_widget.effects_list, new_effect)
        end
    end
    score_lua_widget.alpha_bars_count = _bars_alpha
end

function score_lua_widget.Init(_bars, _score, _alpha_bars)
    score_lua_widget.bars_count = _bars
    score_lua_widget.score_count = _score
    score_lua_widget.alpha_bars_count = _alpha_bars

    local visaul_bars_count = score_lua_widget.bars_count
    score_lua_widget.set_grade_width(visaul_bars_count, score_lua_widget.alpha_bars_count)
    score_lua_widget.set_white_grade_color(sf.graphics.Color(0, 0, 0, 0))


    for i,o in ipairs(bars_multiply_table) do
        if visaul_bars_count >= o.count then  
            o.state = 2
            o.alpha_on = 255
            o.image_on.SetColor(sf.graphics.Color(o.alpha_on, 255, 255, 255))
        end
    end  

    --score_lua_widget.grade_image.SetRect(sf.misc.FloatRect(0, 0, visaul_bars_count*score_lua_widget.bar_width+0.0001, hints_lua_widget.grade_image_size.Y) ) 

    if score_lua_widget.score_label_widget then
        score_lua_widget.score_label_widget.SetText(tostring(score_lua_widget.score_count))
        score_lua_widget.score_size = score_lua_widget.score_label_widget.GetSize()
        score_lua_widget.score_pos = score_lua_widget.score_label_widget.GetOffset() + score_lua_widget.score_size/2

    end
    
end

score_lua_widget.add_score_effects_list = {}
score_lua_widget.effects_list = {}
score_lua_widget.current_effect = nil

function score_lua_widget.DoUpdate(_this)


    local current_time = score_lua_widget.score_timer.Get().GetTime()

    if score_lua_widget.enable_alpha_decres then
        if score_lua_widget.alpha_bars_count > 0 then
            local current_frame_delta = score_lua_widget.score_timer.Get().GetFrameDelta()


            score_lua_widget.alpha_bars_count = score_lua_widget.alpha_bars_count - score.one_bar_fill_time_in_full_temp*(current_frame_delta/1000)* (score_lua_widget.bars_count/score.const_global_max_bars_count)
            if score_lua_widget.alpha_bars_count < 0 then
                score_lua_widget.alpha_bars_count = 0
            end
            score.SetAlphaBars(score_lua_widget.alpha_bars_count)
            score_lua_widget.set_grade_width(score_lua_widget.bars_count, score_lua_widget.alpha_bars_count)
        end
    end

    if score_lua_widget.effects_list[1] ~= nil then
        score_lua_widget.effects_list[1]:Update(current_time)

        if score_lua_widget.effects_list[1].is_dead == true then
            table.remove(score_lua_widget.effects_list, 1)
            if score_lua_widget.effects_list[1] then
                score_lua_widget.effects_list[1]:Start(current_time)
            end
        end
    end

    local size = #(score_lua_widget.add_score_effects_list)
    if size ~= 0 then
        local i = 1
        while i <= size do
            score_lua_widget.add_score_effects_list[i]:Update(current_time)
            if score_lua_widget.add_score_effects_list[i].is_dead == true then
                table.remove(score_lua_widget.add_score_effects_list, i)
                size = size - 1
                i = i - 1
            end
            i = i + 1
        end
    end

    for i,o in pairs(bars_multiply_table) do
        if o._effect then
            o._effect:Update(current_time)
            if o._effect.is_dead == true then
                o._effect = nil
            end
    

        end
    end


    score_lua_widget.visual_effects_list:Update()

    return false
end

function score_lua_widget.DoDraw(_this, _renderer)


    for i,o in pairs(score_lua_widget.add_score_effects_list) do
        o:Draw(_renderer)
    end

    _renderer.PushState()
    _renderer.ApplyMatrix( sf.misc.MatrixTranslation(score_lua_widget.grade_offset.X, score_lua_widget.grade_offset.Y))
    score_lua_widget.grade_image_alpha.Draw(_renderer)
    score_lua_widget.grade_image.Draw(_renderer)
    score_lua_widget.grade_image_white.Draw(_renderer)
    _renderer.PopState()

    for i = 1, score.const_global_max_bars_count-1 do
        _renderer.PushState()
        _renderer.ApplyMatrix( sf.misc.MatrixTranslation(score_lua_widget.bars_offset.X + i * score_lua_widget.bar_width, score_lua_widget.bars_offset.Y - 5))
        score_lua_widget.grade_division_image.Draw(_renderer)
        _renderer.PopState()
    end

    for i,o in pairs(bars_multiply_table) do
        _renderer.PushState()

        _renderer.ApplyMatrix( sf.misc.MatrixTranslation(o.offset.X, o.offset.Y))

        _renderer.ApplyMatrix( sf.misc.MatrixScale(o.scale, o.scale))


        _renderer.ApplyMatrix( sf.misc.MatrixTranslation(-o.mul_image_half_size.X, -o.mul_image_half_size.Y))
        o.image_off.Draw(_renderer)
        if o.alpha_on > 0 then
            o.image_on.Draw(_renderer)
        end

        

        _renderer.ApplyMatrix( sf.misc.MatrixTranslation(o.mul_image_half_size.X + o.text_offset.X, o.mul_image_half_size.Y + o.text_offset.Y ))
        _renderer.RenderString(score_lua_widget.font, o.text, 0, 0, 0, 0, 1, score_lua_widget.labels_color, 0) 
        _renderer.PopState()
    end


    score_lua_widget.visual_effects_list:PreDraw(_renderer)

    score_lua_widget.visual_effects_list:PostDraw(_renderer)

	return false
end


function score_lua_widget.Load(_this, _info, _templates)
    score_lua_widget._self = _this
    score_lua_widget._self_pos = _this.GetAbsPos(false)
    local score_constants_group = quest.game_resources.GetChild(_T("Constants"), false).GetChild(_T("score"), false)
    local id = score_constants_group.GetId().c_str()
    if score_constants_group.GetId().c_str() == "" then
        __message("   score   ", "")
    else
		--      
		if "true" == score_constants_group.GetValue(_T("turn_off_score")).c_str() then
			--      
			score_lua_widget._turn_off_score = true
            --         
			set_widget_flag_value(_this, sf.gui.CBaseWidget.FlagHidden, true)  
			set_widget_flag_value(_this, sf.gui.CBaseWidget.FlagDisabled, true)  
		end

        score_lua_widget.bars_offset = sf.misc.FloatVector(0, 0)
        score_lua_widget.bars_offset.X = tonumber(score_constants_group.GetValue(_T("term_offset_x")).c_str())
        score_lua_widget.bars_offset.Y = tonumber(score_constants_group.GetValue(_T("term_offset_y")).c_str())

        score_lua_widget.grade_offset.X = tonumber(score_constants_group.GetValue(_T("grade_offset_x")).c_str())
        score_lua_widget.grade_offset.Y = tonumber(score_constants_group.GetValue(_T("grade_offset_y")).c_str())

        local res = tonumber(score_constants_group.GetValue(_T("labels_offset_x")).c_str())
        if res ~= nil then score_lua_widget.labels_offset.X  = res end
        res = tonumber(score_constants_group.GetValue(_T("labels_offset_y")).c_str())
        if res ~= nil then score_lua_widget.labels_offset.Y  = res end

        local res = tonumber(score_constants_group.GetValue("grade_size_x").c_str())
        if res ~= nil then score_lua_widget.grade_traget_size.X = res end

        res = tonumber(score_constants_group.GetValue("grade_size_y").c_str())
        if res ~= nil then score_lua_widget.grade_traget_size.Y = res end

        res = tonumber(score_constants_group.GetValue("max_bars_count").c_str())
        if res ~= nil then score.const_global_max_bars_count = res end

        res = tonumber(score_constants_group.GetValue("last_dead_bar_width").c_str())
        if res ~= nil then score_lua_widget.last_dead_bar_width = res end

        res = score_constants_group.GetValue("div_image").c_str()
        if res ~= "" then score.grade_div_image_id = res end


        res = score_constants_group.GetValue("font_id").c_str()
        if res ~= nil then score_lua_widget.font_id = res end

        res = score_constants_group.GetValue("labels_color").c_str()
        if res ~= "" then score_lua_widget.labels_color = string_to_color(res) end


        score_lua_widget.font = g_App.GetResourceManager().GetFont(score_lua_widget.font_id)

        score_lua_widget.bar_width = (score_lua_widget.grade_traget_size.X-score_lua_widget.last_dead_bar_width) / score.const_global_max_bars_count


        score_lua_widget.grade_image = sf.graphics.CImage("gui_game_gui_grade")
        score_lua_widget.grade_image_alpha = sf.graphics.CImage("gui_game_gui_grade")

        score_lua_widget.grade_image_white = sf.graphics.CImage("gui_game_gui_grade_white")
        
        score_lua_widget.mul_image_on = sf.graphics.CImage("gui_game_gui_lable01_on")
        score_lua_widget.mul_image_off = sf.graphics.CImage("gui_game_gui_lable01_off")



        local rect = score_lua_widget.mul_image_on.GetRect()
        score_lua_widget.mul_image_size = sf.misc.FloatVector(rect.Width/2, rect.Height/2 )




         

        score_lua_widget.grade_division_image = sf.graphics.CImage(score.grade_div_image_id)

        rect = score_lua_widget.grade_image.GetRect()
        score_lua_widget.grade_image_size = sf.misc.FloatVector(rect.Width, rect.Height )
    


        local add_info = quest.game_resources.GetChild("Constants", false).GetChildRef("add_score_effect", false)
        if add_info then
            local res = tonumber(add_info.GetValue("bar_fill_time").c_str())
            if res ~= nil then score.bar_fill_time = res end

            res = tonumber(add_info.GetValue("blink_time").c_str())
            if res ~= nil then score.blink_time = res end

            res = tonumber(add_info.GetValue("back_alpha_max_alpha").c_str())
            if res ~= nil then score.blink_max_alpha = res end

--score.score_go_up_font_id = "font_12"
  --          score.score_go_up_font = score.score_go_up_time = 3200

            res = tonumber(add_info.GetValue("blink_time").c_str())
            if res ~= nil then score.blink_time = res end

            res = tonumber(add_info.GetValue("back_alpha_max_alpha").c_str())
            if res ~= nil then score.blink_max_alpha = res end

            res = tonumber(add_info.GetValue("score_fly_height").c_str())
            if res ~= nil then score.score_go_up_alt = res end

            res = tonumber(add_info.GetValue("score_start_offset_x").c_str())
            if res ~= nil then score.score_go_up_offset.X = res end

            res = tonumber(add_info.GetValue("score_start_offset_y").c_str())
            if res ~= nil then score.score_go_up_offset.Y = res end

            res = tonumber(add_info.GetValue("score_fly_time").c_str())
            if res ~= nil then score.score_go_up_time = res end

            res =add_info.GetValue("score_font").c_str()
            if res ~= "" then score.score_go_up_font_id = res end
            
            score.score_go_up_font = g_App.GetResourceManager().GetFont(score.score_go_up_font_id)


        end

        local calc_info = quest.game_resources.GetChild("Constants", false).GetChildRef("calc_score_effect", false)
        if calc_info then
--            local res = tonumber(calc_info.GetValue("effect_time").c_str())
  --          if res ~= nil then score.bar_empty_effect_time = res end

            res = tonumber(calc_info.GetValue("empty_time").c_str())
            if res ~= nil then score.bar_empty_time = res end

            res = tonumber(calc_info.GetValue("color_time").c_str())
            if res ~= nil then score.bar_color_effect_time = res end

            res = tonumber(calc_info.GetValue("color_max_alpha").c_str())
            if res ~= nil then score.bar_color_effect_max_alpha = res end

--[[
            res = tonumber(calc_info.GetValue("score_width").c_str())
            if res ~= nil then score_lua_widget.score_width = res end

            res = tonumber(calc_info.GetValue("start_x").c_str())
            if res ~= nil then score_lua_widget.ctrl_1.X = res end

            res = tonumber(calc_info.GetValue("start_y").c_str())
            if res ~= nil then score_lua_widget.ctrl_1.Y = res end

            res = tonumber(calc_info.GetValue("start_r").c_str())
            if res ~= nil then score_lua_widget.ctrl_1_rand = res end

            res = tonumber(calc_info.GetValue("end_x").c_str())
            if res ~= nil then score_lua_widget.ctrl_2.X = res end

            res = tonumber(calc_info.GetValue("end_y").c_str())
            if res ~= nil then score_lua_widget.ctrl_2.Y = res end

            res = tonumber(calc_info.GetValue("end_r").c_str())
            if res ~= nil then score_lua_widget.ctrl_2_rand = res end
]]

        end


        local calc_info = quest.game_resources.GetChild("Constants", false).GetChildRef("alpha_score_effect", false)
        if calc_info then
--[[
            local res = tonumber(calc_info.GetValue("decrease_time").c_str())
            if res ~= nil then score.alpha_bar_fill_time = res end
]]
            res = tonumber(calc_info.GetValue("fill_time").c_str())
            if res ~= nil then score.alpha_bar_decrease_time = res end
--[[
            res = tonumber(calc_info.GetValue("decrease_part").c_str())
            if res ~= nil then score.alpha_bar_decrease_part = res end

            res = tonumber(calc_info.GetValue("fill_bars_per_second").c_str())
            if res ~= nil then score.one_bar_fill_time_in_full_temp = res end
]]
            res = calc_info.GetValue("alpha_bar_color").c_str()
            if res ~= "" then score.alpha_bar_image_color = string_to_color(res) end


        end
        local calc_info = quest.game_resources.GetChild("Constants", false).GetChildRef("mul_score_effect", false)
        if calc_info then
            res = tonumber(calc_info.GetValue("max_scale").c_str())
            if res ~= nil then score_lua_widget.go_on_max_scale = res end


            res = tonumber(calc_info.GetValue("on_down_time").c_str())
            if res ~= nil then score_lua_widget.go_on_size_down_time = res end

            res = tonumber(calc_info.GetValue("on_up_time").c_str())
            if res ~= nil then score_lua_widget.go_on_size_up_time = res end

            res = tonumber(calc_info.GetValue("off_time").c_str())
            if res ~= nil then score_lua_widget.go_off_time = res end

        end

        score.const_gloabl_max_incorrect_click_count = tonumber(score_constants_group.GetValue(_T("incorect_click_limit")).c_str())
        
        local mult_table = score_constants_group.GetChild(_T("mult_table"), false)
        if mult_table.GetId().c_str() ~= "" then

            local res = mult_table.GetValue("def_on_image").c_str()
            if res ~= "" then score_lua_widget.mul_on_def_image = res end

            res = mult_table.GetValue("def_off_image").c_str()
            if res ~= "" then score_lua_widget.mul_off_def_image = res end

            bars_multiply_table = {}
            local row_group = mult_table.GetFirstChildRef()
            while row_group do
                if row_group.GetId().c_str() == "row" then
                    new_row = {}



                    __inherite(new_row, default_mul_row())

                    new_row.count = tonumber(row_group.GetValue(_T("count")).c_str())
                    new_row.koef = tonumber(row_group.GetValue(_T("koef")).c_str())
                    new_row.text = "x"..tostring(new_row.koef)
                    local on_image = row_group.GetValue(_T("on_image")).c_str()
                    if on_image == "" then on_image = score_lua_widget.mul_on_def_image end

                   local off_image = row_group.GetValue(_T("off_image")).c_str()
                    if off_image == "" then off_image = score_lua_widget.mul_off_def_image end

 
                    new_row.image_on = sf.graphics.CImage(on_image)
                    new_row.image_off = sf.graphics.CImage(off_image)

                    local rect = new_row.image_on.GetRect()
                    new_row.mul_image_half_size = sf.misc.FloatVector(rect.Width/2, rect.Height/2 )
                    --new_row.text_offset = sf.misc.FloatVector(0, 0)

                    local res = tonumber(row_group.GetValue("text_offset_x").c_str())
                    if res ~= nil then new_row.text_offset.X = res end

                    res = tonumber(row_group.GetValue("text_offset_y").c_str())
                    if res ~= nil then new_row.text_offset.Y = res end

                    new_row.scale = 1
                    new_row.alpha_on = 0
                    new_row.image_on.SetColor(sf.graphics.Color(new_row.alpha_on, 255, 255, 255))
                    new_row.offset = sf.misc.FloatVector(score_lua_widget.labels_offset.X + new_row.count * score_lua_widget.bar_width, score_lua_widget.labels_offset.Y)
                    new_row.state = 1 --1  off      2  on

                    table.insert(bars_multiply_table, new_row)
                end
                row_group = row_group.GetNextSiblingRef()
            end
        end


        score_lua_widget.grade_image_alpha.SetColor(score.alpha_bar_image_color) 


    end
    score_lua_widget.visual_effects_list = visual_effects.CreateEffectsList()
end


function default_mul_row()
	return 
	{
        count = 1,
        koef = 1,
        text = "x1",
        text_offset = sf.misc.FloatVector(0, 0),
        scale = 1,
        alpha_on = 0,
        offset = sf.misc.FloatVector(0, 0),
        state = 1,
	}
end


-------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------

quest.click_table = {}
quest.last_click_time = 0

quest.click_limit_time = 3000
quest.click_limit_count = 5


scene_click_widget = scene_click_widget or {}

scene_click_widget.click_timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")).AttachTimer(_T("")))


__inherite(scene_click_widget, null_lua_widget_handler())



function scene_click_widget.DropClicks()
    quest.click_table = {}
    quest.last_click_time = 0    
end


function scene_click_widget.CheckClick(_click_time)
    if #(quest.click_table) > quest.click_limit_count then
        scene_click_widget.DropClicks()
        score.CalculateScore()
        avatar_widget.ChangeState("sad")
    end
end

function scene_click_widget.AddClick(_click_time)

    quest.last_click_time = _click_time


   local size = #(quest.click_table)
    if size ~= 0 then
        local i = 1
        while i <= size do
            if _click_time - quest.click_table[i] > quest.click_limit_time then
                table.remove(quest.click_table, i)
                size = size - 1
                i = i - 1
            end
            i = i + 1
        end
    end

    table.insert(quest.click_table, _click_time)
    
    scene_click_widget.CheckClick(_click_time)
end

function scene_click_widget.OnMouseDown(_this, _pos, _button, _state, _broadcast)
    if not threads_managment.IsClikThread() then
        --scene_click_widget.AddClick(scene_click_widget.click_timer.Get().GetTime())
    end
    return false
end

function scene_click_widget.OnDoubleClick(_this, _pos, _state, _broadcast)
    if not threads_managment.IsClikThread() then
        --scene_click_widget.AddClick(scene_click_widget.click_timer.Get().GetTime())
    end
    return false
end

function scene_click_widget.DoUpdate(_this)
	return false
end

function scene_click_widget.__CreateInstance()
    return "scene_click_widget"
end

function scene_click_widget.Enable(_value)
    --assert(scene_click_widget.self)
    if scene_click_widget.self then
        if _value ~= nil then
            set_widget_flag_value(scene_click_widget.self, sf.gui.CBaseWidget.FlagDisabled, not _value)
        end
    end
end

function scene_click_widget.Load(_this, _info, _templates)
    local score_constants_group = quest.game_resources.GetChild(_T("Constants"), false).GetChild(_T("score"), false)
    if score_constants_group.GetId().c_str() == "" then
        __message("   score   ", "")
    else
        quest.click_limit_time = tonumber(score_constants_group.GetValue(_T("limit_time")).c_str())
        quest.click_limit_count = tonumber(score_constants_group.GetValue(_T("limit_click_count")).c_str())
    end
end

function score_lua_widget.CreateAddBarsEffect()
    local new_child_effect = 
    {
        mul_table = {},
        Init = function(_self, _start_bars_count, _end_bars_count)

            _self._start_bars_count = _start_bars_count
            _self._end_bars_count = _end_bars_count
            _self._do_not_show_blink = false
            if _self._end_bars_count >= score.const_global_max_bars_count then
                _self._do_not_show_blink = true
            end
            _self:CheckMuls()
    

        end,
        CheckMuls = function(_self)

            for i,o in pairs(bars_multiply_table) do
                if o.count <= _self._end_bars_count then
                    if o.state == 1 then
                        if _self.mul_table[o.count] == nil then
                            --table.insert(_self.mul_table,{count = o.count, is_add = false} )
                            _self.mul_table[o.count] = {count = o.count, is_add = false}
                        end
                    end
                end 
            end
        end,

        Start = function(_self, _start_time)
            _self.start_time = _start_time
            _self.total_time = math.abs(_self._end_bars_count - _self._start_bars_count) * score.bar_fill_time
            _self.end_time = _self.start_time + _self.total_time

            _self.particle_pos = sf.misc.FloatVector(score_lua_widget.grade_offset)
            _self.particle_pos.X = _self.particle_pos.X + (_self._start_bars_count/score.const_global_max_bars_count)*score_lua_widget.grade_traget_size.X
            _self.particle_pos.Y = _self.particle_pos.Y + score_lua_widget.grade_traget_size.Y/2

            _self.particle_effect = score_lua_widget.visual_effects_list:CreateEffect("AddEffectGrade", _self.particle_pos)

        end,

        SetBars = function(_self, _bars)
            if _bars >= _self._end_bars_count then
                _self._end_bars_count = _bars
                _self:CheckMuls()
                if _self._end_bars_count >= score.const_global_max_bars_count then
                    _self._do_not_show_blink = true
                end

                if _self.start_time then
                    _self.total_time = math.abs(_self._end_bars_count - _self._start_bars_count) * score.bar_fill_time
                    _self.end_time = _self.start_time + _self.total_time
                end
            else
                __message("   ","")
            end

        end,

        GetType = function(_self)
            return  1 -- add bars
        end,

        Draw = function(_self, _renderer)

        end,

        Update = function(_self, _time)
            local koef = (_time - _self.start_time)/_self.total_time
            if _time > _self.end_time then
                if not _self._blink_time and not _self._do_not_show_blink then
                    _self._blink_time = _time
                    _self._blink_finished = false
                end
                if _self.particle_effect then
                    _self.particle_effect:Kill(false)
                    _self.particle_effect = nil
                end
                koef = 1
            end
            local visaul_bars_count = _self._start_bars_count + (_self._end_bars_count - _self._start_bars_count)*koef
            local grade_width = score_lua_widget.set_grade_width(visaul_bars_count, score_lua_widget.alpha_bars_count)

            for i,o in pairs(_self.mul_table) do

                if o.is_add == false and o.count <= visaul_bars_count then
                    o.is_add = true

                    for j,obj in pairs(bars_multiply_table) do
                        if  obj.count == o.count then
                            local new_effect = score_lua_widget.CreateMulEffectGoOn()
                            new_effect:Init(_time, obj)
                            obj._effect = new_effect
                        end
                    end

                end
            end


            if _self.particle_effect then
                _self.particle_pos.X = score_lua_widget.grade_offset.X + grade_width
                _self.particle_effect:SetPos(_self.particle_pos)
            end
    

            if _self._blink_time then
                local koef = (_time - _self._blink_time) /(score.blink_time)
                if koef > 1 then
                    koef = 1
                end
                local color_koef = koef
                if koef > 0.5 then
                    color_koef = 1 - koef
                end
                color_koef = color_koef*((score.blink_max_alpha/255)/0.5)
      
                score_lua_widget.set_white_grade_color(sf.graphics.Color(255*color_koef, 255, 255, 255))
                if koef == 1 then
                    score_lua_widget.set_white_grade_color(sf.graphics.Color(0, 255, 255, 255))
                    _self._blink_finished = true
                end

            end
            if _time > _self.end_time and (_self._blink_finished == true or _self._do_not_show_blink ) then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            score_lua_widget.set_white_grade_color(sf.graphics.Color(0, 255, 255, 255))
            _self.is_dead = true
        end,
        is_dead = false,
    }
    return new_child_effect
end

function score_lua_widget.CreateAddScoreEffect()
    local new_child_effect = 
    {
        Init = function(_self, _start_time, _add_points_count, _points_mul_koef, _start_pos)


            _self.start_time = _start_time
            _self.total_time = score.score_go_up_time
            _self.end_time = _self.start_time + _self.total_time

            _self._add_points_count = _add_points_count
            _self._add_points_koef = _points_mul_koef
            _self._add_text = ""
            if _self._add_points_koef > 1 then
                _self._add_text = "x"..tonumber(_self._add_points_koef)
            end
            
            _self.text = "+"..tostring(_self._add_points_count).._self._add_text
            _self._text_width = 0
            if score.score_go_up_font then            
                _self._text_width = score.score_go_up_font.GetStringWidth(_self.text)
            end
            _self._start_pos = _start_pos + score.score_go_up_offset
            _self._draw_pos = sf.misc.FloatVector(_self._start_pos)
            _self._color = sf.graphics.Color(255, 255, 255, 255)
        
            score.score_text_border_offset = 5
            _self._draw_pos.X = _self._draw_pos.X - _self._text_width/2
            if _self._draw_pos.X < 0 then
                _self._draw_pos.X = score.score_text_border_offset
            end
            if _self._draw_pos.X + _self._text_width > 1024 - score.score_text_border_offset then
                _self._draw_pos.X = 1024 - (_self._text_width + score.score_text_border_offset)
            end
        
        end,

        Draw = function(_self, _renderer)
            if score.score_go_up_font then
                _renderer.RenderString(score.score_go_up_font, _self.text, _self._draw_pos.X, _self._draw_pos.Y, -1, -1, 1, _self._color, 0) --0xff000000, 0)
            end
        end,

        Update = function(_self, _time)
            local koef = (_time - _self.start_time)/_self.total_time
            if _time > _self.end_time then
                koef = 1
            end
            _self._draw_pos.Y = _self._start_pos.Y - koef*score.score_go_up_alt
            _self._color = sf.graphics.Color((1-koef)*255, 255, 255, 255)
            if _time > _self.end_time then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            _self.is_dead = true
        end,
        is_dead = false,
    }
    return new_child_effect
end
function score_lua_widget.CreateMulEffectGoOn()
    local new_child_effect = 
    {
        Init = function(_self, _start_time, _mul_row)

            _self.start_time = _start_time
            _self.start_state = 1

             _self.total_time = score_lua_widget.go_on_size_up_time
            _self.row = _mul_row
            _self.end_time = _self.start_time + _self.total_time
            _self.row.state = 2
            score_lua_widget.visual_effects_list:CreateInstantEffect("MulOn", _self.row.offset)        
        end,

        GetType = function(_self)
            return  1 -- go on
        end,

        Update = function(_self, _time)
            local koef = (_time - _self.start_time)/_self.total_time
            if koef > 1 then
                koef = 1
            end
            if _self.start_state == 1 then
                _self.row.scale = 1 + (score_lua_widget.go_on_max_scale - 1)*koef

                _self.row.alpha_on = 255*koef
                _self.row.image_on.SetColor(sf.graphics.Color(_self.row.alpha_on, 255, 255, 255))


                if koef == 1 then
                    _self.start_time = _time
                    _self.total_time = score_lua_widget.go_on_size_down_time
                    _self.start_state = 2
                end
            elseif _self.start_state == 2 then
                _self.row.scale = 1 + (score_lua_widget.go_on_max_scale - 1)*(1 - koef)

                if koef == 1 then
                    _self:InstantApply()
                end
            end
        end,

        InstantApply = function(_self)
            --score_lua_widget.set_grade_color(sf.graphics.Color(0, 255, 255, 255))
            --score_lua_widget.enable_alpha_decres = true
            _self.is_dead = true
        end,
        is_dead = false,
    }
    return new_child_effect
end
function score_lua_widget.CreateMulEffectGoOff()
    local new_child_effect = 
    {
        Init = function(_self, _start_time, _mul_row)

            _self.start_time = _start_time
            _self.start_state = 1
             _self.total_time = score_lua_widget.go_off_time
            _self.row = _mul_row
            _self.end_time = _self.start_time + _self.total_time
            _self.row.state = 1
            _self.row.scale = 1
        end,

        GetType = function(_self)
            return  1 -- go on
        end,

        Update = function(_self, _time)
            local koef = (_time - _self.start_time)/_self.total_time
            if koef > 1 then
                koef = 1
            end

            _self.row.alpha_on = 255*(1-koef)
            _self.row.image_on.SetColor(sf.graphics.Color(_self.row.alpha_on, 255, 255, 255))


            if koef == 1 then
                _self:InstantApply()
            end
        end,

        InstantApply = function(_self)
            --score_lua_widget.set_grade_color(sf.graphics.Color(0, 255, 255, 255))
            --score_lua_widget.enable_alpha_decres = true
            _self.is_dead = true
        end,
        is_dead = false,
    }
    return new_child_effect
end
