visual_effects = visual_effects or {}

function visual_effects.EffectsFactory(_effects_group, _effect_pos)
	local creators = 
	{
		particle = visual_effects.CreateSimpleParticleSystemEffect,
		composite = visual_effects.CreateCompositeEffect,
		sound = visual_effects.CreateSoundEffect
	}
	
    local effect_type = tostring(_effects_group.GetId())
	local creator = creators[effect_type]
	if creator then 
		local new_effect = creator()
		new_effect:Init(_effects_group, _effect_pos)
		return new_effect
	end
end

visual_effects._effect_list_prototype = 
{
    effects_list = {},
	
	Update = function(_self)
		local size = #(_self.effects_list)
		if size ~= 0 then
			local i = 1
			while i <= size do
				_self.effects_list[i]:Update()
				if _self.effects_list[i].is_dead == true then
					table.remove(_self.effects_list, i)
					size = size - 1
					i = i - 1
				end
				i = i + 1
			end
		end
	end,
	
	PreDraw = function(_self, _renderer)
		for i,o in pairs(_self.effects_list) do
			if o.pre_draw == true or o.pre_draw==nil then
				o:Draw(_renderer, true)
			end
		end
	end,
	
	PostDraw = function(_self, _renderer)
		for i,o in pairs(_self.effects_list) do
			if o.pre_draw == false or o.pre_draw==nil then
				o:Draw(_renderer, false)
			end
		end
	end,
	
	CreateEffect = function(_self, _effect_id, _effect_pos)
		if not visual_effects._disable_effects then
			local effect_id = _T(tostring(_effect_id))
			local effect = quest.game_resources.GetChild(_T("Effects"), false).GetFirstChildRef()
			while effect do
				if effect.GetValue("id").compare(effect_id)==0 then
					local new_effect = visual_effects.EffectsFactory(effect, _effect_pos)
					table.insert(_self.effects_list, new_effect)
					return new_effect
				end
				effect = effect.GetNextSiblingRef()
			end
		end
		
		local new_effect = visual_effects.CreateDumpEffect()
		new_effect:Init(_effect_id, _effect_pos)
		if not visual_effects._disable_effects then table.insert(_self.effects_list, new_effect) end
		return new_effect
	end,
	
	CreateInstantEffect = function( _self, ...)
		local new_effect = _self:CreateEffect(...)
		new_effect:SetFinished(true)
		return new_effect
	end
}

function visual_effects.CreateEffectsList()
    local ret = copy_table(visual_effects._effect_list_prototype) 
    ret.effects_list = {}
    return ret
end

function visual_effects._DisableEffects(_disable)
	visual_effects._disable_effects = _disable
end

--  ""  
visual_effects._base_effect_class = 
{
	id = "",
	is_dead = false,
	is_finished = false,
	pre_draw = false, --   3 : false, true  nil; nil ,     ,  
	offset = sf.misc.FloatVector(0, 0),
	
	Update = function(_self) 
		return false 
	end,

    GetChildEffect = function(_id)
        return nil
    end,
	
	Draw = function(_self, _renderer, _pre_draw) 
	end,
	
	SetFinished = function(_self, _value)
		_self.is_finished = _value
	end,
	
	Kill = function(_self, _momental)
		if _momental == true then
			_self.is_dead = true
		else
			_self.is_finished = true
		end
	end,
	
	SetPos = function(_self, _pos)
	end,
	
	Init = function(_self, _effect_group, _effect_pos)
		_self.id = tostring(_effect_group.GetValue("id"))
		
		_self.pre_draw = (tostring(_effect_group.GetValue("pre_draw")) == "true")

		_self.offset.X = tonumber(_effect_group.GetValue("offset_x")) or 0
		_self.offset.Y = tonumber(_effect_group.GetValue("offset_y")) or 0

		_self:SetPos(_effect_pos or sf.misc.FloatVector(0, 0))
	end
}

function visual_effects.CreateCompositeEffect()
	return __inherite(
    {
        child_effects_list = {},

        GetChildEffect = function(_self, _id)
            return _self.child_effects_list[_id]
        end,
		
        Update = function(_self)
			if not _self.is_dead then
	            _self.is_dead = true
	            for i,o in pairs(_self.child_effects_list) do
	                if o:Update() == false then
	                    _self.is_dead = false
	                end
	            end
			end
            return _self.is_dead
        end,

        SetEmiterSize = function(_self, _size)
            for i,o in pairs(_self.child_effects_list) do
                if o.SetEmiterSize then
                    o:SetEmiterSize(_size)
                end
            end
        end,
		
        Kill = function(_self, _momental)
			_self.__base.Kill(_self, _momental)
            for i,o in pairs(_self.child_effects_list) do
                o:Kill(_momental)
            end
        end,
		
        Draw = function(_self, _renderer, _pre_draw)
			if _pre_draw==nil then _pre_draw = false end
            for i,o in pairs(_self.child_effects_list) do
				if _pre_draw == o.pre_draw or o.pre_draw==nil then
					o:Draw(_renderer, _pre_draw)
				end
            end
        end,
		
        SetPos = function(_self, _pos)
            for i,o in pairs(_self.child_effects_list) do
                o:SetPos(_pos + _self.offset)
            end
        end,
		
        Init = function(_self, _effect_group, _effect_pos)
            local group = _effect_group.GetFirstChildRef()
            while group ~= nil do
                local new_effect = visual_effects.EffectsFactory(group, _effect_pos)
                --table.insert(_self.child_effects_list, new_effect)
                if new_effect.id ~= "" and new_effect.id ~= nil then
                    _self.child_effects_list[new_effect.id] = new_effect
                else
                    table.insert(_self.child_effects_list, new_effect)      
                end
                
                group = group.GetNextSiblingRef()
            end
			
			_self.__base.Init(_self, _effect_group, _effect_pos)
			
			_self.pre_draw = nil
        end,

        SetFinished = function(_self, _value)
            _self.__base.SetFinished(_self, _value)
            for i,o in pairs(_self.child_effects_list) do
                o:SetFinished(_value)
            end
        end
    }, visual_effects._base_effect_class)
end

function visual_effects.CreateSimpleParticleSystemEffect()
    return __inherite(
    {
        _particle_effect = nil,
		
        Update = function(_self)
			if not _self.is_dead then
				_self._particle_effect.Update()
	            _self.is_dead = _self.is_finished and _self._particle_effect.IsDead() and _self._particle_effect.GetLifeParticlesCount()==0 
			end
            return _self.is_dead
        end,
        SetEmiterSize = function(_self, _size)
            _self._particle_effect.SetEmiterSize(_size)
        end,
		
		
        SetPos = function(_self, _pos)
            if not _self.static_draw then
                _self._particle_effect.SetLocation(_pos.X + _self.offset.X, _pos.Y + _self.offset.Y)
            else
               _self._pos = _pos + _self.offset
            end
        end,
		
        Kill = function(_self, _momental)
            _self.__base.Kill(_self, _momental)
            if not _momental then
                _self._particle_effect.SetFlags( __or(_self._particle_effect.GetFlags(), sf.graphics.CParticleSystem.IsStopEmit) )
                if __and(_self._particle_effect.GetFlags(), sf.graphics.CParticleSystem.IsContinuous) then
                    _self._particle_effect.SetFlags( __xor(_self._particle_effect.GetFlags(), sf.graphics.CParticleSystem.IsContinuous) )
                end
            end
        end,

        Draw = function(_self, _renderer)
            if not _self.static_draw then
                _self._particle_effect.Render(_renderer)
            else
                _renderer.PushState()
                _renderer.ApplyMatrix(sf.misc.MatrixTranslation(_self._pos.X, _self._pos.Y))
                _self._particle_effect.Render(_renderer)
                _renderer.PopState()
            end
            
        end,

        Init = function(_self, _effect_group, _effect_pos)
            _self.static_draw = (tostring(_effect_group.GetValue("static_draw")) == "true")
            _self._particle_effect = sf.graphics.CParticleSystem(sf.core.g_Application.GetTimeManager().GetTimer(_T("qe_level")).AttachTimer(""))
			local particle_id = _effect_group.GetValue("particle_id")
			local particle = quest.game_resources.GetChild("Particles", false).GetChildByAttribute("particle", "id", particle_id, false)
			__assert(not particle.GetId().empty(), "effects.xml: particle '"..tostring(particle_id).."' not found!")
            _self._particle_effect.Load(particle)

			_self.__base.Init(_self, _effect_group, _effect_pos)

            if _self.static_draw then
                _self._particle_effect.SetLocation(0, 0)
            end

            _self._particle_effect.DropOldPos()
        end
    }, visual_effects._base_effect_class)
end

function visual_effects.CreateSoundEffect()
    return __inherite(
    {
		_sound = nil,
		--_timer = nil,
		
        Update = function(_self)
			if not _self.is_dead then 
				if _self._sound then sound(_self._sound) end
				_self.is_dead = true
			end
			return true
        end,
		
        Init = function(_self, _effect_group)
            --_self.timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().AttachTimer("", nil))

			_self._sound = tostring(_effect_group.GetValue("sound_id"))
        end
    }, visual_effects._base_effect_class)
end

function visual_effects.CreateDumpEffect()
    return __inherite(
    {	
		_pos = sf.misc.FloatVector(0, 0),
				
        SetPos = function(_self, _pos)
            _self.pos = _pos
        end,
		
        Kill = function(_self, _momental)
            _self.is_dead = true
        end,
		
        Draw = function(_self, _renderer)
            _renderer.RenderLine(_self.pos - sf.misc.FloatVector(20,20), _self.pos + sf.misc.FloatVector(20,20), 0xffffffff)
            _renderer.RenderLine(_self.pos - sf.misc.FloatVector(20,-20), _self.pos + sf.misc.FloatVector(20,-20), 0xffffffff)
        end,
		
        Init = function(_self, _effect_group, _effect_pos)
            _self.SetPos(_effect_pos or sf.misc.FloatVector(0, 0))
        end
    }, visual_effects._base_effect_class)
end

