game_menu = game_menu or {}
game_menu.actions = game_menu.actions or {}

function game_menu.Show(_window)
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "in_game_menu", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	dialog.UpdateLayout()
    local parent_offset = _window.GetAbsPos(true)
	dialog.SetOffset((1024 - dialog.GetSize().X)/2 - parent_offset.X, (768 - dialog.GetSize().Y)/2 - parent_offset.Y)

    local dialog_ptr = sf.gui.CBaseWindowPtrT(dialog)
    local modal_res = _window.DoModal(dialog_ptr)
    dialog_ptr = 0

	collectgarbage()
    return modal_res

end

function game_menu.DoDraw(_this, _renderer)
end

function game_menu.DoUpdate(_this)
end

function game_menu.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function game_menu.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	if _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast) then
        return true
    end
    
    if _key == 27 then
		_this.EndModal(0)
        return true
    end
    return false

end

function game_menu.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function game_menu.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove( _pos, _state, _broadcast) 
end

function game_menu.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function game_menu.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function game_menu.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function game_menu.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function game_menu.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = game_menu.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end
	
game_menu.actions.return_main_menu = 
{
	pressed = function(_window) 
		_window.EndModal(1)
	end
}

game_menu.actions.return_game = 
{
	pressed = function(_window) 
		_window.EndModal(0)
	end
}

game_menu.actions.options = 
{
	pressed = function(_window) 
		local options_res = options_window_dialog.Show(_window)
        if options_res == 1 then
    		_window.EndModal(0)
        end
	end
}

game_menu.actions.difficulty = 
{
	pressed = function(_window) 
        if dificulty_window.Show(_window) == 1 then
    		_window.EndModal(2)
        end
	end
}