function log(str)
	print(str)
	io.flush()
end

g_App = sf.core.g_Application
g_Lua = sf.lua.CLua.GetLua("main")
g_Lua.LoadScript("scripts/game_engine/main.lua")
g_Lua.LoadScript("scripts/game_engine/misc.lua")


g_Lua.LoadScript("scripts/scrollable_panel.lua")
g_Lua.LoadScript("scripts/main_menu_window.lua")
g_Lua.LoadScript("scripts/comics_window.lua")
g_Lua.LoadScript("scripts/user_profiles.lua")
g_Lua.LoadScript("scripts/options_window.lua")
g_Lua.LoadScript("scripts/credits_window.lua")
g_Lua.LoadScript("scripts/game_menu.lua")
g_Lua.LoadScript("scripts/dificulty_window.lua")
g_Lua.LoadScript("scripts/dialog_window.lua")
g_Lua.LoadScript("scripts/records_window.lua")
g_Lua.LoadScript("scripts/achievements_window.lua")
g_Lua.LoadScript("scripts/replay_window.lua")


function convert_to_scene_object(_scene_object_base)
    return __cast(_scene_object_base, qe.CSceneObject)
end

function set_widget_flag_value(_widget, _flag, _value)
	if _value then
		_widget.SetFlags(sf.misc.BitwiseOr(_widget.GetFlags(), _flag))
	else
		if sf.misc.BitwiseAnd(_widget.GetFlags(), _flag) == 0 then
		else
			_widget.SetFlags(sf.misc.BitwiseXor(_widget.GetFlags(), _flag))
		end
	end
end

function LoadGameStr()

	local _file = "properties/game_struct.xml"
	local file_info = sf.core.CSettings()
	file_info.LoadXml(_file)
	info = file_info.GetFirstChild()
	g_QuestStr = {}
	local widget = info.GetChildRef("step", false)
	while widget do
		if widget.GetId().c_str()=="step" then
			local id = widget.GetValue("id")
            local type = widget.GetValue("type").c_str()
            local track_table = {}

            local track = widget.GetValue("track").c_str()
            table.insert(track_table, track)

            if type == "level" then
                local level_step = widget.GetFirstChildRef()
                if level_step then
                    track_table = {}
                end
	            while level_step do            
                    table.insert(track_table, level_step.GetValue("id").c_str())
	                level_step = level_step.GetNextSiblingRef()
	            end

            end

            local new_step = {}
            new_step.Id = id
            new_step.Type = type
            new_step.Track = track_table
            
            if type == "comics" then
                local steps_table = {}           
                local comics_step = widget.GetFirstChildRef()
	            while comics_step do            
                    local start_time = tonumber(comics_step.GetValue("start_time").c_str())
                    local end_time = tonumber(comics_step.GetValue("end_time").c_str())
					--    
					local flash_path = comics_step.GetValue("flash_path").c_str()
                    table.insert(steps_table, {id = comics_step.GetValue("id").c_str(), start_time = start_time, end_time = end_time, flash_path = flash_path })
	                comics_step = comics_step.GetNextSiblingRef()
	            end
	            if #steps_table > 0 then
	                new_step.Childs = steps_table
	            end
            end
            table.insert(g_QuestStr, new_step)
		end
		widget = widget.GetNextSiblingRef()
	end
end

function Init()
    --g_App.GetRenderer().SetSourceResolution(1024, 768)
    --g_App.ChangeScreenMode(game.g_GameOptions.Instance().GetFullScreenMode(), false, 1024, 768)
end

function Run()
	g_QuestData = qe.CQuest() 
	g_QuestData.Load()
	LoadGameStr()
	
	if lfs.touch("scripts/game/generate_hints.lua") then
		g_Lua.LoadScript("scripts/game/generate_hints.lua")
	end
	
	if g_S10GenerateHints then
		main_menu.GenerateHints()
	else
	    main_menu.Show(true)
	end
end

function MoveWindowToCenter(_owner, _child_window)
	local owner_size = _owner.GetSize()
	local owner_offset = _owner.GetOffset()
	local child_size = _child_window.GetSize()
	_child_window.SetOffset(owner_size.X/2 - child_size.X/2, owner_size.Y/2 - child_size.Y/2)
end

function set_widget_flag_value(_widget, _flag, _value)
	if _value then
		_widget.SetFlags(sf.misc.BitwiseOr(_widget.GetFlags(), _flag))
	else
		if sf.misc.BitwiseAnd(_widget.GetFlags(), _flag) == 0 then
		else
			_widget.SetFlags(sf.misc.BitwiseXor(_widget.GetFlags(), _flag))
		end
	end
end

