enter_password_on_mouse_scene03_01 = {}
local self = enter_password_on_mouse_scene03_01

self.params = 
{
	password = {1, 1, 3},
	sound_on_click = "",
	sound_win = "mini_game_mini_game_enter_password_true_01", --  
	sound_lose = "mini_game_mini_game_enter_password_false_01", --  
	sleep = 1000.0 --        /       
}

function self.Reset(_owner)
	self.current_sequence = {}	
	local w = _owner.GetWidgets()
	while not w.IsEnd() do
		local button = __cast(w.Get(), sf.gui.CButtonWidget)
		if button then
			button.DisableButton(false)
		else
			local img = __cast(w.Get(), sf.gui.CImageWidget)
			if img then
				local id = img.GetId().c_str()
				if id == "opened" then
					self.opened = img
					img.AddFlags(sf.gui.CWidget.FlagHidden)
					elseif id == "closed" then
					self.closed = img
				elseif id == "turned_off" then
					self.turned_off = img
				elseif id == "turned_on_wrong" then
					self.wrong = img
					img.AddFlags(sf.gui.CWidget.FlagHidden)
				elseif id == "turned_on_right" then
					self.right = img
					img.AddFlags(sf.gui.CWidget.FlagHidden)	
				end
			end
		end
		w.Next()
	end 
	_owner.OnMouseMove(sf.misc.IntVector(-1000,-1000), 0, true)
	
	self.indicate = nil --   
	self.timer = __create_timer()
	self.win = nil
end

function self.OnMouseMove(_owner, _pos, _state, _broadcast)
	return true
end

function self.OnChildAction(_owner, _action, _child)
	if self.indicate then return end
	if	_action.c_str() == "pressed" then		
		local number = tonumber(_child.GetId().c_str())
		if number then
			if self.params.sound_on_click then
				sf.core.g_Application.GetAudioManager().Play(self.params.sound_on_click, -2, -2, -2, -2, -2)
			end

			table.insert(self.current_sequence, number)
			
			local current_length = #self.current_sequence
			local target_length = #self.params.password
			
			assert(current_length <= target_length)
			
			if current_length == target_length then
				--    
				local correctly = true
				for i=1, target_length do
					local n1 = self.current_sequence[i]
					local n2 = self.params.password[i]
					if n1 ~= n2 then
						correctly = false
						break
					end
				end
				if not correctly then
					-- 
					self.indicate = true
					self.start = self.timer.Get().GetTime()
					self.wrong.RemFlags(sf.gui.CWidget.FlagHidden)
					if self.params.sound_lose then
						sound(self.params.sound_lose)
					end
				else
					--  
					self.indicate = true
					self.start = self.timer.Get().GetTime()
					self.right.RemFlags(sf.gui.CWidget.FlagHidden)
					if self.params.sound_win then
						sound(self.params.sound_win)
					end
				end
			end
		end
	end
end

function self.OnUpdate(_owner)
	if not self.indicate then return end
	--       
	if self.timer.Get().GetTime() - self.start >= self.params.sleep then
		if self.win then 
			--  
			_owner.SetGameResult(1)
			_owner.OnEndGame()
		else
			if __and (sf.gui.CWidget.FlagHidden, self.wrong.GetFlags()) == 0 then
				--    ,  
				self.Reset(_owner)
				if self.params.sound_error then
					sf.core.g_Application.GetAudioManager().Play(self.params.sound_error, -2, -2, -2, -2, -2)
				end
				self.indicate = false
			else
				--   ,    ,   
				self.win = true
				self.right.AddFlags(sf.gui.CWidget.FlagHidden)
				self.opened.RemFlags(sf.gui.CWidget.FlagHidden)
				self.turned_off.AddFlags(sf.gui.CWidget.FlagHidden)
				self.HideButtons(_owner)
				self.start = self.timer.Get().GetTime()
			end
		end
	end
end
--   
function self.HideButtons(_owner)
	local w = _owner.GetWidgets()
	while not w.IsEnd() do
		local button = __cast(w.Get(), sf.gui.CButtonWidget)
		if button then
			button.AddFlags(sf.gui.CWidget.FlagHidden)
		end
		w.Next()
	end 
end 

function self.OnPreferredSize(_owner)
	return sminigames.OnPreferredSize(_owner)
end 

function self.Init(_owner)
	sminigames.SetStandartScriptName(_owner, enter_password_on_mouse_scene03_01)
	self.Reset(_owner)
end
