--[[
 
 ]]

liquids_pouring = {}

local self = liquids_pouring

self.params = {
	weight_num_id = "scenes_scene06_02_minigame_minigame01_number", -- id   
	weight_num_layer = 1, -- ,      
	sound_on_pour = "mini_game_mini_game_liquids_pouring_water_01",  --  
	sound_on_move = "mini_game_mini_game_liquids_pouring_go_01", --   .  dsfrontend   max_concurent_sound = 1
	sound_select = "mini_game_mini_game_birds_and_fishes_select_01", --  
	sound_on_win = "", --   
	before_win_clip_id = "wrong_center", -- ,    ,     
	win_clip_id = "correct_center", -- id  dsfrontend,   .    . 
	moving_shelf = 
	{ --   
		lower_pos = sf.misc.FloatVector(355, 569), --    
		higher_pos = sf.misc.FloatVector(355, 121), --    
		start_pos = sf.misc.FloatVector(355, 569), --   
		bottle = 1, --    
		speed = 10 --   -   
	},
	liquids_exchange_time = 100, --       (  )
	bottles = 
	{
		{ --1
			start_amount = 14, --  
			size = 14, --  
			need = 7, --     . 0 ,  
			id = "bottle01_", --   id    (   dsfrontend)
			layer = 2, --  
			select_clip ="glow01", --   .      -
			weight_number_pos =
			{ --     
				sf.misc.FloatVector(343, 131), --  
				sf.misc.FloatVector(319, 131) -- 
			}
		},
		{ --2
			start_amount = 0, --  
			size = 9, --  
			need = 0, --     . 0 ,  
			id = "bottle02_", --   id    (   dsfrontend)
			layer = 2, --  
			select_clip ="glow02", --   .      -
			weight_number_pos =
			{ --     
				sf.misc.FloatVector(526, 503), --  
				sf.misc.FloatVector(502, 503) -- 
			},
			moving = false --    
		},
		{ --3 
			start_amount = 0, --  
			size = 5, --  
			need = 0, --     . 0 ,  
			id = "bottle03_", --   id    (   dsfrontend)
			layer = 2, --  
			select_clip ="glow03", --   .      -
			weight_number_pos =
			{ --     
				sf.misc.FloatVector(653, 386), --  
				sf.misc.FloatVector(627, 386) -- 
			},
			moving = false --    
		}
	}
}

function self.Init(_owner)
	sminigames.SetStandartScriptName(_owner, liquids_pouring) 
	
	self.LoadInfo(_owner)
	self.timer = __create_timer()
end

--   
function self.LoadInfo(_owner)
	self.objects = {}
	--  
	for i = 1, #self.params.bottles do
		local now = self.params.bottles[i].start_amount
	
		--    
		local id = "bottle"
		if i < 10 then
			id = id .. 0
		end
		id = id .. i
		local bottle = __cast(_owner.GetWidget(id, true), sf.gui.CImageWidget)
		__assert(bottle, " image_widget   dsfrontend: id = "..id)
		local layer = self.params.bottles[i].layer or 1
		bottle.SetLayer(layer)
		
		local object = {
			bottle_image = bottle,
			weight = now, --  
			size = self.params.bottles[i].size, --  
			need = self.params.bottles[i].need, --     
			fill_images = {}, --   
			weight_widgets = {} --   
		}
		
		table.insert(self.objects, object)
		
		local fill = nil
		--    
		fill =  self.GetFillImages(_owner, i)
		object.fill_images = fill
		
		self.ShowFillAmount(i, now)
		--    
		self.SetBottleWeight(_owner, i, now)
	end
	
	self.selected = -1 --  
	
	local shelf = __cast(_owner.GetWidget("shelf", true), sf.gui.CImageWidget)
	shelf.SetOffset(self.params.moving_shelf.start_pos.X, self.params.moving_shelf.start_pos.Y)
	self.moving_widgets = 
	{ 
		shelf = shelf,
		bottle = self.objects[self.params.moving_shelf.bottle]
	}
	local right = __cast(_owner.GetWidget(self.params.win_clip_id, true), sf.gui.CClipWidget)
	if right then
		right.AddFlags(sf.gui.CWidget.FlagHidden)
	end
end 

--     
function self.SetBottleWeight(_owner, _i, _weight)
	--       
	
	for _, widget in pairs(self.objects[_i].weight_widgets) do
		_owner.RemoveWidget(widget)
	end
	self.objects[_i].weight_widgets = {}
	if _weight > 0 then
		--     
		local ones = self.GetOnes(_weight)
		local tens = self.GetTens(_weight)
		local base_id = self.params.weight_num_id --  id    
		
		local ones_id = base_id .. ones -- id  
		local tens_id = base_id .. tens -- id  
		--      
		local weight_pos = self.params.bottles[_i].weight_number_pos
		
		--    
		local ones_widget = sf.gui.CImageWidget(ones_id, "ones_".._i, 0, 0)
		ones_widget.SetOffset(weight_pos[1].X, weight_pos[1].Y)
		local layer = self.params.weight_num_layer or 1
		ones_widget.SetLayer(layer)
		_owner.AddWidget(ones_widget)
		
		local tens_widget = sf.gui.CImageWidget(tens_id, "tens_".._i, 0, 0)
		tens_widget.SetOffset(weight_pos[2].X, weight_pos[2].Y)
		_owner.AddWidget(tens_widget)
		tens_widget.SetLayer(layer)
		
		table.insert(self.objects[_i].weight_widgets, ones_widget)
		table.insert(self.objects[_i].weight_widgets, tens_widget)
	end
end

--    _num 
function self.GetOnes(_num)
	return _num % 10
end
--    
function self.GetTens(_num)
	return math.floor(_num / 10) % 10
end

function self.CheckEnd(_owner)
	for i = 1, #self.objects do
		--      
		if self.objects[i].weight ~= self.params.bottles[i].need 
			and self.params.bottles[i].need ~= 0 then
				return false
		end
	end
	if self.params.sound_on_win then
		sound(self.params.sound_on_win)
	end
	
	local wrong = __cast(_owner.GetWidget(self.params.before_win_clip_id, true), sf.gui.CClipWidget)
	if wrong then
		wrong.AddFlags(sf.gui.CWidget.FlagHidden)
	end
	self.right = __cast(_owner.GetWidget(self.params.win_clip_id, true), sf.gui.CClipWidget)
	if self.right then
		self.right.RemFlags(sf.gui.CWidget.FlagHidden)
		self.right.GetClip().Play()
		self.win_start = self.timer.Get().GetTime()
	else
		_owner.OnEndGame()
	end
end 

-- ,     
function self.IsBottle(_pos)
	for i = 1, #self.objects do
		if misc.GetRect(self.objects[i].bottle_image).IsContains(_pos.X, _pos.Y) then
			return i
		end
	end
	return nil
end 

--  
function self.Select(_owner, _i)
	self.Deselect(_owner)
	
	if self.params.sound_select then
		sound(self.params.sound_select)
	end
	
	self.selected = _i
	
	self.selection_clip =  sf.gui.CClipWidget("", 0, 0)
	self.selection_clip.GetClip().Load(self.params.bottles[self.selected].select_clip, true)
	_owner.AddWidget(self.selection_clip)
	--    (      )
	local center_offset = self.objects[self.selected].bottle_image.GetOffset() + 
						self.objects[self.selected].bottle_image.GetSize()/2
	local clip_size = self.selection_clip.GetClip().GetViewSize()
	self.selection_clip.SetOffset(center_offset.X - clip_size.X/2, center_offset.Y- clip_size.Y/2)	
end

--    
function self.Deselect(_owner)
	if self.selected > 0 then
		self.selection_clip.GetClip().Stop()
		_owner.RemoveWidget(self.selection_clip)
	end
	
	self.selected = -1
end

function self.OnMouseDown(_owner, _pos, _button, _keyboard_state, _broadcast)
	if self.exchange_start or self.move_start  or self.win_start then 
		return false 
	end
	
	local ind = self.IsBottle(_pos) -- ,     
	
	if not ind then return false end
	
	--  	
	if self.selected == ind then
		--    
		self.Deselect(_owner)
	else
		if self.selected < 0  then
			if self.objects[ind].weight ~= 0 then 
				self.Select(_owner, ind) --  ,    - 
			end
		else
			--    ,  
			self.Pour(_owner, self.selected, ind)
			self.Deselect(_owner)
		end
	end
	
	return true
end 

-- ,       
function self.Pour(_owner, _from, _where)
	-- ,     
	if self.params.sound_on_pour then
		sound(self.params.sound_on_pour)
	end
	local free_space = self.objects[_where].size - self.objects[_where].weight 
	local has = self.objects[_from].weight --    -
	
	local amount = math.min(has, free_space) --  
	--    
	self.objects[_where].weight = self.objects[_where].weight + amount
	self.objects[_from].weight = self.objects[_from].weight - amount
	
	--    ,    
	self.ShowFillAmount(_where, self.objects[_where].weight)
	--        
	if self.objects[_where].weight < 0 then --    ,   
		self.objects[_where].weight = 0
	end
	
	--   ,    /
	self.appear_widgets = {}
	for i = self.objects[_where].weight - amount + 1, self.objects[_where].weight do
		table.insert(self.appear_widgets, self.objects[_where].fill_images[i])
		local color = sf.graphics.Color(0, 255, 255, 255)
		self.objects[_where].fill_images[i].SetColor(color)
	end
	
	self.hiding_widgets = {}
	for i = self.objects[_from].weight + 1, self.objects[_from].weight + amount do
		table.insert(self.hiding_widgets, self.objects[_from].fill_images[i])
	end
	self.exchange_start = self.timer.Get().GetTime() --   
	self.from = _from
	self.where = _where
	
	if self.params.moving_shelf.bottle == _where or self.params.moving_shelf.bottle == _from then
		self.need_move_shelf = true
	else
		self.need_move_shelf = nil
	end
end 
--   dsfrontend       _num
function self.GetFillImages(_owner, _num)
	local fill = {}
	local base_id = self.params.bottles[_num].id
	local i = 1 
	local flag = true
	while flag do
		local id = nil 
		if i < 10 then
			id = base_id .. 0
		end
		if id then 
			id = id .. i
		else
			id = base_id .. i
		end
		
		local img = __cast(_owner.GetWidget(id, true), sf.gui.CImageWidget)
		if not img then
			img = __cast(_owner.GetWidget(id, true), sf.gui.CClipWidget)
		end
		if not img then
			flag = false
		else
			table.insert(fill, img)
			i = i + 1
		end
	end
	
	return fill
end 

--       _i
function self.ShowFillAmount(_i, _amount)
	local fill = self.objects[_i].fill_images
	--__message(" : "..#fill)
	for i = 1, #fill do
		if i <= _amount then
			-- 
			fill[i].RemFlags(sf.gui.CWidget.FlagHidden)
		else
			fill[i].AddFlags(sf.gui.CWidget.FlagHidden)
			local color = sf.graphics.Color(255, 255, 255, 255)
			fill[i].SetColor(color) --       
		end
	end
end 

function self.OnUpdate(_owner)
	if not self.exchange_start and not self.move_start and not self.win_start then 
		return 
	end
	
	if self.exchange_start then
		self.UpdateExchange(_owner)
	elseif self.move_start then
		self.UpdateMoving(_owner)
	elseif self.win_start then
		local now = self.timer.Get().GetTime()
		local clip_time = qe.GetClipTime(self.right.GetClip())
		if now - self.win_start >= clip_time then
			_owner.OnEndGame()
		end
	end
end 

--  
function self.UpdateMoving(_owner)
	--   
	if self.params.sound_on_move and self.need_move_shelf then
		sound(self.params.sound_on_move)
	end
	local dist = math.abs(self.start_pos.Y - self.end_pos.Y) --  
	local need_time = 1000 * dist / self.params.moving_shelf.speed --   
	local now = self.timer.Get().GetTime()
	local cur_time = (now - self.move_start) / need_time
	if cur_time > 1 then --   
		cur_time = 1
	end
	local cur_pos = self.moving_widgets.shelf.GetOffset()
	local new_shelf_pos = self.start_pos + (self.end_pos - self.start_pos) * cur_time --   
	
	local diff = new_shelf_pos - cur_pos --   
	self.moving_widgets.shelf.SetOffset(new_shelf_pos.X, new_shelf_pos.Y)
	--   
	local bottle_off = self.moving_widgets.bottle.bottle_image.GetOffset() + diff
	self.moving_widgets.bottle.bottle_image.SetOffset(bottle_off.X, bottle_off.Y)
	
	--   
	for i, fill in ipairs(self.moving_widgets.bottle.fill_images) do
		local fill_off = fill.GetOffset() + diff
		fill.SetOffset(fill_off.X, fill_off.Y)
	end
	
	if cur_time == 1 then
		self.move_start = nil
		
		self.CheckEnd(_owner)
	end
end

--    
function self.UpdateExchange(_owner)
	local now = self.timer.Get().GetTime()
	local cur_time = (now - self.exchange_start) / self.params.liquids_exchange_time
	if cur_time > 1 then
		cur_time = 1
	end
	local color_appear = sf.graphics.Color(255*cur_time, 255, 255, 255)
	local color_hide = sf.graphics.Color(255*(1 - cur_time), 255, 255, 255)
	for i = 1, #self.appear_widgets do
		self.appear_widgets[i].SetColor(color_appear)
		self.hiding_widgets[i].SetColor(color_hide)
	end
	
	if cur_time == 1 then
		--  
		self.ShowFillAmount(self.from, self.objects[self.from].weight)
		self.SetBottleWeight(_owner, self.from, self.objects[self.from].weight)
		self.SetBottleWeight(_owner, self.where, self.objects[self.where].weight)
		
		self.from = nil
		self.where = nil
		self.exchange_start = nil
		
		if self.need_move_shelf then
			--   
			self.move_start = now
			self.start_pos = self.moving_widgets.shelf.GetOffset() --  
			local num = self.params.moving_shelf.bottle --   
			local weight = self.objects[num].weight
			local y_diff = self.params.moving_shelf.lower_pos.Y - self.params.moving_shelf.higher_pos.Y
			local y_step = y_diff / self.params.bottles[num].size -- ,        
			self.end_pos = self.params.moving_shelf.higher_pos + sf.misc.FloatVector(0, y_step * weight) --  
		else
			self.CheckEnd(_owner)
		end
	end
end 