--  -
s8_birds_and_fishes_minigame = {} --   ,     
local self = s8_birds_and_fishes_minigame --  ,   s12_example_minigame.some_var  self.some_var

self.params = 
{
	sound_pos =
	{ --   
		blocked = "mini_game_mini_game_birds_and_fishes_false_01", -- -    ,    
		correct_pos = "mini_game_mini_game_birds_and_fishes_true_01", --      
		move = "mini_game_mini_game_birds_and_fishes_select_02" --     
	},
	sound_object =
	{ --   
		select = "mini_game_mini_game_birds_and_fishes_select_01", --  
		move = "mini_game_mini_game_birds_and_fishes_go_01" --   
	},
	fade_move_time = 600, --     
	
	speed = 250, --  ,   
	pos_amount = 15, --      
	dibs_amount = 10, --    
	pos_width = 40,  --   
	pos_height = 40, --   
	clip_selection_on_move = "effect02", -- ,  ,    
	layer_on_move = 1, --       
	clip_on_correct_cell = "effect01", -- ,        ,       
	layer_correct_cell = 0, --       
	clip_on_wrong_click = "cross", -- ,  ,    ,    
	layer_wrong_click = 0, --    
	clip_show_enabled = "effect03", -- ,      ,     
	layer_show_enabled_layer = 1, --     clip_show_enabled
	enabled_fade_time = 500, --       
	positions = { --  ,     
		{ --  : 1
			state =  "fish", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "bird", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(937, 617), --    
			neighbours = { --  ,      
				2
			}
		},
		{ --  : 2
			state =  "fish", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "bird", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(683, 589), --    
			neighbours = { --  ,      
				1, 3, 6
			}
		},
		{ --  : 3
			state =  "fish", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "bird", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(851, 505), --    
			neighbours = { --  ,      
				2, 4
			}
		},
		{ --  : 4
			state =  "fish", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "bird", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(884, 331), --    
			neighbours = { --  ,      
				3, 5
			}
		},
		{ --  : 5
			state =  "fish", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "bird", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(757, 206), --    
			neighbours = { --  ,      
				4
			}
		},
		{ --  : 6
			state =  "free", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "free", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(506, 641), --    
			neighbours = { --  ,      
				2, 7
			}
		},
		{ --  : 7
			state =  "free", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "free", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(569, 475), --    
			neighbours = { --  ,      
				6, 8, 10
			}
		},
		{ --  : 8
			state =  "free", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "free", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(670, 328), --    
			neighbours = { --  ,      
				7, 9
			}
		},
		{ --  : 9
			state =  "free", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "free", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(540, 202), --    
			neighbours = { --  ,      
				8
			}
		},
		{ --  : 10
			state =  "free", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "free", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(432, 359), --    
			neighbours = { --  ,      
				7, 13
			}
		},
		{ --  : 11
			state =  "bird", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "fish", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(213, 681), --    
			neighbours = { --  ,      
				12
			}
		},
		{ --  : 12
			state =  "bird", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "fish", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(370, 577), --    
			neighbours = { --  ,      
				11, 13
			}
		},
		{ --  : 13
			state =  "bird", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "fish", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(256, 436), --    
			neighbours = { --  ,      
				12, 10, 14
			}
		},
		{ --  : 14
			state =  "bird", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "fish", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(244, 259), --    
			neighbours = { --  ,      
				13, 15
			}
		},
		{ --  : 15
			state =  "bird", --  : "bird" -    , "fish" -    , "free" - 
			end_state = "fish", --          : "bird" -    , "fish" -    , "free" - 
			pos = sf.misc.FloatVector(54, 258), --    
			neighbours = { --  ,      
				14
			}
		}
	}	
}
-- ,     
function self.CheckEnd(_owner)
	local alright = true;
	--  ,        
	for i = 1, self.params.pos_amount do
		if (self.position_state[i] ~= self.params.positions[i].end_state) then
			--  i-       ,   
			alright = false;
			break
		end
	end
	
	if (alright == true) then
	--  
		self.win = true
	end
end

function self.Init(_owner) -- ,  ;      ,  
	sminigames.SetStandartScriptName(_owner, s8_birds_and_fishes_minigame) 
	
	--  
	--    
	self.position_state = {}
	for i = 1, self.params.pos_amount do
		table.insert(self.position_state, self.params.positions[i].state)
	end
	
	self.objects = {}
	--  
	local i = 1
	local initialized = {}
	while true do
		local image_widget =  __cast(_owner.GetWidget("bird_"..i, true), sf.gui.CImageWidget)
		
		if not image_widget then 
			break 
		end
		
		local clip_widget 
		clip_widget = sf.gui.CClipWidget("", 0, 0)
		clip_widget.GetClip().Load("bird0"..i, true)
		clip_widget.SetOffset(0, 0)
		clip_widget.SetSize(0, 0)
		_owner.AddWidget(clip_widget)

		--    
		local o = {image = image_widget, object_type = "bird", clip = clip_widget }
		table.insert(self.objects, o)
		table.insert(initialized, false)
		
		i = i + 1		
	end
	
	--  
	local i = 1
	while true do
		local image_widget = __cast(_owner.GetWidget("fish_"..i, true), sf.gui.CImageWidget)
		if not image_widget then 
			break 
		end
		
		local clip_widget
		
		clip_widget = sf.gui.CClipWidget("", 0, 0)
		clip_widget.GetClip().Load("fish0"..i, true)
		clip_widget.SetOffset(0, 0)
		clip_widget.SetSize(0, 0)
		_owner.AddWidget(clip_widget)
		--end
		--    
		local o = {image = image_widget, object_type = "fish", clip = clip_widget }
		table.insert(self.objects, o)
		table.insert(initialized, false)
		
		i = i + 1		
	end
	
	--  
	for i = 1, self.params.pos_amount do
		local ob_type = self.params.positions[i].state
		if (ob_type ~= "free") then
			for j = 1, #self.objects do
				if (initialized[j] == false and ob_type == self.objects[j].object_type) then
					initialized[j] = true
					local width, height = self.objects[j].image.GetSize().X, self.objects[j].image.GetSize().Y
					self.objects[j].image.SetOffset(self.params.positions[i].pos.X - width/2, self.params.positions[i].pos.Y - height)
					self.objects[j].clip.SetSize(0, 0)
					break
				end
			end			
		end
	end
-- ,  	
	local id = self.params.clip_selection_on_move or ""
	local layer = self.params.layer_on_move or 0
	self.clip_on_move = sf.gui.CClipWidget("", layer, 0)
	self.clip_on_move.GetClip().Load(id, true)
	self.on_move_size = self.clip_on_move.GetClip().GetViewSize()
	self.clip_on_move.SetOffset(0, 0)
	self.clip_on_move.SetSize(0, 0)
	_owner.AddWidget(self.clip_on_move) 
-- ,     	
	id = self.params.clip_on_correct_cell or ""
	layer = self.params.layer_correct_cell or 0
	self.clip_on_correct = sf.gui.CClipWidget("", layer, 0) 
	self.clip_on_correct.GetClip().Load(id, true)
	self.on_correct_size = self.clip_on_correct.GetClip().GetViewSize()
	self.clip_on_correct.SetOffset(0, 0)
	self.clip_on_correct.SetSize(0, 0)
	_owner.AddWidget(self.clip_on_correct) 
		
-- ,   
	id = self.params.clip_on_wrong_click or ""
	layer = self.params.layer_wrong_click or 0
	self.clip_cross = sf.gui.CClipWidget("", layer, 0) 
	self.clip_cross.GetClip().Load(id, true)
	self.cross_size = self.clip_cross.GetClip().GetViewSize()
	self.clip_cross.SetOffset(0, 0)
	self.clip_cross.SetSize(0, 0)
	_owner.AddWidget(self.clip_cross) 		
	
	__assert(#self.objects == self.params.dibs_amount, 
		"-     - ,  "..#self.objects.."   "..self.params.dibs_amount)
	
	self.selected = -1 --     (  )
	self.sel_pos = -1 --   
	
	self.cur_way = {} --     
	self.cur_line = -1 --      
	self.moving = -1 --   
	self.obj_pos = {x = 0, y = 0} --   
	self.last_start = 0 --     
	self.last_length = 0 --      
	
	self.timer = __create_timer() --  ,      
		
	self.win = false -- ?
end

--  
function self.Select(_owner, _i)
	self.Deselect(_owner)
	
	if self.params.sound_object.select then
		sound(self.params.sound_object.select)
	end
	
	local pos = self.objects[_i].image.GetOffset()
	local width, height = self.objects[_i].image.GetSize().X, self.objects[_i].image.GetSize().Y
	
	self.objects[_i].clip.SetOffset(pos.X, pos.Y)
	self.objects[_i].clip.SetSize(width, height)
	self.objects[_i].image.SetLayer(2)
end

--  
function self.Deselect(_owner)
	if self.selected ~= -1 then
		self.DeleteEnabledCellsClips(_owner)
		self.objects[self.selected].clip.SetSize(0, 0)
		self.objects[self.selected].image.SetLayer(3)
	end
end

--      
function self.DeleteEnabledCellsClips(_owner)
	if self.enabled_cells and #self.enabled_cells > 0 then
		for _, clip in pairs(self.enabled_cells) do
			_owner.RemoveWidget(clip)
		end
		self.enabled_cells = {}
	end
end

--           
function self.SelectEnabledCells(_owner, _selected)
	local matr = self.MakeTransitionMatrix()
	local enabled = {}
	for i = 1, #self.params.positions do
		if self.position_state[i] == "free" and i ~= _selected then
			local way = self.FindWay(matr, _selected, i)
			if way then
				table.insert(enabled, i)
			end
		end
	end
	if not self.enabled_cells then
		self.enabled_cells = {}
	end
	for i = 1, #enabled do
		local pos_num = enabled[i]
		local pos = self.params.positions[pos_num].pos
		local widget = sf.gui.CClipWidget("", 0, 0)
		local layer = self.params.layer_show_enabled or 0
		widget.SetLayer(layer)
		local id = self.params.clip_show_enabled or ""
		widget.GetClip().Load(id, true)
		local sz = widget.GetClip().GetViewSize()
		widget.SetOffset(pos.X - sz.X/2, pos.Y - sz.Y/2)
		_owner.AddWidget(widget)
		
		table.insert(self.enabled_cells, widget)
	end
end

--  ,     ;    ,  nil
function self.FindDibByPos(_owner, _x, _y)
	local i

	for i = 1, #self.objects do
		local pos = self.objects[i].image.GetOffset()
		local width, height = self.objects[i].image.GetSize().X, self.objects[i].image.GetSize().Y

		if (pos.X <= _x) and (_x <= pos.X + width) and (pos.Y <= _y) and (_y <= pos.Y + height) then
		-- ,    
			if (sminigames.IsVisiblePoint(self.objects[i].image.GetImage(), _x - pos.X, _y - pos.Y)) then
				--       ,     
				self.Select(_owner, i)
				
				
				return i
			end
		end
	end
end

--    
function self.OnMouseDown(_owner, _pos, _button, _keyboard_state, _broadcast)
	--   ,    
	if _broadcast or self.moving >= 0 then return false end
	
	-- ,    
	local dib_in_pos = self.FindDibByPos(_owner, _pos.X, _pos.Y) --   - ?
	if dib_in_pos then
		--    -  ,     
		local pos_x, pos_y  = self.objects[dib_in_pos].image.GetOffset().X, self.objects[dib_in_pos].image.GetOffset().Y
		local width, height = self.objects[dib_in_pos].image.GetSize().X, self.objects[dib_in_pos].image.GetSize().Y
		local center = { --        
			X = pos_x + width/2,
			Y = pos_y + height
		} 
		--   ,    ,  
		for i = 1, self.params.pos_amount do
			local posi = self.params.positions[i].pos
			if (math.abs(posi.X - center.X) < self.params.pos_width/2 ) and (math.abs(posi.Y - center.Y) < self.params.pos_height/2) then
				--     
				self.selected = dib_in_pos
				self.sel_pos = i
				self.SelectEnabledCells(_owner, i)
				break
			end
		end
	else
		--    ...     
		for i = 1, self.params.pos_amount do
			local posi = self.params.positions[i].pos
			if (math.abs(posi.X - _pos.X) < self.params.pos_width/2 ) and (math.abs(posi.Y - _pos.Y) < self.params.pos_height/2) then
				--     
				if self.selected ~= -1 then
					--          
					local matr = self.MakeTransitionMatrix()

					local way = self.FindWay(matr, self.sel_pos, i)
					if (way == nil) then
						--   - .       
						local pos_clip_x, pos_clip_y = self.params.positions[i].pos.X, self.params.positions[i].pos.Y
						self.clip_cross.SetOffset(pos_clip_x - self.cross_size.X/2, pos_clip_y - self.cross_size.Y/2)
						self.clip_cross.SetSize(self.cross_size.X, self.cross_size.Y)
						self.clip_cross.GetClip().SetTime(0)
						self.clip_cross.GetClip().Play()
						
						if self.params.sound_pos.blocked then
							sound(self.params.sound_pos.blocked)
						end
					else
						--      selected  free,  i  object_type
						if #way > 1 then
							local pos_clip_x, pos_clip_y = self.params.positions[way[1]].pos.X, self.params.positions[way[1]].pos.Y
							self.clip_on_move.SetOffset(pos_clip_x - self.on_move_size.X/2, pos_clip_y - self.on_move_size.Y/2)
							self.clip_on_move.SetSize(self.on_move_size.X, self.on_move_size.Y)
						
							local w = self.ReverseArray(way)
							self.position_state[self.sel_pos] = "free"
							self.position_state[i] = self.objects[self.selected].object_type
							self.sel_pos = w[#w]
					
							self.cur_way = w -- ,     
							self.moving = self.selected --   
							self.cur_line = 1
							self.obj_pos.x = self.objects[self.selected].image.GetOffset().X + self.objects[self.selected].image.GetSize().X/2
							self.obj_pos.y = self.objects[self.selected].image.GetOffset().Y + self.objects[self.selected].image.GetSize().Y/2
					
							self.UpdateMovingTimer()
							
							self.fade_start  = self.timer.Get().GetTime()
							
							if self.params.sound_pos.move then
								sound(self.params.sound_pos.move)
							end
						end
					end
				end
				
				break
			end
		end
	end
	
	self.CheckEnd(_owner)
	return true
end


--     _start_pos  _end_pos
-- _adj_matr -  
-- !  ,   _end_pos
function self.FindWay(_adj_matr, _start_pos, _end_pos)
	local isSeen = {} --   
	local last = {} --    
	local dst = {} --     start_pos  end_pos
	local pos_amount = self.params.pos_amount
	for j = 1, pos_amount do
		table.insert(isSeen, 0)
		table.insert(dst, -100) -- 
	end

	dst[_start_pos] = 0
	isSeen[_start_pos] = 1
	last = _start_pos
	--     start_pos     ( )
	for j = 1, (pos_amount-1) do
		for i = 1, pos_amount do
			if (isSeen[i] == 0 and _adj_matr[last][i] == 1) then --       
				if (dst[i] < 0) then
					dst[i] = dst[last] + 1
				else
					dst[i] = math.min((dst[last] + 1), dst[i])
				end
			end
		end
		local min_dist = -100
		for x = 1, pos_amount do
			if (isSeen[x] == 0) then
				if (min_dist < 0) then
					min_dist = dst[x]
					last = x
				else
					if (dst[x] >= 0) then
						if (min_dist > dst[x]) then
							min_dist = dst[x]
							last = x
						end
					end
				end
			end
		end
		isSeen[last] = 1
	end
	
	--   
	if (dst[_end_pos] >= 0) then --  
		local way = {_end_pos} --     
		local verse = _end_pos
		while (verse ~= _start_pos) do
			for i = 1, pos_amount do
				if (dst[i] + 1 == dst[verse] and _adj_matr[i][way[#way]] == 1) then --      
					table.insert(way, i)
					verse = i
					break
				end
			end
		end
		
		return way --     
	else
		return nil
	end
end

--      
function self.MakeTransitionMatrix()
	local matr = {}
	local pos_amount = self.params.pos_amount
	--  
	for i = 1, pos_amount do
		table.insert(matr, {})
		for j = 1, pos_amount do
			table.insert(matr[i], 0)
		end
	end
	--     
	for i = 1, pos_amount do
		if (self.position_state[i] == "free" or i == self.sel_pos) then
			local j = 1
			while (self.params.positions[i].neighbours[j]) do
				if (self.position_state[self.params.positions[i].neighbours[j]] == "free" or self.params.positions[i].neighbours[j] == self.sel_pos) then
					matr[i][self.params.positions[i].neighbours[j]] = 1
					matr[self.params.positions[i].neighbours[j]][i] = 1
				end
				j = j +1
			end
		end
	end
	
	return matr
end

--    _arr   
function self.ReverseArray(_arr)
	local size = #_arr
	local res = {}
	while (size > 0) do
		table.insert(res, _arr[size])
		size = size - 1
	end
	return res
end

--    
function self.UpdateFadeClips(_owner)
	if self.fade_start and self.enabled_cells then
		local need = self.params.enabled_fade_time
		local cur_time = (self.timer.Get().GetTime() - self.fade_start)/need
		if cur_time > 1 then
			cur_time = 1
		end
		for i, clip in ipairs(self.enabled_cells) do
			local color = sf.graphics.Color(clip.GetColor())
			color.Alpha = 255*(1 - cur_time)
			clip.SetColor(color)
		end
		if cur_time == 1 then
			self.fade_start = nil
			self.DeleteEnabledCellsClips(_owner)
		end
	end
end

--   
function self.OnUpdate(_owner)
	if (self.moving <= 0) then 
		return 
	end
	self.UpdateFadeClips(_owner)
	
	local ind_end = self.cur_way[self.cur_line + 1]

	local ind_start = self.cur_way[self.cur_line]
	
	if self.params.sound_object.move then
		sound(self.params.sound_object.move)
	end
	
	local width, height = self.objects[self.moving].image.GetSize().X, self.objects[self.moving].image.GetSize().Y
	local current_time = (self.timer.Get().GetTime() - self.last_start)/self.last_length
    if current_time > 1 then 
		current_time = 1  --       
	end
    --        
	local start_pos = self.params.positions[ind_start].pos
	local end_pos = self.params.positions[ind_end].pos
	self.obj_pos.x = start_pos.X + (end_pos.X - start_pos.X )*current_time 
	self.obj_pos.y = start_pos.Y + (end_pos.Y - start_pos.Y)*current_time 
    self.objects[self.moving].image.SetOffset(self.obj_pos.x - width/2, self.obj_pos.y - height)
	self.objects[self.moving].clip.SetOffset(self.obj_pos.x - width/2, self.obj_pos.y - height)
	
	local now = self.timer.Get().GetTime()
	if (now  >= self.last_length +  self.last_start) then --  ,       ?
		self.cur_line = self.cur_line + 1 --     
		if (self.cur_line == #self.cur_way) then
			--    ,     
			local new_x = self.params.positions[self.cur_way[self.cur_line]].pos.X - width/2
			local new_y = self.params.positions[self.cur_way[self.cur_line]].pos.Y - height
			self.objects[self.moving].image.SetOffset(new_x, new_y)
			self.objects[self.moving].image.SetLayer(3)
			self.objects[self.moving].clip.SetSize(0, 0)
						
			self.clip_on_move.SetSize(0, 0) --      
			if self.objects[self.moving].object_type == self.params.positions[ self.cur_way[#self.cur_way] ].end_state then
			--  ,       
			--__message(" !")
				local new_pos = self.params.positions[ self.cur_way[#self.cur_way] ].pos
				self.clip_on_correct.SetOffset(new_pos.X - self.on_correct_size.X/2, new_pos.Y - self.on_correct_size.Y/2)
				self.clip_on_correct.SetSize(self.on_correct_size.X, self.on_correct_size.Y)
				self.clip_on_correct.GetClip().SetTime(0)
				self.clip_on_correct.GetClip().Play()
				
				if self.params.sound_pos.correct_pos then
					sound(self.params.sound_pos.correct_pos)
				end
				
				if self.params.sound_object.move and self.params.fade_move_time then
					stop_sound(self.params.sound_object.move, self.params.fade_move_time)
				end
			end
			
			self.cur_way = {} --     
			self.cur_line = -1 --      
			self.moving = -1 --   
			self.obj_pos = {x = 0, y = 0} --   
			
			self.selected = -1
			self.sel_pos = -1
			
			if (self.win) then --       ,         
				--self.DeleteWidgets(_owner)
				_owner.SetGameResult(1)
				_owner.OnEndGame()
			end
		else --   
			self.UpdateMovingTimer()
		end
	end
end

--              
function self.UpdateMovingTimer()
	self.last_start = self.timer.Get().GetTime() --  	
	
	local height = self.objects[self.moving].image.GetSize().Y
	local end_pos = self.params.positions[self.cur_way[self.cur_line + 1]].pos

	local distance_sqr1 = (self.obj_pos.x - end_pos.X)*(self.obj_pos.x - end_pos.X)
	local distance_sqr2 = (self.obj_pos.y + height/2 - end_pos.Y)*(self.obj_pos.y + height/2 - end_pos.Y)
	
	self.last_length = 1000*math.sqrt(distance_sqr1 + distance_sqr2) / self.params.speed
end

function self.DeleteWidgets(_owner)
	for i = 1, #self.objects do
		self.objects[i].clip.SetSize(0,0)
		self.objects[i].clip.GetClip().Stop() --    
		_owner.RemoveWidget(self.objects[i].clip)
	end
end
