s8_get_key_from_lake = {}
local self = s8_get_key_from_lake

self.params = {
	speed_horizontal = 200, --   
	speed_vertical = 400, --     
	start_mov = sf.misc.FloatVector(0, 530), --        
	end_mov = sf.misc.FloatVector(1000, 530), 
	catcher = "plunger", -- id ,  
	catcher_luck = "plunger_catch", -- id   
	barrier_id = "barrier0", --  id 
	fish_id = "fish0", --  id   dsfrontend 
	aim_id = "aim", -- id   dsfrontend	
	fish_id_clip = "fish01", --  id   
	catched_fish_id = "scenes_scene01_05_minigame_minigame02_catched_fish0", -- id     
	catched_bar_id = "scenes_scene01_05_minigame_minigame02_barrier0", -- id    
	catched_aim_id = "scenes_scene01_05_minigame_minigame02_catched_key", -- id   
	show_delay = 300, --       
	
	edge_moving = 0 --     
	
}

--    dsfrontend
function self.Load(_owner)
self.plunger = __cast(_owner.GetWidget(self.params.catcher, true), sf.gui.CImageWidget) --  
	__assert(self.plunger, "   dsfrontend'e, id="..self.params.catcher) 
	self.plunger.SetOffset(self.params.start_mov.X, self.params.start_mov.Y)
	
	self.luck = __cast(_owner.GetWidget(self.params.catcher_luck, true), sf.gui.CImageWidget) --  -2
	__assert(self.luck, "     dsfrontend'e, id="..self.params.catcher_luck) 
	self.luck_size = {X = self.luck.GetSize().X, Y = self.luck.GetSize().Y}--  
	self.luck.SetSize(1,1) --    
	
	-- ,    
	self.barriers = {} -- 
	self.barriers_catched = {} -- id    
	local flag, i = true, 1
	while flag do
		local clip = __cast(_owner.GetWidget(self.params.barrier_id..i, true), sf.gui.CClipWidget) --   
		if clip then
			table.insert(self.barriers, clip)
			table.insert(self.barriers_catched, self.params.catched_bar_id..i)
			i = i + 1
		else
			flag = false
		end
	end
	
	self.fishes = {} -- 
	self.fish_catched = {} -- id    
	local flag, i = true, 1
	while flag do
		local clip = __cast(_owner.GetWidget(self.params.fish_id..i, true), sf.gui.CClipWidget) --   /  ..
		if clip then
			table.insert(self.fishes, clip)
			table.insert(self.fish_catched, self.params.catched_fish_id..i)
			i = i + 1
		else
			flag = false
		end
	end
	
	self.aim = __cast(_owner.GetWidget(self.params.aim_id, true), sf.gui.CImageWidget)
	__assert(self.aim, " image_widget  id="..self.params.aim_id.." ( )")
end

function self.Init(_owner)
	sminigames.SetStandartScriptName(_owner, s8_get_key_from_lake)
	
	self.timer = sf.core.CTimerWrapper(sf.core.g_Application.GetTimeManager().AttachTimer(_T(""), nil))
	
	self.is_catching = -1 --      -    
	
	self.moving = {start = self.params.start_mov, end_mov = self.params.end_mov} --   
	self.last_start = self.timer.Get().GetTime()
	
	self.Load(_owner)
	
	--  
	self.plunger_offset = sf.misc.FloatVector(0, 0) --  ,   
	self.back_to_usual = false
	self.prev_end_mov = sf.misc.FloatVector(0, 0) --      
	
	self.grabbed = nil -- ,   
	self.grabbed_size = {}
	self.grab_stage = 0 --0 - , 1 - , 2 - 
end 

function self.OnUpdate(_owner)
	if self.is_catching < 0 then
		--   -
		local flag_switch = self.SetNewPos(self.params.speed_horizontal, self.moving.start, self.moving.end_mov)
		
		if flag_switch then
			--      
			local tmp_start = self.moving.start
			self.moving.start = self.moving.end_mov
			self.moving.end_mov = tmp_start
			self.last_start = self.timer.Get().GetTime()
			
			if self.back_to_usual then
				if self.prev_end_mov.X == self.params.end_mov.X and self.prev_end_mov.Y == self.params.end_mov.Y then
					self.moving.end_mov.X = self.params.start_mov.X
					self.moving.end_mov.Y = self.params.start_mov.Y
				else
					self.moving.end_mov.X = self.params.end_mov.X
					self.moving.end_mov.Y = self.params.end_mov.Y
				end
				
				self.back_to_usual = false
			end
		end
	else
		if not self.grabbed then
			--    
			CatchObject(_owner)
		else
			--   
			local need_time = self.luck_size.X / self.params.speed_horizontal * 1000
			local cur = (self.timer.Get().GetTime() - self.last_start)/need_time
			if cur > 1 then 
				cur = 1 
			end
			-- 
			local new_size = {Y = self.luck_size.X, Y = self.luck_size.Y}
			local new_pos = {X = self.luck.GetOffset().X, Y = self.luck.GetOffset().Y}
			if (self.grab_stage == 0) then
				-- 
				new_size = {X = self.luck_size.X*cur, Y = self.luck_size.Y*cur}
				new_pos = {X = _owner.GetSize().X/2 - new_size.X/2, 
							Y = _owner.GetSize().Y/2 - new_size.Y/2}
				if (cur == 1) then 
					self.grab_stage = 1 --  
					self.last_start = self.timer.Get().GetTime()
				end
				self.luck.SetOffset(new_pos.X, new_pos.Y)
				self.luck.SetSize(new_size.X, new_size.Y)
				--  
				new_size.X = self.grabbed_size.X*cur
				new_size.Y = self.grabbed_size.Y*cur
				new_pos.X = _owner.GetSize().X/2 - new_size.X/2
				new_pos.Y = _owner.GetSize().Y/2 - new_size.Y/2
				self.grabbed.SetOffset(new_pos.X, new_pos.Y)
				self.grabbed.SetSize(new_size.X, new_size.Y)
			elseif (self.grab_stage == 1) then
				-- 
				if (self.timer.Get().GetTime() - self.last_start >= self.params.show_delay) then
					self.grab_stage = 2 --  
					self.last_start = self.timer.Get().GetTime()
				end
			elseif (self.grab_stage == 2) then
				--  
				new_size = {X = self.luck_size.X*(1 - cur), Y = self.luck_size.Y*(1 - cur)}
				new_pos = {X = _owner.GetSize().X/2 - new_size.X/2, 
							Y = _owner.GetSize().Y/2 - new_size.Y/2}
				self.luck.SetOffset(new_pos.X, new_pos.Y)
				self.luck.SetSize(new_size.X, new_size.Y)
				--  
				new_size.X = self.grabbed_size.X*(1 - cur)
				new_size.Y = self.grabbed_size.Y*(1 - cur)
				new_pos.X = _owner.GetSize().X/2 - new_size.X/2
				new_pos.Y = _owner.GetSize().Y/2 - new_size.Y/2
				self.grabbed.SetOffset(new_pos.X, new_pos.Y)
				self.grabbed.SetSize(new_size.X, new_size.Y)
			end

				
			
			if cur == 1 and self.grab_stage == 2 then
				--  , ,  ,  ...
				self.grab_stage = 0 
				self.last_start = self.timer.Get().GetTime()
				local flag = false
				if tostring(self.grabbed.GetId()) == "aim" then
					flag = true
				end
				local color = sf.graphics.Color(self.grabbed.GetColor())
				color.Alpha = 0
				self.grabbed.SetColor(color)
				_owner.RemoveWidget(self.grabbed)
				self.grabbed = nil
				self.luck.SetSize(1, 1)
				self.is_catching = -1
				if flag then
					_owner.SetGameResult(1)
					_owner.OnEndGame()
				else
				-- 
				self.plunger.SetOffset(self.params.start_mov.X, self.params.start_mov.Y)
					local color = sf.graphics.Color(self.plunger.GetColor())
					color.Alpha = 255
					self.plunger.SetColor(color)
				end
			end
		end
	end
end

-- ,          , ,      
function self.SetNewPos(_speed, _start_point, _end_point)
	local distance = math.sqrt((_start_point.X - _end_point.X)*(_start_point.X - _end_point.X) 
				+  (_start_point.Y - _end_point.Y)*(_start_point.Y - _end_point.Y))
	local need_time = distance / _speed * 1000
	local current = (self.timer.Get().GetTime() - self.last_start) / need_time
	local flag_switch = false
	if current >= 1 then
		flag_switch = true
		current = 1
	end
	local new_pos = sf.misc.FloatVector(0, 0)
	local cur_x, cur_y = self.plunger.GetOffset().X, self.plunger.GetOffset().Y
	new_pos.X = _start_point.X + (_end_point.X - _start_point.X)*current
	new_pos.Y = _start_point.Y + (_end_point.Y - _start_point.Y)*current
		
	self.plunger.SetOffset(new_pos.X, new_pos.Y)
	
	return flag_switch	
end

function self.OnMouseDown(_owner, _pos, _button, _state, _broadcast)
	--     
	if self.is_catching > 0 then return false end
	self.prev_end_mov = { X = self.moving.end_mov.X, Y = self.moving.end_mov.Y}
	self.plunger_offset = {X = self.plunger.GetOffset().X, Y = self.plunger.GetOffset().Y}
	self.moving = {start = self.plunger_offset, 
			end_mov = sf.misc.FloatVector(self.plunger.GetOffset().X, self.params.edge_moving)} --   
	self.last_start = self.timer.Get().GetTime()
	
	self.is_catching = 1
	
	return true
end 

--     
function CatchObject(_owner)
	--    
	local flag_switch = self.SetNewPos(self.params.speed_vertical, self.moving.start, self.moving.end_mov)
	
	-- ,     
	local barr = self.IntersectArr(self.barriers)
	if  barr then
		--  
		-- 
		local color = sf.graphics.Color(self.plunger.GetColor())
		color.Alpha = 0
		self.plunger.SetColor(color)
		
		--   
		--__message(self.barriers_catched[barr])
		self.grabbed = sf.gui.CImageWidget(self.barriers_catched[barr] , "img", 2, 0) --    
		self.grabbed_size = {X = self.grabbed.GetSize().X, Y = self.grabbed.GetSize().Y }
		self.grabbed.SetSize(1, 1)
		_owner.AddWidget(self.grabbed)
		local new_offset = {X = _owner.GetSize().X/2, Y = _owner.GetSize().Y/2}
		self.grabbed.SetOffset(new_offset.X/2, new_offset.Y/2)
		self.luck.SetOffset(new_offset.X/2, new_offset.Y/2)
		
		--    
		self.moving =  {start = self.params.start_mov, end_mov = self.params.end_mov} --   
		self.last_start = self.timer.Get().GetTime()
	else
		local fish = self.IntersectArr(self.fishes)
		if not fish then
			-- ,     
			local cur_x, cur_y = self.plunger.GetOffset().X, self.plunger.GetOffset().Y
			local width, height = self.plunger.GetSize().X, self.plunger.GetSize().Y/5 --      
			local rect = sf.misc.FloatRect(cur_x, cur_y, width, height)
			if misc.GetRect(self.aim).IsIntersects(rect) then
				--  
				-- 
				local color = sf.graphics.Color(self.plunger.GetColor())
				color.Alpha = 0
				self.plunger.SetColor(color)		
			
				--   
				self.grabbed = sf.gui.CImageWidget(self.params.catched_aim_id , "aim", 2, 0) --    
				self.grabbed_size = {X = self.grabbed.GetSize().X, Y = self.grabbed.GetSize().Y }
				self.grabbed.SetSize(1, 1)
				_owner.AddWidget(self.grabbed)
				local new_offset = {X = _owner.GetSize().X/2, Y = _owner.GetSize().Y/2}
				self.grabbed.SetOffset(new_offset.X/2, new_offset.Y/2)
				self.luck.SetOffset(new_offset.X/2, new_offset.Y/2)
		
				--    
				self.last_start = self.timer.Get().GetTime()
			end
		else
			--  
			-- 
			local color = sf.graphics.Color(self.plunger.GetColor())
			color.Alpha = 0
			self.plunger.SetColor(color)		
			
			--   
					
			self.grabbed = sf.gui.CImageWidget(self.fish_catched[fish] , "img", 2, 0) --    
			self.grabbed_size = {X = self.grabbed.GetSize().X, Y = self.grabbed.GetSize().Y }
			self.grabbed.SetSize(1, 1)
			_owner.AddWidget(self.grabbed)
			local new_offset = {X = _owner.GetSize().X/2, Y = _owner.GetSize().Y/2}
			self.grabbed.SetOffset(new_offset.X/2, new_offset.Y/2)
			self.luck.SetOffset(new_offset.X/2, new_offset.Y/2)
		
			--    
			_owner.RemoveWidget(self.fishes[fish])
			table.remove(self.fishes, fish)
			table.remove(self.fish_catched, fish)
			self.moving =  {start = self.params.start_mov, end_mov = self.params.end_mov} --   
			self.last_start = self.timer.Get().GetTime()
			
		end		
	end
	
	-- ,       
	if flag_switch then
		if self.moving.end_mov.X == self.plunger_offset.X and
		    self.moving.end_mov.Y == self.plunger_offset.Y then
			--      -    
			self.moving = {start = self.plunger_offset, end_mov = self.prev_end_mov}
			self.last_start = self.timer.Get().GetTime()
			self.is_catching = -1
			self.back_to_usual = true
		else
			--   ,   
			--      
			local tmp_start = self.moving.start
			self.moving.start = self.moving.end_mov
			self.moving.end_mov = tmp_start
			
			self.last_start = self.timer.Get().GetTime()
		end
	end
end 

-- ,       _array
function self.IntersectArr(_array)
	local cur_x, cur_y = self.plunger.GetOffset().X, self.plunger.GetOffset().Y
	local width, height = self.plunger.GetSize().X, self.plunger.GetSize().Y/5 --      
	cur_y = cur_y + height/2

	local rect = sf.misc.Poly4FromRect(sf.misc.FloatRect(cur_x, cur_y, width, height))
	for i = 1, #_array do
		-- , 
		local clip = _array[i].GetClip()
		local obj = clip.FindObject(self.params.fish_id_clip)
	
		if obj then
			if (obj.GetLocation().GetPoly() + _array[i].GetOffset()).IsIntersects(rect) then
			-- 
				return i
			end
		end
	end
	return nil
end 