options_window_dialog = options_window_dialog or {}
options_window_dialog.actions = options_window_dialog.actions or {}

function options_window_dialog.Show(_window)
    local app = sf.core.g_Application			
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "options_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))

    local slider_value = g_App.GetSettings().GetChild("settings", false).GetValue("voice_slider").c_str()
    if not (slider_value == "true") then
        local slider_widget = __cast(dialog.GetWidget("voice_volume_slider").get(), sf.gui.CWidget)
        local label_widget = __cast(dialog.GetWidget("voice_label").get(), sf.gui.CWidget)
        options_window.sliders_params["voice_volume_slider"] = nil

        local _parent = slider_widget.GetParentWidget()
        _parent.RemoveWidget(slider_widget)
        _parent.RemoveWidget(label_widget)
        dialog.Update()
    end

	dialog.UpdateLayout()
    local parent_window_size = _window.GetSize()
	dialog.SetOffset((parent_window_size.X - dialog.GetSize().X)/2, (parent_window_size.Y - dialog.GetSize().Y)/2)
	_window.AddChildWindow(dialog)

	local window_ptr = sf.gui.CBaseWindowPtrT(dialog)
	options_window.init_options_window(dialog)	

	local res = _window.DoModal(window_ptr)
	window_ptr = nil
	collectgarbage()
    return res
end

function options_window_dialog.DoDraw(_this, _renderer)
end

function options_window_dialog.DoUpdate(_this)
end

function options_window_dialog.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function options_window_dialog.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	if _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast) then
      return true
    end

    if _key == 13 then
		options_window.apply_changes()
		_this.EndModal(1)
        return true
    end

    if _key == 27 then
		options_window.restore()
		_this.EndModal(0)
        return true
    end
    return false

end

function options_window_dialog.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function options_window_dialog.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove( _pos, _state, _broadcast) 
end

function options_window_dialog.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function options_window_dialog.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function options_window_dialog.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function options_window_dialog.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function options_window_dialog.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = options_window_dialog.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
    if _action.c_str() == "value_changed" then
        if options_window.sliders_params[T_(_child.GetId()).c_str()] then
            local slider_value = options_window.get_slider_value(T_(_child.GetId()).c_str())
            local current_set_function = options_window.sliders_params[T_(_child.GetId()).c_str()].set_function
            if current_set_function then
                current_set_function(slider_value)
            end
        end

    elseif _action.c_str() == "check_changed" then
        if options_window.checkbox_params[T_(_child.GetId()).c_str()] then
            local checkbox_widget = options_window.checkbox_params[T_(_child.GetId()).c_str()].widget
            if checkbox_widget then
                local checkbox_value = checkbox_widget.IsChecked()
                local set_fun = options_window.checkbox_params[T_(_child.GetId()).c_str()].set_function
                if set_fun then
                    set_fun(checkbox_value)
                    options_window.fill_widgets()
                end
            end
        end
    end
end
	
options_window_dialog.actions.ok = 
{
	pressed = function(_window) 
        options_window.apply_changes()
        _window.EndModal(1)
	end
}

options_window_dialog.actions.credits = 
{
	pressed = function(_window) 
        _window.EndModal(0)
	end
}

options_window_dialog.actions.cancel = 
{
	pressed = function(_window) 
        options_window.restore()
        _window.EndModal(0)
	end
}

options_window_dialog.actions.credits = 
{
	pressed = function(_window) 
        credits_window.Show(_window)
	end
}



------------------------------------------------------------------

options_window = {}


options_window.sliders_params = {}

options_window.sliders_params["sound_volume_slider"] = {}
options_window.sliders_params["sound_volume_slider"].widget = false
options_window.sliders_params["sound_volume_slider"].min_value = 0 
options_window.sliders_params["sound_volume_slider"].max_value = 100
options_window.sliders_params["sound_volume_slider"].get_function = function () return game.g_GameOptions.Instance().GetSoundVolume() end
options_window.sliders_params["sound_volume_slider"].set_function = function (_value) game.g_GameOptions.Instance().SetSoundVolume(_value) 
game.g_GameOptions.Instance().ApplyMusicChanges()
end
                               
options_window.sliders_params["music_volume_slider"] = {}
options_window.sliders_params["music_volume_slider"].widget = false
options_window.sliders_params["music_volume_slider"].min_value = 0 
options_window.sliders_params["music_volume_slider"].max_value = 100
options_window.sliders_params["music_volume_slider"].get_function = function () return game.g_GameOptions.Instance().GetMusicVolume() end
options_window.sliders_params["music_volume_slider"].set_function = function (_value) 
game.g_GameOptions.Instance().SetMusicVolume(_value) 
game.g_GameOptions.Instance().ApplyMusicChanges()
end

options_window.sliders_params["voice_volume_slider"] = {}
options_window.sliders_params["voice_volume_slider"].widget = false
options_window.sliders_params["voice_volume_slider"].min_value = 0 
options_window.sliders_params["voice_volume_slider"].max_value = 100
options_window.sliders_params["voice_volume_slider"].get_function = function () return game.g_GameOptions.Instance().GetVoiceVolume() end
options_window.sliders_params["voice_volume_slider"].set_function = function (_value) 
game.g_GameOptions.Instance().SetVoiceVolume(_value) 
game.g_GameOptions.Instance().ApplyMusicChanges()
end



-----------------------------

options_window.checkbox_params = {}

options_window.checkbox_params["full_screen_checkbox"] = {}
options_window.checkbox_params["full_screen_checkbox"].widget = false
options_window.checkbox_params["full_screen_checkbox"].get_function = function ()
	return game.g_GameOptions.Instance().GetFullScreenMode()
end
options_window.checkbox_params["full_screen_checkbox"].set_function = function (_value) 
	game.g_GameOptions.Instance().SetFullScreenMode(_value)
	game.g_GameOptions.Instance().ApplyOptionsChanges()
end

--------------------------

function options_window.set_slider_value(_slider_id, _value)
	local current_silder = options_window.sliders_params[_slider_id]
	if current_silder then
		local diver = (current_silder.max_value - current_silder.min_value)
		if math.abs(diver) > 0.0001 then
			if current_silder.widget then
				current_silder.widget.SetValue((_value-current_silder.min_value)/diver, false)		
			end
		end
	end
end

function options_window.get_slider_value(_slider_id)
	local current_silder = options_window.sliders_params[_slider_id]
	if current_silder then
		local slider_value = 0
		if current_silder.widget then
			slider_value = current_silder.widget.GetValue()		
		end
		local res = current_silder.min_value + (current_silder.max_value - current_silder.min_value)*slider_value
		return res
	else
		return 0 
	end
end

function options_window.fill_widgets()
	for slider_id in pairs(options_window.sliders_params) do
		local current_get_fun = options_window.sliders_params[slider_id].get_function
		if current_get_fun then
			options_window.set_slider_value(slider_id, current_get_fun())
		end
	end
	for checkbox_id in pairs(options_window.checkbox_params) do
		local current_get_fun = options_window.checkbox_params[checkbox_id].get_function
		if current_get_fun then
			local current_widget = options_window.checkbox_params[checkbox_id].widget
			if current_widget then
				current_widget.Check(current_get_fun(), false)
			end
		end
	end
end

function options_window.init_options_window(_owner)
	for slider_id in pairs(options_window.sliders_params) do
		options_window.sliders_params[slider_id].widget	= 
			__cast(_owner.GetWidget(_T(slider_id), true).get(), "sf.gui.CSliderWidget")
	end

	for checkbox_id in pairs(options_window.checkbox_params) do
		options_window.checkbox_params[checkbox_id].widget = 
			__cast(_owner.GetWidget(_T(checkbox_id), true).get(), "sf.gui.CCheckboxWidget")
	end
	options_window.fill_widgets()
end

function options_window.apply_changes()
	game.g_GameOptions.Instance().UpdateLocalSettings()
	local res = game.g_GameOptions.Instance().ApplyOptionsChanges();
	game.g_GameOptions.Instance().Save()
end

function options_window.restore()
	game.g_GameOptions.Instance().RestoreOptions()
	game.g_GameOptions.Instance().Save()
end
