records_window_dialog = records_window_dialog or {}
records_window_dialog.actions = records_window_dialog.actions or {}



records_window_dialog.last_record_color = sf.graphics.Color(255, 255, 255, 0)

function records_window_dialog.Show(_window)
    local app = sf.core.g_Application			
	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "scores_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	dialog.UpdateLayout()
    local parent_window_size = _window.GetSize()
	dialog.SetOffset((parent_window_size.X - dialog.GetSize().X)/2, (parent_window_size.Y - dialog.GetSize().Y)/2)
	_window.AddChildWindow(dialog)

	records_window_dialog.score_table = __cast(dialog.GetWidget(_T("table_scores"),true).get(), "sf.gui.CTableWidget")

    records_window_dialog.header_row = app.GetSettings().GetChild(_T("GUI"), false).GetChildByAttribute(
		_T("window"), _T("id"), _T("scores_window"), true).GetChildByAttribute(
			_T("table_widget"), _T("id"), _T("table_scores"), true).GetNamedChild(_T("rows"), false).GetChild(_T("row"), false)
	records_window_dialog.string_row = records_window_dialog.header_row.GetNextSibling()
	records_window_dialog.template = app.GetSettings().GetChild(_T("GUITemplates"), false)

    local records_info = g_App.GetSettings().GetChild("Constants", false).GetChildRef("records_window", false)
    if records_info then
        local res = records_info.GetValue("last_record_color").c_str()
        if res ~= "" then
            records_window_dialog.last_record_color = string_to_color(res)
        end
    end

    records_window_dialog.fill_one_table()

    dialog.UpdateLayout()
	local window_ptr = sf.gui.CBaseWindowPtrT(dialog)

	local res = _window.DoModal(window_ptr)
	window_ptr = nil
	collectgarbage()
    return res
end

function records_window_dialog.fill_one_table()
	local current_table_widget = records_window_dialog.score_table

	if current_table_widget then
		current_table_widget.ClearTable()
		current_table_widget.LoadRow(records_window_dialog.header_row, records_window_dialog.template)
	   
		local record = game.g_RecordTable.Instance().GetRecords()
		local last_record_pos = game.g_RecordTable.Instance().GetLastRecordPos()
		local nomer = 1
		while not record.IsEnd() do 
			
			current_table_widget.LoadRow(records_window_dialog.string_row, records_window_dialog.template)
			__cast(current_table_widget.GetCell(nomer, 0).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetText(_T("  "..tostring(nomer)))
			__cast(current_table_widget.GetCell(nomer, 1).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetText(_T("  ") .. record.Get().Name)
			__cast(current_table_widget.GetCell(nomer, 2).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetText(_T("  "..tostring(record.Get().Score)))
		if nomer == last_record_pos then
			__cast(current_table_widget.GetCell(nomer, 0).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetColor(records_window_dialog.last_record_color)
			__cast(current_table_widget.GetCell(nomer, 1).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetColor(records_window_dialog.last_record_color)
			__cast(current_table_widget.GetCell(nomer, 2).GetWidgets().Get().get(), "sf.gui.CLabelWidget").SetColor(records_window_dialog.last_record_color)
		end
			nomer = nomer + 1
			record.Next()
		end	
		current_table_widget.FitCells() 
	end

end


function records_window_dialog.DoDraw(_this, _renderer)
end

function records_window_dialog.DoUpdate(_this)
end

function records_window_dialog.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function records_window_dialog.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	if _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast) then
      return true
    end
    return false

end

function records_window_dialog.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function records_window_dialog.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove( _pos, _state, _broadcast) 
end

function records_window_dialog.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function records_window_dialog.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function records_window_dialog.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function records_window_dialog.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function records_window_dialog.OnChildAction(_this, _action, _child)
	if not _child then return end
	local handler = records_window_dialog.actions[_child.GetId().c_str()]
	if handler then handler = handler[_action.c_str()] end
	if handler then handler(_this, _child) end
end
	
records_window_dialog.actions.ok = 
{
	pressed = function(_window) 
        _window.EndModal(1)
	end
}

records_window_dialog.actions.clear = 
{
	pressed = function(_window) 
        local modal_res = dialog_window.RunCustomDialog(_window, "records_clear_dialog")
        if modal_res == 1 then
            game.g_RecordTable.Instance().Clear()
            records_window_dialog.fill_one_table()
            _window.UpdateLayout()
        end
	end
}
