--[[ 
	 .
	   ,    .    ,     , .
	        .         
	       .
--]]
replay_window = replay_window or {}
replay_window.actions = replay_window.actions or {}

function replay_window.Show(_window)
    replay_window._parent_window = _window
    --    
    replay_window._parent_window.AddFlags(replay_window._parent_window.FlagHidden)

	local dialog = sf.gui.CWindow()
	dialog.Load(g_App.GetSettings().GetChild("GUI", false).GetChildByAttribute("window", "id", "replay_window", true),
		g_App.GetSettings().GetChild("GUITemplates", false))
	dialog.UpdateLayout()
    local parent_offset = _window.GetAbsPos(true)
	dialog.SetOffset((1024 - dialog.GetSize().X)/2 - parent_offset.X, (768 - dialog.GetSize().Y)/2 - parent_offset.Y)
	
	local current_profile = game.g_ProfileManager.Instance().GetCurrentProfile()
	
	-- ,      
	--  /  
	local iter = dialog.GetWidgets()
	while not iter.IsEnd() do
		local button = __cast(iter.Get(), sf.gui.CButtonWidget)
		if button then
			local id = button.GetId().c_str()
			
			local level_id = string.match(id, "level_(.+)")
			if level_id then
				--  
				button.DisableButton(not current_profile or not current_profile.IsLevelStepAvailable(level_id))
			end
			
			local comics_id = string.match(id, "comics_(.+)")
			if comics_id then
				--  
				button.DisableButton(not current_profile or not current_profile.IsComicsStepAvailable(comics_id))
			end
		end
		
		iter.Next()
	end
	
    _window.AddChildWindow(dialog)
end

function replay_window.DoDraw(_this, _renderer)
end

function replay_window.DoUpdate(_this)
end

function replay_window.OnChar(_this, _char, _keyboard_state, _state, _broadcast)
	return _this.SuperOnChar(_char, _keyboard_state, _state, _broadcast)
end

function replay_window.OnKeyDown(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyDown( _key, _keyboard_state, _state, _broadcast)
end

function replay_window.OnKeyUp(_this, _key, _keyboard_state, _state, _broadcast)
	return _this.SuperOnKeyUp( _key, _keyboard_state, _state, _broadcast)
end

function replay_window.OnMouseMove(_this, _pos, _state, _broadcast)
	return _this.SuperOnMouseMove( _pos, _state, _broadcast) 
end

function replay_window.OnMouseDown(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseDown( _pos, _button, _state, _broadcast) 
end

function replay_window.OnMouseUp(_this, _pos, _button, _state, _broadcast)
	return _this.SuperOnMouseUp( _pos, _button, _state, _broadcast) 
end

function replay_window.OnDoubleClick(_this, _pos, _state, _broadcast)
	return _this.SuperOnDoubleClick( _pos, _state, _broadcast) 
end

function replay_window.OnMouseWheel(_this, _pos, _delta, _state, _broadcast)
	return _this.SuperOnMouseWheel( _pos, _delta, _state, _broadcast)
end

function replay_window.OnChildAction(_this, _action, _child)
	if not _child then return end
	local child_id = _child.GetId().c_str()
	local handler = replay_window.actions[child_id]
	if handler then handler = handler[_action.c_str()] end
	if handler then 
		handler(_this, _child) 
		return
	end
	
	--       
	if _action.c_str() == "pressed" then
		local level_id = string.match(child_id, "level_(.+)")
		if level_id then
			--      level_id
			--   , ..       
			local level_index = 0
			for i,o in ipairs(g_QuestStr) do
				if o.Type == "level" then
					level_index = level_index + 1
                    if tostring(o.Id) == level_id then
                        break
                    end
				end
			end
			__assert(level_index ~= 0)
            
			if dialog_window.RunCustomDialog(_this, "confirm_replay_level_dialog") == 1 then
				main_menu.RunGame(level_index)
			end
			return
		end
		
		local comics_id = string.match(child_id, "comics_(.+)")
		if comics_id then
			--    comics_id
			local found = false
			for i,o in ipairs(g_QuestStr) do
				if o.Type == "comics" and tostring(o.Id) == comics_id then
					found = true
					main_menu.RunComics(_this, o.Id, o.Childs, o.Track[1] or "", true, true, true, true)
					break
				end
			end
			__assert(found)
			return
		end
	end
end
	
replay_window.actions.close = 
{
	pressed = function(_window) 
        replay_window._parent_window.RemFlags(replay_window._parent_window.FlagHidden)
		_window.AddFlags(_window.FlagDead)
	end
}
